package com.ustadmobile.core.db.dao;

import java.lang.System;

@com.ustadmobile.door.annotation.Repository()
@androidx.room.Dao()
@kotlin.Metadata(mv = {1, 6, 0}, k = 1, d1 = {"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000f\b\'\u0018\u0000 R2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0003RSTB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\tH\u0002J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u000f\u001a\u00020\tH\'J\u001b\u0010\u0010\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u000f\u001a\u00020\tH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0011J\u0018\u0010\u0012\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u00132\u0006\u0010\u000f\u001a\u00020\tH\'J \u0010\u0014\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00150\u00132\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\tH\'J\u0014\u0010\u0017\u001a\u0004\u0018\u00010\u00022\b\u0010\u0018\u001a\u0004\u0018\u00010\u0007H\'J#\u0010\u0019\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u0007H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001bJ\u0019\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0018\u001a\u00020\u0007H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001eJ\u001b\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010\u000f\u001a\u00020\tH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0011JV\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020#0\"2\u0006\u0010$\u001a\u00020\t2\u0006\u0010%\u001a\u00020\t2\u0006\u0010&\u001a\u00020\t2\f\u0010\'\u001a\b\u0012\u0004\u0012\u00020\t0(2\u0006\u0010)\u001a\u00020\t2\u0006\u0010*\u001a\u00020\u001d2\n\b\u0002\u0010+\u001a\u0004\u0018\u00010\u0007H\'JP\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00020(2\u0006\u0010$\u001a\u00020\t2\u0006\u0010%\u001a\u00020\t2\u0006\u0010&\u001a\u00020\t2\f\u0010\'\u001a\b\u0012\u0004\u0012\u00020\t0(2\u0006\u0010)\u001a\u00020\t2\u0006\u0010*\u001a\u00020\u001d2\n\b\u0002\u0010+\u001a\u0004\u0018\u00010\u0007H\'J\u001b\u0010-\u001a\u0004\u0018\u00010\u00022\u0006\u0010.\u001a\u00020\tH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0011J\u001b\u0010/\u001a\u0004\u0018\u0001002\u0006\u0010\u0018\u001a\u00020\u0007H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001eJ\u000e\u00101\u001a\b\u0012\u0004\u0012\u00020\u00020(H\'J\u0010\u00102\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u000203H\'J\u0010\u00104\u001a\u00020\t2\u0006\u00105\u001a\u000206H\'J\u001f\u00107\u001a\u00020\u000b2\f\u00108\u001a\b\u0012\u0004\u0012\u00020\u00020(H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00109J\u0019\u0010:\u001a\u00020\u000b2\u0006\u0010;\u001a\u00020\u0002H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010<J\u0010\u0010=\u001a\u00020\u000b2\u0006\u0010>\u001a\u00020?H\'J\u0019\u0010@\u001a\u00020\t2\u0006\u0010A\u001a\u00020BH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010CJ\u0019\u0010D\u001a\u00020\t2\u0006\u0010E\u001a\u00020FH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010GJ\u0018\u0010H\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\'J)\u0010I\u001a\u00020\u00052\u0006\u0010)\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010J\u001a\u00020\tH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010KJ\u0019\u0010L\u001a\u00020\u00052\u0006\u0010)\u001a\u00020\tH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0011J\u0011\u0010M\u001a\u00020\u000bH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010NJ\u001b\u0010O\u001a\u00020\u000b2\b\b\u0001\u0010P\u001a\u00020\tH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0011J\u0019\u0010Q\u001a\u00020\u001d2\u0006\u00105\u001a\u00020\u0002H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010<\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006U"}, d2 = {"Lcom/ustadmobile/core/db/dao/PersonDao;", "Lcom/ustadmobile/core/db/dao/BaseDao;", "Lcom/ustadmobile/lib/db/entities/Person;", "()V", "authenticate", "", "token", "", "personUid", "", "createAuditLog", "", "toPersonUid", "fromPersonUid", "findByUid", "uid", "findByUidAsync", "(JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findByUidLive", "Lcom/ustadmobile/door/DoorLiveData;", "findByUidWithDisplayDetailsLive", "Lcom/ustadmobile/lib/db/entities/PersonWithPersonParentJoin;", "activeUserPersonUid", "findByUsername", "username", "findByUsernameAndPasswordHash2", "passwordHash", "(Ljava/lang/String;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findByUsernameCount", "", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findPersonAccountByUid", "Lcom/ustadmobile/lib/db/entities/PersonWithAccount;", "findPersonsWithPermission", "Lcom/ustadmobile/door/DoorDataSourceFactory;", "Lcom/ustadmobile/lib/db/entities/PersonWithDisplayDetails;", "timestamp", "excludeClazz", "excludeSchool", "excludeSelected", "", "accountPersonUid", "sortOrder", "searchText", "findPersonsWithPermissionAsList", "findSystemAccount", "nodeId", "findUidAndPasswordHashAsync", "Lcom/ustadmobile/core/db/dao/PersonDao$PersonUidAndPasswordHash;", "getAllPerson", "insertAccessToken", "Lcom/ustadmobile/lib/db/entities/AccessToken;", "insertAuditLog", "entity", "Lcom/ustadmobile/lib/db/entities/AuditLog;", "insertListAsync", "entityList", "(Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "insertOrReplace", "person", "(Lcom/ustadmobile/lib/db/entities/Person;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "insertPersonAuth", "personAuth", "Lcom/ustadmobile/lib/db/entities/PersonAuth;", "insertPersonGroup", "personGroup", "Lcom/ustadmobile/lib/db/entities/PersonGroup;", "(Lcom/ustadmobile/lib/db/entities/PersonGroup;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "insertPersonGroupMember", "personGroupMember", "Lcom/ustadmobile/lib/db/entities/PersonGroupMember;", "(Lcom/ustadmobile/lib/db/entities/PersonGroupMember;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "isValidToken", "personHasPermissionAsync", "permission", "(JJJLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "personIsAdmin", "replicateOnChange", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "replicateOnNewNode", "newNodeId", "updateAsync", "Companion", "PersonNameAndUid", "PersonUidAndPasswordHash", "lib-database"})
public abstract class PersonDao implements com.ustadmobile.core.db.dao.BaseDao<com.ustadmobile.lib.db.entities.Person> {
    @org.jetbrains.annotations.NotNull()
    public static final com.ustadmobile.core.db.dao.PersonDao.Companion Companion = null;
    public static final int SORT_FIRST_NAME_ASC = 1;
    public static final int SORT_FIRST_NAME_DESC = 2;
    public static final int SORT_LAST_NAME_ASC = 3;
    public static final int SORT_LAST_NAME_DESC = 4;
    @org.jetbrains.annotations.NotNull()
    public static final java.lang.String SQL_SELECT_LIST_WITH_PERMISSION = "\n         SELECT Person.* \n           FROM PersonGroupMember \n                \n            JOIN ScopedGrant\n                 ON ScopedGrant.sgGroupUid = PersonGroupMember.groupMemberGroupUid\n                    AND (ScopedGrant.sgPermissions &\n                    64\n                    \n                                                    ) > 0\n            JOIN Person \n                 ON \n                ((ScopedGrant.sgTableId = -2\n                    AND ScopedGrant.sgEntityUid = -2)\n                 OR (ScopedGrant.sgTableId = 9\n                    AND ScopedGrant.sgEntityUid = Person.personUid)\n                 OR (ScopedGrant.sgTableId = 6       \n                    AND Person.personUid IN (\n                        SELECT DISTINCT clazzEnrolmentPersonUid\n                          FROM ClazzEnrolment\n                         WHERE clazzEnrolmentClazzUid =ScopedGrant.sgEntityUid \n                           AND ClazzEnrolment.clazzEnrolmentActive))\n                 OR (ScopedGrant.sgTableId = 164\n                    AND Person.personUid IN (\n                        SELECT DISTINCT schoolMemberPersonUid\n                          FROM SchoolMember\n                         WHERE schoolMemberSchoolUid = ScopedGrant.sgEntityUid\n                           AND schoolMemberActive))\n                           )    \n        \n        \n         WHERE PersonGroupMember.groupMemberPersonUid = :accountPersonUid\n           AND PersonGroupMember.groupMemberActive \n           AND (:excludeClazz = 0 OR :excludeClazz NOT IN\n                    (SELECT clazzEnrolmentClazzUid \n                       FROM ClazzEnrolment \n                      WHERE clazzEnrolmentPersonUid = Person.personUid \n                            AND :timestamp BETWEEN ClazzEnrolment.clazzEnrolmentDateJoined \n                                AND ClazzEnrolment.clazzEnrolmentDateLeft\n           AND ClazzEnrolment.clazzEnrolmentActive))\n           AND (:excludeSchool = 0 OR :excludeSchool NOT IN\n                    (SELECT schoolMemberSchoolUid\n                      FROM SchoolMember \n                     WHERE schoolMemberPersonUid = Person.personUid \n                       AND :timestamp BETWEEN SchoolMember.schoolMemberJoinDate\n                            AND SchoolMember.schoolMemberLeftDate ))\n           AND Person.personType = 0                  \n           AND (Person.personUid NOT IN (:excludeSelected))\n           AND (:searchText = \'%\' \n               OR Person.firstNames || \' \' || Person.lastName LIKE :searchText)\n      GROUP BY Person.personUid\n      ORDER BY CASE(:sortOrder)\n               WHEN 1 THEN Person.firstNames\n               WHEN 3 THEN Person.lastName\n               ELSE \'\'\n               END ASC,\n               CASE(:sortOrder)\n               WHEN 2 THEN Person.firstNames\n               WHEN 4 THEN Person.lastName\n               ELSE \'\'\n               END DESC\n    ";
    private static final java.lang.String ENTITY_PERSONS_WITH_PERMISSION_PT1 = "\n            SELECT DISTINCT Person_Perm.personUid FROM Person Person_Perm\n            LEFT JOIN PersonGroupMember ON Person_Perm.personUid = PersonGroupMember.groupMemberPersonUid\n            LEFT JOIN EntityRole ON EntityRole.erGroupUid = PersonGroupMember.groupMemberGroupUid\n            LEFT JOIN Role ON EntityRole.erRoleUid = Role.roleUid\n            WHERE\n            CAST(Person_Perm.admin AS INTEGER) = 1 OR ( (\n            ";
    private static final java.lang.String ENTITY_PERSONS_WITH_PERMISSION_PT2 = "\n            = 0) AND (Person_Perm.personUid = Person.personUid))\n            OR\n            (\n            ((EntityRole.erTableId = 9 AND EntityRole.erEntityUid = Person.personUid) OR \n            (EntityRole.erTableId = 6 AND EntityRole.erEntityUid IN (SELECT DISTINCT clazzEnrolmentClazzUid FROM ClazzEnrolment WHERE clazzEnrolmentPersonUid = Person.personUid)) OR\n            (EntityRole.erTableId = 164 AND EntityRole.erEntityUid IN (SELECT DISTINCT schoolMemberSchoolUid FROM SchoolMember WHERE schoolMemberPersonUid = Person.PersonUid)) OR\n            (EntityRole.erTableId = 164 AND EntityRole.erEntityUid IN (\n                SELECT DISTINCT Clazz.clazzSchoolUid \n                FROM Clazz\n                JOIN ClazzEnrolment ON ClazzEnrolment.clazzEnrolmentClazzUid = Clazz.clazzUid AND ClazzEnrolment.clazzEnrolmentPersonUid = Person.personUid\n            ))\n            ) \n            AND (Role.rolePermissions & \n        ";
    private static final java.lang.String ENTITY_PERSONS_WITH_PERMISSION_PT4 = ") > 0)";
    public static final long SESSION_LENGTH = 2419200000L;
    @org.jetbrains.annotations.NotNull()
    @java.lang.Deprecated()
    public static final java.lang.String ENTITY_PERSONS_WITH_LEARNING_RECORD_PERMISSION = "\n            SELECT DISTINCT Person_Perm.personUid FROM Person Person_Perm\n            LEFT JOIN PersonGroupMember ON Person_Perm.personUid = PersonGroupMember.groupMemberPersonUid\n            LEFT JOIN EntityRole ON EntityRole.erGroupUid = PersonGroupMember.groupMemberGroupUid\n            LEFT JOIN Role ON EntityRole.erRoleUid = Role.roleUid\n            WHERE\n            CAST(Person_Perm.admin AS INTEGER) = 1 OR ( (\n             0 \n            = 0) AND (Person_Perm.personUid = Person.personUid))\n            OR\n            (\n            ((EntityRole.erTableId = 9 AND EntityRole.erEntityUid = Person.personUid) OR \n            (EntityRole.erTableId = 6 AND EntityRole.erEntityUid IN (SELECT DISTINCT clazzEnrolmentClazzUid FROM ClazzEnrolment WHERE clazzEnrolmentPersonUid = Person.personUid)) OR\n            (EntityRole.erTableId = 164 AND EntityRole.erEntityUid IN (SELECT DISTINCT schoolMemberSchoolUid FROM SchoolMember WHERE schoolMemberPersonUid = Person.PersonUid)) OR\n            (EntityRole.erTableId = 164 AND EntityRole.erEntityUid IN (\n                SELECT DISTINCT Clazz.clazzSchoolUid \n                FROM Clazz\n                JOIN ClazzEnrolment ON ClazzEnrolment.clazzEnrolmentClazzUid = Clazz.clazzUid AND ClazzEnrolment.clazzEnrolmentPersonUid = Person.personUid\n            ))\n            ) \n            AND (Role.rolePermissions & \n         549755813888 ) > 0)";
    
    public PersonDao() {
        super();
    }
    
    @org.jetbrains.annotations.Nullable()
    @com.ustadmobile.door.annotation.ReplicationRunOnNewNode()
    @androidx.room.Query(value = "\n     REPLACE INTO PersonReplicate(personPk, personDestination)\n      SELECT DISTINCT Person.personUid AS personUid,\n             :newNodeId AS personDestination\n        FROM UserSession\n             JOIN PersonGroupMember\n                ON UserSession.usPersonUid = PersonGroupMember.groupMemberPersonUid\n                   \n            JOIN ScopedGrant\n                 ON ScopedGrant.sgGroupUid = PersonGroupMember.groupMemberGroupUid\n                    AND (ScopedGrant.sgPermissions &\n                   64\n                   \n                                                    ) > 0\n            JOIN Person \n                 ON \n                ((ScopedGrant.sgTableId = -2\n                    AND ScopedGrant.sgEntityUid = -2)\n                 OR (ScopedGrant.sgTableId = 9\n                    AND ScopedGrant.sgEntityUid = Person.personUid)\n                 OR (ScopedGrant.sgTableId = 6       \n                    AND Person.personUid IN (\n                        SELECT DISTINCT clazzEnrolmentPersonUid\n                          FROM ClazzEnrolment\n                         WHERE clazzEnrolmentClazzUid =ScopedGrant.sgEntityUid \n                           AND ClazzEnrolment.clazzEnrolmentActive))\n                 OR (ScopedGrant.sgTableId = 164\n                    AND Person.personUid IN (\n                        SELECT DISTINCT schoolMemberPersonUid\n                          FROM SchoolMember\n                         WHERE schoolMemberSchoolUid = ScopedGrant.sgEntityUid\n                           AND schoolMemberActive))\n                           )    \n        \n        \n       WHERE Person.personType = 0\n         AND UserSession.usClientNodeId = :newNodeId\n         AND Person.personLct != COALESCE(\n             (SELECT personVersionId\n                FROM PersonReplicate\n               WHERE personPk = Person.personUid\n                 AND personDestination = :newNodeId), 0)              \n      /*psql ON CONFLICT(personPk, personDestination) DO UPDATE\n             SET personPending = true\n      */       \n    ")
    @com.ustadmobile.door.annotation.ReplicationCheckPendingNotificationsFor(value = {com.ustadmobile.lib.db.entities.Person.class})
    public abstract java.lang.Object replicateOnNewNode(@com.ustadmobile.door.annotation.NewNodeIdParam()
    long newNodeId, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n REPLACE INTO PersonReplicate(personPk, personDestination)\n  SELECT DISTINCT Person.personUid AS personUid,\n         UserSession.usClientNodeId AS personDestination\n    FROM ChangeLog\n         JOIN Person\n             ON ChangeLog.chTableId = 9\n                AND ChangeLog.chEntityPk = Person.personUid\n         \n            JOIN ScopedGrant \n                   ON \n            ((ScopedGrant.sgTableId = -2\n                    AND ScopedGrant.sgEntityUid = -2)\n                 OR (ScopedGrant.sgTableId = 9\n                    AND ScopedGrant.sgEntityUid = Person.personUid)\n                 OR (ScopedGrant.sgTableId = 6       \n                    AND ScopedGrant.sgEntityUid IN (\n                        SELECT DISTINCT clazzEnrolmentClazzUid\n                          FROM ClazzEnrolment\n                         WHERE clazzEnrolmentPersonUid = Person.personUid \n                           AND ClazzEnrolment.clazzEnrolmentActive))\n                 OR (ScopedGrant.sgTableId = 164\n                    AND ScopedGrant.sgEntityUid IN (\n                        SELECT DISTINCT schoolMemberSchoolUid\n                          FROM SchoolMember\n                         WHERE schoolMemberPersonUid = Person.personUid\n                           AND schoolMemberActive))\n                           )\n        \n                   AND (ScopedGrant.sgPermissions & \n        \n            64\n            \n                                                     ) > 0\n             JOIN PersonGroupMember AS PrsGrpMbr\n                   ON ScopedGrant.sgGroupUid = PrsGrpMbr.groupMemberGroupUid\n              JOIN UserSession\n                   ON UserSession.usPersonUid = PrsGrpMbr.groupMemberPersonUid\n                      AND UserSession.usStatus = 1\n        \n   WHERE Person.personType = 0\n     AND UserSession.usClientNodeId != (\n         SELECT nodeClientId \n           FROM SyncNode\n          LIMIT 1)\n     AND Person.personLct != COALESCE(\n         (SELECT personVersionId\n            FROM PersonReplicate\n           WHERE personPk = Person.personUid\n             AND personDestination = UserSession.usClientNodeId), 0)\n /*psql ON CONFLICT(personPk, personDestination) DO UPDATE\n     SET personPending = true\n  */               \n ")
    @com.ustadmobile.door.annotation.ReplicationCheckPendingNotificationsFor(value = {com.ustadmobile.lib.db.entities.Person.class})
    @com.ustadmobile.door.annotation.ReplicationRunOnChange(value = {com.ustadmobile.lib.db.entities.Person.class})
    public abstract java.lang.Object replicateOnChange(@org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Insert()
    public abstract java.lang.Object insertListAsync(@org.jetbrains.annotations.NotNull()
    java.util.List<? extends com.ustadmobile.lib.db.entities.Person> entityList, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Insert(onConflict = 1)
    public abstract java.lang.Object insertOrReplace(@org.jetbrains.annotations.NotNull()
    com.ustadmobile.lib.db.entities.Person person, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "SELECT COUNT(*) FROM Person where Person.username = :username")
    public abstract java.lang.Object findByUsernameCount(@org.jetbrains.annotations.NotNull()
    java.lang.String username, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super java.lang.Integer> continuation);
    
    public final boolean authenticate(@org.jetbrains.annotations.NotNull()
    java.lang.String token, long personUid) {
        return false;
    }
    
    @androidx.room.Query(value = "SELECT EXISTS(SELECT token FROM AccessToken WHERE token = :token  and accessTokenPersonUid = :personUid)")
    public abstract boolean isValidToken(@org.jetbrains.annotations.NotNull()
    java.lang.String token, long personUid);
    
    @androidx.room.Insert()
    public abstract void insertAccessToken(@org.jetbrains.annotations.NotNull()
    com.ustadmobile.lib.db.entities.AccessToken token);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n        SELECT Person.personUid, Person.admin, Person.firstNames, Person.lastName, \n               PersonAuth.passwordHash\n          FROM Person\n               JOIN PersonAuth\n                    ON Person.personUid = PersonAuth.personAuthUid\n         WHERE Person.username = :username\n    ")
    public abstract java.lang.Object findUidAndPasswordHashAsync(@org.jetbrains.annotations.NotNull()
    java.lang.String username, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super com.ustadmobile.core.db.dao.PersonDao.PersonUidAndPasswordHash> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n        SELECT Person.*\n          FROM Person\n               JOIN PersonAuth2\n                    ON Person.personUid = PersonAuth2.pauthUid\n         WHERE Person.username = :username \n               AND PersonAuth2.pauthAuth = :passwordHash\n    ")
    public abstract java.lang.Object findByUsernameAndPasswordHash2(@org.jetbrains.annotations.NotNull()
    java.lang.String username, @org.jetbrains.annotations.NotNull()
    java.lang.String passwordHash, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super com.ustadmobile.lib.db.entities.Person> continuation);
    
    @androidx.room.Insert()
    public abstract void insertPersonAuth(@org.jetbrains.annotations.NotNull()
    com.ustadmobile.lib.db.entities.PersonAuth personAuth);
    
    /**
     * Checks if a user has the given permission over a given person in the database
     *
     * @param accountPersonUid the personUid of the person who wants to perform the operation
     * @param personUid the personUid of the person object in the database to perform the operation on
     * @param permission permission to check for
     * @param checkPermissionForSelf if 0 then don't check for permission when accountPersonUid == personUid
     * (e.g. where give the person permission over their own entity automatically).
     */
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n        SELECT EXISTS(\n                SELECT 1\n                  FROM Person\n                  JOIN ScopedGrant\n                       ON \n                ((ScopedGrant.sgTableId = -2\n                    AND ScopedGrant.sgEntityUid = -2)\n                 OR (ScopedGrant.sgTableId = 9\n                    AND ScopedGrant.sgEntityUid = Person.personUid)\n                 OR (ScopedGrant.sgTableId = 6       \n                    AND Person.personUid IN (\n                        SELECT DISTINCT clazzEnrolmentPersonUid\n                          FROM ClazzEnrolment\n                         WHERE clazzEnrolmentClazzUid =ScopedGrant.sgEntityUid \n                           AND ClazzEnrolment.clazzEnrolmentActive))\n                 OR (ScopedGrant.sgTableId = 164\n                    AND Person.personUid IN (\n                        SELECT DISTINCT schoolMemberPersonUid\n                          FROM SchoolMember\n                         WHERE schoolMemberSchoolUid = ScopedGrant.sgEntityUid\n                           AND schoolMemberActive))\n                           )    \n        \n                  JOIN PersonGroupMember \n                       ON ScopedGrant.sgGroupUid = PersonGroupMember.groupMemberGroupUid\n                 WHERE Person.personUid = :personUid\n                   AND (ScopedGrant.sgPermissions & :permission) > 0\n                   AND PersonGroupMember.groupMemberPersonUid = :accountPersonUid\n                 LIMIT 1)\n    ")
    public abstract java.lang.Object personHasPermissionAsync(long accountPersonUid, long personUid, long permission, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super java.lang.Boolean> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @com.ustadmobile.door.annotation.PostgresQuery(value = "SELECT COALESCE((SELECT admin FROM Person WHERE personUid = :accountPersonUid), FALSE)")
    @androidx.room.Query(value = "SELECT COALESCE((SELECT admin FROM Person WHERE personUid = :accountPersonUid), 0)")
    public abstract java.lang.Object personIsAdmin(long accountPersonUid, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super java.lang.Boolean> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "SELECT Person.* FROM PERSON Where Person.username = :username")
    public abstract com.ustadmobile.lib.db.entities.Person findByUsername(@org.jetbrains.annotations.Nullable()
    java.lang.String username);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n        SELECT Person.*\n          FROM Person\n         WHERE Person.dateOfBirth = :nodeId\n           AND Person.personType = 1\n    ")
    public abstract java.lang.Object findSystemAccount(long nodeId, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super com.ustadmobile.lib.db.entities.Person> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "SELECT * FROM PERSON WHERE Person.personUid = :uid")
    public abstract com.ustadmobile.lib.db.entities.Person findByUid(long uid);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "SELECT Person.*, null as newPassword, null as currentPassword,null as confirmedPassword FROM PERSON WHERE Person.personUid = :uid")
    public abstract java.lang.Object findPersonAccountByUid(long uid, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super com.ustadmobile.lib.db.entities.PersonWithAccount> continuation);
    
    @org.jetbrains.annotations.NotNull()
    @androidx.room.Query(value = "SELECT * From Person WHERE personUid = :uid")
    public abstract com.ustadmobile.door.DoorLiveData<com.ustadmobile.lib.db.entities.Person> findByUidLive(long uid);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "SELECT * FROM Person WHERE personUid = :uid")
    public abstract java.lang.Object findByUidAsync(long uid, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super com.ustadmobile.lib.db.entities.Person> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Update()
    public abstract java.lang.Object updateAsync(@org.jetbrains.annotations.NotNull()
    com.ustadmobile.lib.db.entities.Person entity, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super java.lang.Integer> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Insert()
    public abstract java.lang.Object insertPersonGroup(@org.jetbrains.annotations.NotNull()
    com.ustadmobile.lib.db.entities.PersonGroup personGroup, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super java.lang.Long> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Insert()
    public abstract java.lang.Object insertPersonGroupMember(@org.jetbrains.annotations.NotNull()
    com.ustadmobile.lib.db.entities.PersonGroupMember personGroupMember, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super java.lang.Long> continuation);
    
    @org.jetbrains.annotations.NotNull()
    @androidx.room.Query(value = "\n         SELECT Person.* \n           FROM PersonGroupMember \n                \n            JOIN ScopedGrant\n                 ON ScopedGrant.sgGroupUid = PersonGroupMember.groupMemberGroupUid\n                    AND (ScopedGrant.sgPermissions &\n                    64\n                    \n                                                    ) > 0\n            JOIN Person \n                 ON \n                ((ScopedGrant.sgTableId = -2\n                    AND ScopedGrant.sgEntityUid = -2)\n                 OR (ScopedGrant.sgTableId = 9\n                    AND ScopedGrant.sgEntityUid = Person.personUid)\n                 OR (ScopedGrant.sgTableId = 6       \n                    AND Person.personUid IN (\n                        SELECT DISTINCT clazzEnrolmentPersonUid\n                          FROM ClazzEnrolment\n                         WHERE clazzEnrolmentClazzUid =ScopedGrant.sgEntityUid \n                           AND ClazzEnrolment.clazzEnrolmentActive))\n                 OR (ScopedGrant.sgTableId = 164\n                    AND Person.personUid IN (\n                        SELECT DISTINCT schoolMemberPersonUid\n                          FROM SchoolMember\n                         WHERE schoolMemberSchoolUid = ScopedGrant.sgEntityUid\n                           AND schoolMemberActive))\n                           )    \n        \n        \n         WHERE PersonGroupMember.groupMemberPersonUid = :accountPersonUid\n           AND PersonGroupMember.groupMemberActive \n           AND (:excludeClazz = 0 OR :excludeClazz NOT IN\n                    (SELECT clazzEnrolmentClazzUid \n                       FROM ClazzEnrolment \n                      WHERE clazzEnrolmentPersonUid = Person.personUid \n                            AND :timestamp BETWEEN ClazzEnrolment.clazzEnrolmentDateJoined \n                                AND ClazzEnrolment.clazzEnrolmentDateLeft\n           AND ClazzEnrolment.clazzEnrolmentActive))\n           AND (:excludeSchool = 0 OR :excludeSchool NOT IN\n                    (SELECT schoolMemberSchoolUid\n                      FROM SchoolMember \n                     WHERE schoolMemberPersonUid = Person.personUid \n                       AND :timestamp BETWEEN SchoolMember.schoolMemberJoinDate\n                            AND SchoolMember.schoolMemberLeftDate ))\n           AND Person.personType = 0                  \n           AND (Person.personUid NOT IN (:excludeSelected))\n           AND (:searchText = \'%\' \n               OR Person.firstNames || \' \' || Person.lastName LIKE :searchText)\n      GROUP BY Person.personUid\n      ORDER BY CASE(:sortOrder)\n               WHEN 1 THEN Person.firstNames\n               WHEN 3 THEN Person.lastName\n               ELSE \'\'\n               END ASC,\n               CASE(:sortOrder)\n               WHEN 2 THEN Person.firstNames\n               WHEN 4 THEN Person.lastName\n               ELSE \'\'\n               END DESC\n    ")
    public abstract com.ustadmobile.door.DoorDataSourceFactory<java.lang.Integer, com.ustadmobile.lib.db.entities.PersonWithDisplayDetails> findPersonsWithPermission(long timestamp, long excludeClazz, long excludeSchool, @org.jetbrains.annotations.NotNull()
    java.util.List<java.lang.Long> excludeSelected, long accountPersonUid, int sortOrder, @org.jetbrains.annotations.Nullable()
    java.lang.String searchText);
    
    @org.jetbrains.annotations.NotNull()
    @androidx.room.Query(value = "\n         SELECT Person.* \n           FROM PersonGroupMember \n                \n            JOIN ScopedGrant\n                 ON ScopedGrant.sgGroupUid = PersonGroupMember.groupMemberGroupUid\n                    AND (ScopedGrant.sgPermissions &\n                    64\n                    \n                                                    ) > 0\n            JOIN Person \n                 ON \n                ((ScopedGrant.sgTableId = -2\n                    AND ScopedGrant.sgEntityUid = -2)\n                 OR (ScopedGrant.sgTableId = 9\n                    AND ScopedGrant.sgEntityUid = Person.personUid)\n                 OR (ScopedGrant.sgTableId = 6       \n                    AND Person.personUid IN (\n                        SELECT DISTINCT clazzEnrolmentPersonUid\n                          FROM ClazzEnrolment\n                         WHERE clazzEnrolmentClazzUid =ScopedGrant.sgEntityUid \n                           AND ClazzEnrolment.clazzEnrolmentActive))\n                 OR (ScopedGrant.sgTableId = 164\n                    AND Person.personUid IN (\n                        SELECT DISTINCT schoolMemberPersonUid\n                          FROM SchoolMember\n                         WHERE schoolMemberSchoolUid = ScopedGrant.sgEntityUid\n                           AND schoolMemberActive))\n                           )    \n        \n        \n         WHERE PersonGroupMember.groupMemberPersonUid = :accountPersonUid\n           AND PersonGroupMember.groupMemberActive \n           AND (:excludeClazz = 0 OR :excludeClazz NOT IN\n                    (SELECT clazzEnrolmentClazzUid \n                       FROM ClazzEnrolment \n                      WHERE clazzEnrolmentPersonUid = Person.personUid \n                            AND :timestamp BETWEEN ClazzEnrolment.clazzEnrolmentDateJoined \n                                AND ClazzEnrolment.clazzEnrolmentDateLeft\n           AND ClazzEnrolment.clazzEnrolmentActive))\n           AND (:excludeSchool = 0 OR :excludeSchool NOT IN\n                    (SELECT schoolMemberSchoolUid\n                      FROM SchoolMember \n                     WHERE schoolMemberPersonUid = Person.personUid \n                       AND :timestamp BETWEEN SchoolMember.schoolMemberJoinDate\n                            AND SchoolMember.schoolMemberLeftDate ))\n           AND Person.personType = 0                  \n           AND (Person.personUid NOT IN (:excludeSelected))\n           AND (:searchText = \'%\' \n               OR Person.firstNames || \' \' || Person.lastName LIKE :searchText)\n      GROUP BY Person.personUid\n      ORDER BY CASE(:sortOrder)\n               WHEN 1 THEN Person.firstNames\n               WHEN 3 THEN Person.lastName\n               ELSE \'\'\n               END ASC,\n               CASE(:sortOrder)\n               WHEN 2 THEN Person.firstNames\n               WHEN 4 THEN Person.lastName\n               ELSE \'\'\n               END DESC\n    ")
    public abstract java.util.List<com.ustadmobile.lib.db.entities.Person> findPersonsWithPermissionAsList(long timestamp, long excludeClazz, long excludeSchool, @org.jetbrains.annotations.NotNull()
    java.util.List<java.lang.Long> excludeSelected, long accountPersonUid, int sortOrder, @org.jetbrains.annotations.Nullable()
    java.lang.String searchText);
    
    @org.jetbrains.annotations.NotNull()
    @com.ustadmobile.door.annotation.QueryLiveTables(value = {"Person", "PersonParentJoin"})
    @androidx.room.Query(value = "\n        SELECT Person.*, PersonParentJoin.* \n          FROM Person\n     LEFT JOIN PersonParentJoin on ppjUid = (\n                SELECT ppjUid \n                  FROM PersonParentJoin\n                 WHERE ppjMinorPersonUid = :personUid \n                       AND ppjParentPersonUid = :activeUserPersonUid \n                LIMIT 1)     \n         WHERE Person.personUid = :personUid\n        ")
    public abstract com.ustadmobile.door.DoorLiveData<com.ustadmobile.lib.db.entities.PersonWithPersonParentJoin> findByUidWithDisplayDetailsLive(long personUid, long activeUserPersonUid);
    
    private final void createAuditLog(long toPersonUid, long fromPersonUid) {
    }
    
    @androidx.room.Insert()
    public abstract long insertAuditLog(@org.jetbrains.annotations.NotNull()
    com.ustadmobile.lib.db.entities.AuditLog entity);
    
    @org.jetbrains.annotations.NotNull()
    @androidx.room.Query(value = "SELECT * FROM Person")
    public abstract java.util.List<com.ustadmobile.lib.db.entities.Person> getAllPerson();
    
    @kotlin.Metadata(mv = {1, 6, 0}, k = 1, d1 = {"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010\t\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001c\u0010\t\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001c\u0010\u000f\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\f\"\u0004\b\u0011\u0010\u000eR\u001c\u0010\u0012\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\f\"\u0004\b\u0014\u0010\u000eR\u001a\u0010\u0015\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001b"}, d2 = {"Lcom/ustadmobile/core/db/dao/PersonDao$PersonUidAndPasswordHash;", "", "()V", "admin", "", "getAdmin", "()Z", "setAdmin", "(Z)V", "firstNames", "", "getFirstNames", "()Ljava/lang/String;", "setFirstNames", "(Ljava/lang/String;)V", "lastName", "getLastName", "setLastName", "passwordHash", "getPasswordHash", "setPasswordHash", "personUid", "", "getPersonUid", "()J", "setPersonUid", "(J)V", "lib-database"})
    public static final class PersonUidAndPasswordHash {
        @org.jetbrains.annotations.Nullable()
        private java.lang.String passwordHash;
        private long personUid = 0L;
        @org.jetbrains.annotations.Nullable()
        private java.lang.String firstNames;
        @org.jetbrains.annotations.Nullable()
        private java.lang.String lastName;
        private boolean admin = false;
        
        public PersonUidAndPasswordHash() {
            super();
        }
        
        @org.jetbrains.annotations.Nullable()
        public final java.lang.String getPasswordHash() {
            return null;
        }
        
        public final void setPasswordHash(@org.jetbrains.annotations.Nullable()
        java.lang.String p0) {
        }
        
        public final long getPersonUid() {
            return 0L;
        }
        
        public final void setPersonUid(long p0) {
        }
        
        @org.jetbrains.annotations.Nullable()
        public final java.lang.String getFirstNames() {
            return null;
        }
        
        public final void setFirstNames(@org.jetbrains.annotations.Nullable()
        java.lang.String p0) {
        }
        
        @org.jetbrains.annotations.Nullable()
        public final java.lang.String getLastName() {
            return null;
        }
        
        public final void setLastName(@org.jetbrains.annotations.Nullable()
        java.lang.String p0) {
        }
        
        public final boolean getAdmin() {
            return false;
        }
        
        public final void setAdmin(boolean p0) {
        }
    }
    
    @kotlin.Metadata(mv = {1, 6, 0}, k = 1, d1 = {"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0087\b\u0018\u0000 $2\u00020\u0001:\u0002#$B+\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nB\u0019\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0007H\u00c6\u0003J\u001d\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u0003H\u00d6\u0001J\b\u0010\u001b\u001a\u00020\u0007H\u0016J!\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u00c7\u0001R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013\u00a8\u0006%"}, d2 = {"Lcom/ustadmobile/core/db/dao/PersonDao$PersonNameAndUid;", "", "seen1", "", "personUid", "", "name", "", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(IJLjava/lang/String;Lkotlinx/serialization/internal/SerializationConstructorMarker;)V", "(JLjava/lang/String;)V", "getName", "()Ljava/lang/String;", "setName", "(Ljava/lang/String;)V", "getPersonUid", "()J", "setPersonUid", "(J)V", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "$serializer", "Companion", "lib-database"})
    @kotlinx.serialization.Serializable()
    public static final class PersonNameAndUid {
        @org.jetbrains.annotations.NotNull()
        public static final com.ustadmobile.core.db.dao.PersonDao.PersonNameAndUid.Companion Companion = null;
        private long personUid;
        @org.jetbrains.annotations.NotNull()
        private java.lang.String name;
        
        @org.jetbrains.annotations.NotNull()
        public final com.ustadmobile.core.db.dao.PersonDao.PersonNameAndUid copy(long personUid, @org.jetbrains.annotations.NotNull()
        java.lang.String name) {
            return null;
        }
        
        @java.lang.Override()
        public boolean equals(@org.jetbrains.annotations.Nullable()
        java.lang.Object other) {
            return false;
        }
        
        @java.lang.Override()
        public int hashCode() {
            return 0;
        }
        
        @kotlin.jvm.JvmStatic()
        public static final void write$Self(@org.jetbrains.annotations.NotNull()
        com.ustadmobile.core.db.dao.PersonDao.PersonNameAndUid self, @org.jetbrains.annotations.NotNull()
        kotlinx.serialization.encoding.CompositeEncoder output, @org.jetbrains.annotations.NotNull()
        kotlinx.serialization.descriptors.SerialDescriptor serialDesc) {
        }
        
        public PersonNameAndUid() {
            super();
        }
        
        public PersonNameAndUid(long personUid, @org.jetbrains.annotations.NotNull()
        java.lang.String name) {
            super();
        }
        
        public final long component1() {
            return 0L;
        }
        
        public final long getPersonUid() {
            return 0L;
        }
        
        public final void setPersonUid(long p0) {
        }
        
        @org.jetbrains.annotations.NotNull()
        public final java.lang.String component2() {
            return null;
        }
        
        @org.jetbrains.annotations.NotNull()
        public final java.lang.String getName() {
            return null;
        }
        
        public final void setName(@org.jetbrains.annotations.NotNull()
        java.lang.String p0) {
        }
        
        @org.jetbrains.annotations.NotNull()
        @java.lang.Override()
        public java.lang.String toString() {
            return null;
        }
        
        @kotlin.Metadata(mv = {1, 6, 0}, k = 1, d1 = {"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u00c6\u0001\u00a8\u0006\u0006"}, d2 = {"Lcom/ustadmobile/core/db/dao/PersonDao$PersonNameAndUid$Companion;", "", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lcom/ustadmobile/core/db/dao/PersonDao$PersonNameAndUid;", "lib-database"})
        public static final class Companion {
            
            private Companion() {
                super();
            }
            
            @org.jetbrains.annotations.NotNull()
            public final kotlinx.serialization.KSerializer<com.ustadmobile.core.db.dao.PersonDao.PersonNameAndUid> serializer() {
                return null;
            }
        }
        
        @kotlin.Metadata(mv = {1, 6, 0}, k = 1, d1 = {"\u00006\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n0\tH\u00d6\u0001\u00a2\u0006\u0002\u0010\u000bJ\u0011\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\u0019\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0002H\u00d6\u0001R\u0014\u0010\u0004\u001a\u00020\u00058VX\u00d6\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0014"}, d2 = {"com/ustadmobile/core/db/dao/PersonDao.PersonNameAndUid.$serializer", "Lkotlinx/serialization/internal/GeneratedSerializer;", "Lcom/ustadmobile/core/db/dao/PersonDao$PersonNameAndUid;", "()V", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "getDescriptor", "()Lkotlinx/serialization/descriptors/SerialDescriptor;", "childSerializers", "", "Lkotlinx/serialization/KSerializer;", "()[Lkotlinx/serialization/KSerializer;", "deserialize", "decoder", "Lkotlinx/serialization/encoding/Decoder;", "serialize", "", "encoder", "Lkotlinx/serialization/encoding/Encoder;", "value", "lib-database"})
        @java.lang.Deprecated()
        public static final class $serializer implements kotlinx.serialization.internal.GeneratedSerializer<com.ustadmobile.core.db.dao.PersonDao.PersonNameAndUid> {
            @org.jetbrains.annotations.NotNull()
            public static final com.ustadmobile.core.db.dao.PersonDao.PersonNameAndUid.$serializer INSTANCE = null;
            
            private $serializer() {
                super();
            }
            
            @org.jetbrains.annotations.NotNull()
            @java.lang.Override()
            public kotlinx.serialization.KSerializer<?>[] childSerializers() {
                return null;
            }
            
            @org.jetbrains.annotations.NotNull()
            @java.lang.Override()
            public com.ustadmobile.core.db.dao.PersonDao.PersonNameAndUid deserialize(@org.jetbrains.annotations.NotNull()
            kotlinx.serialization.encoding.Decoder decoder) {
                return null;
            }
            
            @org.jetbrains.annotations.NotNull()
            @java.lang.Override()
            public kotlinx.serialization.descriptors.SerialDescriptor getDescriptor() {
                return null;
            }
            
            @java.lang.Override()
            public void serialize(@org.jetbrains.annotations.NotNull()
            kotlinx.serialization.encoding.Encoder encoder, @org.jetbrains.annotations.NotNull()
            com.ustadmobile.core.db.dao.PersonDao.PersonNameAndUid value) {
            }
            
            @org.jetbrains.annotations.NotNull()
            public kotlinx.serialization.KSerializer<?>[] typeParametersSerializers() {
                return null;
            }
        }
    }
    
    @kotlin.Metadata(mv = {1, 6, 0}, k = 1, d1 = {"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\u00020\u00048\u0006X\u0087T\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0005\u0010\u0002R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\fX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\fX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2 = {"Lcom/ustadmobile/core/db/dao/PersonDao$Companion;", "", "()V", "ENTITY_PERSONS_WITH_LEARNING_RECORD_PERMISSION", "", "getENTITY_PERSONS_WITH_LEARNING_RECORD_PERMISSION$annotations", "ENTITY_PERSONS_WITH_PERMISSION_PT1", "ENTITY_PERSONS_WITH_PERMISSION_PT2", "ENTITY_PERSONS_WITH_PERMISSION_PT4", "SESSION_LENGTH", "", "SORT_FIRST_NAME_ASC", "", "SORT_FIRST_NAME_DESC", "SORT_LAST_NAME_ASC", "SORT_LAST_NAME_DESC", "SQL_SELECT_LIST_WITH_PERMISSION", "lib-database"})
    public static final class Companion {
        
        private Companion() {
            super();
        }
        
        @java.lang.Deprecated()
        public static void getENTITY_PERSONS_WITH_LEARNING_RECORD_PERMISSION$annotations() {
        }
    }
}