package com.ustadmobile.core.db.dao;

import java.lang.System;

@androidx.room.Dao()
@com.ustadmobile.door.annotation.Repository()
@kotlin.Metadata(mv = {1, 6, 0}, k = 1, d1 = {"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0010\b\n\u0002\b\u0003\b\'\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\'J\u001b\u0010\u0007\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0006H\'J\u001b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u0006H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\bJ\u0011\u0010\u000e\u001a\u00020\u000fH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0010J\u0011\u0010\u0011\u001a\u00020\u000fH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0010J\u0011\u0010\u0012\u001a\u00020\u000fH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0010J\u0011\u0010\u0013\u001a\u00020\u000fH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0010J\u001b\u0010\u0014\u001a\u00020\u000f2\b\b\u0001\u0010\u0015\u001a\u00020\u0006H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\bJ\u001b\u0010\u0016\u001a\u00020\u000f2\b\b\u0001\u0010\u0015\u001a\u00020\u0006H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\bJ\u001b\u0010\u0017\u001a\u00020\u000f2\b\b\u0001\u0010\u0015\u001a\u00020\u0006H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\bJ\u001b\u0010\u0018\u001a\u00020\u000f2\b\b\u0001\u0010\u0015\u001a\u00020\u0006H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\bJ\u0019\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0002H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001c\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u001d"}, d2 = {"Lcom/ustadmobile/core/db/dao/PersonGroupDao;", "Lcom/ustadmobile/core/db/dao/BaseDao;", "Lcom/ustadmobile/lib/db/entities/PersonGroup;", "()V", "findByUid", "uid", "", "findByUidAsync", "(JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findByUidLive", "Lcom/ustadmobile/door/DoorLiveData;", "findNameByGroupUid", "", "groupUid", "replicateOnChange", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "replicateOnChangeClazzBased", "replicateOnChangePersonBased", "replicateOnChangeSchoolBased", "replicateOnNewNode", "newNodeId", "replicateOnNewNodeClazzBased", "replicateOnNewNodePersonBased", "replicateOnNewNodeSchoolBased", "updateAsync", "", "entity", "(Lcom/ustadmobile/lib/db/entities/PersonGroup;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "lib-database"})
public abstract class PersonGroupDao implements com.ustadmobile.core.db.dao.BaseDao<com.ustadmobile.lib.db.entities.PersonGroup> {
    
    public PersonGroupDao() {
        super();
    }
    
    @org.jetbrains.annotations.Nullable()
    @com.ustadmobile.door.annotation.ReplicationRunOnNewNode()
    @androidx.room.Query(value = "\n     REPLACE INTO PersonGroupReplicate(pgPk, pgDestination)\n      SELECT DISTINCT \n      PersonGroup.groupUid AS pgUid\n    ,\n             :newNodeId AS pgDestination\n        FROM UserSession\n             JOIN PersonGroupMember\n                    ON UserSession.usPersonUid = PersonGroupMember.groupMemberPersonUid\n             \n            JOIN ScopedGrant\n                 ON ScopedGrant.sgGroupUid = PersonGroupMember.groupMemberGroupUid\n                    AND (ScopedGrant.sgPermissions &\n                    64\n                    \n                                                    ) > 0\n            JOIN Person \n                 ON \n                ((ScopedGrant.sgTableId = -2\n                    AND ScopedGrant.sgEntityUid = -2)\n                 OR (ScopedGrant.sgTableId = 9\n                    AND ScopedGrant.sgEntityUid = Person.personUid)\n                 OR (ScopedGrant.sgTableId = 6       \n                    AND Person.personUid IN (\n                        SELECT DISTINCT clazzEnrolmentPersonUid\n                          FROM ClazzEnrolment\n                         WHERE clazzEnrolmentClazzUid =ScopedGrant.sgEntityUid \n                           AND ClazzEnrolment.clazzEnrolmentActive))\n                 OR (ScopedGrant.sgTableId = 164\n                    AND Person.personUid IN (\n                        SELECT DISTINCT schoolMemberPersonUid\n                          FROM SchoolMember\n                         WHERE schoolMemberSchoolUid = ScopedGrant.sgEntityUid\n                           AND schoolMemberActive))\n                           )    \n        \n        \n             JOIN PersonGroupMember PersonsWithPerm_GroupMember\n                    ON PersonsWithPerm_GroupMember.groupMemberPersonUid = Person.personUid\n             JOIN PersonGroup\n                    ON PersonGroup.groupUid = PersonsWithPerm_GroupMember.groupMemberGroupUid\n       WHERE UserSession.usClientNodeId = :newNodeId\n         AND UserSession.usStatus = 1\n         AND \n      PersonGroup.groupLct != COALESCE(\n         (SELECT pgVersionId\n            FROM PersonGroupReplicate\n           WHERE pgPk = PersonGroup.groupUid\n             AND pgDestination = UserSession.usClientNodeId), 0)\n    \n      /*psql ON CONFLICT(pgPk, pgDestination) DO UPDATE\n             SET pgPending = true\n      */       \n    ")
    @com.ustadmobile.door.annotation.ReplicationCheckPendingNotificationsFor(value = {com.ustadmobile.lib.db.entities.PersonGroup.class})
    public abstract java.lang.Object replicateOnNewNode(@com.ustadmobile.door.annotation.NewNodeIdParam()
    long newNodeId, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n REPLACE INTO PersonGroupReplicate(pgPk, pgDestination)\n  SELECT DISTINCT \n      PersonGroup.groupUid AS pgUid\n     ,\n         UserSession.usClientNodeId AS pgDestination\n    FROM ChangeLog\n         JOIN PersonGroup\n              ON ChangeLog.chTableId = 43\n                AND ChangeLog.chEntityPk = PersonGroup.groupUid\n         JOIN PersonGroupMember\n              ON PersonGroupMember.groupMemberGroupUid = PersonGroup.groupUid\n         JOIN Person\n              ON PersonGroupMember.groupMemberPersonUid = Person.personUid\n         \n            JOIN ScopedGrant \n                   ON \n            ((ScopedGrant.sgTableId = -2\n                    AND ScopedGrant.sgEntityUid = -2)\n                 OR (ScopedGrant.sgTableId = 9\n                    AND ScopedGrant.sgEntityUid = Person.personUid)\n                 OR (ScopedGrant.sgTableId = 6       \n                    AND ScopedGrant.sgEntityUid IN (\n                        SELECT DISTINCT clazzEnrolmentClazzUid\n                          FROM ClazzEnrolment\n                         WHERE clazzEnrolmentPersonUid = Person.personUid \n                           AND ClazzEnrolment.clazzEnrolmentActive))\n                 OR (ScopedGrant.sgTableId = 164\n                    AND ScopedGrant.sgEntityUid IN (\n                        SELECT DISTINCT schoolMemberSchoolUid\n                          FROM SchoolMember\n                         WHERE schoolMemberPersonUid = Person.personUid\n                           AND schoolMemberActive))\n                           )\n        \n                   AND (ScopedGrant.sgPermissions & \n        \n              64\n              \n                                                     ) > 0\n             JOIN PersonGroupMember AS PrsGrpMbr\n                   ON ScopedGrant.sgGroupUid = PrsGrpMbr.groupMemberGroupUid\n              JOIN UserSession\n                   ON UserSession.usPersonUid = PrsGrpMbr.groupMemberPersonUid\n                      AND UserSession.usStatus = 1\n                        \n   WHERE \n            UserSession.usClientNodeId != (\n                 SELECT nodeClientId \n                   FROM SyncNode\n                  LIMIT 1)\n        \n     AND \n      PersonGroup.groupLct != COALESCE(\n         (SELECT pgVersionId\n            FROM PersonGroupReplicate\n           WHERE pgPk = PersonGroup.groupUid\n             AND pgDestination = UserSession.usClientNodeId), 0)\n    \n /*psql ON CONFLICT(pgPk, pgDestination) DO UPDATE\n     SET pgPending = true\n  */               \n    ")
    @com.ustadmobile.door.annotation.ReplicationCheckPendingNotificationsFor(value = {com.ustadmobile.lib.db.entities.PersonGroup.class})
    @com.ustadmobile.door.annotation.ReplicationRunOnChange(value = {com.ustadmobile.lib.db.entities.PersonGroup.class})
    public abstract java.lang.Object replicateOnChange(@org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n REPLACE INTO PersonGroupReplicate(pgPk, pgDestination)\n       SELECT DISTINCT PersonGroup.groupUid AS pgUid,\n              UserSession.usClientNodeId AS pgDestination\n         FROM ChangeLog\n              JOIN PersonGroup\n                   ON ChangeLog.chTableId = 43\n                      AND ChangeLog.chEntityPk = PersonGroup.groupUid     \n         JOIN ScopedGrant ScopedGrantEntity\n              ON PersonGroup.groupUid = ScopedGrantEntity.sgGroupUid\n         JOIN Clazz \n              ON ScopedGrantEntity.sgTableId = 6\n                 AND ScopedGrantEntity.sgEntityUid = Clazz.clazzUid\n              \n            JOIN ScopedGrant\n                 ON \n            ((ScopedGrant.sgTableId = -2\n                                AND ScopedGrant.sgEntityUid = -2)\n                            OR (ScopedGrant.sgTableId = 6\n                                AND ScopedGrant.sgEntityUid = Clazz.clazzUid)\n                            OR (ScopedGrant.sgTableId = 164\n                                AND ScopedGrant.sgEntityUid = Clazz.clazzSchoolUid))\n        \n                    AND (ScopedGrant.sgPermissions & \n        \n                 2\n                 \n              \n                                                       ) > 0\n             JOIN PersonGroupMember AS PrsGrpMbr\n                   ON ScopedGrant.sgGroupUid = PrsGrpMbr.groupMemberGroupUid\n                                               \n              JOIN UserSession\n                   ON UserSession.usPersonUid = PrsGrpMbr.groupMemberPersonUid\n                      AND UserSession.usStatus = 1\n              \n        WHERE UserSession.usClientNodeId != (\n                SELECT nodeClientId \n                  FROM SyncNode\n                 LIMIT 1)\n          AND PersonGroup.groupLct != COALESCE(\n              (SELECT pgVersionId\n                 FROM PersonGroupReplicate\n                WHERE pgPk = PersonGroup.groupUid\n                  AND pgDestination = UserSession.usClientNodeId), 0)\n    /*psql ON CONFLICT(pgPk, pgDestination) DO UPDATE\n     SET pgPending = true\n    */               \n    ")
    @com.ustadmobile.door.annotation.ReplicationCheckPendingNotificationsFor(value = {com.ustadmobile.lib.db.entities.PersonGroup.class})
    @com.ustadmobile.door.annotation.ReplicationRunOnChange(value = {com.ustadmobile.lib.db.entities.PersonGroup.class})
    public abstract java.lang.Object replicateOnChangeClazzBased(@org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @com.ustadmobile.door.annotation.ReplicationRunOnNewNode()
    @androidx.room.Query(value = "\n REPLACE INTO PersonGroupReplicate(pgPk, pgDestination)\n  SELECT DISTINCT \n      PersonGroup.groupUid AS pgUid\n     ,\n         UserSession.usClientNodeId AS pgDestination\n    FROM UserSession\n         JOIN PersonGroupMember \n              ON UserSession.usPersonUid = PersonGroupMember.groupMemberPersonUid\n         \n               JOIN ScopedGrant\n                    ON ScopedGrant.sgGroupUid = PersonGroupMember.groupMemberGroupUid\n                        AND (ScopedGrant.sgPermissions & \n        \n              2 \n              \n                       ) > 0\n               JOIN Clazz \n                    ON \n            ((ScopedGrant.sgTableId = -2\n                                AND ScopedGrant.sgEntityUid = -2)\n                            OR (ScopedGrant.sgTableId = 6\n                                AND ScopedGrant.sgEntityUid = Clazz.clazzUid)\n                            OR (ScopedGrant.sgTableId = 164\n                                AND ScopedGrant.sgEntityUid = Clazz.clazzSchoolUid))\n        \n        \n         JOIN ScopedGrant ScopedGrantEntity\n              ON Clazz.clazzUid = ScopedGrantEntity.sgEntityUid\n                 AND ScopedGrantEntity.sgTableId = 6\n         JOIN PersonGroup\n              ON ScopedGrantEntity.sgGroupUid = PersonGroup.groupUid\n   WHERE UserSession.usClientNodeId = :newNodeId\n         AND UserSession.usStatus = 1\n         AND PersonGroup.groupLct != COALESCE(\n              (SELECT pgVersionId\n                 FROM PersonGroupReplicate\n                WHERE pgPk = PersonGroup.groupUid\n                  AND pgDestination = UserSession.usClientNodeId), 0) \n      /*psql ON CONFLICT(pgPk, pgDestination) DO UPDATE\n             SET pgPending = true\n      */      \n    ")
    @com.ustadmobile.door.annotation.ReplicationCheckPendingNotificationsFor(value = {com.ustadmobile.lib.db.entities.PersonGroup.class})
    public abstract java.lang.Object replicateOnNewNodeClazzBased(@com.ustadmobile.door.annotation.NewNodeIdParam()
    long newNodeId, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n REPLACE INTO PersonGroupReplicate(pgPk, pgDestination)\n       SELECT DISTINCT PersonGroup.groupUid AS pgUid,\n              UserSession.usClientNodeId AS pgDestination\n         FROM ChangeLog\n              JOIN PersonGroup\n                   ON ChangeLog.chTableId = 43\n                      AND ChangeLog.chEntityPk = PersonGroup.groupUid     \n         JOIN ScopedGrant ScopedGrantEntity\n              ON PersonGroup.groupUid = ScopedGrantEntity.sgGroupUid\n         JOIN Person \n              ON ScopedGrantEntity.sgTableId = 9\n                 AND ScopedGrantEntity.sgEntityUid = Person.personUid\n         \n            JOIN ScopedGrant \n                   ON \n            ((ScopedGrant.sgTableId = -2\n                    AND ScopedGrant.sgEntityUid = -2)\n                 OR (ScopedGrant.sgTableId = 9\n                    AND ScopedGrant.sgEntityUid = Person.personUid)\n                 OR (ScopedGrant.sgTableId = 6       \n                    AND ScopedGrant.sgEntityUid IN (\n                        SELECT DISTINCT clazzEnrolmentClazzUid\n                          FROM ClazzEnrolment\n                         WHERE clazzEnrolmentPersonUid = Person.personUid \n                           AND ClazzEnrolment.clazzEnrolmentActive))\n                 OR (ScopedGrant.sgTableId = 164\n                    AND ScopedGrant.sgEntityUid IN (\n                        SELECT DISTINCT schoolMemberSchoolUid\n                          FROM SchoolMember\n                         WHERE schoolMemberPersonUid = Person.personUid\n                           AND schoolMemberActive))\n                           )\n        \n                   AND (ScopedGrant.sgPermissions & \n        \n              64\n              \n                                                     ) > 0\n             JOIN PersonGroupMember AS PrsGrpMbr\n                   ON ScopedGrant.sgGroupUid = PrsGrpMbr.groupMemberGroupUid\n              JOIN UserSession\n                   ON UserSession.usPersonUid = PrsGrpMbr.groupMemberPersonUid\n                      AND UserSession.usStatus = 1\n                        \n        WHERE UserSession.usClientNodeId != (\n                SELECT nodeClientId \n                  FROM SyncNode\n                 LIMIT 1)\n          AND PersonGroup.groupLct != COALESCE(\n              (SELECT pgVersionId\n                 FROM PersonGroupReplicate\n                WHERE pgPk = PersonGroup.groupUid\n                  AND pgDestination = UserSession.usClientNodeId), 0)\n    /*psql ON CONFLICT(pgPk, pgDestination) DO UPDATE\n     SET pgPending = true\n    */                     \n    ")
    @com.ustadmobile.door.annotation.ReplicationCheckPendingNotificationsFor(value = {com.ustadmobile.lib.db.entities.PersonGroup.class})
    @com.ustadmobile.door.annotation.ReplicationRunOnChange(value = {com.ustadmobile.lib.db.entities.PersonGroup.class})
    public abstract java.lang.Object replicateOnChangePersonBased(@org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @com.ustadmobile.door.annotation.ReplicationRunOnNewNode()
    @androidx.room.Query(value = "\n REPLACE INTO PersonGroupReplicate(pgPk, pgDestination)\n  SELECT DISTINCT \n      PersonGroup.groupUid AS pgUid\n     ,\n         UserSession.usClientNodeId AS pgDestination\n    FROM UserSession\n         JOIN PersonGroupMember \n              ON UserSession.usPersonUid = PersonGroupMember.groupMemberPersonUid\n         \n            JOIN ScopedGrant\n                 ON ScopedGrant.sgGroupUid = PersonGroupMember.groupMemberGroupUid\n                    AND (ScopedGrant.sgPermissions &\n              64\n              \n                                                    ) > 0\n            JOIN Person \n                 ON \n                ((ScopedGrant.sgTableId = -2\n                    AND ScopedGrant.sgEntityUid = -2)\n                 OR (ScopedGrant.sgTableId = 9\n                    AND ScopedGrant.sgEntityUid = Person.personUid)\n                 OR (ScopedGrant.sgTableId = 6       \n                    AND Person.personUid IN (\n                        SELECT DISTINCT clazzEnrolmentPersonUid\n                          FROM ClazzEnrolment\n                         WHERE clazzEnrolmentClazzUid =ScopedGrant.sgEntityUid \n                           AND ClazzEnrolment.clazzEnrolmentActive))\n                 OR (ScopedGrant.sgTableId = 164\n                    AND Person.personUid IN (\n                        SELECT DISTINCT schoolMemberPersonUid\n                          FROM SchoolMember\n                         WHERE schoolMemberSchoolUid = ScopedGrant.sgEntityUid\n                           AND schoolMemberActive))\n                           )    \n        \n        \n         JOIN ScopedGrant ScopedGrantEntity\n              ON Person.personUid = ScopedGrantEntity.sgEntityUid\n                 AND ScopedGrantEntity.sgTableId = 9\n         JOIN PersonGroup\n              ON ScopedGrantEntity.sgGroupUid = PersonGroup.groupUid\n   WHERE UserSession.usClientNodeId = :newNodeId\n         AND UserSession.usStatus = 1\n         AND PersonGroup.groupLct != COALESCE(\n              (SELECT pgVersionId\n                 FROM PersonGroupReplicate\n                WHERE pgPk = PersonGroup.groupUid\n                  AND pgDestination = UserSession.usClientNodeId), 0) \n      /*psql ON CONFLICT(pgPk, pgDestination) DO UPDATE\n             SET pgPending = true\n      */      \n    ")
    @com.ustadmobile.door.annotation.ReplicationCheckPendingNotificationsFor(value = {com.ustadmobile.lib.db.entities.PersonGroup.class})
    public abstract java.lang.Object replicateOnNewNodePersonBased(@com.ustadmobile.door.annotation.NewNodeIdParam()
    long newNodeId, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n REPLACE INTO PersonGroupReplicate(pgPk, pgDestination)\n       SELECT DISTINCT PersonGroup.groupUid AS pgUid,\n              UserSession.usClientNodeId AS pgDestination\n         FROM ChangeLog\n              JOIN PersonGroup\n                   ON ChangeLog.chTableId = 43\n                      AND ChangeLog.chEntityPk = PersonGroup.groupUid     \n         JOIN ScopedGrant ScopedGrantEntity\n              ON PersonGroup.groupUid = ScopedGrantEntity.sgGroupUid\n         JOIN School \n              ON ScopedGrantEntity.sgTableId = 164\n                 AND ScopedGrantEntity.sgEntityUid = School.schoolUid\n         \n            JOIN ScopedGrant\n                 ON \n            ((ScopedGrant.sgTableId = -2\n                    AND ScopedGrant.sgEntityUid = -2)\n                OR (ScopedGrant.sgTableId = 164\n                    AND ScopedGrant.sgEntityUid = School.schoolUid))\n        \n                        AND (SCopedGrant.sgPermissions &\n        \n              536870912\n              \n                                                     ) > 0\n             JOIN PersonGroupMember AS PrsGrpMbr\n                   ON ScopedGrant.sgGroupUid = PrsGrpMbr.groupMemberGroupUid\n              JOIN UserSession\n                   ON UserSession.usPersonUid = PrsGrpMbr.groupMemberPersonUid\n                      AND UserSession.usStatus = 1\n                      \n                        \n        WHERE UserSession.usClientNodeId != (\n                SELECT nodeClientId \n                  FROM SyncNode\n                 LIMIT 1)\n          AND PersonGroup.groupLct != COALESCE(\n              (SELECT pgVersionId\n                 FROM PersonGroupReplicate\n                WHERE pgPk = PersonGroup.groupUid\n                  AND pgDestination = UserSession.usClientNodeId), 0)\n    /*psql ON CONFLICT(pgPk, pgDestination) DO UPDATE\n     SET pgPending = true\n    */                     \n    ")
    @com.ustadmobile.door.annotation.ReplicationCheckPendingNotificationsFor(value = {com.ustadmobile.lib.db.entities.PersonGroup.class})
    @com.ustadmobile.door.annotation.ReplicationRunOnChange(value = {com.ustadmobile.lib.db.entities.PersonGroup.class})
    public abstract java.lang.Object replicateOnChangeSchoolBased(@org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @com.ustadmobile.door.annotation.ReplicationRunOnNewNode()
    @androidx.room.Query(value = "\n REPLACE INTO PersonGroupReplicate(pgPk, pgDestination)\n  SELECT DISTINCT \n      PersonGroup.groupUid AS pgUid\n     ,\n         UserSession.usClientNodeId AS pgDestination\n    FROM UserSession\n         JOIN PersonGroupMember \n              ON UserSession.usPersonUid = PersonGroupMember.groupMemberPersonUid\n         \n            JOIN ScopedGrant \n                 ON ScopedGrant.sgGroupUid = PersonGroupMember.groupMemberGroupUid\n                        AND (ScopedGrant.sgPermissions &\n                 \n        \n              536870912\n              \n                    ) > 0\n            JOIN School\n                 ON \n            ((ScopedGrant.sgTableId = -2\n                    AND ScopedGrant.sgEntityUid = -2)\n                OR (ScopedGrant.sgTableId = 164\n                    AND ScopedGrant.sgEntityUid = School.schoolUid))\n        \n        \n         JOIN ScopedGrant ScopedGrantEntity\n              ON School.schoolUid = ScopedGrantEntity.sgEntityUid\n                 AND ScopedGrantEntity.sgTableId = 9\n         JOIN PersonGroup\n              ON ScopedGrantEntity.sgGroupUid = PersonGroup.groupUid\n   WHERE UserSession.usClientNodeId = :newNodeId\n         AND UserSession.usStatus = 1\n         AND PersonGroup.groupLct != COALESCE(\n              (SELECT pgVersionId\n                 FROM PersonGroupReplicate\n                WHERE pgPk = PersonGroup.groupUid\n                  AND pgDestination = UserSession.usClientNodeId), 0) \n      /*psql ON CONFLICT(pgPk, pgDestination) DO UPDATE\n             SET pgPending = true\n      */      \n    ")
    @com.ustadmobile.door.annotation.ReplicationCheckPendingNotificationsFor(value = {com.ustadmobile.lib.db.entities.PersonGroup.class})
    public abstract java.lang.Object replicateOnNewNodeSchoolBased(@com.ustadmobile.door.annotation.NewNodeIdParam()
    long newNodeId, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "SELECT * FROM PersonGroup WHERE groupUid = :uid")
    public abstract com.ustadmobile.lib.db.entities.PersonGroup findByUid(long uid);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "SELECT * FROM PersonGroup WHERE groupUid = :uid")
    public abstract java.lang.Object findByUidAsync(long uid, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super com.ustadmobile.lib.db.entities.PersonGroup> continuation);
    
    @org.jetbrains.annotations.NotNull()
    @androidx.room.Query(value = "SELECT * FROM PersonGroup WHERE groupUid = :uid")
    public abstract com.ustadmobile.door.DoorLiveData<com.ustadmobile.lib.db.entities.PersonGroup> findByUidLive(long uid);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Update()
    public abstract java.lang.Object updateAsync(@org.jetbrains.annotations.NotNull()
    com.ustadmobile.lib.db.entities.PersonGroup entity, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super java.lang.Integer> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n        Select CASE\n               WHEN Person.firstNames IS NOT NULL THEN Person.firstNames\n               ELSE PersonGroup.groupName \n               END AS name\n          FROM PersonGroup\n               LEFT JOIN Person\n                         ON Person.personGroupUid = PersonGroup.groupUid\n         WHERE PersonGroup.groupUid = :groupUid\n         LIMIT 1\n    ")
    public abstract java.lang.Object findNameByGroupUid(long groupUid, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super java.lang.String> continuation);
}