package com.ustadmobile.core.db.dao;

import java.lang.System;

@androidx.room.Dao()
@com.ustadmobile.door.annotation.Repository()
@kotlin.Metadata(mv = {1, 6, 0}, k = 1, d1 = {"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0003\b\'\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\'\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\tJ\u001f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u00052\u0006\u0010\b\u001a\u00020\u0007H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000bJ#\u0010\f\u001a\u0004\u0018\u00010\u00022\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\tJ1\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0007H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0012J\u0011\u0010\u0013\u001a\u00020\u0014H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0015J\u0011\u0010\u0016\u001a\u00020\u0014H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0015J\u0011\u0010\u0017\u001a\u00020\u0014H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0015J\u001b\u0010\u0018\u001a\u00020\u00142\b\b\u0001\u0010\u0019\u001a\u00020\u0007H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000bJ\u001b\u0010\u001a\u001a\u00020\u00142\b\b\u0001\u0010\u0019\u001a\u00020\u0007H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000bJ\u001b\u0010\u001b\u001a\u00020\u00142\b\b\u0001\u0010\u0019\u001a\u00020\u0007H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000bJ1\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020\u0007H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010 \u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006!"}, d2 = {"Lcom/ustadmobile/core/db/dao/PersonGroupMemberDao;", "Lcom/ustadmobile/core/db/dao/BaseDao;", "Lcom/ustadmobile/lib/db/entities/PersonGroupMember;", "()V", "checkPersonBelongsToGroup", "", "groupUid", "", "personUid", "(JJLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findAllGroupWherePersonIsIn", "(JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findByPersonUidAndGroupUid", "moveGroupAsync", "", "newGroup", "oldGroup", "changeTime", "(JJJJLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "replicateOnChange", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "replicateOnChangeClazzBased", "replicateOnChangeSchoolBased", "replicateOnNewNode", "newNodeId", "replicateOnNewNodeClazzBased", "replicateOnNewNodeSchoolBased", "updateGroupMemberActive", "activeStatus", "", "updateTime", "(ZJJJLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "lib-database"})
public abstract class PersonGroupMemberDao implements com.ustadmobile.core.db.dao.BaseDao<com.ustadmobile.lib.db.entities.PersonGroupMember> {
    
    public PersonGroupMemberDao() {
        super();
    }
    
    /**
     * PersonGroupMember must replicate to:
     * 1) Anyone who has select permission for the person linked to the member
     * 2) If this PersonGroupMember is related to a group that is used with ScopedGrant(s), then it
     *    must be replicated for anyone who has permission to select the subject (e.g. Clazz, School,
     *     Person, etc) of the ScopedGrant.
     */
    @org.jetbrains.annotations.Nullable()
    @com.ustadmobile.door.annotation.ReplicationRunOnNewNode()
    @androidx.room.Query(value = "\n     REPLACE INTO PersonGroupMemberReplicate(pgmPk, pgmDestination)\n      SELECT DISTINCT PersonGroupMember.groupMemberUid AS pgmUid,\n             :newNodeId AS pgmDestination\n        FROM UserSession\n             JOIN PersonGroupMember\n                    ON UserSession.usPersonUid = PersonGroupMember.groupMemberPersonUid\n             \n            JOIN ScopedGrant\n                 ON ScopedGrant.sgGroupUid = PersonGroupMember.groupMemberGroupUid\n                    AND (ScopedGrant.sgPermissions &\n                    64\n                    \n                                                    ) > 0\n            JOIN Person \n                 ON \n                ((ScopedGrant.sgTableId = -2\n                    AND ScopedGrant.sgEntityUid = -2)\n                 OR (ScopedGrant.sgTableId = 9\n                    AND ScopedGrant.sgEntityUid = Person.personUid)\n                 OR (ScopedGrant.sgTableId = 6       \n                    AND Person.personUid IN (\n                        SELECT DISTINCT clazzEnrolmentPersonUid\n                          FROM ClazzEnrolment\n                         WHERE clazzEnrolmentClazzUid =ScopedGrant.sgEntityUid \n                           AND ClazzEnrolment.clazzEnrolmentActive))\n                 OR (ScopedGrant.sgTableId = 164\n                    AND Person.personUid IN (\n                        SELECT DISTINCT schoolMemberPersonUid\n                          FROM SchoolMember\n                         WHERE schoolMemberSchoolUid = ScopedGrant.sgEntityUid\n                           AND schoolMemberActive))\n                           )    \n        \n        \n             JOIN PersonGroupMember PersonsWithPerm_GroupMember\n                    ON PersonsWithPerm_GroupMember.groupMemberPersonUid = Person.personUid\n       WHERE UserSession.usClientNodeId = :newNodeId\n         AND UserSession.usStatus = 1\n         AND PersonGroupMember.groupMemberLct != COALESCE(\n             (SELECT pgmVersionId\n                FROM PersonGroupMemberReplicate\n               WHERE pgmPk = PersonGroupMember.groupMemberUid\n                 AND pgmDestination = :newNodeId), 0) \n      /*psql ON CONFLICT(pgmPk, pgmDestination) DO UPDATE\n             SET pgmPending = true\n      */       \n    ")
    @com.ustadmobile.door.annotation.ReplicationCheckPendingNotificationsFor(value = {com.ustadmobile.lib.db.entities.PersonGroupMember.class})
    public abstract java.lang.Object replicateOnNewNode(@com.ustadmobile.door.annotation.NewNodeIdParam()
    long newNodeId, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n REPLACE INTO PersonGroupMemberReplicate(pgmPk, pgmDestination)\n  SELECT DISTINCT PersonGroupMember.groupMemberUid AS pgmUid,\n         UserSession.usClientNodeId AS pgmDestination\n    FROM ChangeLog\n         JOIN PersonGroupMember\n             ON ChangeLog.chTableId = 44\n                AND ChangeLog.chEntityPk = PersonGroupMember.groupMemberUid\n         JOIN Person\n              ON PersonGroupMember.groupMemberPersonUid = Person.personUid\n         \n            JOIN ScopedGrant \n                   ON \n            ((ScopedGrant.sgTableId = -2\n                    AND ScopedGrant.sgEntityUid = -2)\n                 OR (ScopedGrant.sgTableId = 9\n                    AND ScopedGrant.sgEntityUid = Person.personUid)\n                 OR (ScopedGrant.sgTableId = 6       \n                    AND ScopedGrant.sgEntityUid IN (\n                        SELECT DISTINCT clazzEnrolmentClazzUid\n                          FROM ClazzEnrolment\n                         WHERE clazzEnrolmentPersonUid = Person.personUid \n                           AND ClazzEnrolment.clazzEnrolmentActive))\n                 OR (ScopedGrant.sgTableId = 164\n                    AND ScopedGrant.sgEntityUid IN (\n                        SELECT DISTINCT schoolMemberSchoolUid\n                          FROM SchoolMember\n                         WHERE schoolMemberPersonUid = Person.personUid\n                           AND schoolMemberActive))\n                           )\n        \n                   AND (ScopedGrant.sgPermissions & \n        \n              64\n              \n                                                     ) > 0\n             JOIN PersonGroupMember AS PrsGrpMbr\n                   ON ScopedGrant.sgGroupUid = PrsGrpMbr.groupMemberGroupUid\n              JOIN UserSession\n                   ON UserSession.usPersonUid = PrsGrpMbr.groupMemberPersonUid\n                      AND UserSession.usStatus = 1\n        \n   WHERE UserSession.usClientNodeId != (\n         SELECT nodeClientId \n           FROM SyncNode\n          LIMIT 1)\n     AND PersonGroupMember.groupMemberLct != COALESCE(\n         (SELECT pgmVersionId\n            FROM PersonGroupMemberReplicate\n           WHERE pgmPk = PersonGroupMember.groupMemberUid\n             AND pgmDestination = UserSession.usClientNodeId), 0)\n     /*psql ON CONFLICT(pgmPk, pgmDestination) DO UPDATE\n         SET pgmPending = true\n      */               \n     ")
    @com.ustadmobile.door.annotation.ReplicationCheckPendingNotificationsFor(value = {com.ustadmobile.lib.db.entities.PersonGroupMember.class})
    @com.ustadmobile.door.annotation.ReplicationRunOnChange(value = {com.ustadmobile.lib.db.entities.PersonGroupMember.class})
    public abstract java.lang.Object replicateOnChange(@org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n REPLACE INTO PersonGroupMemberReplicate(pgmPk, pgmDestination)\n  SELECT DISTINCT PersonGroupMember.groupMemberUid AS pgmUid,\n         UserSession.usClientNodeId AS pgmDestination\n    FROM ChangeLog\n         JOIN PersonGroupMember\n             ON ChangeLog.chTableId = 44\n                AND ChangeLog.chEntityPk = PersonGroupMember.groupMemberUid\n         JOIN ScopedGrant ScopedGrantEntity\n              ON PersonGroupMember.groupMemberUid = ScopedGrantEntity.sgGroupUid\n         JOIN Clazz \n              ON ScopedGrantEntity.sgTableId = 6\n                 AND ScopedGrantEntity.sgEntityUid = Clazz.clazzUid\n         \n            JOIN ScopedGrant\n                 ON \n            ((ScopedGrant.sgTableId = -2\n                                AND ScopedGrant.sgEntityUid = -2)\n                            OR (ScopedGrant.sgTableId = 6\n                                AND ScopedGrant.sgEntityUid = Clazz.clazzUid)\n                            OR (ScopedGrant.sgTableId = 164\n                                AND ScopedGrant.sgEntityUid = Clazz.clazzSchoolUid))\n        \n                    AND (ScopedGrant.sgPermissions & \n        \n              2\n              \n              \n                                                       ) > 0\n             JOIN PersonGroupMember AS PrsGrpMbr\n                   ON ScopedGrant.sgGroupUid = PrsGrpMbr.groupMemberGroupUid\n                                               \n              JOIN UserSession\n                   ON UserSession.usPersonUid = PrsGrpMbr.groupMemberPersonUid\n                      AND UserSession.usStatus = 1\n              \n   WHERE UserSession.usClientNodeId != (\n                SELECT nodeClientId \n                  FROM SyncNode\n                 LIMIT 1)\n     AND PersonGroupMember.groupMemberLct != COALESCE(\n              (SELECT pgmVersionId\n                 FROM PersonGroupMemberReplicate\n                WHERE pgmPk = PersonGroupMember.groupMemberUid\n                  AND pgmDestination = UserSession.usClientNodeId), 0)\n  /*psql ON CONFLICT(pgmPk, pgmDestination) DO UPDATE\n     SET pgmPending = true\n    */                   \n    ")
    @com.ustadmobile.door.annotation.ReplicationCheckPendingNotificationsFor(value = {com.ustadmobile.lib.db.entities.PersonGroupMember.class})
    @com.ustadmobile.door.annotation.ReplicationRunOnChange(value = {com.ustadmobile.lib.db.entities.PersonGroupMember.class})
    public abstract java.lang.Object replicateOnChangeClazzBased(@org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @com.ustadmobile.door.annotation.ReplicationRunOnNewNode()
    @androidx.room.Query(value = "\n REPLACE INTO PersonGroupMemberReplicate(pgmPk, pgmDestination)\n      SELECT DISTINCT PersonGroupMember.groupMemberUid AS pgmUid,\n             :newNodeId AS pgmDestination\n        FROM UserSession\n             JOIN PersonGroupMember\n                  ON UserSession.usPersonUid = PersonGroupMember.groupMemberPersonUid\n             \n               JOIN ScopedGrant\n                    ON ScopedGrant.sgGroupUid = PersonGroupMember.groupMemberGroupUid\n                        AND (ScopedGrant.sgPermissions & \n        \n                  2 \n                  \n                       ) > 0\n               JOIN Clazz \n                    ON \n            ((ScopedGrant.sgTableId = -2\n                                AND ScopedGrant.sgEntityUid = -2)\n                            OR (ScopedGrant.sgTableId = 6\n                                AND ScopedGrant.sgEntityUid = Clazz.clazzUid)\n                            OR (ScopedGrant.sgTableId = 164\n                                AND ScopedGrant.sgEntityUid = Clazz.clazzSchoolUid))\n        \n        \n             JOIN ScopedGrant ScopedGrantEntity\n                  ON Clazz.clazzUid = ScopedGrantEntity.sgEntityUid\n                     AND ScopedGrantEntity.sgTableId = 6\n             JOIN PersonGroupMember PersonGroupMemberEntity\n                  ON PersonGroupMemberEntity.groupMemberGroupUid = ScopedGrantEntity.sgGroupUid\n       WHERE UserSession.usClientNodeId = :newNodeId\n         AND UserSession.usStatus = 1  \n         AND PersonGroupMember.groupMemberLct != COALESCE(\n             (SELECT pgmVersionId\n                FROM PersonGroupMemberReplicate\n               WHERE pgmPk = PersonGroupMember.groupMemberUid\n                 AND pgmDestination = :newNodeId), 0) \n      /*psql ON CONFLICT(pgmPk, pgmDestination) DO UPDATE\n             SET pgmPending = true\n      */                \n    ")
    @com.ustadmobile.door.annotation.ReplicationCheckPendingNotificationsFor(value = {com.ustadmobile.lib.db.entities.PersonGroupMember.class})
    public abstract java.lang.Object replicateOnNewNodeClazzBased(@com.ustadmobile.door.annotation.NewNodeIdParam()
    long newNodeId, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n REPLACE INTO PersonGroupMemberReplicate(pgmPk, pgmDestination)\n  SELECT DISTINCT PersonGroupMember.groupMemberUid AS pgmUid,\n         UserSession.usClientNodeId AS pgmDestination\n    FROM ChangeLog\n         JOIN PersonGroupMember\n             ON ChangeLog.chTableId = 44\n                AND ChangeLog.chEntityPk = PersonGroupMember.groupMemberUid\n         JOIN ScopedGrant ScopedGrantEntity\n              ON PersonGroupMember.groupMemberUid = ScopedGrantEntity.sgGroupUid\n         JOIN School \n              ON ScopedGrantEntity.sgTableId = 164\n                 AND ScopedGrantEntity.sgEntityUid = School.schoolUid\n         \n            JOIN ScopedGrant\n                 ON \n            ((ScopedGrant.sgTableId = -2\n                    AND ScopedGrant.sgEntityUid = -2)\n                OR (ScopedGrant.sgTableId = 164\n                    AND ScopedGrant.sgEntityUid = School.schoolUid))\n        \n                        AND (SCopedGrant.sgPermissions &\n        \n              536870912\n              \n                                                     ) > 0\n             JOIN PersonGroupMember AS PrsGrpMbr\n                   ON ScopedGrant.sgGroupUid = PrsGrpMbr.groupMemberGroupUid\n              JOIN UserSession\n                   ON UserSession.usPersonUid = PrsGrpMbr.groupMemberPersonUid\n                      AND UserSession.usStatus = 1\n                      \n        \n   WHERE UserSession.usClientNodeId != (\n                SELECT nodeClientId \n                  FROM SyncNode\n                 LIMIT 1)\n     AND PersonGroupMember.groupMemberLct != COALESCE(\n              (SELECT pgmVersionId\n                 FROM PersonGroupMemberReplicate\n                WHERE pgmPk = PersonGroupMember.groupMemberUid\n                  AND pgmDestination = UserSession.usClientNodeId), 0)\n  /*psql ON CONFLICT(pgmPk, pgmDestination) DO UPDATE\n     SET pgmPending = true\n    */                   \n    ")
    @com.ustadmobile.door.annotation.ReplicationCheckPendingNotificationsFor(value = {com.ustadmobile.lib.db.entities.PersonGroupMember.class})
    @com.ustadmobile.door.annotation.ReplicationRunOnChange(value = {com.ustadmobile.lib.db.entities.PersonGroupMember.class})
    public abstract java.lang.Object replicateOnChangeSchoolBased(@org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @com.ustadmobile.door.annotation.ReplicationRunOnNewNode()
    @androidx.room.Query(value = "\n REPLACE INTO PersonGroupMemberReplicate(pgmPk, pgmDestination)\n      SELECT DISTINCT PersonGroupMember.groupMemberUid AS pgmUid,\n             :newNodeId AS pgmDestination\n        FROM UserSession\n             JOIN PersonGroupMember\n                  ON UserSession.usPersonUid = PersonGroupMember.groupMemberPersonUid\n             \n            JOIN ScopedGrant \n                 ON ScopedGrant.sgGroupUid = PersonGroupMember.groupMemberGroupUid\n                        AND (ScopedGrant.sgPermissions &\n                 \n        \n                  536870912\n                  \n                    ) > 0\n            JOIN School\n                 ON \n            ((ScopedGrant.sgTableId = -2\n                    AND ScopedGrant.sgEntityUid = -2)\n                OR (ScopedGrant.sgTableId = 164\n                    AND ScopedGrant.sgEntityUid = School.schoolUid))\n        \n        \n             JOIN ScopedGrant ScopedGrantEntity\n                  ON School.schoolUid = ScopedGrantEntity.sgEntityUid\n                     AND ScopedGrantEntity.sgTableId = 164\n             JOIN PersonGroupMember PersonGroupMemberEntity\n                  ON PersonGroupMemberEntity.groupMemberGroupUid = ScopedGrantEntity.sgGroupUid\n       WHERE UserSession.usClientNodeId = :newNodeId\n         AND UserSession.usStatus = 1  \n         AND PersonGroupMember.groupMemberLct != COALESCE(\n             (SELECT pgmVersionId\n                FROM PersonGroupMemberReplicate\n               WHERE pgmPk = PersonGroupMember.groupMemberUid\n                 AND pgmDestination = :newNodeId), 0) \n      /*psql ON CONFLICT(pgmPk, pgmDestination) DO UPDATE\n             SET pgmPending = true\n      */                \n    ")
    @com.ustadmobile.door.annotation.ReplicationCheckPendingNotificationsFor(value = {com.ustadmobile.lib.db.entities.PersonGroupMember.class})
    public abstract java.lang.Object replicateOnNewNodeSchoolBased(@com.ustadmobile.door.annotation.NewNodeIdParam()
    long newNodeId, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "SELECT * FROM PersonGroupMember WHERE groupMemberPersonUid = :personUid AND PersonGroupMember.groupMemberActive")
    public abstract java.lang.Object findAllGroupWherePersonIsIn(long personUid, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super java.util.List<com.ustadmobile.lib.db.entities.PersonGroupMember>> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "SELECT * FROM PersonGroupMember WHERE groupMemberGroupUid = :groupUid \n             AND groupMemberPersonUid = :personUid AND PersonGroupMember.groupMemberActive")
    public abstract java.lang.Object checkPersonBelongsToGroup(long groupUid, long personUid, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super java.util.List<com.ustadmobile.lib.db.entities.PersonGroupMember>> continuation);
    
    /**
     * Updates an existing group membership to a new group
     */
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n        UPDATE PersonGroupMember \n           SET groupMemberGroupUid = :newGroup,\n               groupMemberLct = :changeTime\n         WHERE groupMemberPersonUid = :personUid \n           AND groupMemberGroupUid = :oldGroup \n           AND PersonGroupMember.groupMemberActive")
    public abstract java.lang.Object moveGroupAsync(long personUid, long newGroup, long oldGroup, long changeTime, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super java.lang.Integer> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n        UPDATE PersonGroupMember \n           SET groupMemberActive = :activeStatus,\n               groupMemberLct = :updateTime\n        WHERE groupMemberPersonUid = :personUid \n          AND groupMemberGroupUid = :groupUid \n          AND PersonGroupMember.groupMemberActive")
    public abstract java.lang.Object updateGroupMemberActive(boolean activeStatus, long personUid, long groupUid, long updateTime, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n        SELECT PersonGroupMember.*\n          FROM PersonGroupMember\n         WHERE PersonGroupMember.groupMemberPersonUid = :personUid\n           AND PersonGroupMember.groupMemberGroupUid = :groupUid\n    ")
    public abstract java.lang.Object findByPersonUidAndGroupUid(long personUid, long groupUid, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super com.ustadmobile.lib.db.entities.PersonGroupMember> continuation);
}