package com.ustadmobile.core.db.dao;

import java.lang.System;

@com.ustadmobile.door.annotation.Repository()
@androidx.room.Dao()
@kotlin.Metadata(mv = {1, 6, 0}, k = 1, d1 = {"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0007\b\'\u0018\u00002\u00020\u0001:\u0001\u001fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u001f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\bJ\'\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u0007H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\fJ\u001b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0007H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\bJ\u001b\u0010\u0010\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0007H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\bJ\u0019\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0005H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0013J\u0019\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0006\u001a\u00020\u0007H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\bJ!\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\fJ\u0011\u0010\u0018\u001a\u00020\u0019H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001aJ\u001b\u0010\u001b\u001a\u00020\u00192\b\b\u0001\u0010\u001c\u001a\u00020\u0007H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\bJ\u0019\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u0005H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0013\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006 "}, d2 = {"Lcom/ustadmobile/core/db/dao/PersonParentJoinDao;", "", "()V", "findByMinorPersonUid", "", "Lcom/ustadmobile/lib/db/entities/PersonParentJoin;", "minorPersonUid", "", "(JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findByMinorPersonUidWhereParentNotEnrolledInClazz", "Lcom/ustadmobile/core/db/dao/PersonParentJoinDao$ParentEnrolmentRequired;", "clazzUidFilter", "(JJLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findByUidWithMinorAsync", "Lcom/ustadmobile/lib/db/entities/PersonParentJoinWithMinorPerson;", "uid", "findByUidWithMinorAsyncFromWeb", "insertAsync", "entity", "(Lcom/ustadmobile/lib/db/entities/PersonParentJoin;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "isMinorApproved", "", "isParentOf", "userPersonUid", "replicateOnChange", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "replicateOnNewNode", "newNodeId", "updateAsync", "personParentJoin", "ParentEnrolmentRequired", "lib-database"})
public abstract class PersonParentJoinDao {
    
    public PersonParentJoinDao() {
        super();
    }
    
    @org.jetbrains.annotations.Nullable()
    @com.ustadmobile.door.annotation.ReplicationRunOnNewNode()
    @androidx.room.Query(value = "\n     REPLACE INTO PersonParentJoinReplicate(ppjPk, ppjDestination)\n      SELECT DISTINCT PersonParentJoin.ppjUid AS ppjPk,\n             :newNodeId AS ppjDestination\n        FROM UserSession\n             JOIN PersonGroupMember\n                  ON UserSession.usPersonUid = PersonGroupMember.groupMemberPersonUid\n             \n            JOIN ScopedGrant\n                 ON ScopedGrant.sgGroupUid = PersonGroupMember.groupMemberGroupUid\n                    AND (ScopedGrant.sgPermissions &\n                  64\n                  \n                                                    ) > 0\n            JOIN Person \n                 ON \n                ((ScopedGrant.sgTableId = -2\n                    AND ScopedGrant.sgEntityUid = -2)\n                 OR (ScopedGrant.sgTableId = 9\n                    AND ScopedGrant.sgEntityUid = Person.personUid)\n                 OR (ScopedGrant.sgTableId = 6       \n                    AND Person.personUid IN (\n                        SELECT DISTINCT clazzEnrolmentPersonUid\n                          FROM ClazzEnrolment\n                         WHERE clazzEnrolmentClazzUid =ScopedGrant.sgEntityUid \n                           AND ClazzEnrolment.clazzEnrolmentActive))\n                 OR (ScopedGrant.sgTableId = 164\n                    AND Person.personUid IN (\n                        SELECT DISTINCT schoolMemberPersonUid\n                          FROM SchoolMember\n                         WHERE schoolMemberSchoolUid = ScopedGrant.sgEntityUid\n                           AND schoolMemberActive))\n                           )    \n        \n        \n             JOIN PersonParentJoin\n                  ON PersonParentJoin.ppjParentPersonUid = Person.personUid       \n       WHERE UserSession.usStatus = 1\n         AND PersonParentJoin.ppjLct != COALESCE(\n             (SELECT ppjVersionId\n                FROM PersonParentJoinReplicate\n               WHERE ppjPk = PersonParentJoin.ppjUid\n                 AND ppjDestination = :newNodeId), 0) \n      /*psql ON CONFLICT(ppjPk, ppjDestination) DO UPDATE\n             SET ppjPending = true\n      */       \n    ")
    @com.ustadmobile.door.annotation.ReplicationCheckPendingNotificationsFor(value = {com.ustadmobile.lib.db.entities.PersonParentJoin.class})
    public abstract java.lang.Object replicateOnNewNode(@com.ustadmobile.door.annotation.NewNodeIdParam()
    long newNodeId, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n REPLACE INTO PersonParentJoinReplicate(ppjPk, ppjDestination)\n  SELECT DISTINCT PersonParentJoin.ppjUid AS ppjUid,\n         UserSession.usClientNodeId AS ppjDestination\n    FROM ChangeLog\n         JOIN PersonParentJoin\n             ON ChangeLog.chTableId = 512\n                AND ChangeLog.chEntityPk = PersonParentJoin.ppjUid\n         JOIN Person\n              ON PersonParentJoin.ppjParentPersonUid = Person.personUid\n         \n            JOIN ScopedGrant \n                   ON \n            ((ScopedGrant.sgTableId = -2\n                    AND ScopedGrant.sgEntityUid = -2)\n                 OR (ScopedGrant.sgTableId = 9\n                    AND ScopedGrant.sgEntityUid = Person.personUid)\n                 OR (ScopedGrant.sgTableId = 6       \n                    AND ScopedGrant.sgEntityUid IN (\n                        SELECT DISTINCT clazzEnrolmentClazzUid\n                          FROM ClazzEnrolment\n                         WHERE clazzEnrolmentPersonUid = Person.personUid \n                           AND ClazzEnrolment.clazzEnrolmentActive))\n                 OR (ScopedGrant.sgTableId = 164\n                    AND ScopedGrant.sgEntityUid IN (\n                        SELECT DISTINCT schoolMemberSchoolUid\n                          FROM SchoolMember\n                         WHERE schoolMemberPersonUid = Person.personUid\n                           AND schoolMemberActive))\n                           )\n        \n                   AND (ScopedGrant.sgPermissions & \n        \n              64\n              \n                                                     ) > 0\n             JOIN PersonGroupMember AS PrsGrpMbr\n                   ON ScopedGrant.sgGroupUid = PrsGrpMbr.groupMemberGroupUid\n              JOIN UserSession\n                   ON UserSession.usPersonUid = PrsGrpMbr.groupMemberPersonUid\n                      AND UserSession.usStatus = 1\n               \n   WHERE UserSession.usClientNodeId != (\n         SELECT nodeClientId\n           FROM SyncNode\n          LIMIT 1)\n     AND PersonParentJoin.ppjLct != COALESCE(\n         (SELECT ppjVersionId\n            FROM PersonParentJoinReplicate\n           WHERE ppjPk = PersonParentJoin.ppjUid\n             AND ppjDestination = UserSession.usClientNodeId), 0)\n /*psql ON CONFLICT(ppjPk, ppjDestination) DO UPDATE\n     SET ppjPending = true\n  */\n    ")
    @com.ustadmobile.door.annotation.ReplicationCheckPendingNotificationsFor(value = {com.ustadmobile.lib.db.entities.PersonParentJoin.class})
    @com.ustadmobile.door.annotation.ReplicationRunOnChange(value = {com.ustadmobile.lib.db.entities.PersonParentJoin.class})
    public abstract java.lang.Object replicateOnChange(@org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Insert()
    public abstract java.lang.Object insertAsync(@org.jetbrains.annotations.NotNull()
    com.ustadmobile.lib.db.entities.PersonParentJoin entity, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super java.lang.Long> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n        SELECT PersonParentJoin.*, Person.*\n          FROM PersonParentJoin\n     LEFT JOIN Person ON Person.personUid = PersonParentJoin.ppjMinorPersonUid    \n         WHERE PersonParentJoin.ppjUid = :uid\n    ")
    public abstract java.lang.Object findByUidWithMinorAsync(long uid, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super com.ustadmobile.lib.db.entities.PersonParentJoinWithMinorPerson> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @com.ustadmobile.door.annotation.Repository(methodType = 2)
    @com.ustadmobile.door.annotation.RepoHttpAccessible()
    @androidx.room.Query(value = "\n        SELECT PersonParentJoin.*, Person.*\n          FROM PersonParentJoin\n     LEFT JOIN Person ON Person.personUid = PersonParentJoin.ppjMinorPersonUid    \n         WHERE PersonParentJoin.ppjUid = :uid\n    ")
    public abstract java.lang.Object findByUidWithMinorAsyncFromWeb(long uid, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super com.ustadmobile.lib.db.entities.PersonParentJoinWithMinorPerson> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n        SELECT PersonParentJoin.*\n          FROM PersonParentJoin\n         WHERE ppjMinorPersonUid = :minorPersonUid \n    ")
    public abstract java.lang.Object findByMinorPersonUid(long minorPersonUid, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super java.util.List<? extends com.ustadmobile.lib.db.entities.PersonParentJoin>> continuation);
    
    /**
     * Find classes for which a minor (child) is enroled where there is no parent enrolment for
     * the parent in the same class.
     */
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n        SELECT PersonParentJoin.ppjParentPersonUid AS parentPersonUid,\n               ChildEnrolment.clazzEnrolmentClazzUid AS clazzUid\n          FROM PersonParentJoin\n               JOIN ClazzEnrolment ChildEnrolment \n                    ON ChildEnrolment.clazzEnrolmentPersonUid = :minorPersonUid\n                   AND (:clazzUidFilter = 0 OR ChildEnrolment.clazzEnrolmentClazzUid = :clazzUidFilter)\n         WHERE PersonParentJoin.ppjMinorPersonUid = :minorPersonUid\n           AND PersonParentJoin.ppjParentPersonUid != 0\n           AND NOT EXISTS(\n               SELECT clazzEnrolmentUid \n                 FROM ClazzEnrolment\n                WHERE ClazzEnrolment.clazzEnrolmentPersonUid = PersonParentJoin.ppjParentPersonUid\n                  AND ClazzEnrolment.clazzEnrolmentClazzUid = ChildEnrolment.clazzEnrolmentClazzUid\n                  AND ClazzEnrolment.clazzEnrolmentRole = 1003\n                  AND CAST(ClazzEnrolment.clazzEnrolmentActive AS INTEGER) = 1)\n    ")
    public abstract java.lang.Object findByMinorPersonUidWhereParentNotEnrolledInClazz(long minorPersonUid, long clazzUidFilter, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super java.util.List<com.ustadmobile.core.db.dao.PersonParentJoinDao.ParentEnrolmentRequired>> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n        SELECT EXISTS(\n               SELECT ppjUid\n                 FROM PersonParentJoin\n                WHERE ppjMinorPersonUid = :minorPersonUid\n                      AND ppjParentPersonUid = :userPersonUid\n                      AND CAST(ppjInactive AS INTEGER) = 0)\n    ")
    public abstract java.lang.Object isParentOf(long userPersonUid, long minorPersonUid, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super java.lang.Boolean> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Update()
    public abstract java.lang.Object updateAsync(@org.jetbrains.annotations.NotNull()
    com.ustadmobile.lib.db.entities.PersonParentJoin personParentJoin, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n        SELECT EXISTS(\n               SELECT ppjUid\n                 FROM PersonParentJoin\n                WHERE ppjMinorPersonUid = :minorPersonUid\n                  AND CAST(ppjInactive AS INTEGER) = 0\n                  AND ppjStatus = 1)\n    ")
    public abstract java.lang.Object isMinorApproved(long minorPersonUid, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super java.lang.Boolean> continuation);
    
    /**
     * Represents a parent enrolment that needs to be done
     */
    @kotlin.Metadata(mv = {1, 6, 0}, k = 1, d1 = {"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0007\"\u0004\b\u000b\u0010\t\u00a8\u0006\u0016"}, d2 = {"Lcom/ustadmobile/core/db/dao/PersonParentJoinDao$ParentEnrolmentRequired;", "", "parentPersonUid", "", "clazzUid", "(JJ)V", "getClazzUid", "()J", "setClazzUid", "(J)V", "getParentPersonUid", "setParentPersonUid", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "lib-database"})
    public static final class ParentEnrolmentRequired {
        private long parentPersonUid;
        private long clazzUid;
        
        /**
         * Represents a parent enrolment that needs to be done
         */
        @org.jetbrains.annotations.NotNull()
        public final com.ustadmobile.core.db.dao.PersonParentJoinDao.ParentEnrolmentRequired copy(long parentPersonUid, long clazzUid) {
            return null;
        }
        
        /**
         * Represents a parent enrolment that needs to be done
         */
        @java.lang.Override()
        public boolean equals(@org.jetbrains.annotations.Nullable()
        java.lang.Object other) {
            return false;
        }
        
        /**
         * Represents a parent enrolment that needs to be done
         */
        @java.lang.Override()
        public int hashCode() {
            return 0;
        }
        
        /**
         * Represents a parent enrolment that needs to be done
         */
        @org.jetbrains.annotations.NotNull()
        @java.lang.Override()
        public java.lang.String toString() {
            return null;
        }
        
        public ParentEnrolmentRequired() {
            super();
        }
        
        public ParentEnrolmentRequired(long parentPersonUid, long clazzUid) {
            super();
        }
        
        public final long component1() {
            return 0L;
        }
        
        public final long getParentPersonUid() {
            return 0L;
        }
        
        public final void setParentPersonUid(long p0) {
        }
        
        public final long component2() {
            return 0L;
        }
        
        public final long getClazzUid() {
            return 0L;
        }
        
        public final void setClazzUid(long p0) {
        }
    }
}