package com.ustadmobile.core.db.dao;

import java.lang.System;

@com.ustadmobile.door.annotation.Repository()
@androidx.room.Dao()
@kotlin.Metadata(mv = {1, 6, 0}, k = 1, d1 = {"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\b\'\u0018\u0000 \u00122\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0012B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001b\u0010\u0004\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0006H\'J\u0011\u0010\n\u001a\u00020\u000bH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\fJ\u001b\u0010\r\u001a\u00020\u000b2\b\b\u0001\u0010\u000e\u001a\u00020\u0006H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0007J\u0019\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0002H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0011\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0013"}, d2 = {"Lcom/ustadmobile/core/db/dao/PersonPictureDao;", "Lcom/ustadmobile/core/db/dao/BaseDao;", "Lcom/ustadmobile/lib/db/entities/PersonPicture;", "()V", "findByPersonUidAsync", "personUid", "", "(JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findByPersonUidLive", "Lcom/ustadmobile/door/DoorLiveData;", "replicateOnChange", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "replicateOnNewNode", "newNodeId", "updateAsync", "personPicture", "(Lcom/ustadmobile/lib/db/entities/PersonPicture;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "lib-database"})
public abstract class PersonPictureDao implements com.ustadmobile.core.db.dao.BaseDao<com.ustadmobile.lib.db.entities.PersonPicture> {
    @org.jetbrains.annotations.NotNull()
    public static final com.ustadmobile.core.db.dao.PersonPictureDao.Companion Companion = null;
    @org.jetbrains.annotations.NotNull()
    private static final java.lang.String TABLE_LEVEL_PERMISSION = "(SELECT admin FROM Person WHERE personUid = :accountPersonUid) OR EXISTS(SELECT PersonGroupMember.groupMemberPersonUid FROM PersonGroupMember  JOIN EntityRole ON EntityRole.erGroupUid = PersonGroupMember.groupMemberGroupUid  JOIN Role ON EntityRole.erRoleUid = Role.roleUid  WHERE  PersonGroupMember.groupMemberPersonUid = :accountPersonUid  AND EntityRole.erTableId = 50 AND Role.rolePermissions & ";
    @org.jetbrains.annotations.NotNull()
    private static final java.lang.String TABLE_LEVEL_PERMISSION_CONDITION2 = " > 0)";
    
    public PersonPictureDao() {
        super();
    }
    
    @org.jetbrains.annotations.Nullable()
    @com.ustadmobile.door.annotation.ReplicationRunOnNewNode()
    @androidx.room.Query(value = "\n     REPLACE INTO PersonPictureReplicate(ppPk, ppDestination)\n      SELECT DISTINCT PersonPicture.personPictureUid AS ppPk,\n             :newNodeId AS ppDestination\n        FROM UserSession\n             JOIN PersonGroupMember\n                  ON UserSession.usPersonUid = PersonGroupMember.groupMemberPersonUid\n             \n            JOIN ScopedGrant\n                 ON ScopedGrant.sgGroupUid = PersonGroupMember.groupMemberGroupUid\n                    AND (ScopedGrant.sgPermissions &\n                  1048576\n                  \n                                                    ) > 0\n            JOIN Person \n                 ON \n                ((ScopedGrant.sgTableId = -2\n                    AND ScopedGrant.sgEntityUid = -2)\n                 OR (ScopedGrant.sgTableId = 9\n                    AND ScopedGrant.sgEntityUid = Person.personUid)\n                 OR (ScopedGrant.sgTableId = 6       \n                    AND Person.personUid IN (\n                        SELECT DISTINCT clazzEnrolmentPersonUid\n                          FROM ClazzEnrolment\n                         WHERE clazzEnrolmentClazzUid =ScopedGrant.sgEntityUid \n                           AND ClazzEnrolment.clazzEnrolmentActive))\n                 OR (ScopedGrant.sgTableId = 164\n                    AND Person.personUid IN (\n                        SELECT DISTINCT schoolMemberPersonUid\n                          FROM SchoolMember\n                         WHERE schoolMemberSchoolUid = ScopedGrant.sgEntityUid\n                           AND schoolMemberActive))\n                           )    \n        \n        \n             JOIN PersonPicture\n                  ON PersonPicture.personPicturePersonUid = Person.personUid\n       WHERE UserSession.usClientNodeId = :newNodeId\n         AND UserSession.usStatus = 1\n         AND PersonPicture.personPictureLct != COALESCE(\n             (SELECT ppVersionId\n                FROM PersonPictureReplicate\n               WHERE ppPk = PersonPicture.personPictureUid\n                 AND ppDestination = :newNodeId), 0) \n      /*psql ON CONFLICT(ppPk, ppDestination) DO UPDATE\n             SET ppPending = true\n      */       \n    ")
    @com.ustadmobile.door.annotation.ReplicationCheckPendingNotificationsFor(value = {com.ustadmobile.lib.db.entities.PersonPicture.class})
    public abstract java.lang.Object replicateOnNewNode(@com.ustadmobile.door.annotation.NewNodeIdParam()
    long newNodeId, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n REPLACE INTO PersonPictureReplicate(ppPk, ppDestination)\n  SELECT DISTINCT PersonPicture.personPictureUid AS ppUid,\n         UserSession.usClientNodeId AS ppDestination\n    FROM ChangeLog\n         JOIN PersonPicture\n              ON ChangeLog.chTableId = 50\n                 AND ChangeLog.chEntityPk = PersonPicture.personPictureUid\n         JOIN Person\n              ON Person.personUid = PersonPicture.personPicturePersonUid\n         \n            JOIN ScopedGrant \n                   ON \n            ((ScopedGrant.sgTableId = -2\n                    AND ScopedGrant.sgEntityUid = -2)\n                 OR (ScopedGrant.sgTableId = 9\n                    AND ScopedGrant.sgEntityUid = Person.personUid)\n                 OR (ScopedGrant.sgTableId = 6       \n                    AND ScopedGrant.sgEntityUid IN (\n                        SELECT DISTINCT clazzEnrolmentClazzUid\n                          FROM ClazzEnrolment\n                         WHERE clazzEnrolmentPersonUid = Person.personUid \n                           AND ClazzEnrolment.clazzEnrolmentActive))\n                 OR (ScopedGrant.sgTableId = 164\n                    AND ScopedGrant.sgEntityUid IN (\n                        SELECT DISTINCT schoolMemberSchoolUid\n                          FROM SchoolMember\n                         WHERE schoolMemberPersonUid = Person.personUid\n                           AND schoolMemberActive))\n                           )\n        \n                   AND (ScopedGrant.sgPermissions & \n        \n              1048576\n              \n                                                     ) > 0\n             JOIN PersonGroupMember AS PrsGrpMbr\n                   ON ScopedGrant.sgGroupUid = PrsGrpMbr.groupMemberGroupUid\n              JOIN UserSession\n                   ON UserSession.usPersonUid = PrsGrpMbr.groupMemberPersonUid\n                      AND UserSession.usStatus = 1\n        \n   WHERE UserSession.usClientNodeId != (\n         SELECT nodeClientId \n           FROM SyncNode\n          LIMIT 1)\n     AND PersonPicture.personPictureLct != COALESCE(\n         (SELECT ppVersionId\n            FROM PersonPictureReplicate\n           WHERE ppPk = PersonPicture.personPictureUid\n             AND ppDestination = UserSession.usClientNodeId), 0)\n /*psql ON CONFLICT(ppPk, ppDestination) DO UPDATE\n     SET ppPending = true\n  */               \n    ")
    @com.ustadmobile.door.annotation.ReplicationCheckPendingNotificationsFor(value = {com.ustadmobile.lib.db.entities.PersonPicture.class})
    @com.ustadmobile.door.annotation.ReplicationRunOnChange(value = {com.ustadmobile.lib.db.entities.PersonPicture.class})
    public abstract java.lang.Object replicateOnChange(@org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "SELECT * FROM PersonPicture \n        WHERE personPicturePersonUid = :personUid\n        AND CAST(personPictureActive AS INTEGER) = 1\n        ORDER BY picTimestamp DESC LIMIT 1")
    public abstract java.lang.Object findByPersonUidAsync(long personUid, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super com.ustadmobile.lib.db.entities.PersonPicture> continuation);
    
    @org.jetbrains.annotations.NotNull()
    @androidx.room.Query(value = "SELECT * FROM PersonPicture where personPicturePersonUid = :personUid ORDER BY  picTimestamp DESC LIMIT 1")
    public abstract com.ustadmobile.door.DoorLiveData<com.ustadmobile.lib.db.entities.PersonPicture> findByPersonUidLive(long personUid);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Update()
    public abstract java.lang.Object updateAsync(@org.jetbrains.annotations.NotNull()
    com.ustadmobile.lib.db.entities.PersonPicture personPicture, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @kotlin.Metadata(mv = {1, 6, 0}, k = 1, d1 = {"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0084D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\t"}, d2 = {"Lcom/ustadmobile/core/db/dao/PersonPictureDao$Companion;", "", "()V", "TABLE_LEVEL_PERMISSION", "", "getTABLE_LEVEL_PERMISSION", "()Ljava/lang/String;", "TABLE_LEVEL_PERMISSION_CONDITION2", "getTABLE_LEVEL_PERMISSION_CONDITION2", "lib-database"})
    public static final class Companion {
        
        private Companion() {
            super();
        }
        
        @org.jetbrains.annotations.NotNull()
        public final java.lang.String getTABLE_LEVEL_PERMISSION() {
            return null;
        }
        
        @org.jetbrains.annotations.NotNull()
        protected final java.lang.String getTABLE_LEVEL_PERMISSION_CONDITION2() {
            return null;
        }
    }
}