package com.ustadmobile.core.db.dao;

import java.lang.System;

@com.ustadmobile.door.annotation.Repository()
@androidx.room.Dao()
@kotlin.Metadata(mv = {1, 6, 0}, k = 1, d1 = {"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0010\b\'\u0018\u0000 ,2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001,B\u0005\u00a2\u0006\u0002\u0010\u0003J4\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rH\'J\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\u000f2\u0006\u0010\f\u001a\u00020\rH\'J\u001c\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u000f0\u00112\u0006\u0010\f\u001a\u00020\rH\'J\u001b\u0010\u0012\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0013\u001a\u00020\nH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0014J\u001c\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\n0\u000f2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\n0\u000fH\'J\u0018\u0010\u0017\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u00112\u0006\u0010\u0018\u001a\u00020\nH\'J\u0016\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u001bH\'J\u0006\u0010\u001c\u001a\u00020\u001dJ\u0016\u0010\u001e\u001a\u00020\u001d2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00020\u000fH\'J\u0011\u0010 \u001a\u00020\u001dH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010!J\u001b\u0010\"\u001a\u00020\u001d2\b\b\u0001\u0010#\u001a\u00020\nH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0014J/\u0010$\u001a\u00020\u001d2\u0006\u0010%\u001a\u00020\r2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\n0\u000f2\u0006\u0010\'\u001a\u00020\nH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010(J\u0019\u0010)\u001a\u00020\u001d2\u0006\u0010*\u001a\u00020\u0002H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010+\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006-"}, d2 = {"Lcom/ustadmobile/core/db/dao/ReportDao;", "Lcom/ustadmobile/core/db/dao/BaseDao;", "Lcom/ustadmobile/lib/db/entities/Report;", "()V", "findAllActiveReport", "Lcom/ustadmobile/door/DoorDataSourceFactory;", "", "searchBit", "", "personUid", "", "sortOrder", "isTemplate", "", "findAllActiveReportList", "", "findAllActiveReportLive", "Lcom/ustadmobile/door/DoorLiveData;", "findByUid", "entityUid", "(JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findByUidList", "uidList", "findByUidLive", "uid", "getResults", "query", "Lcom/ustadmobile/door/DoorQuery;", "initPreloadedTemplates", "", "replaceList", "entityList", "replicateOnChangeTemplates", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "replicateOnNewNodeTemplates", "newNodeId", "toggleVisibilityReportItems", "toggleVisibility", "selectedItem", "updateTime", "(ZLjava/util/List;JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "updateAsync", "entity", "(Lcom/ustadmobile/lib/db/entities/Report;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "lib-database"})
public abstract class ReportDao implements com.ustadmobile.core.db.dao.BaseDao<com.ustadmobile.lib.db.entities.Report> {
    @org.jetbrains.annotations.NotNull()
    public static final com.ustadmobile.core.db.dao.ReportDao.Companion Companion = null;
    public static final int SORT_TITLE_ASC = 1;
    public static final int SORT_TITLE_DESC = 2;
    
    public ReportDao() {
        super();
    }
    
    @org.jetbrains.annotations.Nullable()
    @com.ustadmobile.door.annotation.ReplicationRunOnNewNode()
    @androidx.room.Query(value = "\n     REPLACE INTO ReportReplicate(reportPk, reportDestination)\n      SELECT DISTINCT Report.reportUid AS reportPk,\n             :newNodeId AS reportDestination\n        FROM Report\n             JOIN UserSession\n                  ON UserSession.usStatus = 1\n                     AND CAST(Report.isTemplate AS INTEGER) = 1\n       WHERE Report.reportLct != COALESCE(\n             (SELECT reportVersionId\n                FROM ReportReplicate\n               WHERE reportPk = Report.reportUid\n                 AND reportDestination = :newNodeId), 0) \n      /*psql ON CONFLICT(reportPk, reportDestination) DO UPDATE\n             SET reportPending = true\n      */       \n    ")
    @com.ustadmobile.door.annotation.ReplicationCheckPendingNotificationsFor(value = {com.ustadmobile.lib.db.entities.Report.class})
    public abstract java.lang.Object replicateOnNewNodeTemplates(@com.ustadmobile.door.annotation.NewNodeIdParam()
    long newNodeId, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n REPLACE INTO ReportReplicate(reportPk, reportDestination)\n  SELECT DISTINCT Report.reportUid AS reportUid,\n         UserSession.usClientNodeId AS reportDestination\n    FROM ChangeLog\n         JOIN Report\n              ON ChangeLog.chTableId = 101 \n                 AND ChangeLog.chEntityPk = Report.reportUid\n         JOIN UserSession\n              ON UserSession.usStatus = 1\n                 AND CAST(Report.isTemplate AS INTEGER) = 1\n   WHERE UserSession.usClientNodeId != (\n         SELECT nodeClientId \n           FROM SyncNode\n          LIMIT 1)\n     AND Report.reportLct != COALESCE(\n         (SELECT reportVersionId\n            FROM ReportReplicate\n           WHERE reportPk = Report.reportUid\n             AND reportDestination = UserSession.usClientNodeId), 0)\n /*psql ON CONFLICT(reportPk, reportDestination) DO UPDATE\n     SET reportPending = true\n  */               \n ")
    @com.ustadmobile.door.annotation.ReplicationCheckPendingNotificationsFor(value = {com.ustadmobile.lib.db.entities.Report.class})
    @com.ustadmobile.door.annotation.ReplicationRunOnChange(value = {com.ustadmobile.lib.db.entities.Report.class})
    public abstract java.lang.Object replicateOnChangeTemplates(@org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @org.jetbrains.annotations.NotNull()
    @androidx.room.RawQuery()
    public abstract java.util.List<com.ustadmobile.lib.db.entities.Report> getResults(@org.jetbrains.annotations.NotNull()
    com.ustadmobile.door.DoorQuery query);
    
    @org.jetbrains.annotations.NotNull()
    @androidx.room.Query(value = "SELECT * FROM REPORT WHERE NOT reportInactive \n        AND reportOwnerUid = :personUid\n        AND isTemplate = :isTemplate\n        AND reportTitle LIKE :searchBit\n        ORDER BY priority, CASE(:sortOrder)\n            WHEN 1 THEN Report.reportTitle\n            ELSE \'\'\n        END ASC,\n        CASE(:sortOrder)\n            WHEN 2 THEN Report.reportTitle\n            ELSE \'\'\n        END DESC\n            ")
    public abstract com.ustadmobile.door.DoorDataSourceFactory<java.lang.Integer, com.ustadmobile.lib.db.entities.Report> findAllActiveReport(@org.jetbrains.annotations.NotNull()
    java.lang.String searchBit, long personUid, int sortOrder, boolean isTemplate);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "SELECT * FROM Report WHERE reportUid = :entityUid")
    public abstract java.lang.Object findByUid(long entityUid, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super com.ustadmobile.lib.db.entities.Report> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Update()
    public abstract java.lang.Object updateAsync(@org.jetbrains.annotations.NotNull()
    com.ustadmobile.lib.db.entities.Report entity, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @org.jetbrains.annotations.NotNull()
    @androidx.room.Query(value = "SELECT * From Report WHERE  reportUid = :uid")
    public abstract com.ustadmobile.door.DoorLiveData<com.ustadmobile.lib.db.entities.Report> findByUidLive(long uid);
    
    @org.jetbrains.annotations.NotNull()
    @androidx.room.Query(value = "SELECT * FROM REPORT WHERE NOT reportInactive \n        AND isTemplate = :isTemplate\n        ORDER BY priority ASC\n            ")
    public abstract com.ustadmobile.door.DoorLiveData<java.util.List<com.ustadmobile.lib.db.entities.Report>> findAllActiveReportLive(boolean isTemplate);
    
    @org.jetbrains.annotations.NotNull()
    @androidx.room.Query(value = "SELECT * FROM REPORT WHERE NOT reportInactive \n        AND isTemplate = :isTemplate\n        ORDER BY priority ASC\n            ")
    public abstract java.util.List<com.ustadmobile.lib.db.entities.Report> findAllActiveReportList(boolean isTemplate);
    
    @org.jetbrains.annotations.NotNull()
    @androidx.room.Query(value = "SELECT reportUid FROM Report WHERE reportUid IN (:uidList)")
    public abstract java.util.List<java.lang.Long> findByUidList(@org.jetbrains.annotations.NotNull()
    java.util.List<java.lang.Long> uidList);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n        UPDATE Report \n           SET reportInactive = :toggleVisibility,\n               reportLct = :updateTime \n         WHERE reportUid IN (:selectedItem)\n    ")
    public abstract java.lang.Object toggleVisibilityReportItems(boolean toggleVisibility, @org.jetbrains.annotations.NotNull()
    java.util.List<java.lang.Long> selectedItem, long updateTime, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @androidx.room.Insert(onConflict = 1)
    public abstract void replaceList(@org.jetbrains.annotations.NotNull()
    java.util.List<? extends com.ustadmobile.lib.db.entities.Report> entityList);
    
    public final void initPreloadedTemplates() {
    }
    
    @kotlin.Metadata(mv = {1, 6, 0}, k = 1, d1 = {"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2 = {"Lcom/ustadmobile/core/db/dao/ReportDao$Companion;", "", "()V", "SORT_TITLE_ASC", "", "SORT_TITLE_DESC", "lib-database"})
    public static final class Companion {
        
        private Companion() {
            super();
        }
    }
}