package com.ustadmobile.core.db.dao;

import java.lang.System;

@androidx.room.Dao()
@com.ustadmobile.door.annotation.Repository()
@kotlin.Metadata(mv = {1, 6, 0}, k = 1, d1 = {"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0002\b\'\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\'\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\tH\u0097@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000bJ\u001c\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00020\r2\u0006\u0010\u000f\u001a\u00020\tH\'J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00020\b2\u0006\u0010\u000f\u001a\u00020\tH\'J\u001c\u0010\u0011\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\b0\u00122\u0006\u0010\u000f\u001a\u00020\tH\'J\u001f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00020\b2\u0006\u0010\u000f\u001a\u00020\tH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0014J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0016\u001a\u00020\tH\'J\u001b\u0010\u0017\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0016\u001a\u00020\tH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0014J\u0010\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\u0002H\'J\u0011\u0010\u001a\u001a\u00020\u0006H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001bJ\u001b\u0010\u001c\u001a\u00020\u00062\b\b\u0001\u0010\u001d\u001a\u00020\tH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0014J\u0019\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u0002H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001fJ)\u0010 \u001a\u00020\u00062\u0006\u0010!\u001a\u00020\t2\u0006\u0010\"\u001a\u00020#2\u0006\u0010\n\u001a\u00020\tH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010$\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006%"}, d2 = {"Lcom/ustadmobile/core/db/dao/ScheduleDao;", "Lcom/ustadmobile/core/db/dao/BaseDao;", "Lcom/ustadmobile/lib/db/entities/Schedule;", "Lcom/ustadmobile/core/db/dao/OneToManyJoinDao;", "()V", "deactivateByUids", "", "uidList", "", "", "changeTime", "(Ljava/util/List;JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findAllSchedulesByClazzUid", "Lcom/ustadmobile/door/DoorDataSourceFactory;", "", "clazzUid", "findAllSchedulesByClazzUidAsList", "findAllSchedulesByClazzUidAsLiveList", "Lcom/ustadmobile/door/DoorLiveData;", "findAllSchedulesByClazzUidAsync", "(JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findByUid", "uid", "findByUidAsync", "insert", "entity", "replicateOnChange", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "replicateOnNewNode", "newNodeId", "updateAsync", "(Lcom/ustadmobile/lib/db/entities/Schedule;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "updateScheduleActivated", "scheduleUid", "active", "", "(JZJLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "lib-database"})
public abstract class ScheduleDao implements com.ustadmobile.core.db.dao.BaseDao<com.ustadmobile.lib.db.entities.Schedule>, com.ustadmobile.core.db.dao.OneToManyJoinDao<com.ustadmobile.lib.db.entities.Schedule> {
    
    public ScheduleDao() {
        super();
    }
    
    @org.jetbrains.annotations.Nullable()
    @com.ustadmobile.door.annotation.ReplicationRunOnNewNode()
    @androidx.room.Query(value = "\n     REPLACE INTO ScheduleReplicate(schedulePk, scheduleDestination)\n      SELECT DISTINCT Schedule.scheduleUid AS schedulePk,\n             :newNodeId AS scheduleDestination\n        FROM UserSession\n              JOIN PersonGroupMember\n                    ON UserSession.usPersonUid = PersonGroupMember.groupMemberPersonUid\n              \n               JOIN ScopedGrant\n                    ON ScopedGrant.sgGroupUid = PersonGroupMember.groupMemberGroupUid\n                        AND (ScopedGrant.sgPermissions & \n        \n                    2\n                    \n                       ) > 0\n               JOIN Clazz \n                    ON \n            ((ScopedGrant.sgTableId = -2\n                                AND ScopedGrant.sgEntityUid = -2)\n                            OR (ScopedGrant.sgTableId = 6\n                                AND ScopedGrant.sgEntityUid = Clazz.clazzUid)\n                            OR (ScopedGrant.sgTableId = 164\n                                AND ScopedGrant.sgEntityUid = Clazz.clazzSchoolUid))\n        \n        \n              JOIN Schedule\n                   ON Schedule.scheduleClazzUid = Clazz.clazzUid\n       WHERE UserSession.usClientNodeId = :newNodeId\n         AND UserSession.usStatus = 1\n         AND Schedule.scheduleLastChangedTime != COALESCE(\n             (SELECT scheduleVersionId\n                FROM ScheduleReplicate\n               WHERE schedulePk = Schedule.scheduleUid\n                 AND scheduleDestination = :newNodeId), 0) \n      /*psql ON CONFLICT(schedulePk, scheduleDestination) DO UPDATE\n             SET schedulePending = true\n      */       \n ")
    @com.ustadmobile.door.annotation.ReplicationCheckPendingNotificationsFor(value = {com.ustadmobile.lib.db.entities.Schedule.class})
    public abstract java.lang.Object replicateOnNewNode(@com.ustadmobile.door.annotation.NewNodeIdParam()
    long newNodeId, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n REPLACE INTO ScheduleReplicate(schedulePk, scheduleDestination)\n  SELECT DISTINCT Schedule.scheduleUid AS scheduleUid,\n         UserSession.usClientNodeId AS scheduleDestination\n    FROM ChangeLog\n         JOIN Schedule\n              ON ChangeLog.chTableId = 21\n                 AND Schedule.scheduleUid = ChangeLog.chEntityPk\n         JOIN Clazz\n              ON Clazz.clazzUid = Schedule.scheduleClazzUid\n         \n            JOIN ScopedGrant\n                 ON \n            ((ScopedGrant.sgTableId = -2\n                                AND ScopedGrant.sgEntityUid = -2)\n                            OR (ScopedGrant.sgTableId = 6\n                                AND ScopedGrant.sgEntityUid = Clazz.clazzUid)\n                            OR (ScopedGrant.sgTableId = 164\n                                AND ScopedGrant.sgEntityUid = Clazz.clazzSchoolUid))\n        \n                    AND (ScopedGrant.sgPermissions & \n        \n              2\n              \n              \n                                                       ) > 0\n             JOIN PersonGroupMember AS PrsGrpMbr\n                   ON ScopedGrant.sgGroupUid = PrsGrpMbr.groupMemberGroupUid\n                                               \n              JOIN UserSession\n                   ON UserSession.usPersonUid = PrsGrpMbr.groupMemberPersonUid\n                      AND UserSession.usStatus = 1\n        \n   WHERE UserSession.usClientNodeId != (\n         SELECT nodeClientId \n           FROM SyncNode\n          LIMIT 1)\n     AND Schedule.scheduleLastChangedTime != COALESCE(\n         (SELECT scheduleVersionId\n            FROM ScheduleReplicate\n           WHERE schedulePk = Schedule.scheduleUid\n             AND scheduleDestination = UserSession.usClientNodeId), 0)\n /*psql ON CONFLICT(schedulePk, scheduleDestination) DO UPDATE\n     SET schedulePending = true\n  */               \n    ")
    @com.ustadmobile.door.annotation.ReplicationCheckPendingNotificationsFor(value = {com.ustadmobile.lib.db.entities.Schedule.class})
    @com.ustadmobile.door.annotation.ReplicationRunOnChange(value = {com.ustadmobile.lib.db.entities.Schedule.class})
    public abstract java.lang.Object replicateOnChange(@org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @androidx.room.Insert()
    @java.lang.Override()
    public abstract long insert(@org.jetbrains.annotations.NotNull()
    com.ustadmobile.lib.db.entities.Schedule entity);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Update()
    public abstract java.lang.Object updateAsync(@org.jetbrains.annotations.NotNull()
    com.ustadmobile.lib.db.entities.Schedule entity, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super java.lang.Integer> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Transaction()
    @java.lang.Override()
    public java.lang.Object deactivateByUids(@org.jetbrains.annotations.NotNull()
    java.util.List<java.lang.Long> uidList, long changeTime, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation) {
        return null;
    }
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n        UPDATE Schedule \n           SET scheduleActive = :active,\n               scheduleLastChangedTime = :changeTime\n         WHERE scheduleUid = :scheduleUid\n            ")
    public abstract java.lang.Object updateScheduleActivated(long scheduleUid, boolean active, long changeTime, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "SELECT * FROM Schedule WHERE scheduleUid = :uid")
    public abstract com.ustadmobile.lib.db.entities.Schedule findByUid(long uid);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "SELECT * FROM Schedule WHERE scheduleUid = :uid")
    public abstract java.lang.Object findByUidAsync(long uid, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super com.ustadmobile.lib.db.entities.Schedule> continuation);
    
    @org.jetbrains.annotations.NotNull()
    @androidx.room.Query(value = "SELECT * FROM Schedule WHERE scheduleClazzUid = :clazzUid AND CAST(scheduleActive AS INTEGER) = 1 ")
    public abstract com.ustadmobile.door.DoorDataSourceFactory<java.lang.Integer, com.ustadmobile.lib.db.entities.Schedule> findAllSchedulesByClazzUid(long clazzUid);
    
    @org.jetbrains.annotations.NotNull()
    @androidx.room.Query(value = "SELECT * FROM Schedule WHERE scheduleClazzUid = :clazzUid AND CAST(scheduleActive AS INTEGER) = 1")
    public abstract java.util.List<com.ustadmobile.lib.db.entities.Schedule> findAllSchedulesByClazzUidAsList(long clazzUid);
    
    @org.jetbrains.annotations.NotNull()
    @androidx.room.Query(value = "SELECT * FROM Schedule WHERE scheduleClazzUid = :clazzUid AND CAST(scheduleActive AS INTEGER) = 1")
    public abstract com.ustadmobile.door.DoorLiveData<java.util.List<com.ustadmobile.lib.db.entities.Schedule>> findAllSchedulesByClazzUidAsLiveList(long clazzUid);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "SELECT * FROM Schedule WHERE scheduleClazzUid = :clazzUid AND CAST(scheduleActive AS INTEGER) = 1 ")
    public abstract java.lang.Object findAllSchedulesByClazzUidAsync(long clazzUid, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super java.util.List<com.ustadmobile.lib.db.entities.Schedule>> continuation);
}