package com.ustadmobile.core.db.dao;

import java.lang.System;

@androidx.room.Dao()
@com.ustadmobile.door.annotation.Repository()
@kotlin.Metadata(mv = {1, 6, 0}, k = 1, d1 = {"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\b\b\'\u0018\u0000 $2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001$B\u0005\u00a2\u0006\u0002\u0010\u0003J4\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u0006H\'J\u001b\u0010\u000e\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u000f\u001a\u00020\tH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0010J\u001b\u0010\u0011\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u000f\u001a\u00020\tH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0010J\u001b\u0010\u0012\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0013\u001a\u00020\u000bH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0014J\u001b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u000bH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0014J)\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001bJ\u0011\u0010\u001c\u001a\u00020\u001dH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001eJ\u001b\u0010\u001f\u001a\u00020\u001d2\b\b\u0001\u0010 \u001a\u00020\u000bH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0014J\u0019\u0010!\u001a\u00020\u00062\u0006\u0010\"\u001a\u00020\u0002H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010#\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006%"}, d2 = {"Lcom/ustadmobile/core/db/dao/SchoolDao;", "Lcom/ustadmobile/core/db/dao/BaseDao;", "Lcom/ustadmobile/lib/db/entities/School;", "()V", "findAllActiveSchoolWithMemberCountAndLocationName", "Lcom/ustadmobile/door/DoorDataSourceFactory;", "", "Lcom/ustadmobile/lib/db/entities/SchoolWithMemberCountAndLocation;", "searchBit", "", "personUid", "", "permission", "sortOrder", "findBySchoolCode", "code", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findBySchoolCodeFromWeb", "findByUidAsync", "schoolUid", "(JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findByUidWithHolidayCalendarAsync", "Lcom/ustadmobile/lib/db/entities/SchoolWithHolidayCalendar;", "uid", "personHasPermissionWithSchool", "", "accountPersonUid", "(JJJLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "replicateOnChange", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "replicateOnNewNode", "newNodeId", "updateAsync", "entity", "(Lcom/ustadmobile/lib/db/entities/School;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "lib-database"})
public abstract class SchoolDao implements com.ustadmobile.core.db.dao.BaseDao<com.ustadmobile.lib.db.entities.School> {
    @org.jetbrains.annotations.NotNull()
    public static final com.ustadmobile.core.db.dao.SchoolDao.Companion Companion = null;
    public static final int SORT_NAME_ASC = 1;
    public static final int SORT_NAME_DESC = 2;
    @org.jetbrains.annotations.NotNull()
    public static final java.lang.String ENTITY_PERSONS_WITH_PERMISSION_PT1 = "\n            SELECT DISTINCT Person.PersonUid FROM Person\n            LEFT JOIN PersonGroupMember ON Person.personUid = PersonGroupMember.groupMemberPersonUid\n            LEFT JOIN EntityRole ON EntityRole.erGroupUid = PersonGroupMember.groupMemberGroupUid\n            LEFT JOIN Role ON EntityRole.erRoleUid = Role.roleUid\n            WHERE \n            CAST(Person.admin AS INTEGER) = 1\n            OR \n            (EntityRole.ertableId = 164 AND \n            EntityRole.erEntityUid = School.schoolUid AND\n            (Role.rolePermissions &  \n        ";
    @org.jetbrains.annotations.NotNull()
    public static final java.lang.String ENTITY_PERSONS_WITH_PERMISSION_PT2 = ") > 0)";
    @org.jetbrains.annotations.NotNull()
    public static final java.lang.String ENTITY_PERSONS_WITH_PERMISSION = "\n            SELECT DISTINCT Person.PersonUid FROM Person\n            LEFT JOIN PersonGroupMember ON Person.personUid = PersonGroupMember.groupMemberPersonUid\n            LEFT JOIN EntityRole ON EntityRole.erGroupUid = PersonGroupMember.groupMemberGroupUid\n            LEFT JOIN Role ON EntityRole.erRoleUid = Role.roleUid\n            WHERE \n            CAST(Person.admin AS INTEGER) = 1\n            OR \n            (EntityRole.ertableId = 164 AND \n            EntityRole.erEntityUid = School.schoolUid AND\n            (Role.rolePermissions &  \n         :permission ) > 0)";
    
    public SchoolDao() {
        super();
    }
    
    @org.jetbrains.annotations.Nullable()
    @com.ustadmobile.door.annotation.ReplicationRunOnNewNode()
    @androidx.room.Query(value = "\n     REPLACE INTO SchoolReplicate(schoolPk, schoolDestination)\n      SELECT DISTINCT School.schoolUid AS schoolPk,\n             :newNodeId AS schoolDestination\n        FROM UserSession\n             JOIN PersonGroupMember\n                  ON UserSession.usPersonUid = PersonGroupMember.groupMemberPersonUid\n             \n            JOIN ScopedGrant \n                 ON ScopedGrant.sgGroupUid = PersonGroupMember.groupMemberGroupUid\n                        AND (ScopedGrant.sgPermissions &\n                 \n        \n                  536870912\n                  \n                    ) > 0\n            JOIN School\n                 ON \n            ((ScopedGrant.sgTableId = -2\n                    AND ScopedGrant.sgEntityUid = -2)\n                OR (ScopedGrant.sgTableId = 164\n                    AND ScopedGrant.sgEntityUid = School.schoolUid))\n        \n        \n       WHERE UserSession.usClientNodeId = :newNodeId\n         AND UserSession.usStatus = 1\n         AND School.schoolLct != COALESCE(\n             (SELECT schoolVersionId\n                FROM SchoolReplicate\n               WHERE schoolPk = School.schoolUid\n                 AND schoolDestination = :newNodeId), 0) \n      /*psql ON CONFLICT(schoolPk, schoolDestination) DO UPDATE\n             SET schoolPending = true\n      */       \n    ")
    @com.ustadmobile.door.annotation.ReplicationCheckPendingNotificationsFor(value = {com.ustadmobile.lib.db.entities.School.class})
    public abstract java.lang.Object replicateOnNewNode(@com.ustadmobile.door.annotation.NewNodeIdParam()
    long newNodeId, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n REPLACE INTO SchoolReplicate(schoolPk, schoolDestination)\n  SELECT DISTINCT School.schoolUid AS schoolUid,\n         UserSession.usClientNodeId AS schoolDestination\n    FROM ChangeLog\n         JOIN School\n              ON ChangeLog.chTableId = 164\n                  AND ChangeLog.chEntityPk = School.schoolUid\n              \n            JOIN ScopedGrant\n                 ON \n            ((ScopedGrant.sgTableId = -2\n                    AND ScopedGrant.sgEntityUid = -2)\n                OR (ScopedGrant.sgTableId = 164\n                    AND ScopedGrant.sgEntityUid = School.schoolUid))\n        \n                        AND (SCopedGrant.sgPermissions &\n        \n                  536870912\n                  \n                                                     ) > 0\n             JOIN PersonGroupMember AS PrsGrpMbr\n                   ON ScopedGrant.sgGroupUid = PrsGrpMbr.groupMemberGroupUid\n              JOIN UserSession\n                   ON UserSession.usPersonUid = PrsGrpMbr.groupMemberPersonUid\n                      AND UserSession.usStatus = 1\n                      \n        \n   WHERE UserSession.usClientNodeId != (\n         SELECT nodeClientId \n           FROM SyncNode\n          LIMIT 1)\n     AND School.schoolLct != COALESCE(\n         (SELECT schoolVersionId\n            FROM SchoolReplicate\n           WHERE schoolPk = School.schoolUid\n             AND schoolDestination = UserSession.usClientNodeId), 0)\n /*psql ON CONFLICT(schoolPk, schoolDestination) DO UPDATE\n     SET schoolPending = true\n  */               \n    ")
    @com.ustadmobile.door.annotation.ReplicationCheckPendingNotificationsFor(value = {com.ustadmobile.lib.db.entities.School.class})
    @com.ustadmobile.door.annotation.ReplicationRunOnChange(value = {com.ustadmobile.lib.db.entities.School.class})
    public abstract java.lang.Object replicateOnChange(@org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "SELECT * FROM School WHERE schoolUid = :schoolUid AND CAST(schoolActive AS INTEGER) = 1")
    public abstract java.lang.Object findByUidAsync(long schoolUid, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super com.ustadmobile.lib.db.entities.School> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "SELECT School.*, HolidayCalendar.* FROM School \n            LEFT JOIN HolidayCalendar ON School.schoolHolidayCalendarUid = HolidayCalendar.umCalendarUid\n            WHERE School.schoolUid = :uid")
    public abstract java.lang.Object findByUidWithHolidayCalendarAsync(long uid, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super com.ustadmobile.lib.db.entities.SchoolWithHolidayCalendar> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "SELECT * FROM School WHERE schoolCode = :code")
    public abstract java.lang.Object findBySchoolCode(@org.jetbrains.annotations.NotNull()
    java.lang.String code, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super com.ustadmobile.lib.db.entities.School> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @com.ustadmobile.door.annotation.RepoHttpAccessible()
    @com.ustadmobile.door.annotation.Repository(methodType = 2)
    @androidx.room.Query(value = "SELECT * FROM School WHERE schoolCode = :code")
    public abstract java.lang.Object findBySchoolCodeFromWeb(@org.jetbrains.annotations.NotNull()
    java.lang.String code, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super com.ustadmobile.lib.db.entities.School> continuation);
    
    /**
     * Check if a permission is present on a specific entity e.g. updateState/modify etc
     */
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n    Select EXISTS(\n           SELECT School.schoolUid \n             FROM School\n                  \n            JOIN ScopedGrant\n                 ON \n            ((ScopedGrant.sgTableId = -2\n                    AND ScopedGrant.sgEntityUid = -2)\n                OR (ScopedGrant.sgTableId = 164\n                    AND ScopedGrant.sgEntityUid = School.schoolUid))\n        \n                        AND (SCopedGrant.sgPermissions &\n         :permission) > 0\n             JOIN PersonGroupMember AS PrsGrpMbr\n                   ON ScopedGrant.sgGroupUid = PrsGrpMbr.groupMemberGroupUid\n                      AND PrsGrpMbr.groupMemberPersonUid = :accountPersonUid\n            WHERE School.schoolUid = :schoolUid)      \n    ")
    public abstract java.lang.Object personHasPermissionWithSchool(long accountPersonUid, long schoolUid, long permission, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super java.lang.Boolean> continuation);
    
    @org.jetbrains.annotations.NotNull()
    @androidx.room.Query(value = "\n       SELECT School.*, \n              (SELECT COUNT(*) \n                  FROM SchoolMember \n                 WHERE SchoolMember.schoolMemberSchoolUid = School.schoolUid \n                   AND CAST(SchoolMember.schoolMemberActive AS INTEGER) = 1 \n                   AND SchoolMember.schoolMemberRole = 1003) as numStudents,\n              (SELECT COUNT(*) \n                 FROM SchoolMember \n                WHERE SchoolMember.schoolMemberSchoolUid = School.schoolUid \n                  AND CAST(SchoolMember.schoolMemberActive AS INTEGER) = 1 \n                  AND SchoolMember.schoolMemberRole = 1004) as numTeachers, \n               \'\' as locationName,\n              (SELECT COUNT(*) \n                 FROM Clazz \n                WHERE Clazz.clazzSchoolUid = School.schoolUid \n                  AND CAST(Clazz.clazzUid AS INTEGER) = 1 ) as clazzCount\n         FROM PersonGroupMember\n              \n            JOIN ScopedGrant \n                 ON ScopedGrant.sgGroupUid = PersonGroupMember.groupMemberGroupUid\n                        AND (ScopedGrant.sgPermissions &\n                 \n        \n                    :permission\n                    \n                    ) > 0\n            JOIN School\n                 ON \n            ((ScopedGrant.sgTableId = -2\n                    AND ScopedGrant.sgEntityUid = -2)\n                OR (ScopedGrant.sgTableId = 164\n                    AND ScopedGrant.sgEntityUid = School.schoolUid))\n        \n        \n        WHERE PersonGroupMember.groupMemberPersonUid = :personUid\n          AND PersonGroupMember.groupMemberActive \n          AND CAST(schoolActive AS INTEGER) = 1\n          AND schoolName LIKE :searchBit\n     GROUP BY School.schoolUid\n     ORDER BY CASE(:sortOrder)\n              WHEN 1 THEN School.schoolName\n              ELSE \'\'\n              END ASC,\n              CASE(:sortOrder)\n              WHEN 2 THEN School.schoolName\n              ELSE \'\'\n              END DESC")
    public abstract com.ustadmobile.door.DoorDataSourceFactory<java.lang.Integer, com.ustadmobile.lib.db.entities.SchoolWithMemberCountAndLocation> findAllActiveSchoolWithMemberCountAndLocationName(@org.jetbrains.annotations.NotNull()
    java.lang.String searchBit, long personUid, long permission, int sortOrder);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Update()
    public abstract java.lang.Object updateAsync(@org.jetbrains.annotations.NotNull()
    com.ustadmobile.lib.db.entities.School entity, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super java.lang.Integer> continuation);
    
    @kotlin.Metadata(mv = {1, 6, 0}, k = 1, d1 = {"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2 = {"Lcom/ustadmobile/core/db/dao/SchoolDao$Companion;", "", "()V", "ENTITY_PERSONS_WITH_PERMISSION", "", "ENTITY_PERSONS_WITH_PERMISSION_PT1", "ENTITY_PERSONS_WITH_PERMISSION_PT2", "SORT_NAME_ASC", "", "SORT_NAME_DESC", "lib-database"})
    public static final class Companion {
        
        private Companion() {
            super();
        }
    }
}