package com.ustadmobile.core.db.dao;

import java.lang.System;

@androidx.room.Dao()
@com.ustadmobile.door.annotation.Repository()
@kotlin.Metadata(mv = {1, 6, 0}, k = 1, d1 = {"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\t\b\'\u0018\u0000 !2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001!B\u0005\u00a2\u0006\u0002\u0010\u0003J<\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\tH\'J/\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00070\u00102\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0011J9\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00020\u00102\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00062\b\b\u0002\u0010\u0014\u001a\u00020\tH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0015J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0017\u001a\u00020\tH\'J\u0011\u0010\u0018\u001a\u00020\u0019H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001aJ\u001b\u0010\u001b\u001a\u00020\u00192\b\b\u0001\u0010\u001c\u001a\u00020\tH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001dJ\u0019\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u001f\u001a\u00020\u0002H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010 \u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\""}, d2 = {"Lcom/ustadmobile/core/db/dao/SchoolMemberDao;", "Lcom/ustadmobile/core/db/dao/BaseDao;", "Lcom/ustadmobile/lib/db/entities/SchoolMember;", "()V", "findAllActiveMembersBySchoolAndRoleUid", "Lcom/ustadmobile/door/DoorDataSourceFactory;", "", "Lcom/ustadmobile/lib/db/entities/SchoolMemberWithPerson;", "schoolUid", "", "role", "sortOrder", "searchQuery", "", "accountPersonUid", "findAllTest", "", "(JILjava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findBySchoolAndPersonAndRole", "personUid", "timeFilter", "(JJIJLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findByUidAsync", "schoolMemberUid", "replicateOnChange", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "replicateOnNewNode", "newNodeId", "(JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "updateAsync", "entity", "(Lcom/ustadmobile/lib/db/entities/SchoolMember;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "lib-database"})
public abstract class SchoolMemberDao implements com.ustadmobile.core.db.dao.BaseDao<com.ustadmobile.lib.db.entities.SchoolMember> {
    @org.jetbrains.annotations.NotNull()
    public static final com.ustadmobile.core.db.dao.SchoolMemberDao.Companion Companion = null;
    public static final int SORT_FIRST_NAME_ASC = 1;
    public static final int SORT_FIRST_NAME_DESC = 2;
    public static final int SORT_LAST_NAME_ASC = 3;
    public static final int SORT_LAST_NAME_DESC = 4;
    
    public SchoolMemberDao() {
        super();
    }
    
    @org.jetbrains.annotations.Nullable()
    @com.ustadmobile.door.annotation.ReplicationRunOnNewNode()
    @androidx.room.Query(value = "\n     REPLACE INTO SchoolMemberReplicate(smPk, smDestination)\n      SELECT DISTINCT SchoolMember.schoolMemberUid AS smPk,\n             :newNodeId AS smDestination\n        FROM UserSession\n             JOIN PersonGroupMember\n                  ON UserSession.usPersonUid = PersonGroupMember.groupMemberPersonUid\n             JOIN ScopedGrant\n                  ON ScopedGrant.sgGroupUid = PersonGroupMember.groupMemberGroupUid\n                     AND (ScopedGrant.sgPermissions &  64) > 0\n             JOIN SchoolMember\n                  ON \n            ((ScopedGrant.sgTableId = -2\n                  AND ScopedGrant.sgEntityUid = -2)\n              OR (ScopedGrant.sgTableId = 9\n                  AND ScopedGrant.sgEntityUid = SchoolMember.schoolMemberPersonUid)\n              OR (ScopedGrant.sgTableId = 164\n                 AND ScopedGrant.sgEntityUid = SchoolMember.schoolMemberSchoolUid))\n        \n       WHERE UserSession.usClientNodeId = :newNodeId\n         AND UserSession.usStatus = 1\n         AND SchoolMember.schoolMemberLct != COALESCE(\n             (SELECT smVersionId\n                FROM SchoolMemberReplicate\n               WHERE smPk = SchoolMember.schoolMemberUid\n                 AND smDestination = :newNodeId), 0) \n      /*psql ON CONFLICT(smPk, smDestination) DO UPDATE\n             SET smPending = true\n      */       \n    ")
    @com.ustadmobile.door.annotation.ReplicationCheckPendingNotificationsFor(value = {com.ustadmobile.lib.db.entities.SchoolMember.class})
    public abstract java.lang.Object replicateOnNewNode(@com.ustadmobile.door.annotation.NewNodeIdParam()
    long newNodeId, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n REPLACE INTO SchoolMemberReplicate(smPk, smDestination)\n  SELECT DISTINCT SchoolMember.schoolMemberUid AS smUid,\n         UserSession.usClientNodeId AS smDestination\n    FROM ChangeLog\n         JOIN SchoolMember\n              ON ChangeLog.chTableId = 200\n                  AND ChangeLog.chEntityPk = SchoolMember.schoolMemberUid\n         \n            JOIN ScopedGrant\n                 ON \n            ((ScopedGrant.sgTableId = -2\n                  AND ScopedGrant.sgEntityUid = -2)\n              OR (ScopedGrant.sgTableId = 9\n                  AND ScopedGrant.sgEntityUid = SchoolMember.schoolMemberPersonUid)\n              OR (ScopedGrant.sgTableId = 164\n                 AND ScopedGrant.sgEntityUid = SchoolMember.schoolMemberSchoolUid))\n        \n                    AND (ScopedGrant.sgPermissions &\n        \n              64\n              \n            ) > 0  \n            JOIN PersonGroupMember \n                   ON ScopedGrant.sgGroupUid = PersonGroupMember.groupMemberGroupUid\n            JOIN UserSession\n                   ON UserSession.usPersonUid = PersonGroupMember.groupMemberPersonUid\n                      AND UserSession.usStatus =1\n        \n   WHERE UserSession.usClientNodeId != (\n         SELECT nodeClientId \n           FROM SyncNode\n          LIMIT 1)\n     AND SchoolMember.schoolMemberLct != COALESCE(\n         (SELECT smVersionId\n            FROM SchoolMemberReplicate\n           WHERE smPk = SchoolMember.schoolMemberUid\n             AND smDestination = UserSession.usClientNodeId), 0)\n /*psql ON CONFLICT(smPk, smDestination) DO UPDATE\n     SET smPending = true\n  */               \n ")
    @com.ustadmobile.door.annotation.ReplicationCheckPendingNotificationsFor(value = {com.ustadmobile.lib.db.entities.SchoolMember.class})
    @com.ustadmobile.door.annotation.ReplicationRunOnChange(value = {com.ustadmobile.lib.db.entities.SchoolMember.class})
    public abstract java.lang.Object replicateOnChange(@org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "SELECT * FROM SchoolMember WHERE schoolMemberUid = :schoolMemberUid  AND CAST(schoolMemberActive AS INTEGER) = 1")
    public abstract com.ustadmobile.lib.db.entities.SchoolMember findByUidAsync(long schoolMemberUid);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Update()
    public abstract java.lang.Object updateAsync(@org.jetbrains.annotations.NotNull()
    com.ustadmobile.lib.db.entities.SchoolMember entity, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super java.lang.Integer> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n        SELECT * FROM SchoolMember WHERE schoolMemberSchoolUid = :schoolUid\n        AND schoolMemberPersonUid = :personUid\n        AND (:role = 0 OR schoolMemberRole = :role)\n        AND (:timeFilter = 0 OR :timeFilter BETWEEN SchoolMember.schoolMemberJoinDate AND SchoolMember.schoolMemberLeftDate) \n        AND CAST(schoolMemberActive AS INTEGER) = 1\n    ")
    public abstract java.lang.Object findBySchoolAndPersonAndRole(long schoolUid, long personUid, int role, long timeFilter, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super java.util.List<? extends com.ustadmobile.lib.db.entities.SchoolMember>> continuation);
    
    @org.jetbrains.annotations.NotNull()
    @androidx.room.Query(value = "\n        SELECT SchoolMember.*, Person.*\n          FROM PersonGroupMember\n                \n            JOIN ScopedGrant\n                 ON ScopedGrant.sgGroupUid = PersonGroupMember.groupMemberGroupUid\n                    AND (ScopedGrant.sgPermissions & \n                64 \n                \n                                                    ) > 0\n            JOIN Person \n                 ON \n                ((ScopedGrant.sgTableId = -2\n                    AND ScopedGrant.sgEntityUid = -2)\n                 OR (ScopedGrant.sgTableId = 9\n                    AND ScopedGrant.sgEntityUid = Person.personUid)\n                 OR (ScopedGrant.sgTableId = 6       \n                    AND Person.personUid IN (\n                        SELECT DISTINCT clazzEnrolmentPersonUid\n                          FROM ClazzEnrolment\n                         WHERE clazzEnrolmentClazzUid =ScopedGrant.sgEntityUid \n                           AND ClazzEnrolment.clazzEnrolmentActive))\n                 OR (ScopedGrant.sgTableId = 164\n                    AND Person.personUid IN (\n                        SELECT DISTINCT schoolMemberPersonUid\n                          FROM SchoolMember\n                         WHERE schoolMemberSchoolUid = ScopedGrant.sgEntityUid\n                           AND schoolMemberActive))\n                           )    \n        \n        \n          LEFT JOIN SchoolMember ON Person.personUid = SchoolMember.schoolMemberPersonUid \n         WHERE PersonGroupMember.groupMemberPersonUid = :accountPersonUid \n         AND PersonGroupMember.groupMemberActive  \n        AND SchoolMember.schoolMemberActive\n        AND SchoolMember.schoolMemberSchoolUid = :schoolUid \n        AND SchoolMember.schoolMemberRole = :role\n        AND Person.active\n        AND (Person.firstNames || \' \' || Person.lastName) LIKE :searchQuery\n        GROUP BY Person.personUid, SchoolMember.schoolMemberUid\n         ORDER BY CASE(:sortOrder)\n                WHEN 1 THEN Person.firstNames\n                WHEN 3 THEN Person.lastName\n                ELSE \'\'\n            END ASC,\n            CASE(:sortOrder)\n                WHEN 2 THEN Person.firstNames\n                WHEN 4 THEN Person.lastName\n                ELSE \'\'\n            END DESC\n            ")
    public abstract com.ustadmobile.door.DoorDataSourceFactory<java.lang.Integer, com.ustadmobile.lib.db.entities.SchoolMemberWithPerson> findAllActiveMembersBySchoolAndRoleUid(long schoolUid, int role, int sortOrder, @org.jetbrains.annotations.NotNull()
    java.lang.String searchQuery, long accountPersonUid);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "SELECT SchoolMember.*, Person.* FROM SchoolMember\n        LEFT JOIN Person ON Person.personUid = SchoolMember.schoolMemberPersonUid\n        WHERE CAST(SchoolMember.schoolMemberActive AS INTEGER) = 1\n        AND SchoolMember.schoolMemberSchoolUid = :schoolUid \n        AND SchoolMember.schoolMemberRole = :role\n        AND CAST(Person.active AS INTEGER) = 1\n        AND (Person.firstNames || \' \' || Person.lastName) LIKE :searchQuery\n        ORDER BY Person.firstNames DESC")
    public abstract java.lang.Object findAllTest(long schoolUid, int role, @org.jetbrains.annotations.NotNull()
    java.lang.String searchQuery, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super java.util.List<com.ustadmobile.lib.db.entities.SchoolMemberWithPerson>> continuation);
    
    @kotlin.Metadata(mv = {1, 6, 0}, k = 1, d1 = {"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2 = {"Lcom/ustadmobile/core/db/dao/SchoolMemberDao$Companion;", "", "()V", "SORT_FIRST_NAME_ASC", "", "SORT_FIRST_NAME_DESC", "SORT_LAST_NAME_ASC", "SORT_LAST_NAME_DESC", "lib-database"})
    public static final class Companion {
        
        private Companion() {
            super();
        }
    }
}