package com.ustadmobile.core.db.dao;

import java.lang.System;

@com.ustadmobile.door.annotation.Repository()
@androidx.room.Dao()
@kotlin.Metadata(mv = {1, 6, 0}, k = 1, d1 = {"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0010\b\'\u0018\u0000 (2\u00020\u0001:\u0001(B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\'J\'\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\fJ$\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\'J\u001b\u0010\u0010\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0011\u001a\u00020\tH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0012J\u0018\u0010\u0013\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\u00142\u0006\u0010\u0011\u001a\u00020\tH\'J\u0019\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u0005H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0017J\u001f\u0010\u0018\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001bJ\u0011\u0010\u001c\u001a\u00020\u0019H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001dJ\u0011\u0010\u001e\u001a\u00020\u0019H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001dJ\u0011\u0010\u001f\u001a\u00020\u0019H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001dJ\u0011\u0010 \u001a\u00020\u0019H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001dJ\u001b\u0010!\u001a\u00020\u00192\b\b\u0001\u0010\"\u001a\u00020\tH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0012J\u0019\u0010#\u001a\u00020\u00192\u0006\u0010\"\u001a\u00020\tH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0012J\u001b\u0010$\u001a\u00020\u00192\b\b\u0001\u0010\"\u001a\u00020\tH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0012J\u001b\u0010%\u001a\u00020\u00192\b\b\u0001\u0010\"\u001a\u00020\tH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0012J\u0019\u0010&\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u0005H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0017J\u001f\u0010\'\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001b\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006)"}, d2 = {"Lcom/ustadmobile/core/db/dao/ScopedGrantDao;", "", "()V", "findByTableIdAndEntityIdSync", "", "Lcom/ustadmobile/lib/db/entities/ScopedGrant;", "tableId", "", "entityUid", "", "findByTableIdAndEntityUid", "Lcom/ustadmobile/lib/db/entities/ScopedGrantAndName;", "(IJLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findByTableIdAndEntityUidWithNameAsDataSource", "Lcom/ustadmobile/door/DoorDataSourceFactory;", "Lcom/ustadmobile/lib/db/entities/ScopedGrantWithName;", "findByUid", "sgUid", "(JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findByUidLiveWithName", "Lcom/ustadmobile/door/DoorLiveData;", "insertAsync", "scopedGrant", "(Lcom/ustadmobile/lib/db/entities/ScopedGrant;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "insertListAsync", "", "scopedGrantList", "(Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "replicateOnChange", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "replicateOnChangeClazzBased", "replicateOnChangePersonBased", "replicateOnChangeSchoolBased", "replicateOnNewNode", "newNodeId", "replicateOnNewNodeClazzBased", "replicateOnNewNodePersonBased", "replicateOnNewNodeSchoolBased", "updateAsync", "updateListAsync", "Companion", "lib-database"})
public abstract class ScopedGrantDao {
    @org.jetbrains.annotations.NotNull()
    public static final com.ustadmobile.core.db.dao.ScopedGrantDao.Companion Companion = null;
    @org.jetbrains.annotations.NotNull()
    public static final java.lang.String SQL_FIND_BY_TABLE_AND_ENTITY = "\n        SELECT ScopedGrant.*,\n               CASE\n               WHEN Person.firstNames IS NOT NULL THEN Person.firstNames\n               ELSE PersonGroup.groupName \n               END AS name\n          FROM ScopedGrant\n               JOIN PersonGroup \n                    ON ScopedGrant.sgGroupUid = PersonGroup.groupUid\n               LEFT JOIN Person\n                         ON Person.personGroupUid = PersonGroup.groupUid\n         WHERE ScopedGrant.sgTableId = :tableId\n               AND ScopedGrant.sgEntityUid = :entityUid  \n    ";
    
    public ScopedGrantDao() {
        super();
    }
    
    /**
     * ScopedGrant must replicate to:
     *  1) Anyone who has person select permission for anyone that is the group to which the
     *     ScopedGrant belongs.
     *  2) Anyone who has permission to select the underlying entity (e.g. Person, Class, School).
     *     This is important because 1) will not lead to replication when the group itself starts
     *     out empty.
     */
    @org.jetbrains.annotations.Nullable()
    @com.ustadmobile.door.annotation.ReplicationRunOnNewNode()
    @androidx.room.Query(value = "\n     REPLACE INTO ScopedGrantReplicate(sgPk, sgDestination)\n      SELECT DISTINCT ScopedGrantWithPerm.sgUid AS sgPk,\n             :newNodeId AS sgDestination\n        FROM UserSession\n             JOIN PersonGroupMember\n                    ON UserSession.usPersonUid = PersonGroupMember.groupMemberPersonUid\n               \n            JOIN ScopedGrant\n                 ON ScopedGrant.sgGroupUid = PersonGroupMember.groupMemberGroupUid\n                    AND (ScopedGrant.sgPermissions &\n                    64\n                    \n                                                    ) > 0\n            JOIN Person \n                 ON \n                ((ScopedGrant.sgTableId = -2\n                    AND ScopedGrant.sgEntityUid = -2)\n                 OR (ScopedGrant.sgTableId = 9\n                    AND ScopedGrant.sgEntityUid = Person.personUid)\n                 OR (ScopedGrant.sgTableId = 6       \n                    AND Person.personUid IN (\n                        SELECT DISTINCT clazzEnrolmentPersonUid\n                          FROM ClazzEnrolment\n                         WHERE clazzEnrolmentClazzUid =ScopedGrant.sgEntityUid \n                           AND ClazzEnrolment.clazzEnrolmentActive))\n                 OR (ScopedGrant.sgTableId = 164\n                    AND Person.personUid IN (\n                        SELECT DISTINCT schoolMemberPersonUid\n                          FROM SchoolMember\n                         WHERE schoolMemberSchoolUid = ScopedGrant.sgEntityUid\n                           AND schoolMemberActive))\n                           )    \n        \n        \n             JOIN PersonGroupMember PersonsWithPerm_GroupMember\n                    ON PersonsWithPerm_GroupMember.groupMemberPersonUid = Person.personUid\n             JOIN ScopedGrant ScopedGrantWithPerm\n                    ON PersonsWithPerm_GroupMember.groupMemberGroupUid = ScopedGrantWithPerm.sgGroupUid\n       WHERE UserSession.usClientNodeId = :newNodeId\n         AND UserSession.usStatus = 1\n         AND ScopedGrantWithPerm.sgLct != COALESCE(\n             (SELECT sgVersionId\n                FROM ScopedGrantReplicate\n               WHERE sgPk = ScopedGrantWithPerm.sgUid\n                 AND sgDestination = :newNodeId), 0) \n      /*psql ON CONFLICT(sgPk, sgDestination) DO UPDATE\n             SET sgPending = true\n      */       \n    ")
    @com.ustadmobile.door.annotation.ReplicationCheckPendingNotificationsFor(value = {com.ustadmobile.lib.db.entities.ScopedGrant.class})
    public abstract java.lang.Object replicateOnNewNode(@com.ustadmobile.door.annotation.NewNodeIdParam()
    long newNodeId, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n REPLACE INTO ScopedGrantReplicate(sgPk, sgDestination)\n  SELECT DISTINCT ScopedGrantEntity.sgUid AS sgPk,\n         UserSession.usClientNodeId AS sgDestination\n    FROM ChangeLog\n         JOIN ScopedGrant ScopedGrantEntity\n             ON ChangeLog.chTableId = 48\n                AND ChangeLog.chEntityPk = ScopedGrantEntity.sgUid\n         JOIN PersonGroupMember\n              ON PersonGroupMember.groupMemberGroupUid = ScopedGrantEntity.sgGroupUid\n         JOIN Person\n              ON PersonGroupMember.groupMemberPersonUid = Person.personUid\n         \n            JOIN ScopedGrant \n                   ON \n            ((ScopedGrant.sgTableId = -2\n                    AND ScopedGrant.sgEntityUid = -2)\n                 OR (ScopedGrant.sgTableId = 9\n                    AND ScopedGrant.sgEntityUid = Person.personUid)\n                 OR (ScopedGrant.sgTableId = 6       \n                    AND ScopedGrant.sgEntityUid IN (\n                        SELECT DISTINCT clazzEnrolmentClazzUid\n                          FROM ClazzEnrolment\n                         WHERE clazzEnrolmentPersonUid = Person.personUid \n                           AND ClazzEnrolment.clazzEnrolmentActive))\n                 OR (ScopedGrant.sgTableId = 164\n                    AND ScopedGrant.sgEntityUid IN (\n                        SELECT DISTINCT schoolMemberSchoolUid\n                          FROM SchoolMember\n                         WHERE schoolMemberPersonUid = Person.personUid\n                           AND schoolMemberActive))\n                           )\n        \n                   AND (ScopedGrant.sgPermissions & \n        \n              64\n              \n                                                     ) > 0\n             JOIN PersonGroupMember AS PrsGrpMbr\n                   ON ScopedGrant.sgGroupUid = PrsGrpMbr.groupMemberGroupUid\n              JOIN UserSession\n                   ON UserSession.usPersonUid = PrsGrpMbr.groupMemberPersonUid\n                      AND UserSession.usStatus = 1\n        \n   WHERE UserSession.usClientNodeId != (\n         SELECT nodeClientId \n           FROM SyncNode\n          LIMIT 1)\n     AND ScopedGrantEntity.sgLct != COALESCE(\n         (SELECT sgVersionId\n            FROM ScopedGrantReplicate\n           WHERE sgPk = ScopedGrantEntity.sgUid\n             AND sgDestination = UserSession.usClientNodeId), 0)\n /*psql ON CONFLICT(sgPk, sgDestination) DO UPDATE\n     SET sgPending = true\n  */               \n    ")
    @com.ustadmobile.door.annotation.ReplicationCheckPendingNotificationsFor(value = {com.ustadmobile.lib.db.entities.ScopedGrant.class})
    @com.ustadmobile.door.annotation.ReplicationRunOnChange(value = {com.ustadmobile.lib.db.entities.ScopedGrant.class})
    public abstract java.lang.Object replicateOnChange(@org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n REPLACE INTO ScopedGrantReplicate(sgPk, sgDestination)\n  SELECT DISTINCT ScopedGrantEntity.sgUid AS sgPk,\n         UserSession.usClientNodeId AS sgDestination\n    FROM ChangeLog\n         JOIN ScopedGrant ScopedGrantEntity\n              ON ChangeLog.chTableId = 48\n                 AND ChangeLog.chEntityPk = ScopedGrantEntity.sgUid\n         JOIN Clazz \n              ON ScopedGrantEntity.sgTableId = 6\n                 AND ScopedGrantEntity.sgEntityUid = Clazz.clazzUid\n         \n            JOIN ScopedGrant\n                 ON \n            ((ScopedGrant.sgTableId = -2\n                                AND ScopedGrant.sgEntityUid = -2)\n                            OR (ScopedGrant.sgTableId = 6\n                                AND ScopedGrant.sgEntityUid = Clazz.clazzUid)\n                            OR (ScopedGrant.sgTableId = 164\n                                AND ScopedGrant.sgEntityUid = Clazz.clazzSchoolUid))\n        \n                    AND (ScopedGrant.sgPermissions & \n        \n              2\n              \n              \n                                                       ) > 0\n             JOIN PersonGroupMember AS PrsGrpMbr\n                   ON ScopedGrant.sgGroupUid = PrsGrpMbr.groupMemberGroupUid\n                                               \n              JOIN UserSession\n                   ON UserSession.usPersonUid = PrsGrpMbr.groupMemberPersonUid\n                      AND UserSession.usStatus = 1\n                \n   WHERE UserSession.usClientNodeId != (\n         SELECT nodeClientId \n           FROM SyncNode\n          LIMIT 1)\n     AND ScopedGrantEntity.sgLct != COALESCE(\n         (SELECT sgVersionId\n            FROM ScopedGrantReplicate\n           WHERE sgPk = ScopedGrantEntity.sgUid\n             AND sgDestination = UserSession.usClientNodeId), 0)\n /*psql ON CONFLICT(sgPk, sgDestination) DO UPDATE\n     SET sgPending = true\n  */               \n    ")
    @com.ustadmobile.door.annotation.ReplicationCheckPendingNotificationsFor(value = {com.ustadmobile.lib.db.entities.ScopedGrant.class})
    @com.ustadmobile.door.annotation.ReplicationRunOnChange(value = {com.ustadmobile.lib.db.entities.ScopedGrant.class})
    public abstract java.lang.Object replicateOnChangeClazzBased(@org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @com.ustadmobile.door.annotation.ReplicationRunOnNewNode()
    @androidx.room.Query(value = "\n     REPLACE INTO ScopedGrantReplicate(sgPk, sgDestination)\n      SELECT DISTINCT ScopedGrantEntity.sgUid AS sgPk,\n             :newNodeId AS sgDestination\n        FROM UserSession\n               JOIN PersonGroupMember \n                    ON UserSession.usPersonUid = PersonGroupMember.groupMemberPersonUid\n               \n               JOIN ScopedGrant\n                    ON ScopedGrant.sgGroupUid = PersonGroupMember.groupMemberGroupUid\n                        AND (ScopedGrant.sgPermissions & \n        \n                    2 \n                    \n                       ) > 0\n               JOIN Clazz \n                    ON \n            ((ScopedGrant.sgTableId = -2\n                                AND ScopedGrant.sgEntityUid = -2)\n                            OR (ScopedGrant.sgTableId = 6\n                                AND ScopedGrant.sgEntityUid = Clazz.clazzUid)\n                            OR (ScopedGrant.sgTableId = 164\n                                AND ScopedGrant.sgEntityUid = Clazz.clazzSchoolUid))\n        \n        \n               JOIN ScopedGrant ScopedGrantEntity\n                    ON Clazz.clazzUid = ScopedGrant.sgEntityUid\n                       AND ScopedGrantEntity.sgTableId = 6\n       WHERE UserSession.usClientNodeId = :newNodeId\n         AND UserSession.usStatus = 1\n         AND ScopedGrantEntity.sgLct != COALESCE(\n             (SELECT sgVersionId\n                FROM ScopedGrantReplicate\n               WHERE sgPk = ScopedGrantEntity.sgUid\n                 AND sgDestination = :newNodeId), 0) \n      /*psql ON CONFLICT(sgPk, sgDestination) DO UPDATE\n             SET sgPending = true\n      */\n    ")
    @com.ustadmobile.door.annotation.ReplicationCheckPendingNotificationsFor(value = {com.ustadmobile.lib.db.entities.ScopedGrant.class})
    public abstract java.lang.Object replicateOnNewNodeClazzBased(long newNodeId, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n REPLACE INTO ScopedGrantReplicate(sgPk, sgDestination)\n  SELECT DISTINCT ScopedGrantEntity.sgUid AS sgPk,\n         UserSession.usClientNodeId AS sgDestination\n    FROM ChangeLog\n         JOIN ScopedGrant ScopedGrantEntity\n              ON ChangeLog.chTableId = 48\n                 AND ChangeLog.chEntityPk = ScopedGrantEntity.sgUid\n         JOIN Person\n              ON ScopedGrantEntity.sgTableId = 9\n                 AND ScopedGrantEntity.sgEntityUid = Person.personUid\n         \n            JOIN ScopedGrant \n                   ON \n            ((ScopedGrant.sgTableId = -2\n                    AND ScopedGrant.sgEntityUid = -2)\n                 OR (ScopedGrant.sgTableId = 9\n                    AND ScopedGrant.sgEntityUid = Person.personUid)\n                 OR (ScopedGrant.sgTableId = 6       \n                    AND ScopedGrant.sgEntityUid IN (\n                        SELECT DISTINCT clazzEnrolmentClazzUid\n                          FROM ClazzEnrolment\n                         WHERE clazzEnrolmentPersonUid = Person.personUid \n                           AND ClazzEnrolment.clazzEnrolmentActive))\n                 OR (ScopedGrant.sgTableId = 164\n                    AND ScopedGrant.sgEntityUid IN (\n                        SELECT DISTINCT schoolMemberSchoolUid\n                          FROM SchoolMember\n                         WHERE schoolMemberPersonUid = Person.personUid\n                           AND schoolMemberActive))\n                           )\n        \n                   AND (ScopedGrant.sgPermissions & \n        \n            64\n            \n                                                     ) > 0\n             JOIN PersonGroupMember AS PrsGrpMbr\n                   ON ScopedGrant.sgGroupUid = PrsGrpMbr.groupMemberGroupUid\n              JOIN UserSession\n                   ON UserSession.usPersonUid = PrsGrpMbr.groupMemberPersonUid\n                      AND UserSession.usStatus = 1\n             \n   WHERE UserSession.usClientNodeId != (\n         SELECT nodeClientId \n           FROM SyncNode\n          LIMIT 1)\n     AND ScopedGrantEntity.sgLct != COALESCE(\n         (SELECT sgVersionId\n            FROM ScopedGrantReplicate\n           WHERE sgPk = ScopedGrantEntity.sgUid\n             AND sgDestination = UserSession.usClientNodeId), 0)\n /*psql ON CONFLICT(sgPk, sgDestination) DO UPDATE\n     SET sgPending = true\n  */                    \n    ")
    @com.ustadmobile.door.annotation.ReplicationCheckPendingNotificationsFor(value = {com.ustadmobile.lib.db.entities.ScopedGrant.class})
    @com.ustadmobile.door.annotation.ReplicationRunOnChange(value = {com.ustadmobile.lib.db.entities.ScopedGrant.class})
    public abstract java.lang.Object replicateOnChangePersonBased(@org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @com.ustadmobile.door.annotation.ReplicationRunOnNewNode()
    @androidx.room.Query(value = "\n REPLACE INTO ScopedGrantReplicate(sgPk, sgDestination)\n      SELECT DISTINCT ScopedGrantEntity.sgUid AS sgPk,\n             :newNodeId AS sgDestination\n        FROM UserSession\n               JOIN PersonGroupMember \n                    ON UserSession.usPersonUid = PersonGroupMember.groupMemberPersonUid\n               \n            JOIN ScopedGrant\n                 ON ScopedGrant.sgGroupUid = PersonGroupMember.groupMemberGroupUid\n                    AND (ScopedGrant.sgPermissions &\n                    64\n                    \n                                                    ) > 0\n            JOIN Person \n                 ON \n                ((ScopedGrant.sgTableId = -2\n                    AND ScopedGrant.sgEntityUid = -2)\n                 OR (ScopedGrant.sgTableId = 9\n                    AND ScopedGrant.sgEntityUid = Person.personUid)\n                 OR (ScopedGrant.sgTableId = 6       \n                    AND Person.personUid IN (\n                        SELECT DISTINCT clazzEnrolmentPersonUid\n                          FROM ClazzEnrolment\n                         WHERE clazzEnrolmentClazzUid =ScopedGrant.sgEntityUid \n                           AND ClazzEnrolment.clazzEnrolmentActive))\n                 OR (ScopedGrant.sgTableId = 164\n                    AND Person.personUid IN (\n                        SELECT DISTINCT schoolMemberPersonUid\n                          FROM SchoolMember\n                         WHERE schoolMemberSchoolUid = ScopedGrant.sgEntityUid\n                           AND schoolMemberActive))\n                           )    \n        \n        \n               JOIN ScopedGrant ScopedGrantEntity\n                    ON ScopedGrantEntity.sgTableId = 9\n                       AND ScopedGrantEntity.sgEntityUid = Person.personUid \n       WHERE UserSession.usClientNodeId = :newNodeId\n         AND UserSession.usStatus = 1 \n         AND ScopedGrantEntity.sgLct != COALESCE(\n             (SELECT sgVersionId\n                FROM ScopedGrantReplicate\n               WHERE sgPk = ScopedGrantEntity.sgUid\n                 AND sgDestination = UserSession.usClientNodeId), 0)\n /*psql ON CONFLICT(sgPk, sgDestination) DO UPDATE\n     SET sgPending = true\n  */                                                       \n    ")
    @com.ustadmobile.door.annotation.ReplicationCheckPendingNotificationsFor(value = {com.ustadmobile.lib.db.entities.ScopedGrant.class})
    public abstract java.lang.Object replicateOnNewNodePersonBased(@com.ustadmobile.door.annotation.NewNodeIdParam()
    long newNodeId, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n REPLACE INTO ScopedGrantReplicate(sgPk, sgDestination)\n  SELECT DISTINCT ScopedGrantEntity.sgUid AS sgPk,\n         UserSession.usClientNodeId AS sgDestination\n    FROM ChangeLog\n         JOIN ScopedGrant ScopedGrantEntity\n              ON ChangeLog.chTableId = 48\n                 AND ChangeLog.chEntityPk = ScopedGrantEntity.sgUid\n         JOIN School\n              ON ScopedGrantEntity.sgTableId = 164\n                 AND ScopedGrantEntity.sgEntityUid = School.schoolUid\n         \n            JOIN ScopedGrant\n                 ON \n            ((ScopedGrant.sgTableId = -2\n                    AND ScopedGrant.sgEntityUid = -2)\n                OR (ScopedGrant.sgTableId = 164\n                    AND ScopedGrant.sgEntityUid = School.schoolUid))\n        \n                        AND (SCopedGrant.sgPermissions &\n        \n                  536870912\n                  \n                                                     ) > 0\n             JOIN PersonGroupMember AS PrsGrpMbr\n                   ON ScopedGrant.sgGroupUid = PrsGrpMbr.groupMemberGroupUid\n              JOIN UserSession\n                   ON UserSession.usPersonUid = PrsGrpMbr.groupMemberPersonUid\n                      AND UserSession.usStatus = 1\n                      \n              \n   WHERE UserSession.usClientNodeId != (\n             SELECT nodeClientId \n               FROM SyncNode\n              LIMIT 1)\n     AND ScopedGrantEntity.sgLct != COALESCE(\n             (SELECT sgVersionId\n                FROM ScopedGrantReplicate\n               WHERE sgPk = ScopedGrantEntity.sgUid\n                 AND sgDestination = UserSession.usClientNodeId), 0)\n /*psql ON CONFLICT(sgPk, sgDestination) DO UPDATE\n     SET sgPending = true\n  */                 \n    ")
    @com.ustadmobile.door.annotation.ReplicationCheckPendingNotificationsFor(value = {com.ustadmobile.lib.db.entities.ScopedGrant.class})
    @com.ustadmobile.door.annotation.ReplicationRunOnChange(value = {com.ustadmobile.lib.db.entities.ScopedGrant.class})
    public abstract java.lang.Object replicateOnChangeSchoolBased(@org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n REPLACE INTO ScopedGrantReplicate(sgPk, sgDestination)\n      SELECT DISTINCT ScopedGrantEntity.sgUid AS sgPk,\n             :newNodeId AS sgDestination\n        FROM UserSession\n               JOIN PersonGroupMember\n                    ON UserSession.usPersonUid = PersonGroupMember.groupMemberPersonUid\n               \n            JOIN ScopedGrant \n                 ON ScopedGrant.sgGroupUid = PersonGroupMember.groupMemberGroupUid\n                        AND (ScopedGrant.sgPermissions &\n                 \n        \n                    536870912\n                    \n                    ) > 0\n            JOIN School\n                 ON \n            ((ScopedGrant.sgTableId = -2\n                    AND ScopedGrant.sgEntityUid = -2)\n                OR (ScopedGrant.sgTableId = 164\n                    AND ScopedGrant.sgEntityUid = School.schoolUid))\n        \n        \n               JOIN ScopedGrant ScopedGrantEntity\n                    ON ScopedGrantEntity.sgTableId = 164\n                       AND ScopedGrantEntity.sgEntityUid = School.schoolUid\n       WHERE UserSession.usClientNodeId = :newNodeId\n         AND UserSession.usStatus = 1 \n         AND ScopedGrantEntity.sgLct != COALESCE(\n             (SELECT sgVersionId\n                FROM ScopedGrantReplicate\n               WHERE sgPk = ScopedGrantEntity.sgUid\n                 AND sgDestination = UserSession.usClientNodeId), 0)\n /*psql ON CONFLICT(sgPk, sgDestination) DO UPDATE\n     SET sgPending = true\n  */                                                                                 \n    ")
    public abstract java.lang.Object replicateOnNewNodeSchoolBased(@com.ustadmobile.door.annotation.NewNodeIdParam()
    long newNodeId, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Insert()
    public abstract java.lang.Object insertAsync(@org.jetbrains.annotations.NotNull()
    com.ustadmobile.lib.db.entities.ScopedGrant scopedGrant, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super java.lang.Long> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Insert()
    public abstract java.lang.Object insertListAsync(@org.jetbrains.annotations.NotNull()
    java.util.List<? extends com.ustadmobile.lib.db.entities.ScopedGrant> scopedGrantList, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Update()
    public abstract java.lang.Object updateAsync(@org.jetbrains.annotations.NotNull()
    com.ustadmobile.lib.db.entities.ScopedGrant scopedGrant, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Update()
    public abstract java.lang.Object updateListAsync(@org.jetbrains.annotations.NotNull()
    java.util.List<? extends com.ustadmobile.lib.db.entities.ScopedGrant> scopedGrantList, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n        SELECT ScopedGrant.*,\n               CASE\n               WHEN Person.firstNames IS NOT NULL THEN Person.firstNames\n               ELSE PersonGroup.groupName \n               END AS name\n          FROM ScopedGrant\n               JOIN PersonGroup \n                    ON ScopedGrant.sgGroupUid = PersonGroup.groupUid\n               LEFT JOIN Person\n                         ON Person.personGroupUid = PersonGroup.groupUid\n         WHERE ScopedGrant.sgTableId = :tableId\n               AND ScopedGrant.sgEntityUid = :entityUid  \n    ")
    public abstract java.lang.Object findByTableIdAndEntityUid(int tableId, long entityUid, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super java.util.List<com.ustadmobile.lib.db.entities.ScopedGrantAndName>> continuation);
    
    @org.jetbrains.annotations.NotNull()
    @androidx.room.Query(value = "\n        SELECT ScopedGrant.*,\n               CASE\n               WHEN Person.firstNames IS NOT NULL THEN Person.firstNames\n               ELSE PersonGroup.groupName \n               END AS name\n          FROM ScopedGrant\n               JOIN PersonGroup \n                    ON ScopedGrant.sgGroupUid = PersonGroup.groupUid\n               LEFT JOIN Person\n                         ON Person.personGroupUid = PersonGroup.groupUid\n         WHERE ScopedGrant.sgTableId = :tableId\n               AND ScopedGrant.sgEntityUid = :entityUid  \n    ")
    public abstract com.ustadmobile.door.DoorDataSourceFactory<java.lang.Integer, com.ustadmobile.lib.db.entities.ScopedGrantWithName> findByTableIdAndEntityUidWithNameAsDataSource(int tableId, long entityUid);
    
    @org.jetbrains.annotations.NotNull()
    @androidx.room.Query(value = "\n        SELECT ScopedGrant.*\n          FROM ScopedGrant\n         WHERE sgTableId = :tableId\n           AND sgEntityUid = :entityUid\n    ")
    public abstract java.util.List<com.ustadmobile.lib.db.entities.ScopedGrant> findByTableIdAndEntityIdSync(int tableId, long entityUid);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n        SELECT ScopedGrant.*\n          FROM ScopedGrant\n         WHERE sgUid = :sgUid \n    ")
    public abstract java.lang.Object findByUid(long sgUid, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super com.ustadmobile.lib.db.entities.ScopedGrant> continuation);
    
    @org.jetbrains.annotations.NotNull()
    @androidx.room.Query(value = "\n        SELECT ScopedGrant.*, \n               CASE\n               WHEN Person.firstNames IS NOT NULL THEN Person.firstNames\n               ELSE PersonGroup.groupName \n               END AS name\n          FROM ScopedGrant\n               LEFT JOIN PersonGroup \n                    ON ScopedGrant.sgGroupUid = PersonGroup.groupUid\n               LEFT JOIN Person\n                    ON Person.personGroupUid = PersonGroup.groupUid\n         WHERE ScopedGrant.sgUid = :sgUid \n    ")
    public abstract com.ustadmobile.door.DoorLiveData<com.ustadmobile.lib.db.entities.ScopedGrantWithName> findByUidLiveWithName(long sgUid);
    
    @kotlin.Metadata(mv = {1, 6, 0}, k = 1, d1 = {"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2 = {"Lcom/ustadmobile/core/db/dao/ScopedGrantDao$Companion;", "", "()V", "SQL_FIND_BY_TABLE_AND_ENTITY", "", "lib-database"})
    public static final class Companion {
        
        private Companion() {
            super();
        }
    }
}