package com.ustadmobile.core.db.dao;

import java.lang.System;

@androidx.room.Dao()
@kotlin.Metadata(mv = {1, 6, 0}, k = 1, d1 = {"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\b\'\u0018\u0000 \u001c2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001cB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\'J\u001a\u0010\b\u001a\u0004\u0018\u00010\u00022\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bH\'J\u001c\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u0007H\'J\u001a\u0010\u0010\u001a\u0004\u0018\u00010\u00022\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0012H\'J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u000bH\'J\u0018\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u000bH\'J \u0010\u0019\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u0007H\'\u00a8\u0006\u001d"}, d2 = {"Lcom/ustadmobile/core/db/dao/ScrapeQueueItemDao;", "Lcom/ustadmobile/core/db/dao/BaseDao;", "Lcom/ustadmobile/lib/db/entities/ScrapeQueueItem;", "()V", "findByUid", "Lcom/ustadmobile/lib/db/entities/ScrapeQueueItemWithScrapeRun;", "sqiUid", "", "findExistingQueueItem", "runId", "entryUid", "", "findNextQueueItems", "Lcom/ustadmobile/door/DoorLiveData;", "", "itemType", "getExistingQueueItem", "indexUrl", "", "setTimeFinished", "", "uid", "timeFinished", "setTimeStarted", "timeStarted", "updateSetStatusById", "status", "errorCode", "Companion", "lib-database"})
public abstract class ScrapeQueueItemDao implements com.ustadmobile.core.db.dao.BaseDao<com.ustadmobile.lib.db.entities.ScrapeQueueItem> {
    @org.jetbrains.annotations.NotNull()
    public static final com.ustadmobile.core.db.dao.ScrapeQueueItemDao.Companion Companion = null;
    public static final int STATUS_PENDING = 1;
    public static final int STATUS_RUNNING = 2;
    public static final int STATUS_DONE = 3;
    public static final int STATUS_FAILED = 4;
    
    public ScrapeQueueItemDao() {
        super();
    }
    
    @org.jetbrains.annotations.NotNull()
    @androidx.room.Query(value = "SELECT * FROM ScrapeQueueItem WHERE status = 1 AND itemType = :itemType ORDER BY priority ASC LIMIT 10")
    public abstract com.ustadmobile.door.DoorLiveData<java.util.List<com.ustadmobile.lib.db.entities.ScrapeQueueItem>> findNextQueueItems(int itemType);
    
    @androidx.room.Query(value = "UPDATE ScrapeQueueItem SET status = :status, errorCode = :errorCode WHERE sqiUid = :uid")
    public abstract void updateSetStatusById(int uid, int status, int errorCode);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "SELECT * from ScrapeQueueItem WHERE runId = :runId AND scrapeUrl = :indexUrl LIMIT 1")
    public abstract com.ustadmobile.lib.db.entities.ScrapeQueueItem getExistingQueueItem(int runId, @org.jetbrains.annotations.NotNull()
    java.lang.String indexUrl);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "SELECT * from ScrapeQueueItem WHERE runId = :runId AND sqiContentEntryUid = :entryUid LIMIT 1")
    public abstract com.ustadmobile.lib.db.entities.ScrapeQueueItem findExistingQueueItem(int runId, long entryUid);
    
    @androidx.room.Query(value = "UPDATE ScrapeQueueItem SET timeStarted = :timeStarted WHERE sqiUid = :uid")
    public abstract void setTimeStarted(int uid, long timeStarted);
    
    @androidx.room.Query(value = "UPDATE ScrapeQueueItem SET timeFinished = :timeFinished WHERE sqiUid = :uid")
    public abstract void setTimeFinished(int uid, long timeFinished);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "SELECT ScrapeQueueItem.*, ScrapeRun.* FROM ScrapeQueueItem \n                    LEFT JOIN ScrapeRun ON  ScrapeQueueItem.runId = ScrapeRun.scrapeRunUid\n                    WHERE ScrapeQueueItem.sqiUid = :sqiUid")
    public abstract com.ustadmobile.lib.db.entities.ScrapeQueueItemWithScrapeRun findByUid(int sqiUid);
    
    @kotlin.Metadata(mv = {1, 6, 0}, k = 1, d1 = {"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2 = {"Lcom/ustadmobile/core/db/dao/ScrapeQueueItemDao$Companion;", "", "()V", "STATUS_DONE", "", "STATUS_FAILED", "STATUS_PENDING", "STATUS_RUNNING", "lib-database"})
    public static final class Companion {
        
        private Companion() {
            super();
        }
    }
}