package com.ustadmobile.core.db.dao;

import java.lang.System;

@com.ustadmobile.door.annotation.Repository()
@androidx.room.Dao()
@kotlin.Metadata(mv = {1, 6, 0}, k = 1, d1 = {"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0006\b\'\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\n\u0010\u0003\u001a\u0004\u0018\u00010\u0004H\'J\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0004H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0004H\'J\u0019\u0010\n\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0004H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000bJ\u0011\u0010\f\u001a\u00020\rH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0006J\u001b\u0010\u000e\u001a\u00020\r2\b\b\u0001\u0010\u000f\u001a\u00020\bH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0010J\u0019\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0004H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000b\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0013"}, d2 = {"Lcom/ustadmobile/core/db/dao/SiteDao;", "", "()V", "getSite", "Lcom/ustadmobile/lib/db/entities/Site;", "getSiteAsync", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "insert", "", "site", "replaceAsync", "(Lcom/ustadmobile/lib/db/entities/Site;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "replicateOnChange", "", "replicateOnNewNode", "newNodeId", "(JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "updateAsync", "workspace", "lib-database"})
public abstract class SiteDao {
    
    public SiteDao() {
        super();
    }
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "SELECT * FROM Site LIMIT 1")
    public abstract com.ustadmobile.lib.db.entities.Site getSite();
    
    @org.jetbrains.annotations.Nullable()
    @com.ustadmobile.door.annotation.RepoHttpAccessible()
    @androidx.room.Query(value = "SELECT * FROM Site LIMIT 1")
    public abstract java.lang.Object getSiteAsync(@org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super com.ustadmobile.lib.db.entities.Site> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Insert(onConflict = 1)
    public abstract java.lang.Object replaceAsync(@org.jetbrains.annotations.NotNull()
    com.ustadmobile.lib.db.entities.Site site, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super java.lang.Long> continuation);
    
    @androidx.room.Insert()
    public abstract long insert(@org.jetbrains.annotations.NotNull()
    com.ustadmobile.lib.db.entities.Site site);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Update()
    public abstract java.lang.Object updateAsync(@org.jetbrains.annotations.NotNull()
    com.ustadmobile.lib.db.entities.Site workspace, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @com.ustadmobile.door.annotation.ReplicationRunOnNewNode()
    @androidx.room.Query(value = "\n        REPLACE INTO SiteReplicate(sitePk, siteDestination)\n         SELECT DISTINCT Site.siteUid AS sitePk,\n                :newNodeId AS siteDestination\n           FROM Site\n          WHERE Site.siteLct != COALESCE(\n                (SELECT siteVersionId\n                   FROM SiteReplicate\n                  WHERE sitePk = Site.siteUid\n                    AND siteDestination = :newNodeId), 0) \n         /*psql ON CONFLICT(sitePk, siteDestination) DO UPDATE\n                SET sitePending = true\n         */       \n    ")
    @com.ustadmobile.door.annotation.ReplicationCheckPendingNotificationsFor(value = {com.ustadmobile.lib.db.entities.Site.class})
    public abstract java.lang.Object replicateOnNewNode(@com.ustadmobile.door.annotation.NewNodeIdParam()
    long newNodeId, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n        REPLACE INTO SiteReplicate(sitePk, siteDestination)\n         SELECT DISTINCT Site.siteUid AS sitePk,\n                UserSession.usClientNodeId AS siteDestination\n           FROM ChangeLog\n                JOIN Site \n                    ON ChangeLog.chTableId = 189 \n                       AND ChangeLog.chEntityPk = Site.siteUid\n                JOIN UserSession ON UserSession.usStatus = 1\n          WHERE UserSession.usClientNodeId != (\n                SELECT nodeClientId \n                  FROM SyncNode\n                 LIMIT 1)\n            AND Site.siteLct != COALESCE(\n                (SELECT siteVersionId\n                   FROM SiteReplicate\n                  WHERE sitePk = Site.siteUid\n                    AND siteDestination = UserSession.usClientNodeId), 0)     \n        /*psql  ON CONFLICT(sitePk, siteDestination) DO UPDATE\n            SET sitePending = true\n         */               \n    ")
    @com.ustadmobile.door.annotation.ReplicationCheckPendingNotificationsFor(value = {com.ustadmobile.lib.db.entities.Site.class})
    @com.ustadmobile.door.annotation.ReplicationRunOnChange(value = {com.ustadmobile.lib.db.entities.Site.class})
    public abstract java.lang.Object replicateOnChange(@org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
}