package com.ustadmobile.core.db.dao;

import java.lang.System;

@com.ustadmobile.door.annotation.Repository()
@androidx.room.Dao()
@kotlin.Metadata(mv = {1, 6, 0}, k = 1, d1 = {"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\b\'\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\'J\u001a\u0010\b\u001a\u0004\u0018\u00010\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0007H\'J\u0011\u0010\f\u001a\u00020\rH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000eJ\u001b\u0010\u000f\u001a\u00020\r2\b\b\u0001\u0010\u0010\u001a\u00020\u0007H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0011J \u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0007H\'\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0016"}, d2 = {"Lcom/ustadmobile/core/db/dao/StateContentDao;", "Lcom/ustadmobile/core/db/dao/BaseDao;", "Lcom/ustadmobile/lib/db/entities/StateContentEntity;", "()V", "findAllStateContentWithStateUid", "", "id", "", "findStateContentByKeyAndStateUid", "key", "", "stateUid", "replicateOnChange", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "replicateOnNewNode", "newNodeId", "(JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "setInActiveStateContentByKeyAndUid", "isActive", "", "updateTime", "lib-database"})
public abstract class StateContentDao implements com.ustadmobile.core.db.dao.BaseDao<com.ustadmobile.lib.db.entities.StateContentEntity> {
    
    public StateContentDao() {
        super();
    }
    
    @org.jetbrains.annotations.Nullable()
    @com.ustadmobile.door.annotation.ReplicationRunOnNewNode()
    @androidx.room.Query(value = "\n     REPLACE INTO StateContentEntityReplicate(scePk, sceDestination)\n      SELECT DISTINCT StateContentEntity.stateContentUid AS scePk,\n             :newNodeId AS sceDestination\n        FROM StateContentEntity\n       WHERE StateContentEntity.stateContentLct != COALESCE(\n             (SELECT sceVersionId\n                FROM StateContentEntityReplicate\n               WHERE scePk = StateContentEntity.stateContentUid\n                 AND sceDestination = :newNodeId), 0) \n      /*psql ON CONFLICT(scePk, sceDestination) DO UPDATE\n             SET scePending = true\n      */       \n    ")
    @com.ustadmobile.door.annotation.ReplicationCheckPendingNotificationsFor(value = {com.ustadmobile.lib.db.entities.StateContentEntity.class})
    public abstract java.lang.Object replicateOnNewNode(@com.ustadmobile.door.annotation.NewNodeIdParam()
    long newNodeId, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n REPLACE INTO StateContentEntityReplicate(scePk, sceDestination)\n  SELECT DISTINCT StateContentEntity.stateContentUid AS sceUid,\n         UserSession.usClientNodeId AS sceDestination\n    FROM ChangeLog\n         JOIN StateContentEntity\n             ON ChangeLog.chTableId = 72\n                AND ChangeLog.chEntityPk = StateContentEntity.stateContentUid\n         JOIN UserSession ON UserSession.usStatus = 1\n   WHERE UserSession.usClientNodeId != (\n         SELECT nodeClientId \n           FROM SyncNode\n          LIMIT 1)\n     AND StateContentEntity.stateContentLct != COALESCE(\n         (SELECT sceVersionId\n            FROM StateContentEntityReplicate\n           WHERE scePk = StateContentEntity.stateContentUid\n             AND sceDestination = UserSession.usClientNodeId), 0)\n /*psql ON CONFLICT(scePk, sceDestination) DO UPDATE\n     SET scePending = true\n  */               \n ")
    @com.ustadmobile.door.annotation.ReplicationCheckPendingNotificationsFor(value = {com.ustadmobile.lib.db.entities.StateContentEntity.class})
    @com.ustadmobile.door.annotation.ReplicationRunOnChange(value = {com.ustadmobile.lib.db.entities.StateContentEntity.class})
    public abstract java.lang.Object replicateOnChange(@org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @org.jetbrains.annotations.NotNull()
    @androidx.room.Query(value = "SELECT * FROM StateContentEntity WHERE stateContentStateUid = :id AND isIsactive")
    public abstract java.util.List<com.ustadmobile.lib.db.entities.StateContentEntity> findAllStateContentWithStateUid(long id);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "SELECT * FROM StateContentEntity WHERE stateContentStateUid = :stateUid AND stateContentKey = :key AND isIsactive")
    public abstract com.ustadmobile.lib.db.entities.StateContentEntity findStateContentByKeyAndStateUid(@org.jetbrains.annotations.NotNull()
    java.lang.String key, long stateUid);
    
    @androidx.room.Query(value = "\n        UPDATE StateContentEntity \n           SET isIsactive = :isActive,  \n               stateContentLct = :updateTime\n         WHERE stateContentUid = :stateUid\n    ")
    public abstract void setInActiveStateContentByKeyAndUid(boolean isActive, long stateUid, long updateTime);
}