package com.ustadmobile.core.db.dao;

import java.lang.System;

@com.ustadmobile.door.annotation.Repository()
@androidx.room.Dao()
@kotlin.Metadata(mv = {1, 6, 0}, k = 1, d1 = {"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0003\b\'\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J0\u0010\u0004\u001a\u0004\u0018\u00010\u00022\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\u00062\b\u0010\n\u001a\u0004\u0018\u00010\u0006H\'J.\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u0006H\'J\u0011\u0010\u000e\u001a\u00020\u000fH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0010J\u001b\u0010\u0011\u001a\u00020\u000f2\b\b\u0001\u0010\u0012\u001a\u00020\bH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0013J8\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\bH\'J0\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\bH\'\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u001a"}, d2 = {"Lcom/ustadmobile/core/db/dao/StateDao;", "Lcom/ustadmobile/core/db/dao/BaseDao;", "Lcom/ustadmobile/lib/db/entities/StateEntity;", "()V", "findByStateId", "id", "", "agentUid", "", "activityId", "registration", "findStateIdByAgentAndActivity", "", "since", "replicateOnChange", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "replicateOnNewNode", "newNodeId", "(JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "setStateInActive", "stateId", "isActive", "", "updateTime", "updateStateToInActive", "lib-database"})
public abstract class StateDao implements com.ustadmobile.core.db.dao.BaseDao<com.ustadmobile.lib.db.entities.StateEntity> {
    
    public StateDao() {
        super();
    }
    
    @org.jetbrains.annotations.Nullable()
    @com.ustadmobile.door.annotation.ReplicationRunOnNewNode()
    @androidx.room.Query(value = "\n     REPLACE INTO StateEntityReplicate(sePk, seDestination)\n      SELECT DISTINCT StateEntity.stateUid AS sePk,\n             :newNodeId AS seDestination\n        FROM StateEntity\n             JOIN AgentEntity\n                  ON StateEntity.agentUid = AgentEntity.agentUid\n             JOIN UserSession\n                  ON AgentEntity.agentPersonUid = UserSession.usPersonUid\n       WHERE UserSession.usClientNodeId = :newNodeId\n         AND UserSession.usStatus = 1\n         AND StateEntity.stateLct != COALESCE(\n             (SELECT seVersionId\n                FROM StateEntityReplicate\n               WHERE sePk = StateEntity.stateUid\n                 AND seDestination = :newNodeId), 0) \n      /*psql ON CONFLICT(sePk, seDestination) DO UPDATE\n             SET sePending = true\n      */       \n ")
    @com.ustadmobile.door.annotation.ReplicationCheckPendingNotificationsFor(value = {com.ustadmobile.lib.db.entities.StateEntity.class})
    public abstract java.lang.Object replicateOnNewNode(@com.ustadmobile.door.annotation.NewNodeIdParam()
    long newNodeId, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n REPLACE INTO StateEntityReplicate(sePk, seDestination)\n  SELECT DISTINCT StateEntity.stateUid AS seUid,\n         UserSession.usClientNodeId AS seDestination\n    FROM ChangeLog\n         JOIN StateEntity\n              ON ChangeLog.chTableId = 70\n                 AND ChangeLog.chEntityPk = StateEntity.stateUid\n         JOIN AgentEntity\n              ON StateEntity.agentUid = AgentEntity.agentUid\n         JOIN UserSession\n              ON AgentEntity.agentPersonUid = UserSession.usPersonUid\n                 AND UserSession.usStatus = 1\n   WHERE UserSession.usClientNodeId != (\n         SELECT nodeClientId \n           FROM SyncNode\n          LIMIT 1)\n     AND StateEntity.stateLct != COALESCE(\n         (SELECT seVersionId\n            FROM StateEntityReplicate\n           WHERE sePk = StateEntity.stateUid\n             AND seDestination = UserSession.usClientNodeId), 0)\n /*psql ON CONFLICT(sePk, seDestination) DO UPDATE\n     SET sePending = true\n  */               \n    ")
    @com.ustadmobile.door.annotation.ReplicationCheckPendingNotificationsFor(value = {com.ustadmobile.lib.db.entities.StateEntity.class})
    @com.ustadmobile.door.annotation.ReplicationRunOnChange(value = {com.ustadmobile.lib.db.entities.StateEntity.class})
    public abstract java.lang.Object replicateOnChange(@org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "SELECT * FROM StateEntity WHERE stateId = :id AND agentUid = :agentUid AND activityId = :activityId AND registration = :registration AND isIsactive LIMIT 1")
    public abstract com.ustadmobile.lib.db.entities.StateEntity findByStateId(@org.jetbrains.annotations.Nullable()
    java.lang.String id, long agentUid, @org.jetbrains.annotations.Nullable()
    java.lang.String activityId, @org.jetbrains.annotations.Nullable()
    java.lang.String registration);
    
    @org.jetbrains.annotations.NotNull()
    @com.ustadmobile.door.annotation.SqliteOnly()
    @androidx.room.Query(value = "SELECT * FROM StateEntity WHERE agentUid = :agentUid AND activityId = :activityId AND registration = :registration AND isIsactive AND timestamp > :since")
    public abstract java.util.List<com.ustadmobile.lib.db.entities.StateEntity> findStateIdByAgentAndActivity(long agentUid, @org.jetbrains.annotations.NotNull()
    java.lang.String activityId, @org.jetbrains.annotations.NotNull()
    java.lang.String registration, @org.jetbrains.annotations.NotNull()
    java.lang.String since);
    
    @androidx.room.Query(value = "\n        UPDATE StateEntity \n           SET isIsactive = :isActive,\n               stateLct = :updateTime\n         WHERE agentUid = :agentUid AND activityId = :activityId \n           AND registration = :registration AND isIsactive\n    ")
    public abstract void updateStateToInActive(long agentUid, @org.jetbrains.annotations.NotNull()
    java.lang.String activityId, @org.jetbrains.annotations.NotNull()
    java.lang.String registration, boolean isActive, long updateTime);
    
    @androidx.room.Query(value = "\n        UPDATE StateEntity \n          SET isIsactive = :isActive, \n              stateLct = :updateTime\n        WHERE stateId = :stateId AND agentUid = :agentUid \n          AND activityId = :activityId AND registration = :registration \n          AND isIsactive")
    public abstract void setStateInActive(@org.jetbrains.annotations.NotNull()
    java.lang.String stateId, long agentUid, @org.jetbrains.annotations.NotNull()
    java.lang.String activityId, @org.jetbrains.annotations.NotNull()
    java.lang.String registration, boolean isActive, long updateTime);
}