package com.ustadmobile.core.db.dao;

import java.lang.System;

@com.ustadmobile.door.annotation.Repository()
@androidx.room.Dao()
@kotlin.Metadata(mv = {1, 6, 0}, k = 1, d1 = {"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000e\b\'\u0018\u0000 F2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002FGB\u0005\u00a2\u0006\u0002\u0010\u0003J\u001b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\bJ\u0012\u0010\t\u001a\u0004\u0018\u00010\u00022\u0006\u0010\n\u001a\u00020\u0007H\'J\u001c\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\f2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\fH\'J\u001b\u0010\r\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\bJ#\u0010\u000e\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0012J!\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0010H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0012J4\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00190\u00172\u0006\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u0018H\'J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u001e\u001a\u00020\u0010H\'J4\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020 0\u00172\u0006\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010!\u001a\u00020\u00102\u0006\u0010\u0006\u001a\u00020\u0007H\'J,\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020#0\u00172\u0006\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010!\u001a\u00020\u0010H\'J#\u0010$\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u001e\u001a\u00020\u00102\u0006\u0010%\u001a\u00020\u0010H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0012J#\u0010&\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u0010H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0012J\u001c\u0010\'\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020(0\u00172\u0006\u0010)\u001a\u00020*H\'J\u0010\u0010+\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020,H\'J\n\u0010-\u001a\u0004\u0018\u00010.H\'J\u001f\u0010/\u001a\b\u0012\u0004\u0012\u0002000\f2\u0006\u0010)\u001a\u00020*H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00101J-\u0010/\u001a\b\u0012\u0004\u0012\u0002000\f2\u0006\u00102\u001a\u00020\u00072\f\u00103\u001a\b\u0012\u0004\u0012\u00020504H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00106J\n\u00107\u001a\u0004\u0018\u000108H\'J\u001f\u00109\u001a\u00020:2\f\u0010;\u001a\b\u0012\u0004\u0012\u00020\u00020\fH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010<J\u0011\u0010=\u001a\u00020:H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010>J\u001b\u0010?\u001a\u00020:2\b\b\u0001\u0010@\u001a\u00020\u0010H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010AJ \u0010B\u001a\u00020:2\u0006\u0010C\u001a\u00020\u00102\u0006\u0010D\u001a\u00020\u00182\u0006\u0010E\u001a\u00020\u0010H\'\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006H"}, d2 = {"Lcom/ustadmobile/core/db/dao/StatementDao;", "Lcom/ustadmobile/core/db/dao/BaseDao;", "Lcom/ustadmobile/lib/db/entities/StatementEntity;", "()V", "calculateScoreForSession", "Lcom/ustadmobile/lib/db/entities/ContentEntryStatementScoreProgress;", "contextRegistration", "", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findByStatementId", "id", "findByStatementIdList", "", "findCompletedScoreForSession", "findLatestRegistrationStatement", "accountPersonUid", "", "entryUid", "(JJLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findNextStudentNotMarkedForAssignment", "assignmentUid", "currentStudentUid", "findPersonsWithContentEntryAttempts", "Lcom/ustadmobile/door/DoorDataSourceFactory;", "", "Lcom/ustadmobile/lib/db/entities/PersonWithAttemptsSummary;", "contentEntryUid", "searchText", "sortOrder", "findScoreStatementForStudent", "studentUid", "findSessionDetailForPerson", "Lcom/ustadmobile/lib/db/entities/StatementWithSessionDetailDisplay;", "personUid", "findSessionsForPerson", "Lcom/ustadmobile/lib/db/entities/PersonWithSessionsDisplay;", "findSubmittedStatementFromStudent", "assignmentObjectUid", "getBestScoreForContentForPerson", "getListResults", "Lcom/ustadmobile/lib/db/entities/StatementEntityWithDisplayDetails;", "query", "Lcom/ustadmobile/door/DoorQuery;", "getOneStatement", "Lcom/ustadmobile/door/DoorLiveData;", "getPerson", "Lcom/ustadmobile/lib/db/entities/Person;", "getResults", "Lcom/ustadmobile/core/db/dao/StatementDao$ReportData;", "(Lcom/ustadmobile/door/DoorQuery;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "sqlStr", "paramsList", "", "", "(Ljava/lang/String;[Ljava/lang/Object;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getXLangMap", "Lcom/ustadmobile/lib/db/entities/XLangMapEntry;", "insertListAsync", "", "entityList", "(Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "replicateOnChange", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "replicateOnNewNode", "newNodeId", "(JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "updateProgress", "uid", "progress", "updateTime", "Companion", "ReportData", "lib-database"})
public abstract class StatementDao implements com.ustadmobile.core.db.dao.BaseDao<com.ustadmobile.lib.db.entities.StatementEntity> {
    @org.jetbrains.annotations.NotNull()
    public static final com.ustadmobile.core.db.dao.StatementDao.Companion Companion = null;
    public static final int SORT_FIRST_NAME_ASC = 1;
    public static final int SORT_FIRST_NAME_DESC = 2;
    public static final int SORT_LAST_NAME_ASC = 3;
    public static final int SORT_LAST_NAME_DESC = 4;
    public static final int SORT_LAST_ACTIVE_ASC = 5;
    public static final int SORT_LAST_ACTIVE_DESC = 6;
    
    public StatementDao() {
        super();
    }
    
    @org.jetbrains.annotations.Nullable()
    @com.ustadmobile.door.annotation.ReplicationRunOnNewNode()
    @androidx.room.Query(value = "\n     REPLACE INTO StatementEntityReplicate(sePk, seDestination)\n      SELECT DISTINCT StatementEntity.statementUid AS sePk,\n             :newNodeId AS seDestination\n        FROM UserSession\n             JOIN PersonGroupMember\n                  ON UserSession.usPersonUid = PersonGroupMember.groupMemberPersonUid\n             JOIN ScopedGrant\n                  ON ScopedGrant.sgGroupUid = PersonGroupMember.groupMemberGroupUid\n                     AND (ScopedGrant.sgPermissions & 549755813888) > 0\n             JOIN StatementEntity\n                 ON \n            ((ScopedGrant.sgTableId = -2\n                AND ScopedGrant.sgEntityUid = -2)\n             OR (ScopedGrant.sgTableId = 9\n                AND ScopedGrant.sgEntityUid = StatementEntity.statementPersonUid)\n             OR (ScopedGrant.sgTableId = 6\n                AND ScopedGrant.sgEntityUid = StatementEntity.statementClazzUid)\n             OR (ScopedGrant.sgTableId = 164\n                AND ScopedGrant.sgEntityUid = (\n                    SELECT clazzSchoolUid\n                      FROM Clazz \n                     WHERE clazzUid = StatementEntity.statementClazzUid))\n            )         \n        \n       WHERE UserSession.usClientNodeId = :newNodeId\n         AND UserSession.usStatus = 1\n         -- Temporary measure to prevent admin user getting clogged up\n         -- Restrict to the last 30 days of data\n         AND StatementEntity.timestamp > ( \n       --notpsql\n       strftime(\'%s\', \'now\') * 1000\n       --endnotpsql\n       /*psql\n       ROUND(EXTRACT(epoch from NOW())*1000)\n       */\n       - (30 * CAST(86400000 AS BIGINT)))\n       --notpsql\n         AND StatementEntity.statementLct != COALESCE(\n             (SELECT seVersionId\n                FROM StatementEntityReplicate\n               WHERE sePk = StatementEntity.statementUid\n                 AND seDestination = UserSession.usClientNodeId), 0)\n       --endnotpsql           \n      /*psql ON CONFLICT(sePk, seDestination) DO UPDATE\n             SET sePending = (SELECT StatementEntity.statementLct\n            FROM StatementEntity\n           WHERE StatementEntity.statementUid = EXCLUDED.sePk ) \n                 != StatementEntityReplicate.seVersionId\n      */       \n    ")
    @com.ustadmobile.door.annotation.ReplicationCheckPendingNotificationsFor(value = {com.ustadmobile.lib.db.entities.StatementEntity.class})
    public abstract java.lang.Object replicateOnNewNode(@com.ustadmobile.door.annotation.NewNodeIdParam()
    long newNodeId, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n REPLACE INTO StatementEntityReplicate(sePk, seDestination)\n  SELECT DISTINCT StatementEntity.statementUid AS seUid,\n         UserSession.usClientNodeId AS seDestination\n    FROM ChangeLog\n         JOIN StatementEntity\n               ON ChangeLog.chTableId = 60\n                  AND ChangeLog.chEntityPk = StatementEntity.statementUid\n         JOIN ScopedGrant\n              ON \n            ((ScopedGrant.sgTableId = -2\n                AND ScopedGrant.sgEntityUid = -2)\n             OR (ScopedGrant.sgTableId = 9\n                AND ScopedGrant.sgEntityUid = StatementEntity.statementPersonUid)\n             OR (ScopedGrant.sgTableId = 6\n                AND ScopedGrant.sgEntityUid = StatementEntity.statementClazzUid)\n             OR (ScopedGrant.sgTableId = 164\n                AND ScopedGrant.sgEntityUid = (\n                    SELECT clazzSchoolUid\n                      FROM Clazz\n                     WHERE clazzUid = StatementEntity.statementClazzUid))\n             )\n        \n                 AND (ScopedGrant.sgPermissions & 549755813888) > 0\n         JOIN PersonGroupMember\n              ON ScopedGrant.sgGroupUid = PersonGroupMember.groupMemberGroupUid\n         JOIN UserSession\n              ON UserSession.usPersonUid = PersonGroupMember.groupMemberPersonUid\n                 AND UserSession.usStatus = 1\n   WHERE UserSession.usClientNodeId != (\n         SELECT nodeClientId\n           FROM SyncNode\n          LIMIT 1)\n     AND StatementEntity.statementLct != COALESCE(\n         (SELECT seVersionId\n            FROM StatementEntityReplicate\n           WHERE sePk = StatementEntity.statementUid\n             AND seDestination = UserSession.usClientNodeId), 0)\n /*psql ON CONFLICT(sePk, seDestination) DO UPDATE\n     SET sePending = true\n  */\n    ")
    @com.ustadmobile.door.annotation.ReplicationCheckPendingNotificationsFor(value = {com.ustadmobile.lib.db.entities.StatementEntity.class})
    @com.ustadmobile.door.annotation.ReplicationRunOnChange(value = {com.ustadmobile.lib.db.entities.StatementEntity.class})
    public abstract java.lang.Object replicateOnChange(@org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Insert()
    public abstract java.lang.Object insertListAsync(@org.jetbrains.annotations.NotNull()
    java.util.List<? extends com.ustadmobile.lib.db.entities.StatementEntity> entityList, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @org.jetbrains.annotations.NotNull()
    @androidx.room.Query(value = "SELECT * From StatementEntity LIMIT 1")
    public abstract com.ustadmobile.door.DoorLiveData<com.ustadmobile.lib.db.entities.StatementEntity> getOneStatement();
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "SELECT * FROM StatementEntity WHERE statementId = :id LIMIT 1")
    public abstract com.ustadmobile.lib.db.entities.StatementEntity findByStatementId(@org.jetbrains.annotations.NotNull()
    java.lang.String id);
    
    @org.jetbrains.annotations.NotNull()
    @androidx.room.Query(value = "SELECT * FROM StatementEntity WHERE statementId IN (:id)")
    public abstract java.util.List<com.ustadmobile.lib.db.entities.StatementEntity> findByStatementIdList(@org.jetbrains.annotations.NotNull()
    java.util.List<java.lang.String> id);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.RawQuery()
    public abstract java.lang.Object getResults(@org.jetbrains.annotations.NotNull()
    com.ustadmobile.door.DoorQuery query, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super java.util.List<com.ustadmobile.core.db.dao.StatementDao.ReportData>> continuation);
    
    @org.jetbrains.annotations.Nullable()
    public java.lang.Object getResults(@org.jetbrains.annotations.NotNull()
    java.lang.String sqlStr, @org.jetbrains.annotations.NotNull()
    java.lang.Object[] paramsList, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super java.util.List<com.ustadmobile.core.db.dao.StatementDao.ReportData>> continuation) {
        return null;
    }
    
    @org.jetbrains.annotations.NotNull()
    @com.ustadmobile.door.annotation.QueryLiveTables(value = {"StatementEntity", "Person", "XLangMapEntry"})
    @androidx.room.RawQuery(observedEntities = {com.ustadmobile.lib.db.entities.StatementEntity.class, com.ustadmobile.lib.db.entities.Person.class, com.ustadmobile.lib.db.entities.XLangMapEntry.class})
    public abstract com.ustadmobile.door.DoorDataSourceFactory<java.lang.Integer, com.ustadmobile.lib.db.entities.StatementEntityWithDisplayDetails> getListResults(@org.jetbrains.annotations.NotNull()
    com.ustadmobile.door.DoorQuery query);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "SELECT * FROM PERSON LIMIT 1")
    public abstract com.ustadmobile.lib.db.entities.Person getPerson();
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "SELECT * FROM XLangMapEntry LIMIT 1")
    public abstract com.ustadmobile.lib.db.entities.XLangMapEntry getXLangMap();
    
    @androidx.room.Query(value = "\n        UPDATE StatementEntity \n           SET extensionProgress = :progress,\n               statementLct = :updateTime \n            WHERE statementUid = :uid")
    public abstract void updateProgress(long uid, int progress, long updateTime);
    
    @org.jetbrains.annotations.NotNull()
    @com.ustadmobile.door.annotation.SqliteOnly()
    @androidx.room.Query(value = "\n        SELECT ResultSource.personUid, ResultSource.firstNames, ResultSource.lastName,\n            COUNT(DISTINCT(ResultSource.contextRegistration)) AS attempts, \n            MIN(ResultSource.timestamp) AS startDate, \n            MAX(ResultSource.timestamp) AS endDate, \n            SUM(ResultSource.resultDuration) AS duration, \n            MAX(CASE WHEN ResultSource.contentEntryRoot \n                THEN resultScoreRaw\n                ELSE 0 END) AS resultScore, \n            MAX(CASE WHEN ResultSource.contentEntryRoot \n                THEN resultScoreMax\n                ELSE 0 END) AS resultMax,   \n            MAX(CASE WHEN ResultSource.contentEntryRoot \n                THEN resultScoreScaled\n                ELSE 0 END) AS resultScaled, \n            MAX(ResultSource.extensionProgress) AS progress,\n            0 AS penalty,\n            0 as resultWeight,\n            \'FALSE\' AS contentComplete,\n            0 AS success,\n            \n            CASE WHEN ResultSource.resultCompletion \n                THEN 1 ELSE 0 END AS totalCompletedContent,\n                \n            1 as totalContent, \n            \n            0 as fileSubmissionStatus, \n         \n            \'\' AS latestPrivateComment\n        \n         FROM (SELECT Person.personUid, Person.firstNames, Person.lastName, \n            StatementEntity.contextRegistration, StatementEntity.timestamp, \n            StatementEntity.resultDuration, StatementEntity.resultScoreRaw, \n            StatementEntity.resultScoreMax, StatementEntity.resultScoreScaled,\n            StatementEntity.contentEntryRoot, StatementEntity.extensionProgress, \n            StatementEntity.resultCompletion\n            FROM PersonGroupMember\n            \n            JOIN ScopedGrant\n                 ON ScopedGrant.sgGroupUid = PersonGroupMember.groupMemberGroupUid\n                    AND (ScopedGrant.sgPermissions & 549755813888 \n                                                    ) > 0\n            JOIN Person \n                 ON \n                ((ScopedGrant.sgTableId = -2\n                    AND ScopedGrant.sgEntityUid = -2)\n                 OR (ScopedGrant.sgTableId = 9\n                    AND ScopedGrant.sgEntityUid = Person.personUid)\n                 OR (ScopedGrant.sgTableId = 6       \n                    AND Person.personUid IN (\n                        SELECT DISTINCT clazzEnrolmentPersonUid\n                          FROM ClazzEnrolment\n                         WHERE clazzEnrolmentClazzUid =ScopedGrant.sgEntityUid \n                           AND ClazzEnrolment.clazzEnrolmentActive))\n                 OR (ScopedGrant.sgTableId = 164\n                    AND Person.personUid IN (\n                        SELECT DISTINCT schoolMemberPersonUid\n                          FROM SchoolMember\n                         WHERE schoolMemberSchoolUid = ScopedGrant.sgEntityUid\n                           AND schoolMemberActive))\n                           )    \n        \n        \n             LEFT JOIN StatementEntity \n                ON StatementEntity.statementPersonUid = Person.personUid \n                    WHERE PersonGroupMember.groupMemberPersonUid = :accountPersonUid \n                        AND PersonGroupMember.groupMemberActive  \n                        AND statementContentEntryUid = :contentEntryUid\n                        AND Person.firstNames || \' \' || Person.lastName LIKE :searchText              \n                   GROUP BY StatementEntity.statementUid \n                   ORDER BY resultScoreScaled DESC, extensionProgress DESC, resultSuccess DESC) AS ResultSource \n         GROUP BY ResultSource.personUid \n         ORDER BY CASE(:sortOrder) \n                WHEN 1 THEN ResultSource.firstNames\n                WHEN 3 THEN ResultSource.lastName\n                ELSE \'\'\n            END ASC,\n            CASE(:sortOrder)\n                WHEN 2 THEN ResultSource.firstNames\n                WHEN 4 THEN ResultSource.lastName\n                ELSE \'\'\n            END DESC,\n            CASE(:sortOrder)\n                WHEN 5 THEN endDate \n                ELSE 0\n            END ASC,\n            CASE(:sortOrder)\n                WHEN 6 then endDate\n                ELSE 0\n            END DESC\n         ")
    public abstract com.ustadmobile.door.DoorDataSourceFactory<java.lang.Integer, com.ustadmobile.lib.db.entities.PersonWithAttemptsSummary> findPersonsWithContentEntryAttempts(long contentEntryUid, long accountPersonUid, @org.jetbrains.annotations.NotNull()
    java.lang.String searchText, int sortOrder);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n        SELECT \n                COALESCE(StatementEntity.resultScoreMax,0) AS resultMax, \n                COALESCE(StatementEntity.resultScoreRaw,0) AS resultScore, \n                COALESCE(StatementEntity.resultScoreScaled,0) AS resultScaled, \n                COALESCE(StatementEntity.extensionProgress,0) AS progress, \n                COALESCE(StatementEntity.resultCompletion,\'FALSE\') AS contentComplete,\n                COALESCE(StatementEntity.resultSuccess, 0) AS success,\n                0 as resultWeight,\n                \n                COALESCE((CASE WHEN resultCompletion \n                THEN 1 ELSE 0 END),0) AS totalCompletedContent,\n                \n                1 as totalContent, \n                0 as penalty\n                \n        FROM ContentEntry\n            LEFT JOIN StatementEntity\n\t\t\t\t\t\t\tON StatementEntity.statementUid = \n                                (SELECT statementUid \n\t\t\t\t\t\t\t       FROM StatementEntity \n                                  WHERE statementContentEntryUid = ContentEntry.contentEntryUid \n\t\t\t\t\t\t\t        AND StatementEntity.statementPersonUid = :accountPersonUid\n\t\t\t\t\t\t\t        AND contentEntryRoot \n                               ORDER BY resultScoreScaled DESC, extensionProgress DESC, resultSuccess DESC LIMIT 1)\n                               \n       WHERE contentEntryUid = :contentEntryUid\n    ")
    public abstract java.lang.Object getBestScoreForContentForPerson(long contentEntryUid, long accountPersonUid, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super com.ustadmobile.lib.db.entities.ContentEntryStatementScoreProgress> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n         SELECT COALESCE((\n                SELECT DISTINCT(statementpersonUid)\n                  FROM ClazzAssignment \n                      JOIN ClazzEnrolment\n                       ON ClazzEnrolment.clazzEnrolmentClazzUid = ClazzAssignment.caClazzUid\n                       \n                       JOIN CourseBlock\n                       ON CourseBlock.cbEntityUid = ClazzAssignment.caUid\n                       AND CourseBlock.cbType = 103\n                       \n          \t           JOIN StatementEntity AS SubmissionStatement\n          \t           ON SubmissionStatement.statementUid = (SELECT statementUid \n                                   FROM StatementEntity\n                                  WHERE StatementEntity.statementContentEntryUid = 0\n                                    AND xObjectUid = ClazzAssignment.caXObjectUid\n                                    AND StatementEntity.statementPersonUid = ClazzEnrolment.clazzEnrolmentPersonUid\n                                    AND StatementEntity.timestamp \n                                        BETWEEN CourseBlock.cbHideUntilDate\n                                        AND CourseBlock.cbGracePeriodDate\n                               ORDER BY timestamp DESC LIMIT 1)\n                               \n          \t           LEFT JOIN XObjectEntity\n                       ON XObjectEntity.objectStatementRefUid = SubmissionStatement.statementUid  \n               \n                 WHERE ClazzAssignment.caUid = :assignmentUid\n                   AND XObjectEntity.xobjectUid IS NULL\n                   AND ClazzEnrolment.clazzEnrolmentActive\n                   AND ClazzEnrolment.clazzEnrolmentRole = 1000\n                   AND ClazzEnrolment.clazzEnrolmentPersonUid != :currentStudentUid\n            LIMIT 1),0)\n    ")
    public abstract java.lang.Object findNextStudentNotMarkedForAssignment(long assignmentUid, long currentStudentUid, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super java.lang.Long> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n        SELECT * \n          FROM StatementEntity\n         WHERE statementPersonUid = :studentUid\n           AND statementVerbUid = 10008\n           AND xObjectUid = :assignmentObjectUid    \n      ORDER BY timestamp                \n    ")
    public abstract java.lang.Object findSubmittedStatementFromStudent(long studentUid, long assignmentObjectUid, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super com.ustadmobile.lib.db.entities.StatementEntity> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n        SELECT * \n          FROM StatementEntity\n         WHERE statementPersonUid = :studentUid\n           AND statementVerbUid = 10009\n      ORDER BY timestamp                \n    ")
    public abstract com.ustadmobile.lib.db.entities.StatementEntity findScoreStatementForStudent(long studentUid);
    
    @org.jetbrains.annotations.NotNull()
    @com.ustadmobile.door.annotation.SqliteOnly()
    @androidx.room.Query(value = "\n        SELECT MIN(timestamp) AS startDate, \n            MAX(CASE \n                    WHEN StatementEntity.resultSuccess > 0 \n                    AND StatementEntity.contentEntryRoot \n                    THEN StatementEntity.resultSuccess \n                    ELSE 0 END) AS resultSuccess, \n            SUM(CASE \n                     WHEN CAST(resultCompletion AS INTEGER) > 0 \n                     AND StatementEntity.contentEntryRoot \n                     THEN 1 \n                     ELSE 0 END) AS resultComplete, \n            SUM(resultDuration) AS duration, contextRegistration, \n            MAX(CASE WHEN contentEntryRoot \n                     THEN resultScoreRaw ELSE 0 END) AS resultScore, \n            MAX(CASE WHEN contentEntryRoot \n                     THEN resultScoreMax ELSE 0 END) AS resultMax,\n            MAX(CASE WHEN contentEntryRoot \n                     THEN resultScoreScaled ELSE 0 END) AS resultScoreScaled,\n                       \n            SUM(CASE WHEN resultCompletion AND StatementEntity.contentEntryRoot \n                THEN 1 ELSE 0 END) AS totalCompletedContent,\n                \n             1 as totalContent          \n                       \n        FROM StatementEntity \n             JOIN ScopedGrant \n                 ON \n            ((ScopedGrant.sgTableId = -2\n                AND ScopedGrant.sgEntityUid = -2)\n             OR (ScopedGrant.sgTableId = 9\n                AND ScopedGrant.sgEntityUid = StatementEntity.statementPersonUid)\n             OR (ScopedGrant.sgTableId = 6\n                AND ScopedGrant.sgEntityUid = StatementEntity.statementClazzUid)\n             OR (ScopedGrant.sgTableId = 164\n                AND ScopedGrant.sgEntityUid = (\n                    SELECT clazzSchoolUid\n                      FROM Clazz\n                     WHERE clazzUid = StatementEntity.statementClazzUid))\n             )\n        \n                 AND (ScopedGrant.sgPermissions & 549755813888) > 0\n             JOIN PersonGroupMember \n                 ON ScopedGrant.sgGroupUid = PersonGroupMember.groupMemberGroupUid  \n                AND PersonGroupMember.groupMemberPersonUid = :accountPersonUid\n        WHERE statementContentEntryUid = :contentEntryUid   \n          AND statementPersonUid = :personUid \n        GROUP BY StatementEntity.contextRegistration \n        ORDER BY startDate DESC, resultScoreScaled DESC, extensionProgress DESC, resultSuccess DESC\n         ")
    public abstract com.ustadmobile.door.DoorDataSourceFactory<java.lang.Integer, com.ustadmobile.lib.db.entities.PersonWithSessionsDisplay> findSessionsForPerson(long contentEntryUid, long accountPersonUid, long personUid);
    
    @org.jetbrains.annotations.NotNull()
    @androidx.room.Query(value = "\n        SELECT StatementEntity.*, VerbEntity.*, \n            verbLangMap.valueLangMap AS verbDisplay, \n            xobjectMap.valueLangMap AS objectDisplay \n        FROM StatementEntity\n                 JOIN ScopedGrant \n                    ON \n            ((ScopedGrant.sgTableId = -2\n                AND ScopedGrant.sgEntityUid = -2)\n             OR (ScopedGrant.sgTableId = 9\n                AND ScopedGrant.sgEntityUid = StatementEntity.statementPersonUid)\n             OR (ScopedGrant.sgTableId = 6\n                AND ScopedGrant.sgEntityUid = StatementEntity.statementClazzUid)\n             OR (ScopedGrant.sgTableId = 164\n                AND ScopedGrant.sgEntityUid = (\n                    SELECT clazzSchoolUid\n                      FROM Clazz\n                     WHERE clazzUid = StatementEntity.statementClazzUid))\n             )\n        \n                    AND (ScopedGrant.sgPermissions & 549755813888) > 0\n                 JOIN PersonGroupMember \n                    ON ScopedGrant.sgGroupUid = PersonGroupMember.groupMemberGroupUid  \n                AND PersonGroupMember.groupMemberPersonUid = :accountPersonUid\n                LEFT JOIN VerbEntity \n                    ON VerbEntity.verbUid = StatementEntity.statementVerbUid \n                LEFT JOIN XLangMapEntry verbLangMap \n                    ON verbLangMap.verbLangMapUid = VerbEntity.verbUid\n                LEFT JOIN XLangMapEntry xobjectMap \n                    ON xobjectMap.objectLangMapUid = StatementEntity.xObjectUid\n         WHERE statementContentEntryUid = :contentEntryUid \n            AND statementPersonUid = :personUid \n            AND contextRegistration = :contextRegistration \n         ORDER BY StatementEntity.timestamp DESC\n         ")
    public abstract com.ustadmobile.door.DoorDataSourceFactory<java.lang.Integer, com.ustadmobile.lib.db.entities.StatementWithSessionDetailDisplay> findSessionDetailForPerson(long contentEntryUid, long accountPersonUid, long personUid, @org.jetbrains.annotations.NotNull()
    java.lang.String contextRegistration);
    
    @org.jetbrains.annotations.Nullable()
    @com.ustadmobile.door.annotation.SqliteOnly()
    @androidx.room.Query(value = "\n        SELECT SUM(resultScoreRaw) AS resultScore, \n               SUM(resultScoreMax) AS resultMax,\n               MAX(extensionProgress) AS progress,\n               0 as resultWeight,\n               0 as penalty,\n               0 as success,\n               \'FALSE\' as contentComplete,\n               0 AS resultScaled, \n               COALESCE((CASE WHEN resultCompletion \n               THEN 1 ELSE 0 END),0) AS totalCompletedContent,\n                \n                1 as totalContent\n               \n         FROM (SELECT * \n                 FROM StatementEntity \n                WHERE contextRegistration = :contextRegistration\n                  AND NOT contentEntryRoot\n                  AND statementVerbUid = 10007 \n             GROUP BY xObjectUid) AS SessionStatements\n    ")
    public abstract java.lang.Object calculateScoreForSession(@org.jetbrains.annotations.NotNull()
    java.lang.String contextRegistration, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super com.ustadmobile.lib.db.entities.ContentEntryStatementScoreProgress> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n        SELECT resultScoreRaw AS resultScore, \n               resultScoreMax AS resultMax,\n               extensionProgress AS progress,\n               0 AS penalty,\n               0 as resultWeight,\n               resultSuccess AS success,\n               resultCompletion AS contentComplete, \n               resultScoreScaled AS resultScaled,\n                1 AS totalCompletedContent,\n                1 as totalContent\n               \n          FROM StatementEntity\n         WHERE resultCompletion\n          AND contextRegistration = :contextRegistration\n          AND contentEntryRoot\n     ORDER BY resultScoreScaled DESC, \n              extensionProgress DESC, \n              resultSuccess DESC \n              LIMIT 1\n    ")
    public abstract java.lang.Object findCompletedScoreForSession(@org.jetbrains.annotations.NotNull()
    java.lang.String contextRegistration, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super com.ustadmobile.lib.db.entities.ContentEntryStatementScoreProgress> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n        SELECT contextRegistration \n          FROM StatementEntity\n         WHERE statementPersonUid = :accountPersonUid\n           AND statementContentEntryUid = :entryUid\n           AND NOT EXISTS (SELECT statementUid FROM StatementEntity\n                            WHERE statementPersonUid = :accountPersonUid\n                             AND statementContentEntryUid = :entryUid\n                             AND (statementVerbUid = 10001 \n                                    OR statementVerbUid = 10004))\n      ORDER BY timestamp DESC \n    ")
    public abstract java.lang.Object findLatestRegistrationStatement(long accountPersonUid, long entryUid, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super java.lang.String> continuation);
    
    @kotlin.Metadata(mv = {1, 6, 0}, k = 1, d1 = {"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0087\b\u0018\u0000 (2\u00020\u0001:\u0002\'(B5\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bB\'\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\fJ\t\u0010\u0017\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010\u0018\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J\u000b\u0010\u0019\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J+\u0010\u001a\u001a\u00020\u00002\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0007H\u00c6\u0001J\u0013\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001e\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u001f\u001a\u00020\u0007H\u00d6\u0001J!\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u00002\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u00c7\u0001R\u001c\u0010\b\u001a\u0004\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u000e\"\u0004\b\u0012\u0010\u0010R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016\u00a8\u0006)"}, d2 = {"Lcom/ustadmobile/core/db/dao/StatementDao$ReportData;", "", "seen1", "", "yAxis", "", "xAxis", "", "subgroup", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(IFLjava/lang/String;Ljava/lang/String;Lkotlinx/serialization/internal/SerializationConstructorMarker;)V", "(FLjava/lang/String;Ljava/lang/String;)V", "getSubgroup", "()Ljava/lang/String;", "setSubgroup", "(Ljava/lang/String;)V", "getXAxis", "setXAxis", "getYAxis", "()F", "setYAxis", "(F)V", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "$serializer", "Companion", "lib-database"})
    @kotlinx.serialization.Serializable()
    public static final class ReportData {
        @org.jetbrains.annotations.NotNull()
        public static final com.ustadmobile.core.db.dao.StatementDao.ReportData.Companion Companion = null;
        private float yAxis;
        @org.jetbrains.annotations.Nullable()
        private java.lang.String xAxis;
        @org.jetbrains.annotations.Nullable()
        private java.lang.String subgroup;
        
        @org.jetbrains.annotations.NotNull()
        public final com.ustadmobile.core.db.dao.StatementDao.ReportData copy(float yAxis, @org.jetbrains.annotations.Nullable()
        java.lang.String xAxis, @org.jetbrains.annotations.Nullable()
        java.lang.String subgroup) {
            return null;
        }
        
        @java.lang.Override()
        public boolean equals(@org.jetbrains.annotations.Nullable()
        java.lang.Object other) {
            return false;
        }
        
        @java.lang.Override()
        public int hashCode() {
            return 0;
        }
        
        @org.jetbrains.annotations.NotNull()
        @java.lang.Override()
        public java.lang.String toString() {
            return null;
        }
        
        @kotlin.jvm.JvmStatic()
        public static final void write$Self(@org.jetbrains.annotations.NotNull()
        com.ustadmobile.core.db.dao.StatementDao.ReportData self, @org.jetbrains.annotations.NotNull()
        kotlinx.serialization.encoding.CompositeEncoder output, @org.jetbrains.annotations.NotNull()
        kotlinx.serialization.descriptors.SerialDescriptor serialDesc) {
        }
        
        public ReportData() {
            super();
        }
        
        public ReportData(float yAxis, @org.jetbrains.annotations.Nullable()
        java.lang.String xAxis, @org.jetbrains.annotations.Nullable()
        java.lang.String subgroup) {
            super();
        }
        
        public final float component1() {
            return 0.0F;
        }
        
        public final float getYAxis() {
            return 0.0F;
        }
        
        public final void setYAxis(float p0) {
        }
        
        @org.jetbrains.annotations.Nullable()
        public final java.lang.String component2() {
            return null;
        }
        
        @org.jetbrains.annotations.Nullable()
        public final java.lang.String getXAxis() {
            return null;
        }
        
        public final void setXAxis(@org.jetbrains.annotations.Nullable()
        java.lang.String p0) {
        }
        
        @org.jetbrains.annotations.Nullable()
        public final java.lang.String component3() {
            return null;
        }
        
        @org.jetbrains.annotations.Nullable()
        public final java.lang.String getSubgroup() {
            return null;
        }
        
        public final void setSubgroup(@org.jetbrains.annotations.Nullable()
        java.lang.String p0) {
        }
        
        @kotlin.Metadata(mv = {1, 6, 0}, k = 1, d1 = {"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u00c6\u0001\u00a8\u0006\u0006"}, d2 = {"Lcom/ustadmobile/core/db/dao/StatementDao$ReportData$Companion;", "", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lcom/ustadmobile/core/db/dao/StatementDao$ReportData;", "lib-database"})
        public static final class Companion {
            
            private Companion() {
                super();
            }
            
            @org.jetbrains.annotations.NotNull()
            public final kotlinx.serialization.KSerializer<com.ustadmobile.core.db.dao.StatementDao.ReportData> serializer() {
                return null;
            }
        }
        
        @kotlin.Metadata(mv = {1, 6, 0}, k = 1, d1 = {"\u00006\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n0\tH\u00d6\u0001\u00a2\u0006\u0002\u0010\u000bJ\u0011\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\u0019\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0002H\u00d6\u0001R\u0014\u0010\u0004\u001a\u00020\u00058VX\u00d6\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0014"}, d2 = {"com/ustadmobile/core/db/dao/StatementDao.ReportData.$serializer", "Lkotlinx/serialization/internal/GeneratedSerializer;", "Lcom/ustadmobile/core/db/dao/StatementDao$ReportData;", "()V", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "getDescriptor", "()Lkotlinx/serialization/descriptors/SerialDescriptor;", "childSerializers", "", "Lkotlinx/serialization/KSerializer;", "()[Lkotlinx/serialization/KSerializer;", "deserialize", "decoder", "Lkotlinx/serialization/encoding/Decoder;", "serialize", "", "encoder", "Lkotlinx/serialization/encoding/Encoder;", "value", "lib-database"})
        @java.lang.Deprecated()
        public static final class $serializer implements kotlinx.serialization.internal.GeneratedSerializer<com.ustadmobile.core.db.dao.StatementDao.ReportData> {
            @org.jetbrains.annotations.NotNull()
            public static final com.ustadmobile.core.db.dao.StatementDao.ReportData.$serializer INSTANCE = null;
            
            private $serializer() {
                super();
            }
            
            @org.jetbrains.annotations.NotNull()
            @java.lang.Override()
            public kotlinx.serialization.KSerializer<?>[] childSerializers() {
                return null;
            }
            
            @org.jetbrains.annotations.NotNull()
            @java.lang.Override()
            public com.ustadmobile.core.db.dao.StatementDao.ReportData deserialize(@org.jetbrains.annotations.NotNull()
            kotlinx.serialization.encoding.Decoder decoder) {
                return null;
            }
            
            @org.jetbrains.annotations.NotNull()
            @java.lang.Override()
            public kotlinx.serialization.descriptors.SerialDescriptor getDescriptor() {
                return null;
            }
            
            @java.lang.Override()
            public void serialize(@org.jetbrains.annotations.NotNull()
            kotlinx.serialization.encoding.Encoder encoder, @org.jetbrains.annotations.NotNull()
            com.ustadmobile.core.db.dao.StatementDao.ReportData value) {
            }
            
            @org.jetbrains.annotations.NotNull()
            public kotlinx.serialization.KSerializer<?>[] typeParametersSerializers() {
                return null;
            }
        }
    }
    
    @kotlin.Metadata(mv = {1, 6, 0}, k = 1, d1 = {"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2 = {"Lcom/ustadmobile/core/db/dao/StatementDao$Companion;", "", "()V", "SORT_FIRST_NAME_ASC", "", "SORT_FIRST_NAME_DESC", "SORT_LAST_ACTIVE_ASC", "SORT_LAST_ACTIVE_DESC", "SORT_LAST_NAME_ASC", "SORT_LAST_NAME_DESC", "lib-database"})
    public static final class Companion {
        
        private Companion() {
            super();
        }
    }
}