package com.ustadmobile.core.db.dao;

import java.lang.System;

@com.ustadmobile.door.annotation.Repository()
@androidx.room.Dao()
@kotlin.Metadata(mv = {1, 6, 0}, k = 1, d1 = {"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0010 \n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\'\u0018\u0000 +2\u00020\u0001:\u0001+B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0019\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0007J9\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u0006H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000fJ)\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u0004H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0012J%\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00060\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00060\u0014H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0016J%\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00060\u00142\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00060\u0014H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0016J%\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00060\u00142\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00060\u0014H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0016J%\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00060\u00142\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00060\u0014H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0016J\u0017\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u0014H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001fJ\u0014\u0010 \u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001e0\u00140!H\'J\u0018\u0010\"\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010#0!2\u0006\u0010\u0011\u001a\u00020\u0006H\'J\u001f\u0010$\u001a\b\u0012\u0004\u0012\u00020#0\u00142\u0006\u0010\n\u001a\u00020\u0006H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0007J\u0019\u0010%\u001a\u00020\u00062\u0006\u0010&\u001a\u00020#H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\'J\u0011\u0010(\u001a\u00020\tH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001fJ\u001b\u0010)\u001a\u00020\t2\b\b\u0001\u0010*\u001a\u00020\u0006H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0007\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006,"}, d2 = {"Lcom/ustadmobile/core/db/dao/UserSessionDao;", "", "()V", "countAllLocalSessionsAsync", "", "maxDateOfBirth", "", "(JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "endOtherSessions", "", "personUid", "exemptNodeId", "newStatus", "reason", "changeTime", "(JJIIJLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "endSession", "sessionUid", "(JIILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findActiveNodeIdsByPersonUids", "", "personUids", "(Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findActiveNodesIdsByGroupUids", "groupUids", "findAllActiveNodeIdsWithClazzBasedPermission", "clazzUids", "findAllActiveNodeIdsWithSchoolBasedPermission", "schoolUids", "findAllLocalSessionsAsync", "Lcom/ustadmobile/lib/db/entities/UserSessionAndPerson;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findAllLocalSessionsLive", "Lcom/ustadmobile/door/DoorLiveData;", "findByUidLive", "Lcom/ustadmobile/lib/db/entities/UserSession;", "findSessionsByPerson", "insertSession", "session", "(Lcom/ustadmobile/lib/db/entities/UserSession;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "updateReplicationTrackers", "updateReplicationTrackersOnNewNode", "newNodeId", "Companion", "lib-database"})
public abstract class UserSessionDao {
    @org.jetbrains.annotations.NotNull()
    public static final com.ustadmobile.core.db.dao.UserSessionDao.Companion Companion = null;
    @org.jetbrains.annotations.NotNull()
    public static final java.lang.String FIND_LOCAL_SESSIONS_SQL = "\n            SELECT UserSession.*, Person.*\n              FROM UserSession\n                   JOIN Person ON UserSession.usPersonUid = Person.personUid\n             WHERE UserSession.usClientNodeId = (\n                   SELECT COALESCE(\n                          (SELECT nodeClientId \n                            FROM SyncNode\n                           LIMIT 1), 0))\n               AND UserSession.usStatus = 1        \n            ";
    
    public UserSessionDao() {
        super();
    }
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n        REPLACE INTO UserSessionReplicate(usPk, usDestination)\n         SELECT DISTINCT UserSessionSubject.usUid AS usPk,\n                UserSession.usClientNodeId AS usDestination\n           FROM ChangeLog\n                JOIN UserSession UserSessionSubject\n                     ON ChangeLog.chTableId = 679\n                        AND ChangeLog.chEntityPk = UserSessionSubject.usUid\n                        AND UserSessionSubject.usSessionType = 1\n                JOIN Person\n                     ON UserSessionSubject.usPersonUid = Person.personUid\n                \n            JOIN ScopedGrant \n                   ON \n            ((ScopedGrant.sgTableId = -2\n                    AND ScopedGrant.sgEntityUid = -2)\n                 OR (ScopedGrant.sgTableId = 9\n                    AND ScopedGrant.sgEntityUid = Person.personUid)\n                 OR (ScopedGrant.sgTableId = 6       \n                    AND ScopedGrant.sgEntityUid IN (\n                        SELECT DISTINCT clazzEnrolmentClazzUid\n                          FROM ClazzEnrolment\n                         WHERE clazzEnrolmentPersonUid = Person.personUid \n                           AND ClazzEnrolment.clazzEnrolmentActive))\n                 OR (ScopedGrant.sgTableId = 164\n                    AND ScopedGrant.sgEntityUid IN (\n                        SELECT DISTINCT schoolMemberSchoolUid\n                          FROM SchoolMember\n                         WHERE schoolMemberPersonUid = Person.personUid\n                           AND schoolMemberActive))\n                           )\n        \n                   AND (ScopedGrant.sgPermissions & \n        \n                    64\n                    /* Modify second part of query - remove requirement for session to be active.\n                     * This ensures that deactivations are distributed\n                     */\n                    ) > 0\n                     JOIN PersonGroupMember AS PrsGrpMbr\n                          ON ScopedGrant.sgGroupUid = PrsGrpMbr.groupMemberGroupUid\n                     JOIN UserSession\n                          ON UserSession.usPersonUid = PrsGrpMbr.groupMemberPersonUid\n          WHERE UserSessionSubject.usClientNodeId = UserSessionSubject.usClientNodeId                \n          --notpsql              \n            AND UserSessionSubject.usLct != COALESCE(\n                (SELECT usVersionId\n                   FROM UserSessionReplicate\n                  WHERE UserSessionReplicate.usPk = UserSessionSubject.usUid\n                    AND UserSessionReplicate.usDestination = UserSession.usClientNodeId), 0)\n          --endnotpsql                       \n        /*psql ON CONFLICT(usPk, usDestination) \n                DO UPDATE SET usPending = \n                   (SELECT UserSession.usLct\n                      FROM UserSession\n                     WHERE UserSession.usUid = EXCLUDED.usPk ) \n                        != UserSessionReplicate.usVersionId\n         */         \n    ")
    @com.ustadmobile.door.annotation.ReplicationCheckPendingNotificationsFor(value = {com.ustadmobile.lib.db.entities.UserSession.class})
    @com.ustadmobile.door.annotation.ReplicationRunOnChange(value = {com.ustadmobile.lib.db.entities.UserSession.class})
    public abstract java.lang.Object updateReplicationTrackers(@org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @com.ustadmobile.door.annotation.ReplicationRunOnNewNode()
    @androidx.room.Query(value = "\n        REPLACE INTO UserSessionReplicate(usPk, usDestination)\n         SELECT DISTINCT UserSessionSubject.usUid AS usPk,\n                UserSession.usClientNodeId AS usDestination\n           FROM UserSession \n                JOIN PersonGroupMember\n                    ON UserSession.usPersonUid = PersonGroupMember.groupMemberPersonUid\n                \n            JOIN ScopedGrant\n                 ON ScopedGrant.sgGroupUid = PersonGroupMember.groupMemberGroupUid\n                    AND (ScopedGrant.sgPermissions &\n                    64\n                    \n                                                    ) > 0\n            JOIN Person \n                 ON \n                ((ScopedGrant.sgTableId = -2\n                    AND ScopedGrant.sgEntityUid = -2)\n                 OR (ScopedGrant.sgTableId = 9\n                    AND ScopedGrant.sgEntityUid = Person.personUid)\n                 OR (ScopedGrant.sgTableId = 6       \n                    AND Person.personUid IN (\n                        SELECT DISTINCT clazzEnrolmentPersonUid\n                          FROM ClazzEnrolment\n                         WHERE clazzEnrolmentClazzUid =ScopedGrant.sgEntityUid \n                           AND ClazzEnrolment.clazzEnrolmentActive))\n                 OR (ScopedGrant.sgTableId = 164\n                    AND Person.personUid IN (\n                        SELECT DISTINCT schoolMemberPersonUid\n                          FROM SchoolMember\n                         WHERE schoolMemberSchoolUid = ScopedGrant.sgEntityUid\n                           AND schoolMemberActive))\n                           )    \n        \n        \n                JOIN UserSession UserSessionSubject\n                     ON UserSessionSubject.usPersonUid = Person.personUid\n                        AND UserSessionSubject.usSessionType = 1\n                        AND UserSessionSubject.usClientNodeId = :newNodeId\n          WHERE UserSession.usClientNodeId = :newNodeId\n          --notpsql\n            AND UserSessionSubject.usLct != COALESCE(\n                (SELECT usVersionId\n                   FROM UserSessionReplicate\n                  WHERE UserSessionReplicate.usPk = UserSessionSubject.usUid\n                    AND UserSessionReplicate.usDestination = UserSession.usClientNodeId), 0)\n          --endnotpsql          \n         /*psql ON CONFLICT(usPk, usDestination) \n                DO UPDATE SET usPending = \n                   (SELECT UserSession.usLct\n                      FROM UserSession\n                     WHERE UserSession.usUid = EXCLUDED.usPk ) \n                        != UserSessionReplicate.usVersionId\n         */\n    ")
    @com.ustadmobile.door.annotation.ReplicationCheckPendingNotificationsFor(value = {com.ustadmobile.lib.db.entities.UserSession.class})
    public abstract java.lang.Object updateReplicationTrackersOnNewNode(@com.ustadmobile.door.annotation.NewNodeIdParam()
    long newNodeId, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Insert()
    public abstract java.lang.Object insertSession(@org.jetbrains.annotations.NotNull()
    com.ustadmobile.lib.db.entities.UserSession session, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super java.lang.Long> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n        SELECT UserSession.*\n          FROM UserSession\n         WHERE usPersonUid = :personUid \n    ")
    public abstract java.lang.Object findSessionsByPerson(long personUid, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super java.util.List<com.ustadmobile.lib.db.entities.UserSession>> continuation);
    
    @org.jetbrains.annotations.NotNull()
    @androidx.room.Query(value = "\n            SELECT UserSession.*, Person.*\n              FROM UserSession\n                   JOIN Person ON UserSession.usPersonUid = Person.personUid\n             WHERE UserSession.usClientNodeId = (\n                   SELECT COALESCE(\n                          (SELECT nodeClientId \n                            FROM SyncNode\n                           LIMIT 1), 0))\n               AND UserSession.usStatus = 1        \n            ")
    public abstract com.ustadmobile.door.DoorLiveData<java.util.List<com.ustadmobile.lib.db.entities.UserSessionAndPerson>> findAllLocalSessionsLive();
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n            SELECT UserSession.*, Person.*\n              FROM UserSession\n                   JOIN Person ON UserSession.usPersonUid = Person.personUid\n             WHERE UserSession.usClientNodeId = (\n                   SELECT COALESCE(\n                          (SELECT nodeClientId \n                            FROM SyncNode\n                           LIMIT 1), 0))\n               AND UserSession.usStatus = 1        \n            ")
    public abstract java.lang.Object findAllLocalSessionsAsync(@org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super java.util.List<com.ustadmobile.lib.db.entities.UserSessionAndPerson>> continuation);
    
    /**
     * Count sessions on this device. If maxDateOfBirth is non-zero, then this can be used to
     * provide a cut-off (e.g. to find only sessions for adults where their date of birth must be
     * before a cut-off)
     */
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n        SELECT COUNT(*)\n          FROM UserSession\n               JOIN Person \n                    ON UserSession.usPersonUid = Person.personUid\n         WHERE UserSession.usClientNodeId = (\n                   SELECT COALESCE(\n                          (SELECT nodeClientId \n                            FROM SyncNode\n                           LIMIT 1), 0))\n           AND UserSession.usStatus = 1                \n           AND (:maxDateOfBirth = 0 OR Person.dateOfBirth < :maxDateOfBirth)                 \n    ")
    public abstract java.lang.Object countAllLocalSessionsAsync(long maxDateOfBirth, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super java.lang.Integer> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n        UPDATE UserSession\n           SET usAuth = null,\n               usStatus = :newStatus,\n               usReason = :reason,\n               usLcb = COALESCE(\n                               (SELECT nodeClientId\n                                  FROM SyncNode\n                                 LIMIT 1), 0)\n         WHERE UserSession.usUid = :sessionUid                        \n               \n    ")
    public abstract java.lang.Object endSession(long sessionUid, int newStatus, int reason, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @org.jetbrains.annotations.NotNull()
    @androidx.room.Query(value = "\n        SELECT UserSession.*\n          FROM UserSession\n         WHERE UserSession.usUid = :sessionUid\n         LIMIT 1\n    ")
    public abstract com.ustadmobile.door.DoorLiveData<com.ustadmobile.lib.db.entities.UserSession> findByUidLive(long sessionUid);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n        UPDATE UserSession\n           SET usAuth = null,\n               usStatus = :newStatus,\n               usReason = :reason,\n               usLct = :changeTime\n         WHERE usPersonUid = :personUid\n           AND usClientNodeId != :exemptNodeId\n           AND usStatus != :newStatus                     \n    ")
    public abstract java.lang.Object endOtherSessions(long personUid, long exemptNodeId, int newStatus, int reason, long changeTime, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n        SELECT DISTINCT UserSession.usClientNodeId\n          FROM UserSession\n         WHERE UserSession.usPersonUid IN (:personUids)\n           AND UserSession.usStatus = 1\n    ")
    public abstract java.lang.Object findActiveNodeIdsByPersonUids(@org.jetbrains.annotations.NotNull()
    java.util.List<java.lang.Long> personUids, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super java.util.List<java.lang.Long>> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n        SELECT DISTINCT UserSession.usClientNodeId\n          FROM UserSession\n               JOIN PersonGroupMember \n                    ON PersonGroupMember.groupMemberPersonUid = UserSession.usPersonUid\n         WHERE PersonGroupMember.groupMemberGroupUid IN (:groupUids)            \n    ")
    public abstract java.lang.Object findActiveNodesIdsByGroupUids(@org.jetbrains.annotations.NotNull()
    java.util.List<java.lang.Long> groupUids, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super java.util.List<java.lang.Long>> continuation);
    
    /**
     * This query will find the nodeids for all users where the device has permissions that are
     * influenced by a given class.
     */
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n        SELECT UserSession.usClientNodeId\n          FROM ScopedGrant\n               JOIN PersonGroupMember \n                    ON PersonGroupMember.groupMemberGroupUid = ScopedGrant.sgGroupUid\n               JOIN UserSession\n                    ON UserSession.usPersonUid = PersonGroupMember.groupMemberPersonUid\n         WHERE (ScopedGrant.sgTableId = 6 AND ScopedGrant.sgEntityUid IN (:clazzUids))\n            OR (ScopedGrant.sgTableId = 164 AND ScopedGrant.sgEntityUid IN \n                (SELECT clazzSchoolUid\n                   FROM Clazz\n                  WHERE clazzUid IN (:clazzUids)))\n          \n    ")
    public abstract java.lang.Object findAllActiveNodeIdsWithClazzBasedPermission(@org.jetbrains.annotations.NotNull()
    java.util.List<java.lang.Long> clazzUids, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super java.util.List<java.lang.Long>> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n        SELECT UserSession.usClientNodeId\n          FROM ScopedGrant\n               JOIN PersonGroupMember \n                    ON PersonGroupMember.groupMemberGroupUid = ScopedGrant.sgGroupUid\n               JOIN UserSession\n                    ON UserSession.usPersonUid = PersonGroupMember.groupMemberPersonUid\n         WHERE ScopedGrant.sgTableId = 164 \n           AND ScopedGrant.sgEntityUid IN (:schoolUids) \n    ")
    public abstract java.lang.Object findAllActiveNodeIdsWithSchoolBasedPermission(@org.jetbrains.annotations.NotNull()
    java.util.List<java.lang.Long> schoolUids, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super java.util.List<java.lang.Long>> continuation);
    
    @kotlin.Metadata(mv = {1, 6, 0}, k = 1, d1 = {"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2 = {"Lcom/ustadmobile/core/db/dao/UserSessionDao$Companion;", "", "()V", "FIND_LOCAL_SESSIONS_SQL", "", "lib-database"})
    public static final class Companion {
        
        private Companion() {
            super();
        }
    }
}