package com.ustadmobile.core.db.dao;

import java.lang.System;

@com.ustadmobile.door.annotation.Repository()
@androidx.room.Dao()
@kotlin.Metadata(mv = {1, 6, 0}, k = 1, d1 = {"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\b\'\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\"\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00052\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\'J\u001c\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00070\t2\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\'J\"\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00052\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\'J%\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\t2\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000eJ\u0014\u0010\u000f\u001a\u0004\u0018\u00010\u00022\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\'J\u0011\u0010\u0012\u001a\u00020\u0013H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0014J\u001f\u0010\u0015\u001a\u00020\u00132\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00020\tH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000eJ\u0011\u0010\u0017\u001a\u00020\u0013H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0014J\u001b\u0010\u0018\u001a\u00020\u00132\b\b\u0001\u0010\u0019\u001a\u00020\nH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001a\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u001b"}, d2 = {"Lcom/ustadmobile/core/db/dao/VerbDao;", "Lcom/ustadmobile/core/db/dao/BaseDao;", "Lcom/ustadmobile/lib/db/entities/VerbEntity;", "()V", "findAllVerbsAsc", "Lcom/ustadmobile/door/DoorDataSourceFactory;", "", "Lcom/ustadmobile/lib/db/entities/VerbDisplay;", "uidList", "", "", "findAllVerbsAscList", "findAllVerbsDesc", "findByUidList", "(Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findByUrl", "urlId", "", "initPreloadedVerbs", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "replaceList", "entityList", "replicateOnChange", "replicateOnNewNode", "newNodeId", "(JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "lib-database"})
public abstract class VerbDao implements com.ustadmobile.core.db.dao.BaseDao<com.ustadmobile.lib.db.entities.VerbEntity> {
    
    public VerbDao() {
        super();
    }
    
    @org.jetbrains.annotations.Nullable()
    @com.ustadmobile.door.annotation.ReplicationRunOnNewNode()
    @androidx.room.Query(value = "\n     REPLACE INTO VerbEntityReplicate(vePk, veDestination)\n      SELECT DISTINCT VerbEntity.verbUid AS vePk,\n             :newNodeId AS veDestination\n        FROM VerbEntity\n       WHERE VerbEntity.verbLct != COALESCE(\n             (SELECT veVersionId\n                FROM VerbEntityReplicate\n               WHERE vePk = VerbEntity.verbUid\n                 AND veDestination = :newNodeId), 0) \n      /*psql ON CONFLICT(vePk, veDestination) DO UPDATE\n             SET vePending = true\n      */       \n    ")
    @com.ustadmobile.door.annotation.ReplicationCheckPendingNotificationsFor(value = {com.ustadmobile.lib.db.entities.VerbEntity.class})
    public abstract java.lang.Object replicateOnNewNode(@com.ustadmobile.door.annotation.NewNodeIdParam()
    long newNodeId, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n    REPLACE INTO VerbEntityReplicate(vePk, veDestination)\n    SELECT DISTINCT VerbEntity.verbUid AS veUid,\n         UserSession.usClientNodeId AS veDestination\n    FROM ChangeLog\n         JOIN VerbEntity\n             ON ChangeLog.chTableId = 62\n                AND ChangeLog.chEntityPk = VerbEntity.verbUid\n         JOIN UserSession ON UserSession.usStatus = 1\n    WHERE UserSession.usClientNodeId != (\n         SELECT nodeClientId \n           FROM SyncNode\n          LIMIT 1)\n     AND VerbEntity.verbLct != COALESCE(\n         (SELECT veVersionId\n            FROM VerbEntityReplicate\n           WHERE vePk = VerbEntity.verbUid\n             AND veDestination = UserSession.usClientNodeId), 0)\n    /*psql ON CONFLICT(vePk, veDestination) DO UPDATE\n     SET vePending = true\n    */               \n    ")
    @com.ustadmobile.door.annotation.ReplicationCheckPendingNotificationsFor(value = {com.ustadmobile.lib.db.entities.VerbEntity.class})
    @com.ustadmobile.door.annotation.ReplicationRunOnChange(value = {com.ustadmobile.lib.db.entities.VerbEntity.class})
    public abstract java.lang.Object replicateOnChange(@org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "SELECT * FROM VerbEntity WHERE urlId = :urlId")
    public abstract com.ustadmobile.lib.db.entities.VerbEntity findByUrl(@org.jetbrains.annotations.Nullable()
    java.lang.String urlId);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "SELECT verbUid FROM VerbEntity WHERE verbUid IN (:uidList)")
    public abstract java.lang.Object findByUidList(@org.jetbrains.annotations.NotNull()
    java.util.List<java.lang.Long> uidList, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super java.util.List<java.lang.Long>> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Insert(onConflict = 1)
    public abstract java.lang.Object replaceList(@org.jetbrains.annotations.NotNull()
    java.util.List<com.ustadmobile.lib.db.entities.VerbEntity> entityList, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @org.jetbrains.annotations.Nullable()
    public final java.lang.Object initPreloadedVerbs(@org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation) {
        return null;
    }
    
    @org.jetbrains.annotations.NotNull()
    @androidx.room.Query(value = "SELECT VerbEntity.verbUid, VerbEntity.urlId, XLangMapEntry.valueLangMap AS display\n        FROM VerbEntity LEFT JOIN XLangMapEntry on XLangMapEntry.verbLangMapUid = VerbEntity.verbUid WHERE \n         XLangMapEntry.verbLangMapUid NOT IN (:uidList)")
    public abstract java.util.List<com.ustadmobile.lib.db.entities.VerbDisplay> findAllVerbsAscList(@org.jetbrains.annotations.NotNull()
    java.util.List<java.lang.Long> uidList);
    
    @org.jetbrains.annotations.NotNull()
    @androidx.room.Query(value = "SELECT VerbEntity.verbUid, VerbEntity.urlId, XLangMapEntry.valueLangMap AS display \n         FROM VerbEntity LEFT JOIN XLangMapEntry on XLangMapEntry.verbLangMapUid = VerbEntity.verbUid WHERE \n         VerbEntity.verbUid NOT IN (:uidList) ORDER BY display ASC")
    public abstract com.ustadmobile.door.DoorDataSourceFactory<java.lang.Integer, com.ustadmobile.lib.db.entities.VerbDisplay> findAllVerbsAsc(@org.jetbrains.annotations.NotNull()
    java.util.List<java.lang.Long> uidList);
    
    @org.jetbrains.annotations.NotNull()
    @androidx.room.Query(value = "SELECT VerbEntity.verbUid, VerbEntity.urlId, XLangMapEntry.valueLangMap AS display \n         FROM VerbEntity LEFT JOIN XLangMapEntry on XLangMapEntry.verbLangMapUid = VerbEntity.verbUid WHERE \n        VerbEntity.verbUid NOT IN (:uidList) ORDER BY display DESC")
    public abstract com.ustadmobile.door.DoorDataSourceFactory<java.lang.Integer, com.ustadmobile.lib.db.entities.VerbDisplay> findAllVerbsDesc(@org.jetbrains.annotations.NotNull()
    java.util.List<java.lang.Long> uidList);
}