package com.ustadmobile.core.db.dao;

import java.lang.System;

@com.ustadmobile.door.annotation.Repository()
@androidx.room.Dao()
@kotlin.Metadata(mv = {1, 6, 0}, k = 1, d1 = {"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\b\'\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u0004\u0018\u00010\u00022\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\'J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\u00022\u0006\u0010\b\u001a\u00020\tH\'J\u0011\u0010\n\u001a\u00020\u000bH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\fJ\u001b\u0010\r\u001a\u00020\u000b2\b\b\u0001\u0010\u000e\u001a\u00020\tH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000f\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0010"}, d2 = {"Lcom/ustadmobile/core/db/dao/XObjectDao;", "Lcom/ustadmobile/core/db/dao/BaseDao;", "Lcom/ustadmobile/lib/db/entities/XObjectEntity;", "()V", "findByObjectId", "id", "", "findByXobjectUid", "xObjectUid", "", "replicateOnChange", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "replicateOnNewNode", "newNodeId", "(JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "lib-database"})
public abstract class XObjectDao implements com.ustadmobile.core.db.dao.BaseDao<com.ustadmobile.lib.db.entities.XObjectEntity> {
    
    public XObjectDao() {
        super();
    }
    
    @org.jetbrains.annotations.Nullable()
    @com.ustadmobile.door.annotation.ReplicationRunOnNewNode()
    @androidx.room.Query(value = "\n     REPLACE INTO XObjectEntityReplicate(xoePk, xoeDestination)\n      SELECT DISTINCT XObjectEntity.xObjectUid AS xoePk,\n             :newNodeId AS xoeDestination\n        FROM XObjectEntity\n       WHERE XObjectEntity.xObjectLct != COALESCE(\n             (SELECT xoeVersionId\n                FROM XObjectEntityReplicate\n               WHERE xoePk = XObjectEntity.xObjectUid\n                 AND xoeDestination = :newNodeId), 0) \n      /*psql ON CONFLICT(xoePk, xoeDestination) DO UPDATE\n             SET xoePending = true\n      */       \n    ")
    @com.ustadmobile.door.annotation.ReplicationCheckPendingNotificationsFor(value = {com.ustadmobile.lib.db.entities.XObjectEntity.class})
    public abstract java.lang.Object replicateOnNewNode(@com.ustadmobile.door.annotation.NewNodeIdParam()
    long newNodeId, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n REPLACE INTO XObjectEntityReplicate(xoePk, xoeDestination)\n  SELECT DISTINCT XObjectEntity.xObjectUid AS xoeUid,\n         UserSession.usClientNodeId AS xoeDestination\n    FROM ChangeLog\n         JOIN XObjectEntity\n             ON ChangeLog.chTableId = 64\n                AND ChangeLog.chEntityPk = XObjectEntity.xObjectUid\n         JOIN UserSession ON UserSession.usStatus = 1\n   WHERE UserSession.usClientNodeId != (\n         SELECT nodeClientId \n           FROM SyncNode\n          LIMIT 1)\n     AND XObjectEntity.xObjectLct != COALESCE(\n         (SELECT xoeVersionId\n            FROM XObjectEntityReplicate\n           WHERE xoePk = XObjectEntity.xObjectUid\n             AND xoeDestination = UserSession.usClientNodeId), 0)\n /*psql ON CONFLICT(xoePk, xoeDestination) DO UPDATE\n     SET xoePending = true\n  */               \n    ")
    @com.ustadmobile.door.annotation.ReplicationCheckPendingNotificationsFor(value = {com.ustadmobile.lib.db.entities.XObjectEntity.class})
    @com.ustadmobile.door.annotation.ReplicationRunOnChange(value = {com.ustadmobile.lib.db.entities.XObjectEntity.class})
    public abstract java.lang.Object replicateOnChange(@org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "SELECT * from XObjectEntity WHERE objectId = :id")
    public abstract com.ustadmobile.lib.db.entities.XObjectEntity findByObjectId(@org.jetbrains.annotations.Nullable()
    java.lang.String id);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "SELECT * from XObjectEntity WHERE xObjectUid = :xObjectUid")
    public abstract com.ustadmobile.lib.db.entities.XObjectEntity findByXobjectUid(long xObjectUid);
}