/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.sharedse.network;

import com.ustadmobile.sharedse.ext.ByteArrayExtKt;
import com.ustadmobile.sharedse.io.ByteBufferSe;
import com.ustadmobile.sharedse.network.EntryStatusRequest;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u0000 +2\u00020\u0001:\u0001+B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u001f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB\u0015\b\u0016\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\n\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0007H\u0002J\u0018\u0010\u001e\u001a\u00020\r2\u0006\u0010\u001f\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\rH\u0002J\u001b\u0010 \u001a\u00020\u001c2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\nH\u0002\u00a2\u0006\u0002\u0010\u000bJ\u001b\u0010!\u001a\u00020\u00072\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00070\nH\u0002\u00a2\u0006\u0002\u0010#J\u0019\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00070\n2\u0006\u0010\u0013\u001a\u00020\r\u00a2\u0006\u0002\u0010%J\u000e\u0010&\u001a\u00020'2\u0006\u0010\u001d\u001a\u00020\u0007J\u001b\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00070\n2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a2\u0006\u0002\u0010)J\u0006\u0010*\u001a\u00020\u001cR\u001e\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\r@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001e\u0010\u0005\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001e\u0010\u0013\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\r@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0010R\u000e\u0010\u0015\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0017R\"\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\f\u001a\u0004\u0018\u00010\u0007@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0012\u00a8\u0006,"}, d2={"Lcom/ustadmobile/sharedse/network/BleMessage;", "", "()V", "requestType", "", "messageId", "payload", "", "(BB[B)V", "packetsReceived", "", "([[B)V", "<set-?>", "", "length", "getLength", "()I", "getMessageId", "()B", "mtu", "getMtu", "onPacketReceivedCount", "packetReceiveBuffer", "[[B", "getPayload", "()[B", "getRequestType", "assignHeaderValuesFromFirstPacket", "", "packet", "calculateNumPackets", "payloadLength", "constructFromPackets", "depacketizePayload", "packets", "([[B)[B", "getPackets", "(I)[[B", "onPackageReceived", "", "packetizePayload", "([B)[[B", "reset", "Companion", "sharedse_release"})
public final class BleMessage {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private byte[] payload;
    private byte requestType;
    private int mtu;
    private int length;
    private byte messageId;
    @Nullable
    private byte[][] packetReceiveBuffer;
    private int onPacketReceivedCount;
    public static final byte MESSAGE_TYPE_HTTP = 101;
    private static final int payloadLengthStartIndex = 3;
    private static final int payLoadStartIndex = 7;
    public static final int HEADER_SIZE = 7;
    @NotNull
    private static final Map<String, Byte> messageIds = new LinkedHashMap();

    @Nullable
    public final byte[] getPayload() {
        return this.payload;
    }

    public final byte getRequestType() {
        return this.requestType;
    }

    public final int getMtu() {
        return this.mtu;
    }

    public final int getLength() {
        return this.length;
    }

    public final byte getMessageId() {
        return this.messageId;
    }

    public BleMessage() {
    }

    public BleMessage(byte requestType, byte messageId, @NotNull byte[] payload) {
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        this.requestType = requestType;
        this.payload = payload;
        this.length = payload.length;
        this.messageId = messageId;
    }

    public BleMessage(@NotNull byte[][] packetsReceived) {
        Intrinsics.checkNotNullParameter((Object)packetsReceived, (String)"packetsReceived");
        this.constructFromPackets(packetsReceived);
    }

    private final void constructFromPackets(byte[][] packetsReceived) {
        this.messageId = packetsReceived[0][0];
        byte[] messageBytes = this.depacketizePayload(packetsReceived);
        this.assignHeaderValuesFromFirstPacket(packetsReceived[0]);
        byte[] receivedPayload = new byte[this.length];
        ArraysKt.copyInto((byte[])messageBytes, (byte[])receivedPayload, (int)0, (int)7, (int)(7 + this.length));
        boolean isCompressed = !(receivedPayload.length == 0) && receivedPayload[0] == 31 && receivedPayload[1] == -117;
        this.payload = receivedPayload;
        if (isCompressed) {
            this.payload = ByteArrayExtKt.decompressWithGzip(receivedPayload);
        }
    }

    private final void assignHeaderValuesFromFirstPacket(byte[] packet) {
        this.messageId = packet[0];
        this.requestType = packet[1];
        byte[] byArray = new byte[]{packet[2], packet[3]};
        this.mtu = ByteBufferSe.Companion.wrap(byArray).getShort();
        byArray = packet;
        int n = 4;
        int n2 = 8;
        this.length = ByteBufferSe.Companion.wrap(ArraysKt.copyOfRange((byte[])byArray, (int)n, (int)n2)).getInt();
    }

    @NotNull
    public final byte[][] getPackets(int mtu) {
        byte[][] byArray;
        this.mtu = mtu;
        byte[] compressedPayload = (byte[])(this.payload == null ? null : ByteArrayExtKt.compressWithGzip(this.payload));
        Intrinsics.checkNotNull((Object)compressedPayload);
        int n = compressedPayload.length;
        Intrinsics.checkNotNull((Object)this.payload);
        if (n < this.payload.length) {
            byArray = this.packetizePayload(compressedPayload);
        } else {
            Intrinsics.checkNotNull((Object)this.payload);
            byArray = this.packetizePayload(this.payload);
        }
        return byArray;
    }

    private final int calculateNumPackets(int payloadLength, int mtu) {
        return (int)Math.ceil((double)(payloadLength + 7) / (double)(mtu - 1));
    }

    private final byte[][] packetizePayload(byte[] payload) {
        if (payload.length == 0) {
            throw new IllegalArgumentException();
        }
        int numPackets = this.calculateNumPackets(payload.length, this.mtu);
        ByteBufferSe headerBuffer = ByteBufferSe.Companion.allocate(7);
        byte[] header = headerBuffer.put(this.requestType).putShort((short)this.mtu).putInt(payload.length).array();
        byte[] totalPayLoad = ArraysKt.plus((byte[])header, (byte[])payload);
        int n = 0;
        byte[][] byArrayArray = new byte[numPackets][];
        while (n < numPackets) {
            int n2 = n++;
            byArrayArray[n2] = new byte[this.mtu];
        }
        byte[][] packets = byArrayArray;
        n = 0;
        int n3 = ((Object[])packets).length;
        while (n < n3) {
            int i = n++;
            packets[i][0] = this.messageId;
            int payloadPos = i * (this.mtu - 1);
            ArraysKt.copyInto((byte[])totalPayLoad, (byte[])packets[i], (int)1, (int)payloadPos, (int)(payloadPos + Math.min(this.mtu - 1, totalPayLoad.length - payloadPos)));
        }
        return packets;
    }

    /*
     * WARNING - void declaration
     */
    private final byte[] depacketizePayload(byte[][] packets) {
        void $this$fold$iv;
        Object[] objectArray = (Object[])packets;
        byte[] initial$iv = new byte[]{};
        boolean $i$f$fold = false;
        byte[] accumulator$iv = initial$iv;
        for (void element$iv : $this$fold$iv) {
            void bytes;
            byte[] byArray = (byte[])element$iv;
            byte[] acc = accumulator$iv;
            boolean bl = false;
            void packetMessageId = bytes[0];
            if (packetMessageId != this.getMessageId()) {
                throw new IllegalArgumentException("Packet message id error: expected " + this.getMessageId() + " / received " + (int)packetMessageId);
            }
            void var13_13 = bytes;
            int n = 1;
            int n2 = ((void)bytes).length;
            accumulator$iv = ArraysKt.plus((byte[])acc, (byte[])ArraysKt.copyOfRange((byte[])var13_13, (int)n, (int)n2));
        }
        return accumulator$iv;
    }

    public final boolean onPackageReceived(@NotNull byte[] packet) {
        int n;
        Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
        if (this.onPacketReceivedCount == 0) {
            this.assignHeaderValuesFromFirstPacket(packet);
            n = 0;
            int n2 = this.calculateNumPackets(this.length, this.mtu);
            byte[][] byArrayArray = new byte[n2][];
            BleMessage bleMessage = this;
            while (n < n2) {
                int n3 = n++;
                byArrayArray[n3] = new byte[this.mtu];
            }
            bleMessage.packetReceiveBuffer = byArrayArray;
        }
        Intrinsics.checkNotNull((Object)this.packetReceiveBuffer);
        if (this.onPacketReceivedCount < ((Object[])this.packetReceiveBuffer).length) {
            Intrinsics.checkNotNull((Object)this.packetReceiveBuffer);
            n = this.onPacketReceivedCount;
            this.onPacketReceivedCount = n + 1;
            this.packetReceiveBuffer[n] = packet;
        }
        Intrinsics.checkNotNull((Object)this.packetReceiveBuffer);
        if (this.onPacketReceivedCount == ((Object[])this.packetReceiveBuffer).length) {
            Intrinsics.checkNotNull((Object)this.packetReceiveBuffer);
            this.constructFromPackets(this.packetReceiveBuffer);
            return true;
        }
        return false;
    }

    public final void reset() {
        this.requestType = 0;
        this.length = 0;
        this.mtu = 20;
        this.payload = new byte[0];
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0016\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\tJ\u001e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00060\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/ustadmobile/sharedse/network/BleMessage$Companion;", "", "()V", "HEADER_SIZE", "", "MESSAGE_TYPE_HTTP", "", "messageIds", "", "", "payLoadStartIndex", "payloadLengthStartIndex", "findMessageId", "packet", "", "getNextMessageIdForReceiver", "receiverAddr", "newEntryStatusRequestMessage", "Lcom/ustadmobile/sharedse/network/BleMessage;", "destAddr", "endpointUrl", "containerUids", "", "sharedse_release"})
    public static final class Companion {
        private Companion() {
        }

        public final byte findMessageId(@NotNull byte[] packet) {
            Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
            return packet[0];
        }

        public final synchronized byte getNextMessageIdForReceiver(@NotNull String receiverAddr) {
            Intrinsics.checkNotNullParameter((Object)receiverAddr, (String)"receiverAddr");
            Byte by = (Byte)messageIds.get(receiverAddr);
            int lastMessageId = by == null ? -128 : by;
            byte nextMessageId = 0;
            nextMessageId = lastMessageId == 127 ? (byte)-128 : (byte)((byte)(lastMessageId + 1));
            Map map = messageIds;
            Byte by2 = nextMessageId;
            map.put(receiverAddr, by2);
            return nextMessageId;
        }

        @NotNull
        public final BleMessage newEntryStatusRequestMessage(@NotNull String destAddr, @NotNull String endpointUrl, @NotNull long[] containerUids) {
            Intrinsics.checkNotNullParameter((Object)destAddr, (String)"destAddr");
            Intrinsics.checkNotNullParameter((Object)endpointUrl, (String)"endpointUrl");
            Intrinsics.checkNotNullParameter((Object)containerUids, (String)"containerUids");
            return new BleMessage(111, this.getNextMessageIdForReceiver(destAddr), new EntryStatusRequest(endpointUrl, containerUids).toBytes());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

