/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.sharedse.network;

import com.ustadmobile.sharedse.io.ByteBufferSe;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007J\u0014\u0010\b\u001a\u00020\u00072\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a8\u0006\n"}, d2={"Lcom/ustadmobile/sharedse/network/BleMessageUtil;", "", "()V", "bleMessageBytesToLong", "", "", "entryInBytes", "", "bleMessageLongToBytes", "entryList", "sharedse_release"})
public final class BleMessageUtil {
    @NotNull
    public static final BleMessageUtil INSTANCE = new BleMessageUtil();

    private BleMessageUtil() {
    }

    @NotNull
    public final byte[] bleMessageLongToBytes(@NotNull List<Long> entryList) {
        Intrinsics.checkNotNullParameter(entryList, (String)"entryList");
        ByteBufferSe buffer = ByteBufferSe.Companion.allocate(entryList.size() * 8);
        Iterator<Long> iterator = entryList.iterator();
        while (iterator.hasNext()) {
            long entry = ((Number)iterator.next()).longValue();
            buffer.putLong(entry);
        }
        return buffer.array();
    }

    @NotNull
    public final List<Long> bleMessageBytesToLong(@NotNull byte[] entryInBytes) {
        Intrinsics.checkNotNullParameter((Object)entryInBytes, (String)"entryInBytes");
        ArrayList<Long> entries = new ArrayList<Long>();
        int BUFFER_SIZE = 8;
        int start = 0;
        int n = 0;
        int n2 = entryInBytes.length / BUFFER_SIZE;
        while (n < n2) {
            int position = n++;
            int end = start + BUFFER_SIZE;
            byte[] byArray = entryInBytes;
            long entry = ByteBufferSe.Companion.wrap(ArraysKt.copyOfRange((byte[])byArray, (int)start, (int)end)).getLong();
            entries.add(entry);
            start += BUFFER_SIZE;
        }
        return entries;
    }
}

