package com.toughra.ustadmobile.databinding;
import com.toughra.ustadmobile.R;
import com.toughra.ustadmobile.BR;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import android.view.View;
@SuppressWarnings("unchecked")
public class FragmentListBindingImpl extends FragmentListBinding  {

    @Nullable
    private static final androidx.databinding.ViewDataBinding.IncludedLayouts sIncludes;
    @Nullable
    private static final android.util.SparseIntArray sViewsWithIds;
    static {
        sIncludes = null;
        sViewsWithIds = null;
    }
    // views
    // variables
    // values
    // listeners
    // Inverse Binding Event Handlers

    public FragmentListBindingImpl(@Nullable androidx.databinding.DataBindingComponent bindingComponent, @NonNull View root) {
        this(bindingComponent, root, mapBindings(bindingComponent, root, 1, sIncludes, sViewsWithIds));
    }
    private FragmentListBindingImpl(androidx.databinding.DataBindingComponent bindingComponent, View root, Object[] bindings) {
        super(bindingComponent, root, 0
            , (androidx.recyclerview.widget.RecyclerView) bindings[0]
            );
        this.fragmentListRecyclerview.setTag(null);
        setRootTag(root);
        // listeners
        invalidateAll();
    }

    @Override
    public void invalidateAll() {
        synchronized(this) {
                mDirtyFlags = 0x4L;
        }
        requestRebind();
    }

    @Override
    public boolean hasPendingBindings() {
        synchronized(this) {
            if (mDirtyFlags != 0) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean setVariable(int variableId, @Nullable Object variable)  {
        boolean variableSet = true;
        if (BR.presenter == variableId) {
            setPresenter((com.ustadmobile.core.controller.UstadListPresenter) variable);
        }
        else if (BR.addMode == variableId) {
            setAddMode((com.ustadmobile.core.view.ListViewAddMode) variable);
        }
        else {
            variableSet = false;
        }
            return variableSet;
    }

    public void setPresenter(@Nullable com.ustadmobile.core.controller.UstadListPresenter Presenter) {
        this.mPresenter = Presenter;
    }
    public void setAddMode(@Nullable com.ustadmobile.core.view.ListViewAddMode AddMode) {
        this.mAddMode = AddMode;
        synchronized(this) {
            mDirtyFlags |= 0x2L;
        }
        notifyPropertyChanged(BR.addMode);
        super.requestRebind();
    }

    @Override
    protected boolean onFieldChange(int localFieldId, Object object, int fieldId) {
        switch (localFieldId) {
        }
        return false;
    }

    @Override
    protected void executeBindings() {
        long dirtyFlags = 0;
        synchronized(this) {
            dirtyFlags = mDirtyFlags;
            mDirtyFlags = 0;
        }
        float addModeListViewAddModeFABFragmentListRecyclerviewAndroidDimenDimen116dpFragmentListRecyclerviewAndroidDimenDimen56dp = 0f;
        boolean addModeListViewAddModeFAB = false;
        com.ustadmobile.core.view.ListViewAddMode addMode = mAddMode;

        if ((dirtyFlags & 0x6L) != 0) {



                // read addMode == ListViewAddMode.FAB
                addModeListViewAddModeFAB = (addMode) == (com.ustadmobile.core.view.ListViewAddMode.FAB);
            if((dirtyFlags & 0x6L) != 0) {
                if(addModeListViewAddModeFAB) {
                        dirtyFlags |= 0x10L;
                }
                else {
                        dirtyFlags |= 0x8L;
                }
            }


                // read addMode == ListViewAddMode.FAB ? @android:dimen/dimen_116dp : @android:dimen/dimen_56dp
                addModeListViewAddModeFABFragmentListRecyclerviewAndroidDimenDimen116dpFragmentListRecyclerviewAndroidDimenDimen56dp = ((addModeListViewAddModeFAB) ? (fragmentListRecyclerview.getResources().getDimension(R.dimen.dimen_116dp)) : (fragmentListRecyclerview.getResources().getDimension(R.dimen.dimen_56dp)));
        }
        // batch finished
        if ((dirtyFlags & 0x6L) != 0) {
            // api target 1

            androidx.databinding.adapters.ViewBindingAdapter.setPaddingBottom(this.fragmentListRecyclerview, addModeListViewAddModeFABFragmentListRecyclerviewAndroidDimenDimen116dpFragmentListRecyclerviewAndroidDimenDimen56dp);
        }
    }
    // Listener Stub Implementations
    // callback impls
    // dirty flag
    private  long mDirtyFlags = 0xffffffffffffffffL;
    /* flag mapping
        flag 0 (0x1L): presenter
        flag 1 (0x2L): addMode
        flag 2 (0x3L): null
        flag 3 (0x4L): addMode == ListViewAddMode.FAB ? @android:dimen/dimen_116dp : @android:dimen/dimen_56dp
        flag 4 (0x5L): addMode == ListViewAddMode.FAB ? @android:dimen/dimen_116dp : @android:dimen/dimen_56dp
    flag mapping end*/
    //end
}