package com.toughra.ustadmobile.databinding;
import com.toughra.ustadmobile.R;
import com.toughra.ustadmobile.BR;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import android.view.View;
@SuppressWarnings("unchecked")
public class ItemMessageListBindingImpl extends ItemMessageListBinding  {

    @Nullable
    private static final androidx.databinding.ViewDataBinding.IncludedLayouts sIncludes;
    @Nullable
    private static final android.util.SparseIntArray sViewsWithIds;
    static {
        sIncludes = null;
        sViewsWithIds = new android.util.SparseIntArray();
        sViewsWithIds.put(R.id.item_message_list_chat_bubble, 5);
    }
    // views
    // variables
    // values
    // listeners
    // Inverse Binding Event Handlers

    public ItemMessageListBindingImpl(@Nullable androidx.databinding.DataBindingComponent bindingComponent, @NonNull View root) {
        this(bindingComponent, root, mapBindings(bindingComponent, root, 6, sIncludes, sViewsWithIds));
    }
    private ItemMessageListBindingImpl(androidx.databinding.DataBindingComponent bindingComponent, View root, Object[] bindings) {
        super(bindingComponent, root, 0
            , (androidx.constraintlayout.widget.ConstraintLayout) bindings[0]
            , (android.widget.TextView) bindings[3]
            , (android.widget.TextView) bindings[4]
            , (android.widget.TextView) bindings[2]
            , (androidx.constraintlayout.widget.ConstraintLayout) bindings[5]
            , (de.hdodenhof.circleimageview.CircleImageView) bindings[1]
            );
        this.itemCommentsListCl.setTag(null);
        this.itemCommentsListLine2Text.setTag(null);
        this.itemCommentsListLine3Text.setTag(null);
        this.itemCommentsListText.setTag(null);
        this.itemMessageListPersonPic.setTag(null);
        setRootTag(root);
        // listeners
        invalidateAll();
    }

    @Override
    public void invalidateAll() {
        synchronized(this) {
                mDirtyFlags = 0x8L;
        }
        requestRebind();
    }

    @Override
    public boolean hasPendingBindings() {
        synchronized(this) {
            if (mDirtyFlags != 0) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean setVariable(int variableId, @Nullable Object variable)  {
        boolean variableSet = true;
        if (BR.loggedInPersonUid == variableId) {
            setLoggedInPersonUid((java.lang.Long) variable);
        }
        else if (BR.message == variableId) {
            setMessage((com.ustadmobile.lib.db.entities.MessageWithPerson) variable);
        }
        else if (BR.presenter == variableId) {
            setPresenter((com.ustadmobile.core.controller.ChatDetailPresenter) variable);
        }
        else {
            variableSet = false;
        }
            return variableSet;
    }

    public void setLoggedInPersonUid(@Nullable java.lang.Long LoggedInPersonUid) {
        this.mLoggedInPersonUid = LoggedInPersonUid;
        synchronized(this) {
            mDirtyFlags |= 0x1L;
        }
        notifyPropertyChanged(BR.loggedInPersonUid);
        super.requestRebind();
    }
    public void setMessage(@Nullable com.ustadmobile.lib.db.entities.MessageWithPerson Message) {
        this.mMessage = Message;
        synchronized(this) {
            mDirtyFlags |= 0x2L;
        }
        notifyPropertyChanged(BR.message);
        super.requestRebind();
    }
    public void setPresenter(@Nullable com.ustadmobile.core.controller.ChatDetailPresenter Presenter) {
        this.mPresenter = Presenter;
    }

    @Override
    protected boolean onFieldChange(int localFieldId, Object object, int fieldId) {
        switch (localFieldId) {
        }
        return false;
    }

    @Override
    protected void executeBindings() {
        long dirtyFlags = 0;
        synchronized(this) {
            dirtyFlags = mDirtyFlags;
            mDirtyFlags = 0;
        }
        com.ustadmobile.port.android.view.util.ForeignKeyAttachmentUriAdapter personDetailFragmentFOREIGNKEYADAPTERPERSON = null;
        java.lang.Long loggedInPersonUid = mLoggedInPersonUid;
        com.ustadmobile.lib.db.entities.MessageWithPerson message = mMessage;
        long androidxDatabindingViewDataBindingSafeUnboxLoggedInPersonUid = 0;
        long messageMessagePersonPersonUid = 0;
        com.ustadmobile.lib.db.entities.Person messageMessagePerson = null;
        long messageMessageTimestamp = 0;

        if ((dirtyFlags & 0x8L) != 0) {

                // read PersonDetailFragment.FOREIGNKEYADAPTER_PERSON
                personDetailFragmentFOREIGNKEYADAPTERPERSON = com.ustadmobile.port.android.view.PersonDetailFragment.getFOREIGNKEYADAPTER_PERSON();
        }
        if ((dirtyFlags & 0xbL) != 0) {



                // read androidx.databinding.ViewDataBinding.safeUnbox(loggedInPersonUid)
                androidxDatabindingViewDataBindingSafeUnboxLoggedInPersonUid = androidx.databinding.ViewDataBinding.safeUnbox(loggedInPersonUid);
            if ((dirtyFlags & 0xaL) != 0) {

                    if (message != null) {
                        // read message.messagePerson
                        messageMessagePerson = message.getMessagePerson();
                        // read message.messageTimestamp
                        messageMessageTimestamp = message.getMessageTimestamp();
                    }


                    if (messageMessagePerson != null) {
                        // read message.messagePerson.personUid
                        messageMessagePersonPersonUid = messageMessagePerson.getPersonUid();
                    }
            }
        }
        // batch finished
        if ((dirtyFlags & 0xbL) != 0) {
            // api target 1

            com.ustadmobile.port.android.view.binding.TextViewBindingsKt.setChatMessagOrientation(this.itemCommentsListLine2Text, message, androidxDatabindingViewDataBindingSafeUnboxLoggedInPersonUid);
            com.ustadmobile.port.android.view.binding.TextViewBindingsKt.setChatMessageTitle(this.itemCommentsListText, message, androidxDatabindingViewDataBindingSafeUnboxLoggedInPersonUid);
            com.ustadmobile.port.android.view.binding.TextViewBindingsKt.setChatMessagOrientation(this.itemCommentsListText, message, androidxDatabindingViewDataBindingSafeUnboxLoggedInPersonUid);
        }
        if ((dirtyFlags & 0xaL) != 0) {
            // api target 1

            com.ustadmobile.port.android.view.binding.DatePickerBindingAdapter2Kt.setDateWithRelativeTime(this.itemCommentsListLine3Text, messageMessageTimestamp);
            com.ustadmobile.port.android.view.binding.ImageViewBindingsKt.setMessageIconVisibility(this.itemMessageListPersonPic, message);
            com.ustadmobile.port.android.view.binding.ImageViewBindingsKt.setImageForeignKey(this.itemMessageListPersonPic, messageMessagePersonPersonUid, (java.lang.String)null);
        }
        if ((dirtyFlags & 0x8L) != 0) {
            // api target 1

            com.ustadmobile.port.android.view.binding.ImageViewBindingsKt.setImageForeignKeyAdapter(this.itemMessageListPersonPic, personDetailFragmentFOREIGNKEYADAPTERPERSON);
            com.ustadmobile.port.android.view.binding.ImageViewBindingsKt.imageForeignKeyPlaceholder(this.itemMessageListPersonPic, androidx.appcompat.content.res.AppCompatResources.getDrawable(itemMessageListPersonPic.getContext(), R.drawable.ic_account_circle_black_24dp));
        }
    }
    // Listener Stub Implementations
    // callback impls
    // dirty flag
    private  long mDirtyFlags = 0xffffffffffffffffL;
    /* flag mapping
        flag 0 (0x1L): loggedInPersonUid
        flag 1 (0x2L): message
        flag 2 (0x3L): presenter
        flag 3 (0x4L): null
    flag mapping end*/
    //end
}