package com.toughra.ustadmobile.databinding;
import com.toughra.ustadmobile.R;
import com.toughra.ustadmobile.BR;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import android.view.View;
@SuppressWarnings("unchecked")
public class ItemReportStatementListBindingImpl extends ItemReportStatementListBinding  {

    @Nullable
    private static final androidx.databinding.ViewDataBinding.IncludedLayouts sIncludes;
    @Nullable
    private static final android.util.SparseIntArray sViewsWithIds;
    static {
        sIncludes = null;
        sViewsWithIds = new android.util.SparseIntArray();
        sViewsWithIds.put(R.id.guideline_person, 5);
        sViewsWithIds.put(R.id.guideline_verb, 6);
        sViewsWithIds.put(R.id.guideline_result, 7);
    }
    // views
    @NonNull
    private final androidx.constraintlayout.widget.ConstraintLayout mboundView0;
    // variables
    // values
    // listeners
    // Inverse Binding Event Handlers

    public ItemReportStatementListBindingImpl(@Nullable androidx.databinding.DataBindingComponent bindingComponent, @NonNull View root) {
        this(bindingComponent, root, mapBindings(bindingComponent, root, 8, sIncludes, sViewsWithIds));
    }
    private ItemReportStatementListBindingImpl(androidx.databinding.DataBindingComponent bindingComponent, View root, Object[] bindings) {
        super(bindingComponent, root, 0
            , (androidx.constraintlayout.widget.Guideline) bindings[5]
            , (androidx.constraintlayout.widget.Guideline) bindings[7]
            , (androidx.constraintlayout.widget.Guideline) bindings[6]
            , (android.widget.TextView) bindings[1]
            , (android.widget.TextView) bindings[3]
            , (android.widget.TextView) bindings[2]
            , (android.widget.TextView) bindings[4]
            );
        this.mboundView0 = (androidx.constraintlayout.widget.ConstraintLayout) bindings[0];
        this.mboundView0.setTag(null);
        this.xapiPerson.setTag(null);
        this.xapiResult.setTag(null);
        this.xapiVerb.setTag(null);
        this.xapiWhen.setTag(null);
        setRootTag(root);
        // listeners
        invalidateAll();
    }

    @Override
    public void invalidateAll() {
        synchronized(this) {
                mDirtyFlags = 0x4L;
        }
        requestRebind();
    }

    @Override
    public boolean hasPendingBindings() {
        synchronized(this) {
            if (mDirtyFlags != 0) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean setVariable(int variableId, @Nullable Object variable)  {
        boolean variableSet = true;
        if (BR.report == variableId) {
            setReport((com.ustadmobile.lib.db.entities.StatementEntityWithDisplayDetails) variable);
        }
        else if (BR.mPresenter == variableId) {
            setMPresenter((com.ustadmobile.core.controller.ReportDetailPresenter) variable);
        }
        else {
            variableSet = false;
        }
            return variableSet;
    }

    public void setReport(@Nullable com.ustadmobile.lib.db.entities.StatementEntityWithDisplayDetails Report) {
        this.mReport = Report;
        synchronized(this) {
            mDirtyFlags |= 0x1L;
        }
        notifyPropertyChanged(BR.report);
        super.requestRebind();
    }
    public void setMPresenter(@Nullable com.ustadmobile.core.controller.ReportDetailPresenter MPresenter) {
        this.mMPresenter = MPresenter;
    }

    @Override
    protected boolean onFieldChange(int localFieldId, Object object, int fieldId) {
        switch (localFieldId) {
        }
        return false;
    }

    @Override
    protected void executeBindings() {
        long dirtyFlags = 0;
        synchronized(this) {
            dirtyFlags = mDirtyFlags;
            mDirtyFlags = 0;
        }
        long reportTimestamp = 0;
        byte reportResultSuccess = 0;
        java.lang.String reportXlangMapEntryValueLangMap = null;
        com.ustadmobile.lib.db.entities.StatementEntityWithDisplayDetails report = mReport;
        com.ustadmobile.lib.db.entities.XLangMapEntry reportXlangMapEntry = null;
        java.lang.String reportPersonFullName = null;
        com.ustadmobile.lib.db.entities.Person reportPerson = null;

        if ((dirtyFlags & 0x5L) != 0) {



                if (report != null) {
                    // read report.timestamp
                    reportTimestamp = report.getTimestamp();
                    // read report.resultSuccess
                    reportResultSuccess = report.getResultSuccess();
                    // read report.xlangMapEntry
                    reportXlangMapEntry = report.getXlangMapEntry();
                    // read report.person
                    reportPerson = report.getPerson();
                }


                if (reportXlangMapEntry != null) {
                    // read report.xlangMapEntry.valueLangMap
                    reportXlangMapEntryValueLangMap = reportXlangMapEntry.getValueLangMap();
                }
                if (reportPerson != null) {
                    // read report.person.fullName()
                    reportPersonFullName = reportPerson.fullName();
                }
        }
        // batch finished
        if ((dirtyFlags & 0x5L) != 0) {
            // api target 1

            androidx.databinding.adapters.TextViewBindingAdapter.setText(this.xapiPerson, reportPersonFullName);
            com.ustadmobile.port.android.view.binding.TextViewBindingsKt.setTextMessageIdOptionSelected(this.xapiResult, reportResultSuccess);
            androidx.databinding.adapters.TextViewBindingAdapter.setText(this.xapiVerb, reportXlangMapEntryValueLangMap);
            com.ustadmobile.port.android.view.binding.TextViewBindingsKt.setDateText(this.xapiWhen, reportTimestamp);
        }
        if ((dirtyFlags & 0x4L) != 0) {
            // api target 1

            com.ustadmobile.port.android.view.binding.TextViewBindingsKt.setTextMessageIdOptions(this.xapiResult, com.ustadmobile.core.controller.StatementConstants.STATEMENT_RESULT_OPTIONS, (java.lang.Integer)null, (java.lang.String)null);
        }
    }
    // Listener Stub Implementations
    // callback impls
    // dirty flag
    private  long mDirtyFlags = 0xffffffffffffffffL;
    /* flag mapping
        flag 0 (0x1L): report
        flag 1 (0x2L): mPresenter
        flag 2 (0x3L): null
    flag mapping end*/
    //end
}