'use strict';

var addDays = require('date-fns/addDays');
var addSeconds = require('date-fns/addSeconds');
var addMinutes = require('date-fns/addMinutes');
var addHours = require('date-fns/addHours');
var addWeeks = require('date-fns/addWeeks');
var addMonths = require('date-fns/addMonths');
var addYears = require('date-fns/addYears');
var differenceInYears = require('date-fns/differenceInYears');
var differenceInQuarters = require('date-fns/differenceInQuarters');
var differenceInMonths = require('date-fns/differenceInMonths');
var differenceInWeeks = require('date-fns/differenceInWeeks');
var differenceInDays = require('date-fns/differenceInDays');
var differenceInHours = require('date-fns/differenceInHours');
var differenceInMinutes = require('date-fns/differenceInMinutes');
var differenceInSeconds = require('date-fns/differenceInSeconds');
var differenceInMilliseconds = require('date-fns/differenceInMilliseconds');
var eachDayOfInterval = require('date-fns/eachDayOfInterval');
var endOfDay = require('date-fns/endOfDay');
var endOfWeek = require('date-fns/endOfWeek');
var endOfYear = require('date-fns/endOfYear');
var format = require('date-fns/format');
var getHours = require('date-fns/getHours');
var getSeconds = require('date-fns/getSeconds');
var getYear = require('date-fns/getYear');
var isAfter = require('date-fns/isAfter');
var isBefore = require('date-fns/isBefore');
var isEqual = require('date-fns/isEqual');
var isSameDay = require('date-fns/isSameDay');
var isSameYear = require('date-fns/isSameYear');
var isSameMonth = require('date-fns/isSameMonth');
var isSameHour = require('date-fns/isSameHour');
var isValid = require('date-fns/isValid');
var dateFnsParse = require('date-fns/parse');
var setHours = require('date-fns/setHours');
var setMinutes = require('date-fns/setMinutes');
var setMonth = require('date-fns/setMonth');
var getDay = require('date-fns/getDay');
var getDaysInMonth = require('date-fns/getDaysInMonth');
var setSeconds = require('date-fns/setSeconds');
var setYear = require('date-fns/setYear');
var startOfDay = require('date-fns/startOfDay');
var startOfMonth = require('date-fns/startOfMonth');
var endOfMonth = require('date-fns/endOfMonth');
var startOfWeek = require('date-fns/startOfWeek');
var startOfYear = require('date-fns/startOfYear');
var parseISO = require('date-fns/parseISO');
var formatISO = require('date-fns/formatISO');
var isWithinInterval = require('date-fns/isWithinInterval');
var longFormatters = require('date-fns/_lib/format/longFormatters');
var defaultLocale = require('date-fns/locale/en-US');

function _interopDefaultLegacy (e) { return e && typeof e === 'object' && 'default' in e ? e : { 'default': e }; }

var addDays__default = /*#__PURE__*/_interopDefaultLegacy(addDays);
var addSeconds__default = /*#__PURE__*/_interopDefaultLegacy(addSeconds);
var addMinutes__default = /*#__PURE__*/_interopDefaultLegacy(addMinutes);
var addHours__default = /*#__PURE__*/_interopDefaultLegacy(addHours);
var addWeeks__default = /*#__PURE__*/_interopDefaultLegacy(addWeeks);
var addMonths__default = /*#__PURE__*/_interopDefaultLegacy(addMonths);
var addYears__default = /*#__PURE__*/_interopDefaultLegacy(addYears);
var differenceInYears__default = /*#__PURE__*/_interopDefaultLegacy(differenceInYears);
var differenceInQuarters__default = /*#__PURE__*/_interopDefaultLegacy(differenceInQuarters);
var differenceInMonths__default = /*#__PURE__*/_interopDefaultLegacy(differenceInMonths);
var differenceInWeeks__default = /*#__PURE__*/_interopDefaultLegacy(differenceInWeeks);
var differenceInDays__default = /*#__PURE__*/_interopDefaultLegacy(differenceInDays);
var differenceInHours__default = /*#__PURE__*/_interopDefaultLegacy(differenceInHours);
var differenceInMinutes__default = /*#__PURE__*/_interopDefaultLegacy(differenceInMinutes);
var differenceInSeconds__default = /*#__PURE__*/_interopDefaultLegacy(differenceInSeconds);
var differenceInMilliseconds__default = /*#__PURE__*/_interopDefaultLegacy(differenceInMilliseconds);
var eachDayOfInterval__default = /*#__PURE__*/_interopDefaultLegacy(eachDayOfInterval);
var endOfDay__default = /*#__PURE__*/_interopDefaultLegacy(endOfDay);
var endOfWeek__default = /*#__PURE__*/_interopDefaultLegacy(endOfWeek);
var endOfYear__default = /*#__PURE__*/_interopDefaultLegacy(endOfYear);
var format__default = /*#__PURE__*/_interopDefaultLegacy(format);
var getHours__default = /*#__PURE__*/_interopDefaultLegacy(getHours);
var getSeconds__default = /*#__PURE__*/_interopDefaultLegacy(getSeconds);
var getYear__default = /*#__PURE__*/_interopDefaultLegacy(getYear);
var isAfter__default = /*#__PURE__*/_interopDefaultLegacy(isAfter);
var isBefore__default = /*#__PURE__*/_interopDefaultLegacy(isBefore);
var isEqual__default = /*#__PURE__*/_interopDefaultLegacy(isEqual);
var isSameDay__default = /*#__PURE__*/_interopDefaultLegacy(isSameDay);
var isSameYear__default = /*#__PURE__*/_interopDefaultLegacy(isSameYear);
var isSameMonth__default = /*#__PURE__*/_interopDefaultLegacy(isSameMonth);
var isSameHour__default = /*#__PURE__*/_interopDefaultLegacy(isSameHour);
var isValid__default = /*#__PURE__*/_interopDefaultLegacy(isValid);
var dateFnsParse__default = /*#__PURE__*/_interopDefaultLegacy(dateFnsParse);
var setHours__default = /*#__PURE__*/_interopDefaultLegacy(setHours);
var setMinutes__default = /*#__PURE__*/_interopDefaultLegacy(setMinutes);
var setMonth__default = /*#__PURE__*/_interopDefaultLegacy(setMonth);
var getDay__default = /*#__PURE__*/_interopDefaultLegacy(getDay);
var getDaysInMonth__default = /*#__PURE__*/_interopDefaultLegacy(getDaysInMonth);
var setSeconds__default = /*#__PURE__*/_interopDefaultLegacy(setSeconds);
var setYear__default = /*#__PURE__*/_interopDefaultLegacy(setYear);
var startOfDay__default = /*#__PURE__*/_interopDefaultLegacy(startOfDay);
var startOfMonth__default = /*#__PURE__*/_interopDefaultLegacy(startOfMonth);
var endOfMonth__default = /*#__PURE__*/_interopDefaultLegacy(endOfMonth);
var startOfWeek__default = /*#__PURE__*/_interopDefaultLegacy(startOfWeek);
var startOfYear__default = /*#__PURE__*/_interopDefaultLegacy(startOfYear);
var parseISO__default = /*#__PURE__*/_interopDefaultLegacy(parseISO);
var formatISO__default = /*#__PURE__*/_interopDefaultLegacy(formatISO);
var isWithinInterval__default = /*#__PURE__*/_interopDefaultLegacy(isWithinInterval);
var longFormatters__default = /*#__PURE__*/_interopDefaultLegacy(longFormatters);
var defaultLocale__default = /*#__PURE__*/_interopDefaultLegacy(defaultLocale);

var defaultFormats = {
    dayOfMonth: "d",
    fullDate: "PP",
    fullDateWithWeekday: "PPPP",
    fullDateTime: "PP p",
    fullDateTime12h: "PP hh:mm aaa",
    fullDateTime24h: "PP HH:mm",
    fullTime: "p",
    fullTime12h: "hh:mm aaa",
    fullTime24h: "HH:mm",
    hours12h: "hh",
    hours24h: "HH",
    keyboardDate: "P",
    keyboardDateTime: "P p",
    keyboardDateTime12h: "P hh:mm aaa",
    keyboardDateTime24h: "P HH:mm",
    minutes: "mm",
    month: "LLLL",
    monthAndDate: "MMMM d",
    monthAndYear: "LLLL yyyy",
    monthShort: "MMM",
    weekday: "EEEE",
    weekdayShort: "EEE",
    normalDate: "d MMMM",
    normalDateWithWeekday: "EEE, MMM d",
    seconds: "ss",
    shortDate: "MMM d",
    year: "yyyy",
};
var DateFnsUtils = /** @class */ (function () {
    function DateFnsUtils(_a) {
        var _this = this;
        var _b = _a === void 0 ? {} : _a, locale = _b.locale, formats = _b.formats;
        this.lib = "date-fns";
        // Note: date-fns input types are more lenient than this adapter, so we need to expose our more
        // strict signature and delegate to the more lenient signature. Otherwise, we have downstream type errors upon usage.
        this.is12HourCycleInCurrentLocale = function () {
            if (_this.locale) {
                return /a/.test(_this.locale.formatLong.time());
            }
            // By default date-fns is using en-US locale with am/pm enabled
            return true;
        };
        this.getFormatHelperText = function (format) {
            // @see https://github.com/date-fns/date-fns/blob/master/src/format/index.js#L31
            var longFormatRegexp = /P+p+|P+|p+|''|'(''|[^'])+('|$)|./g;
            var locale = _this.locale || defaultLocale__default["default"];
            return format
                .match(longFormatRegexp)
                .map(function (token) {
                var firstCharacter = token[0];
                if (firstCharacter === "p" || firstCharacter === "P") {
                    var longFormatter = longFormatters__default["default"][firstCharacter];
                    return longFormatter(token, locale.formatLong, {});
                }
                return token;
            })
                .join("")
                .replace(/(aaa|aa|a)/g, "(a|p)m")
                .toLocaleLowerCase();
        };
        this.parseISO = function (isoString) {
            return parseISO__default["default"](isoString);
        };
        this.toISO = function (value) {
            return formatISO__default["default"](value, { format: "extended" });
        };
        this.getCurrentLocaleCode = function () {
            var _a;
            return ((_a = _this.locale) === null || _a === void 0 ? void 0 : _a.code) || "en-US";
        };
        this.addSeconds = function (value, count) {
            return addSeconds__default["default"](value, count);
        };
        this.addMinutes = function (value, count) {
            return addMinutes__default["default"](value, count);
        };
        this.addHours = function (value, count) {
            return addHours__default["default"](value, count);
        };
        this.addDays = function (value, count) {
            return addDays__default["default"](value, count);
        };
        this.addWeeks = function (value, count) {
            return addWeeks__default["default"](value, count);
        };
        this.addMonths = function (value, count) {
            return addMonths__default["default"](value, count);
        };
        this.isValid = function (value) {
            return isValid__default["default"](_this.date(value));
        };
        this.getDiff = function (value, comparing, unit) {
            switch (unit) {
                case "years":
                    return differenceInYears__default["default"](value, _this.date(comparing));
                case "quarters":
                    return differenceInQuarters__default["default"](value, _this.date(comparing));
                case "months":
                    return differenceInMonths__default["default"](value, _this.date(comparing));
                case "weeks":
                    return differenceInWeeks__default["default"](value, _this.date(comparing));
                case "days":
                    return differenceInDays__default["default"](value, _this.date(comparing));
                case "hours":
                    return differenceInHours__default["default"](value, _this.date(comparing));
                case "minutes":
                    return differenceInMinutes__default["default"](value, _this.date(comparing));
                case "seconds":
                    return differenceInSeconds__default["default"](value, _this.date(comparing));
                default: {
                    return differenceInMilliseconds__default["default"](value, _this.date(comparing));
                }
            }
        };
        this.isAfter = function (value, comparing) {
            return isAfter__default["default"](value, comparing);
        };
        this.isBefore = function (value, comparing) {
            return isBefore__default["default"](value, comparing);
        };
        this.startOfDay = function (value) {
            return startOfDay__default["default"](value);
        };
        this.endOfDay = function (value) {
            return endOfDay__default["default"](value);
        };
        this.getHours = function (value) {
            return getHours__default["default"](value);
        };
        this.setHours = function (value, count) {
            return setHours__default["default"](value, count);
        };
        this.setMinutes = function (value, count) {
            return setMinutes__default["default"](value, count);
        };
        this.getSeconds = function (value) {
            return getSeconds__default["default"](value);
        };
        this.setSeconds = function (value, count) {
            return setSeconds__default["default"](value, count);
        };
        this.isSameDay = function (value, comparing) {
            return isSameDay__default["default"](value, comparing);
        };
        this.isSameMonth = function (value, comparing) {
            return isSameMonth__default["default"](value, comparing);
        };
        this.isSameYear = function (value, comparing) {
            return isSameYear__default["default"](value, comparing);
        };
        this.isSameHour = function (value, comparing) {
            return isSameHour__default["default"](value, comparing);
        };
        this.startOfYear = function (value) {
            return startOfYear__default["default"](value);
        };
        this.endOfYear = function (value) {
            return endOfYear__default["default"](value);
        };
        this.startOfMonth = function (value) {
            return startOfMonth__default["default"](value);
        };
        this.endOfMonth = function (value) {
            return endOfMonth__default["default"](value);
        };
        this.startOfWeek = function (value) {
            return startOfWeek__default["default"](value, { locale: _this.locale });
        };
        this.endOfWeek = function (value) {
            return endOfWeek__default["default"](value, { locale: _this.locale });
        };
        this.getYear = function (value) {
            return getYear__default["default"](value);
        };
        this.setYear = function (value, count) {
            return setYear__default["default"](value, count);
        };
        this.date = function (value) {
            if (typeof value === "undefined") {
                return new Date();
            }
            if (value === null) {
                return null;
            }
            return new Date(value);
        };
        this.toJsDate = function (value) {
            return value;
        };
        this.parse = function (value, formatString) {
            if (value === "") {
                return null;
            }
            return dateFnsParse__default["default"](value, formatString, new Date(), { locale: _this.locale });
        };
        this.format = function (date, formatKey) {
            return _this.formatByString(date, _this.formats[formatKey]);
        };
        this.formatByString = function (date, formatString) {
            return format__default["default"](date, formatString, { locale: _this.locale });
        };
        this.isEqual = function (date, comparing) {
            if (date === null && comparing === null) {
                return true;
            }
            return isEqual__default["default"](date, comparing);
        };
        this.isNull = function (date) {
            return date === null;
        };
        this.isAfterDay = function (date, value) {
            return isAfter__default["default"](date, endOfDay__default["default"](value));
        };
        this.isBeforeDay = function (date, value) {
            return isBefore__default["default"](date, startOfDay__default["default"](value));
        };
        this.isBeforeYear = function (date, value) {
            return isBefore__default["default"](date, startOfYear__default["default"](value));
        };
        this.isAfterYear = function (date, value) {
            return isAfter__default["default"](date, endOfYear__default["default"](value));
        };
        this.isWithinRange = function (date, _a) {
            var start = _a[0], end = _a[1];
            return isWithinInterval__default["default"](date, { start: start, end: end });
        };
        this.formatNumber = function (numberToFormat) {
            return numberToFormat;
        };
        this.getMinutes = function (date) {
            return date.getMinutes();
        };
        this.getMonth = function (date) {
            return date.getMonth();
        };
        this.getDaysInMonth = function (date) {
            return getDaysInMonth__default["default"](date);
        };
        this.setMonth = function (date, count) {
            return setMonth__default["default"](date, count);
        };
        this.getMeridiemText = function (ampm) {
            return ampm === "am" ? "AM" : "PM";
        };
        this.getNextMonth = function (date) {
            return addMonths__default["default"](date, 1);
        };
        this.getPreviousMonth = function (date) {
            return addMonths__default["default"](date, -1);
        };
        this.getMonthArray = function (date) {
            var firstMonth = startOfYear__default["default"](date);
            var monthArray = [firstMonth];
            while (monthArray.length < 12) {
                var prevMonth = monthArray[monthArray.length - 1];
                monthArray.push(_this.getNextMonth(prevMonth));
            }
            return monthArray;
        };
        this.mergeDateAndTime = function (date, time) {
            return _this.setSeconds(_this.setMinutes(_this.setHours(date, _this.getHours(time)), _this.getMinutes(time)), _this.getSeconds(time));
        };
        this.getWeekdays = function () {
            var now = new Date();
            return eachDayOfInterval__default["default"]({
                start: startOfWeek__default["default"](now, { locale: _this.locale }),
                end: endOfWeek__default["default"](now, { locale: _this.locale }),
            }).map(function (day) { return _this.formatByString(day, "EEEEEE"); });
        };
        this.getWeekArray = function (date) {
            var start = startOfWeek__default["default"](startOfMonth__default["default"](date), { locale: _this.locale });
            var end = endOfWeek__default["default"](endOfMonth__default["default"](date), { locale: _this.locale });
            var count = 0;
            var current = start;
            var nestedWeeks = [];
            var lastDay = null;
            while (isBefore__default["default"](current, end)) {
                var weekNumber = Math.floor(count / 7);
                nestedWeeks[weekNumber] = nestedWeeks[weekNumber] || [];
                var day = getDay__default["default"](current);
                if (lastDay !== day) {
                    lastDay = day;
                    nestedWeeks[weekNumber].push(current);
                    count += 1;
                }
                current = addDays__default["default"](current, 1);
            }
            return nestedWeeks;
        };
        this.getYearRange = function (start, end) {
            var startDate = startOfYear__default["default"](start);
            var endDate = endOfYear__default["default"](end);
            var years = [];
            var current = startDate;
            while (isBefore__default["default"](current, endDate)) {
                years.push(current);
                current = addYears__default["default"](current, 1);
            }
            return years;
        };
        this.locale = locale;
        this.formats = Object.assign({}, defaultFormats, formats);
    }
    return DateFnsUtils;
}());

module.exports = DateFnsUtils;
