import * as React from 'react';
import { AppendOwnerStateReturnType } from './appendOwnerState';
import { MergeSlotPropsParameters, WithCommonProps } from './mergeSlotProps';
export declare type UseSlotPropsParameters<ElementType extends React.ElementType, SlotProps, ExternalForwardedProps, ExternalSlotProps, AdditionalProps, OwnerState> = Omit<MergeSlotPropsParameters<SlotProps, ExternalForwardedProps, ExternalSlotProps, AdditionalProps>, 'externalSlotProps'> & {
    /**
     * The type of the component used in the slot.
     */
    elementType: ElementType;
    /**
     * The `componentsProps.*` of the unstyled component.
     */
    externalSlotProps: ExternalSlotProps | ((ownerState: OwnerState) => ExternalSlotProps) | undefined;
    /**
     * The ownerState of the unstyled component.
     */
    ownerState: OwnerState;
};
export declare type UseSlotPropsResult<ElementType extends React.ElementType, SlotProps, ExternalForwardedProps, ExternalSlotProps, AdditionalProps, OwnerState> = AppendOwnerStateReturnType<ElementType, Omit<SlotProps & ExternalSlotProps & ExternalForwardedProps & AdditionalProps, 'ref'> & {
    className?: string | undefined;
    ref: (instance: any | null) => void;
}, OwnerState>;
/**
 * Builds the props to be passed into the slot of an unstyled component.
 * It merges the internal props of the component with the ones supplied by the user, allowing to customize the behavior.
 * If the slot component is not a host component, it also merges in the `ownerState`.
 *
 * @param parameters.getSlotProps - A function that returns the props to be passed to the slot component.
 */
export default function useSlotProps<ElementType extends React.ElementType, SlotProps, ExternalForwardedProps, ExternalSlotProps, AdditionalProps, OwnerState>(parameters: UseSlotPropsParameters<ElementType, SlotProps, ExternalForwardedProps, WithCommonProps<ExternalSlotProps>, WithCommonProps<AdditionalProps>, OwnerState>): import("@mui/types").Simplify<import("@mui/types").Simplify<SlotProps & Record<string, unknown> & AdditionalProps & {
    className?: string | undefined;
    style?: React.CSSProperties | undefined;
    ref?: React.Ref<any> | undefined;
} & {
    className?: string | undefined;
    style?: React.CSSProperties | undefined;
}> & {
    ref: React.Ref<any>;
} & {
    ownerState: ElementType extends React.ComponentType<any> ? OwnerState : ElementType extends keyof JSX.IntrinsicElements ? undefined : OwnerState | undefined;
}>;
