import _objectWithoutPropertiesLoose from "@babel/runtime/helpers/esm/objectWithoutPropertiesLoose";
import _extends from "@babel/runtime/helpers/esm/extends";
const _excluded = ["className", "hasSelected", "isInner", "type", "value"];
import * as React from 'react';
import { styled } from '@mui/material/styles';
import { CLOCK_WIDTH, CLOCK_HOUR_WIDTH } from './shared';
import { jsx as _jsx } from "react/jsx-runtime";
const ClockPointerRoot = styled('div')(({
  theme,
  ownerState
}) => _extends({
  width: 2,
  backgroundColor: theme.palette.primary.main,
  position: 'absolute',
  left: 'calc(50% - 1px)',
  bottom: '50%',
  transformOrigin: 'center bottom 0px'
}, ownerState.toAnimateTransform && {
  transition: theme.transitions.create(['transform', 'height'])
}));
const ClockPointerThumb = styled('div')(({
  theme,
  ownerState
}) => _extends({
  width: 4,
  height: 4,
  backgroundColor: theme.palette.primary.contrastText,
  borderRadius: '50%',
  position: 'absolute',
  top: -21,
  left: `calc(50% - ${CLOCK_HOUR_WIDTH / 2}px)`,
  border: `${(CLOCK_HOUR_WIDTH - 4) / 2}px solid ${theme.palette.primary.main}`,
  boxSizing: 'content-box'
}, ownerState.hasSelected && {
  backgroundColor: theme.palette.primary.main
}));
/**
 * @ignore - internal component.
 * TODO: Remove class
 */

export class ClockPointer extends React.Component {
  constructor(...args) {
    super(...args);
    this.state = {
      toAnimateTransform: false,
      previousType: undefined
    };
  }

  render() {
    const _this$props = this.props,
          {
      className,
      isInner,
      type,
      value
    } = _this$props,
          other = _objectWithoutPropertiesLoose(_this$props, _excluded);

    const ownerState = _extends({}, this.props, this.state);

    const getAngleStyle = () => {
      const max = type === 'hours' ? 12 : 60;
      let angle = 360 / max * value;

      if (type === 'hours' && value > 12) {
        angle -= 360; // round up angle to max 360 degrees
      }

      return {
        height: Math.round((isInner ? 0.26 : 0.4) * CLOCK_WIDTH),
        transform: `rotateZ(${angle}deg)`
      };
    };

    return /*#__PURE__*/_jsx(ClockPointerRoot, _extends({
      style: getAngleStyle(),
      className: className,
      ownerState: ownerState
    }, other, {
      children: /*#__PURE__*/_jsx(ClockPointerThumb, {
        ownerState: ownerState
      })
    }));
  }

}

ClockPointer.getDerivedStateFromProps = (nextProps, state) => {
  if (nextProps.type !== state.previousType) {
    return {
      toAnimateTransform: true,
      previousType: nextProps.type
    };
  }

  return {
    toAnimateTransform: false,
    previousType: nextProps.type
  };
};