"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PickersModalDialog = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var React = _interopRequireWildcard(require("react"));

var _Button = _interopRequireDefault(require("@mui/material/Button"));

var _DialogActions = _interopRequireDefault(require("@mui/material/DialogActions"));

var _DialogContent = _interopRequireDefault(require("@mui/material/DialogContent"));

var _Dialog = _interopRequireWildcard(require("@mui/material/Dialog"));

var _styles = require("@mui/material/styles");

var _dimensions = require("../constants/dimensions");

var _jsxRuntime = require("react/jsx-runtime");

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

const PickersModalDialogRoot = (0, _styles.styled)(_Dialog.default)({
  [`& .${_Dialog.dialogClasses.container}`]: {
    outline: 0
  },
  [`& .${_Dialog.dialogClasses.paper}`]: {
    outline: 0,
    minWidth: _dimensions.DIALOG_WIDTH
  }
});
const PickersModalDialogContent = (0, _styles.styled)(_DialogContent.default)({
  '&:first-of-type': {
    padding: 0
  }
});
const PickersModalDialogActions = (0, _styles.styled)(_DialogActions.default)(({
  ownerState
}) => (0, _extends2.default)({}, (ownerState.clearable || ownerState.showTodayButton) && {
  // set justifyContent to default value to fix IE11 layout bug
  // see https://github.com/mui-org/material-ui-pickers/pull/267
  justifyContent: 'flex-start',
  '& > *:first-of-type': {
    marginRight: 'auto'
  }
}));

const PickersModalDialog = props => {
  const {
    cancelText = 'Cancel',
    children,
    clearable = false,
    clearText = 'Clear',
    DialogProps = {},
    okText = 'OK',
    onAccept,
    onClear,
    onDismiss,
    onSetToday,
    open,
    showTodayButton = false,
    todayText = 'Today'
  } = props;
  const ownerState = props;
  return /*#__PURE__*/(0, _jsxRuntime.jsxs)(PickersModalDialogRoot, (0, _extends2.default)({
    open: open,
    onClose: onDismiss
  }, DialogProps, {
    children: [/*#__PURE__*/(0, _jsxRuntime.jsx)(PickersModalDialogContent, {
      children: children
    }), /*#__PURE__*/(0, _jsxRuntime.jsxs)(PickersModalDialogActions, {
      ownerState: ownerState,
      children: [clearable && /*#__PURE__*/(0, _jsxRuntime.jsx)(_Button.default, {
        onClick: onClear,
        children: clearText
      }), showTodayButton && /*#__PURE__*/(0, _jsxRuntime.jsx)(_Button.default, {
        onClick: onSetToday,
        children: todayText
      }), cancelText && /*#__PURE__*/(0, _jsxRuntime.jsx)(_Button.default, {
        onClick: onDismiss,
        children: cancelText
      }), okText && /*#__PURE__*/(0, _jsxRuntime.jsx)(_Button.default, {
        onClick: onAccept,
        children: okText
      })]
    })]
  }));
};

exports.PickersModalDialog = PickersModalDialog;