import _extends from "@babel/runtime/helpers/esm/extends";
import * as React from 'react';
import areArraysEqual from '../utils/areArraysEqual';
/**
 * Gets the current state. If the selectedValue is controlled,
 * the `value` prop is the source of truth instead of the internal state.
 */

function getControlledState(internalState, props) {
  if (props.value !== undefined) {
    return _extends({}, internalState, {
      selectedValue: props.value
    });
  }

  return internalState;
}

function areOptionsEqual(option1, option2, optionComparer) {
  if (option1 === option2) {
    return true;
  }

  if (option1 === null || option2 === null) {
    return false;
  }

  return optionComparer(option1, option2);
}
/**
 * Triggers change event handlers when reducer returns changed state.
 */


function useStateChangeDetection(nextState, internalPreviousState, propsRef) {
  React.useEffect(function () {
    if (!propsRef.current) {
      return;
    }

    var previousState = getControlledState(internalPreviousState, propsRef.current);
    var _propsRef$current = propsRef.current,
        multiple = _propsRef$current.multiple,
        optionComparer = _propsRef$current.optionComparer;

    if (multiple) {
      var _previousState$select;

      var previousSelectedValues = (_previousState$select = previousState == null ? void 0 : previousState.selectedValue) != null ? _previousState$select : [];
      var nextSelectedValues = nextState.selectedValue;
      var onChange = propsRef.current.onChange;

      if (!areArraysEqual(nextSelectedValues, previousSelectedValues, optionComparer)) {
        onChange == null ? void 0 : onChange(nextSelectedValues);
      }
    } else {
      var previousSelectedValue = previousState == null ? void 0 : previousState.selectedValue;
      var nextSelectedValue = nextState.selectedValue;
      var _onChange = propsRef.current.onChange;

      if (!areOptionsEqual(nextSelectedValue, previousSelectedValue, optionComparer)) {
        _onChange == null ? void 0 : _onChange(nextSelectedValue);
      }
    }
  }, [nextState.selectedValue, internalPreviousState, propsRef]);
  React.useEffect(function () {
    if (!propsRef.current) {
      return;
    } // Fires the highlightChange event when reducer returns changed `highlightedValue`.


    if (!areOptionsEqual(internalPreviousState.highlightedValue, nextState.highlightedValue, propsRef.current.optionComparer)) {
      var _propsRef$current2, _propsRef$current2$on;

      (_propsRef$current2 = propsRef.current) == null ? void 0 : (_propsRef$current2$on = _propsRef$current2.onHighlightChange) == null ? void 0 : _propsRef$current2$on.call(_propsRef$current2, nextState.highlightedValue);
    }
  }, [nextState.highlightedValue, internalPreviousState.highlightedValue, propsRef]);
}

export default function useControllableReducer(internalReducer, externalReducer, props) {
  var _ref;

  var value = props.value,
      defaultValue = props.defaultValue;
  var propsRef = React.useRef(props);
  propsRef.current = props;
  var initialSelectedValue = (_ref = value === undefined ? defaultValue : value) != null ? _ref : props.multiple ? [] : null;
  var initalState = {
    highlightedValue: null,
    selectedValue: initialSelectedValue
  };
  var combinedReducer = React.useCallback(function (state, action) {
    if (externalReducer) {
      return externalReducer(getControlledState(state, propsRef.current), action);
    }

    return internalReducer(getControlledState(state, propsRef.current), action);
  }, [externalReducer, internalReducer, propsRef]);

  var _React$useReducer = React.useReducer(combinedReducer, initalState),
      nextState = _React$useReducer[0],
      dispatch = _React$useReducer[1];

  var previousState = React.useRef(initalState);
  React.useEffect(function () {
    previousState.current = nextState;
  }, [previousState, nextState]);
  useStateChangeDetection(nextState, previousState.current, propsRef);
  return [getControlledState(nextState, propsRef.current), dispatch];
}