import _extends from "@babel/runtime/helpers/esm/extends";
import merge from './merge';

function compose() {
  for (var _len = arguments.length, styles = new Array(_len), _key = 0; _key < _len; _key++) {
    styles[_key] = arguments[_key];
  }

  var handlers = styles.reduce(function (acc, style) {
    style.filterProps.forEach(function (prop) {
      acc[prop] = style;
    });
    return acc;
  }, {});

  var fn = function fn(props) {
    return Object.keys(props).reduce(function (acc, prop) {
      if (handlers[prop]) {
        return merge(acc, handlers[prop](props));
      }

      return acc;
    }, {});
  };

  fn.propTypes = process.env.NODE_ENV !== 'production' ? styles.reduce(function (acc, style) {
    return _extends(acc, style.propTypes);
  }, {}) : {};
  fn.filterProps = styles.reduce(function (acc, style) {
    return acc.concat(style.filterProps);
  }, []);
  return fn;
}

export default compose;