"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DesktopTooltipWrapper = DesktopTooltipWrapper;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var React = _interopRequireWildcard(require("react"));

var _utils = require("@mui/material/utils");

var _WrapperVariantContext = require("./WrapperVariantContext");

var _utils2 = require("../../utils/utils");

var _PickersPopper = require("../PickersPopper");

var _jsxRuntime = require("react/jsx-runtime");

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function DesktopTooltipWrapper(props) {
  const {
    children,
    DateInputProps,
    KeyboardDateInputComponent,
    open,
    PopperProps,
    PaperProps,
    TransitionComponent,
    onClear,
    onDismiss,
    onCancel,
    onAccept,
    onSetToday,
    components,
    componentsProps
  } = props;
  const inputContainerRef = React.useRef(null);
  const popperRef = React.useRef(null);

  const handleBlur = () => {
    (0, _utils2.executeInTheNextEventLoopTick)(() => {
      var _inputContainerRef$cu, _popperRef$current;

      if ((_inputContainerRef$cu = inputContainerRef.current) != null && _inputContainerRef$cu.contains(document.activeElement) || (_popperRef$current = popperRef.current) != null && _popperRef$current.contains(document.activeElement)) {
        return;
      }

      onDismiss();
    });
  };

  const inputComponentRef = (0, _utils.useForkRef)(DateInputProps.ref, inputContainerRef);
  return /*#__PURE__*/(0, _jsxRuntime.jsxs)(_WrapperVariantContext.WrapperVariantContext.Provider, {
    value: "desktop",
    children: [/*#__PURE__*/(0, _jsxRuntime.jsx)(KeyboardDateInputComponent, (0, _extends2.default)({}, DateInputProps, {
      ref: inputComponentRef,
      onBlur: handleBlur
    })), /*#__PURE__*/(0, _jsxRuntime.jsx)(_PickersPopper.PickersPopper, {
      role: "tooltip",
      open: open,
      containerRef: popperRef,
      anchorEl: inputContainerRef.current,
      TransitionComponent: TransitionComponent,
      PopperProps: PopperProps,
      PaperProps: PaperProps,
      onBlur: handleBlur,
      onClose: onDismiss,
      onClear: onClear,
      onCancel: onCancel,
      onAccept: onAccept,
      onSetToday: onSetToday,
      components: components,
      componentsProps: componentsProps,
      children: children
    })]
  });
}