/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.core.io;

import com.ustadmobile.core.io.ConcatenatedDataIntegrityException;
import com.ustadmobile.door.util.NullOutputStream;
import io.github.aakira.napier.Napier;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.util.zip.GZIPInputStream;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.GlobalScope;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0013\u001a\u00020\u0006J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\nJ\"\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u00062\b\b\u0002\u0010\u0019\u001a\u00020\u001a2\b\b\u0002\u0010\u001b\u001a\u00020\u001aR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/ustadmobile/core/io/GzipMessageDigest;", "", "messageDigest", "Ljava/security/MessageDigest;", "(Ljava/security/MessageDigest;)V", "buf", "", "getBuf", "()[B", "inflate", "", "getMessageDigest", "()Ljava/security/MessageDigest;", "pipeIn", "Ljava/io/PipedInputStream;", "pipeOut", "Ljava/io/PipedOutputStream;", "readJob", "Lkotlinx/coroutines/Job;", "digest", "reset", "", "inflateEnabled", "update", "byteArray", "offset", "", "len", "core"})
public final class GzipMessageDigest {
    @NotNull
    private final MessageDigest messageDigest;
    @NotNull
    private final byte[] buf;
    private volatile PipedOutputStream pipeOut;
    private volatile PipedInputStream pipeIn;
    private volatile boolean inflate;
    @Nullable
    private volatile Job readJob;

    public GzipMessageDigest(@NotNull MessageDigest messageDigest) {
        Intrinsics.checkNotNullParameter((Object)messageDigest, (String)"messageDigest");
        this.messageDigest = messageDigest;
        this.buf = new byte[8192];
    }

    @NotNull
    public final MessageDigest getMessageDigest() {
        return this.messageDigest;
    }

    @NotNull
    public final byte[] getBuf() {
        return this.buf;
    }

    public final void reset(boolean inflateEnabled) {
        this.pipeOut = new PipedOutputStream();
        PipedOutputStream pipedOutputStream = this.pipeOut;
        if (pipedOutputStream == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"pipeOut");
            pipedOutputStream = null;
        }
        this.pipeIn = new PipedInputStream(pipedOutputStream);
        this.inflate = inflateEnabled;
        this.messageDigest.reset();
    }

    public final void update(@NotNull byte[] byteArray, int offset, int len) {
        Intrinsics.checkNotNullParameter((Object)byteArray, (String)"byteArray");
        boolean inflateEnabled = this.inflate;
        if (this.readJob == null) {
            this.readJob = BuildersKt.launch$default((CoroutineScope)((CoroutineScope)GlobalScope.INSTANCE), (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(inflateEnabled, this, null){
                int label;
                final /* synthetic */ boolean $inflateEnabled;
                final /* synthetic */ GzipMessageDigest this$0;
                {
                    this.$inflateEnabled = $inflateEnabled;
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            InputStream inputStream;
                            ResultKt.throwOnFailure((Object)object);
                            if (this.$inflateEnabled) {
                                PipedInputStream pipedInputStream = GzipMessageDigest.access$getPipeIn$p(this.this$0);
                                if (pipedInputStream == null) {
                                    Intrinsics.throwUninitializedPropertyAccessException((String)"pipeIn");
                                    pipedInputStream = null;
                                }
                                inputStream = new GZIPInputStream(pipedInputStream);
                            } else {
                                PipedInputStream pipedInputStream = GzipMessageDigest.access$getPipeIn$p(this.this$0);
                                if (pipedInputStream == null) {
                                    Intrinsics.throwUninitializedPropertyAccessException((String)"pipeIn");
                                    pipedInputStream = null;
                                }
                                inputStream = pipedInputStream;
                            }
                            InputStream digestInput = inputStream;
                            Closeable closeable = new DigestInputStream(digestInput, this.this$0.getMessageDigest());
                            GzipMessageDigest gzipMessageDigest = this.this$0;
                            Throwable throwable = null;
                            try {
                                DigestInputStream it = (DigestInputStream)closeable;
                                boolean bl = false;
                                try {
                                    ByteStreamsKt.copyTo$default((InputStream)it, (OutputStream)((OutputStream)new NullOutputStream()), (int)0, (int)2, null);
                                }
                                catch (IOException e) {
                                    Napier.e$default((Napier)Napier.INSTANCE, (String)"GzipMessageDigest: Exception reading bytes for digest", (Throwable)e, null, (int)4, null);
                                    PipedOutputStream pipedOutputStream = GzipMessageDigest.access$getPipeOut$p(gzipMessageDigest);
                                    if (pipedOutputStream == null) {
                                        Intrinsics.throwUninitializedPropertyAccessException((String)"pipeOut");
                                        pipedOutputStream = null;
                                    }
                                    pipedOutputStream.close();
                                }
                                Unit unit = Unit.INSTANCE;
                            }
                            catch (Throwable throwable2) {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            finally {
                                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                            }
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)2, null);
        }
        try {
            PipedOutputStream pipedOutputStream = this.pipeOut;
            if (pipedOutputStream == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"pipeOut");
                pipedOutputStream = null;
            }
            pipedOutputStream.write(byteArray, offset, len);
        }
        catch (IOException e) {
            throw new ConcatenatedDataIntegrityException("GzipMessageDigest: exception writing to digest pipe (data is probably corrupted)", e);
        }
    }

    public static /* synthetic */ void update$default(GzipMessageDigest gzipMessageDigest, byte[] byArray, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = byArray.length;
        }
        gzipMessageDigest.update(byArray, n, n2);
    }

    @NotNull
    public final byte[] digest() {
        PipedOutputStream pipedOutputStream = this.pipeOut;
        if (pipedOutputStream == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"pipeOut");
            pipedOutputStream = null;
        }
        pipedOutputStream.flush();
        PipedOutputStream pipedOutputStream2 = this.pipeOut;
        if (pipedOutputStream2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"pipeOut");
            pipedOutputStream2 = null;
        }
        pipedOutputStream2.close();
        BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ GzipMessageDigest this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                block5: {
                    var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            v0 = GzipMessageDigest.access$getReadJob$p(this.this$0);
                            if (v0 == null) break;
                            this.label = 1;
                            v1 = v0.join((Continuation)this);
                            if (v1 == var2_2) {
                                return var2_2;
                            }
                            ** GOTO lbl15
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            v1 = $result;
lbl15:
                            // 2 sources

                            v2 = Unit.INSTANCE;
                            break block5;
                        }
                    }
                    v2 = null;
                }
                return v2;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
        this.readJob = null;
        byte[] byArray = this.messageDigest.digest();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"messageDigest.digest()");
        return byArray;
    }

    public static final /* synthetic */ PipedInputStream access$getPipeIn$p(GzipMessageDigest $this) {
        return $this.pipeIn;
    }

    public static final /* synthetic */ PipedOutputStream access$getPipeOut$p(GzipMessageDigest $this) {
        return $this.pipeOut;
    }

    public static final /* synthetic */ Job access$getReadJob$p(GzipMessageDigest $this) {
        return $this.readJob;
    }
}

