/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.core.contentformats.epub.nav;

import com.ustadmobile.core.util.UMFileUtil;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0015\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u0000 +2\u00020\u0001:\u0001+B\u0019\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B+\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\tJ\u000e\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0000J\u000e\u0010#\u001a\u00020\u00002\u0006\u0010$\u001a\u00020\u0004J\u000e\u0010%\u001a\n\u0012\u0004\u0012\u00020\u0000\u0018\u00010\u000bJ\u0006\u0010&\u001a\u00020'J\u0014\u0010(\u001a\u00020!2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00000\u000bJ\u0006\u0010)\u001a\u00020\u0004J\b\u0010*\u001a\u00020\u0007H\u0016R\u0016\u0010\n\u001a\n\u0012\u0004\u0012\u00020\u0000\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001c\u0010\b\u001a\u0004\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001c\u0010\u0014\u001a\u0004\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0011\"\u0004\b\u0016\u0010\u0013R\u001c\u0010\u0017\u001a\u0004\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0011\"\u0004\b\u0019\u0010\u0013R\u001c\u0010\u0002\u001a\u0004\u0018\u00010\u0000X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u0011\"\u0004\b\u001f\u0010\u0013\u00a8\u0006,"}, d2={"Lcom/ustadmobile/core/contentformats/epub/nav/EpubNavItem;", "", "parent", "depth", "", "(Lcom/ustadmobile/core/contentformats/epub/nav/EpubNavItem;I)V", "title", "", "href", "(Ljava/lang/String;Ljava/lang/String;Lcom/ustadmobile/core/contentformats/epub/nav/EpubNavItem;I)V", "children", "", "getDepth", "()I", "setDepth", "(I)V", "getHref", "()Ljava/lang/String;", "setHref", "(Ljava/lang/String;)V", "id", "getId", "setId", "navElEpubTypeAttr", "getNavElEpubTypeAttr", "setNavElEpubTypeAttr", "getParent", "()Lcom/ustadmobile/core/contentformats/epub/nav/EpubNavItem;", "setParent", "(Lcom/ustadmobile/core/contentformats/epub/nav/EpubNavItem;)V", "getTitle", "setTitle", "addChild", "", "child", "getChild", "index", "getChildren", "hasChildren", "", "setChildren", "size", "toString", "Companion", "core"})
public final class EpubNavItem {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private String title;
    @Nullable
    private String href;
    @Nullable
    private EpubNavItem parent;
    private int depth;
    @Nullable
    private String id;
    @Nullable
    private List<EpubNavItem> children;
    @Nullable
    private String navElEpubTypeAttr;

    public EpubNavItem(@Nullable String title, @Nullable String href, @Nullable EpubNavItem parent, int depth) {
        this.title = title;
        this.href = href;
        this.parent = parent;
        this.depth = depth;
        if (this.parent != null) {
            EpubNavItem epubNavItem = this.parent;
            Intrinsics.checkNotNull((Object)epubNavItem);
            epubNavItem.addChild(this);
        }
    }

    @Nullable
    public final String getTitle() {
        return this.title;
    }

    public final void setTitle(@Nullable String string) {
        this.title = string;
    }

    @Nullable
    public final String getHref() {
        return this.href;
    }

    public final void setHref(@Nullable String string) {
        this.href = string;
    }

    @Nullable
    public final EpubNavItem getParent() {
        return this.parent;
    }

    public final void setParent(@Nullable EpubNavItem epubNavItem) {
        this.parent = epubNavItem;
    }

    public final int getDepth() {
        return this.depth;
    }

    public final void setDepth(int n) {
        this.depth = n;
    }

    @Nullable
    public final String getId() {
        return this.id;
    }

    public final void setId(@Nullable String string) {
        this.id = string;
    }

    @Nullable
    public final String getNavElEpubTypeAttr() {
        return this.navElEpubTypeAttr;
    }

    public final void setNavElEpubTypeAttr(@Nullable String string) {
        this.navElEpubTypeAttr = string;
    }

    public EpubNavItem(@Nullable EpubNavItem parent, int depth) {
        this(null, null, parent, depth);
    }

    @Nullable
    public final List<EpubNavItem> getChildren() {
        return this.children;
    }

    public final void setChildren(@NotNull List<EpubNavItem> children) {
        Intrinsics.checkNotNullParameter(children, (String)"children");
        this.children = children;
    }

    @NotNull
    public String toString() {
        StringBuilder sb = new StringBuilder();
        int n = this.depth;
        for (int i = 0; i < n; ++i) {
            sb.append(' ');
        }
        String string = sb.append(this.title).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.append(title).toString()");
        return string;
    }

    public final void addChild(@NotNull EpubNavItem child) {
        Intrinsics.checkNotNullParameter((Object)child, (String)"child");
        if (this.children == null) {
            this.children = new ArrayList();
        }
        List<EpubNavItem> list = this.children;
        Intrinsics.checkNotNull(list);
        list.add(child);
    }

    public final int size() {
        int n;
        if (this.children != null) {
            List<EpubNavItem> list = this.children;
            Intrinsics.checkNotNull(list);
            n = list.size();
        } else {
            n = 0;
        }
        return n;
    }

    @NotNull
    public final EpubNavItem getChild(int index) {
        List<EpubNavItem> list = this.children;
        Intrinsics.checkNotNull(list);
        return list.get(index);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean hasChildren() {
        if (this.children == null) return false;
        List<EpubNavItem> list = this.children;
        Intrinsics.checkNotNull(list);
        if (list.isEmpty()) return false;
        return true;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\b\u00a8\u0006\t"}, d2={"Lcom/ustadmobile/core/contentformats/epub/nav/EpubNavItem$Companion;", "", "()V", "findItemInVectorByHref", "", "href", "", "vector", "", "core"})
    public static final class Companion {
        private Companion() {
        }

        public final int findItemInVectorByHref(@NotNull String href, @NotNull List<?> vector) {
            Intrinsics.checkNotNullParameter((Object)href, (String)"href");
            Intrinsics.checkNotNullParameter(vector, (String)"vector");
            String itemHref = null;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                Object obj = vector.get(i);
                Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type com.ustadmobile.core.contentformats.epub.nav.EpubNavItem");
                itemHref = ((EpubNavItem)obj).getHref();
                if (itemHref == null || !Intrinsics.areEqual((Object)UMFileUtil.INSTANCE.stripAnchorIfPresent(itemHref), (Object)href)) continue;
                return i;
            }
            return -1;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

