/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.core.io;

import com.ustadmobile.core.io.ConcatenatedDataIntegrityException;
import com.ustadmobile.core.io.ConcatenatedEntry;
import com.ustadmobile.core.io.GzipMessageDigest;
import com.ustadmobile.core.io.ext.ConcatenatedEntryExtKt;
import com.ustadmobile.door.ext.ByteArrayExtKt;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0012H\u0002J\b\u0010\u0014\u001a\u00020\u0012H\u0016J\u000e\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\nJ\u0010\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u000eH\u0016J \u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001aH\u0016J\u0010\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u001aH\u0016R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001d"}, d2={"Lcom/ustadmobile/core/io/ConcatenatedOutputStream2;", "Ljava/io/FilterOutputStream;", "outputStream", "Ljava/io/OutputStream;", "messageDigest", "Ljava/security/MessageDigest;", "verifyMd5", "", "(Ljava/io/OutputStream;Ljava/security/MessageDigest;Z)V", "currentEntry", "Lcom/ustadmobile/core/io/ConcatenatedEntry;", "inflateMessageDigest", "Lcom/ustadmobile/core/io/GzipMessageDigest;", "oneByteBuffer", "", "getVerifyMd5$core_release", "()Z", "assertHasCurrentEntry", "", "assertMd5MatchesCurrentEntry", "close", "putNextEntry", "entry", "write", "buf", "offset", "", "len", "p0", "core_release"})
public final class ConcatenatedOutputStream2
extends FilterOutputStream {
    private final boolean verifyMd5;
    @Nullable
    private ConcatenatedEntry currentEntry;
    @NotNull
    private final GzipMessageDigest inflateMessageDigest;
    @NotNull
    private final byte[] oneByteBuffer;

    public ConcatenatedOutputStream2(@NotNull OutputStream outputStream, @NotNull MessageDigest messageDigest, boolean verifyMd5) {
        Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
        Intrinsics.checkNotNullParameter((Object)messageDigest, (String)"messageDigest");
        super(outputStream);
        this.verifyMd5 = verifyMd5;
        this.inflateMessageDigest = new GzipMessageDigest(messageDigest);
        this.oneByteBuffer = new byte[1];
    }

    public /* synthetic */ ConcatenatedOutputStream2(OutputStream outputStream, MessageDigest messageDigest, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            MessageDigest messageDigest2 = MessageDigest.getInstance("MD5");
            Intrinsics.checkNotNullExpressionValue((Object)messageDigest2, (String)"getInstance(\"MD5\")");
            messageDigest = messageDigest2;
        }
        if ((n & 4) != 0) {
            bl = true;
        }
        this(outputStream, messageDigest, bl);
    }

    public final boolean getVerifyMd5$core_release() {
        return this.verifyMd5;
    }

    private final void assertHasCurrentEntry() {
        if (this.currentEntry == null) {
            throw new IOException("ConcatenatedOutputStream2: No current entry: you must call putNextEntry before writing");
        }
    }

    private final void assertMd5MatchesCurrentEntry() {
        ConcatenatedEntry concatenatedEntry = this.currentEntry;
        if (concatenatedEntry == null) {
            throw new IOException("No current entry to verify against.");
        }
        ConcatenatedEntry entryVal = concatenatedEntry;
        byte[] currentMd5 = this.inflateMessageDigest.digest();
        if (!this.verifyMd5) {
            return;
        }
        if (!Arrays.equals(currentMd5, entryVal.getMd5())) {
            throw new ConcatenatedDataIntegrityException("MD5 provided for entry " + ByteArrayExtKt.toHexString((byte[])entryVal.getMd5()) + " does not match the MD5 of the data written " + ByteArrayExtKt.toHexString((byte[])currentMd5) + '!', null, 2, null);
        }
    }

    @Override
    public void write(int p0) {
        this.assertHasCurrentEntry();
        this.oneByteBuffer[0] = (byte)p0;
        GzipMessageDigest.update$default(this.inflateMessageDigest, this.oneByteBuffer, 0, 0, 6, null);
        this.out.write(p0);
    }

    @Override
    public void write(@NotNull byte[] buf) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        this.write(buf, 0, buf.length);
    }

    @Override
    public void write(@NotNull byte[] buf, int offset, int len) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        this.assertHasCurrentEntry();
        this.inflateMessageDigest.update(buf, offset, len);
        this.out.write(buf, offset, len);
    }

    public final void putNextEntry(@NotNull ConcatenatedEntry entry2) {
        Intrinsics.checkNotNullParameter((Object)entry2, (String)"entry");
        if (this.currentEntry != null) {
            this.assertMd5MatchesCurrentEntry();
        }
        this.out.write(ConcatenatedEntryExtKt.toBytes(entry2));
        this.currentEntry = entry2;
        this.inflateMessageDigest.reset(entry2.isCompressed());
    }

    @Override
    public void close() {
        this.assertMd5MatchesCurrentEntry();
        super.close();
    }
}

