/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.core.io;

import com.ustadmobile.core.io.ConcatenatedDataIntegrityException;
import com.ustadmobile.core.io.ConcatenatedEntry;
import com.ustadmobile.core.io.GzipMessageDigest;
import com.ustadmobile.core.io.ext.ConcatenatedEntryExtKt;
import com.ustadmobile.core.io.ext.InputStreamExtKt;
import com.ustadmobile.door.ext.ByteArrayExtKt;
import com.ustadmobile.door.util.NullOutputStream;
import io.github.aakira.napier.Napier;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.io.ByteStreamsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0010\u001a\u00020\u0011H\u0002J\b\u0010\u0012\u001a\u00020\u0011H\u0016J\b\u0010\u0013\u001a\u0004\u0018\u00010\bJ\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\nH\u0016J \u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0015H\u0016J\b\u0010\u0019\u001a\u00020\u0011H\u0002J\u0006\u0010\u001a\u001a\u00020\u0011R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/ustadmobile/core/io/ConcatenatedInputStream2;", "Ljava/io/FilterInputStream;", "inputStream", "Ljava/io/InputStream;", "messageDigest", "Ljava/security/MessageDigest;", "(Ljava/io/InputStream;Ljava/security/MessageDigest;)V", "currentEntry", "Lcom/ustadmobile/core/io/ConcatenatedEntry;", "currentEntryReadMd5", "", "entryRemaining", "", "inflateMessageDigest", "Lcom/ustadmobile/core/io/GzipMessageDigest;", "oneByteBuffer", "assertDataReadMatchesMd5", "", "close", "getNextEntry", "read", "", "buf", "offset", "len", "readCurrentEntryRemaining", "verifyCurrentEntryCompleted", "core_debug"})
public final class ConcatenatedInputStream2
extends FilterInputStream {
    @Nullable
    private ConcatenatedEntry currentEntry;
    private long entryRemaining;
    @NotNull
    private final GzipMessageDigest inflateMessageDigest;
    @NotNull
    private final byte[] oneByteBuffer;
    @Nullable
    private byte[] currentEntryReadMd5;

    public ConcatenatedInputStream2(@NotNull InputStream inputStream, @NotNull MessageDigest messageDigest) {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        Intrinsics.checkNotNullParameter((Object)messageDigest, (String)"messageDigest");
        super(inputStream);
        this.entryRemaining = -1L;
        this.inflateMessageDigest = new GzipMessageDigest(messageDigest);
        this.oneByteBuffer = new byte[1];
    }

    public /* synthetic */ ConcatenatedInputStream2(InputStream inputStream, MessageDigest messageDigest, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            MessageDigest messageDigest2 = MessageDigest.getInstance("MD5");
            Intrinsics.checkNotNullExpressionValue((Object)messageDigest2, (String)"getInstance(\"MD5\")");
            messageDigest = messageDigest2;
        }
        this(inputStream, messageDigest);
    }

    private final void assertDataReadMatchesMd5() {
        byte[] dataMd5;
        ConcatenatedEntry concatenatedEntry = this.currentEntry;
        if (concatenatedEntry == null) {
            throw new IOException("No current entry: cannot verify data");
        }
        ConcatenatedEntry entryVal = concatenatedEntry;
        byte[] byArray = this.currentEntryReadMd5;
        if (this.currentEntryReadMd5 == null) {
            byArray = this.inflateMessageDigest.digest();
        }
        if (!Arrays.equals(dataMd5 = byArray, entryVal.getMd5())) {
            throw new ConcatenatedDataIntegrityException("Data read was corrupted: md5 does not match! Expected MD5: " + ByteArrayExtKt.toHexString((byte[])entryVal.getMd5()) + " / Actual " + ByteArrayExtKt.toHexString((byte[])dataMd5), null, 2, null);
        }
        this.currentEntryReadMd5 = dataMd5;
    }

    private final void readCurrentEntryRemaining() {
        if (this.entryRemaining > 0L) {
            ByteStreamsKt.copyTo$default((InputStream)this, (OutputStream)((OutputStream)new NullOutputStream()), (int)0, (int)2, null);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void verifyCurrentEntryCompleted() {
        String string2;
        if (this.entryRemaining == 0L) {
            this.assertDataReadMatchesMd5();
            return;
        }
        StringBuilder stringBuilder = new StringBuilder().append("verifyCurrentEntryCompleted: entry ");
        Object object = this.currentEntry;
        if (object != null) {
            byte[] byArray = ((ConcatenatedEntry)object).getMd5();
            object = byArray;
            if (byArray != null) {
                string2 = ByteArrayExtKt.toHexString((byte[])object);
                throw new IOException(stringBuilder.append(string2).append(" is not completed").toString());
            }
        }
        string2 = null;
        throw new IOException(stringBuilder.append(string2).append(" is not completed").toString());
    }

    /*
     * Enabled aggressive block sorting
     */
    @Nullable
    public final ConcatenatedEntry getNextEntry() {
        this.readCurrentEntryRemaining();
        if (this.entryRemaining > 0L) {
            String string2;
            StringBuilder stringBuilder = new StringBuilder().append("Premature end of stream: ");
            Object object = this.currentEntry;
            if (object != null) {
                byte[] byArray = ((ConcatenatedEntry)object).getMd5();
                object = byArray;
                if (byArray != null) {
                    string2 = ByteArrayExtKt.toHexString((byte[])object);
                    throw new IOException(stringBuilder.append(string2).append(" has ").append(this.entryRemaining).append(" bytes unread").toString());
                }
            }
            string2 = null;
            throw new IOException(stringBuilder.append(string2).append(" has ").append(this.entryRemaining).append(" bytes unread").toString());
        }
        if (this.currentEntry != null) {
            this.assertDataReadMatchesMd5();
        }
        this.currentEntryReadMd5 = null;
        byte[] entryBuf = new byte[41];
        InputStream inputStream = this.in;
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"super.`in`");
        int bytesRead = InputStreamExtKt.readFully(inputStream, entryBuf, 0, entryBuf.length);
        if (bytesRead == entryBuf.length) {
            ConcatenatedEntry nextEntry = ConcatenatedEntryExtKt.toConcatenatedEntry(entryBuf);
            this.entryRemaining = nextEntry.getCompressedSize();
            this.inflateMessageDigest.reset(nextEntry.isCompressed());
            this.currentEntry = nextEntry;
            return nextEntry;
        }
        this.entryRemaining = 0L;
        this.currentEntry = null;
        return null;
    }

    @Override
    public int read(@NotNull byte[] buf) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        return this.read(buf, 0, buf.length);
    }

    @Override
    public int read() {
        if (this.entryRemaining > 0L) {
            int byteRead = super.read();
            this.oneByteBuffer[0] = (byte)byteRead;
            GzipMessageDigest.update$default(this.inflateMessageDigest, this.oneByteBuffer, 0, 0, 6, null);
            long l = this.entryRemaining;
            this.entryRemaining = l + -1L;
            if (this.entryRemaining == 0L) {
                this.assertDataReadMatchesMd5();
            }
            return byteRead;
        }
        return -1;
    }

    @Override
    public int read(@NotNull byte[] buf, int offset, int len) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        int lenToRead = Integer.min(len, (int)this.entryRemaining);
        if (lenToRead == 0) {
            return -1;
        }
        int bytesRead = super.read(buf, offset, lenToRead);
        if (bytesRead != -1) {
            this.inflateMessageDigest.update(buf, offset, bytesRead);
            this.entryRemaining -= (long)bytesRead;
        }
        if (this.entryRemaining == 0L) {
            this.assertDataReadMatchesMd5();
        }
        return bytesRead;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void close() {
        block4: {
            v0 = new StringBuilder().append("ConcatenatedInputStream: entry ");
            v1 = this.currentEntry;
            if (v1 == null) ** GOTO lbl-1000
            v2 = v1.getMd5();
            v1 = v2;
            if (v2 != null) {
                v3 = ByteArrayExtKt.toHexString((byte[])v1);
            } else lbl-1000:
            // 2 sources

            {
                v3 = null;
            }
            Napier.d$default((Napier)Napier.INSTANCE, (String)v0.append(v3).append(" : close").toString(), null, null, (int)6, null);
            this.readCurrentEntryRemaining();
            if (this.currentEntry == null || this.entryRemaining != 0L) break block4;
            v4 = new StringBuilder().append("ConcatenatedInputStream: entry ");
            v5 = this.currentEntry;
            if (v5 == null) ** GOTO lbl-1000
            v6 = v5.getMd5();
            v5 = v6;
            if (v6 != null) {
                v7 = ByteArrayExtKt.toHexString((byte[])v5);
            } else lbl-1000:
            // 2 sources

            {
                v7 = null;
            }
            Napier.d$default((Napier)Napier.INSTANCE, (String)v4.append(v7).append(" : close check last entry").toString(), null, null, (int)6, null);
            this.assertDataReadMatchesMd5();
        }
        super.close();
    }
}

