/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.core.io;

import java.io.InputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\n\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u000fH\u0016J\u0010\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0004H\u0016R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0002\u001a\u00020\u0001X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/ustadmobile/core/io/RangeInputStream;", "Ljava/io/InputStream;", "input", "start", "", "end", "(Ljava/io/InputStream;JJ)V", "getInput", "()Ljava/io/InputStream;", "setInput", "(Ljava/io/InputStream;)V", "pos", "resetInvalidate", "resetPos", "read", "", "buffer", "", "byteOffset", "byteCount", "skip", "core_release"})
public final class RangeInputStream
extends InputStream {
    @NotNull
    private InputStream input;
    private final long end;
    private long pos;
    private long resetPos;
    private long resetInvalidate;

    public RangeInputStream(@NotNull InputStream input, long start2, long end) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        this.input = input;
        this.end = end;
        this.resetPos = -1L;
        this.resetInvalidate = -1L;
        this.pos = 0L;
        for (long startBytesSkipped = 0L; startBytesSkipped < start2; startBytesSkipped += this.skip(start2 - startBytesSkipped)) {
        }
    }

    @NotNull
    public final InputStream getInput() {
        return this.input;
    }

    public final void setInput(@NotNull InputStream inputStream) {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"<set-?>");
        this.input = inputStream;
    }

    @Override
    public int read() {
        if (this.pos <= this.end) {
            long l = this.pos;
            this.pos = l + 1L;
            return this.input.read();
        }
        return -1;
    }

    @Override
    public int read(@NotNull byte[] buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        return this.read(buffer, 0, buffer.length);
    }

    @Override
    public int read(@NotNull byte[] buffer, int byteOffset, int byteCount) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        int byteCount2 = byteCount;
        byteCount2 = (int)Math.min(this.end + 1L - this.pos, (long)byteCount2);
        if (byteCount2 > 0) {
            int bytesRead = this.input.read(buffer, byteOffset, byteCount2);
            this.pos += (long)bytesRead;
            return bytesRead;
        }
        return -1;
    }

    @Override
    public long skip(long byteCount) {
        int skipped = (int)this.input.skip(byteCount);
        this.pos += (long)skipped;
        return skipped;
    }
}

