/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.core.contentformats.epub.nav;

import com.ustadmobile.core.contentformats.epub.nav.EpubNavItem;
import com.ustadmobile.xmlpullparserkmp.XmlPullParserConstants;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlSerializer;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0010\u001a\u00020\bJ\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0012\u001a\u00020\bJ\u0012\u0010\u0013\u001a\u00020\u00142\n\u0010\u0015\u001a\u00060\u0016j\u0002`\u0017J\u0012\u0010\u0018\u001a\u00020\u00142\n\u0010\u0019\u001a\u00060\u001aj\u0002`\u001bJ\u001c\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u00052\n\u0010\u0019\u001a\u00060\u001aj\u0002`\u001bH\u0002J\u0014\u0010\u001e\u001a\u0004\u0018\u00010\u0005*\u00020\u00052\u0006\u0010\u0010\u001a\u00020\bR\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00050\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\n\u001a\u0004\u0018\u00010\u00052\b\u0010\t\u001a\u0004\u0018\u00010\u0005@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\r\u001a\u0004\u0018\u00010\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\f\u00a8\u0006 "}, d2={"Lcom/ustadmobile/core/contentformats/epub/nav/EpubNavDocument;", "", "()V", "navElements", "", "Lcom/ustadmobile/core/contentformats/epub/nav/EpubNavItem;", "navItems", "", "", "<set-?>", "ncxNavMap", "getNcxNavMap", "()Lcom/ustadmobile/core/contentformats/epub/nav/EpubNavItem;", "toc", "getToc", "getNavByHref", "href", "getNavById", "id", "load", "", "xpp", "Lorg/xmlpull/v1/XmlPullParser;", "Lcom/ustadmobile/xmlpullparserkmp/XmlPullParser;", "serialize", "xs", "Lorg/xmlpull/v1/XmlSerializer;", "Lcom/ustadmobile/xmlpullparserkmp/XmlSerializer;", "writeNavItem", "item", "findByHref", "Companion", "core_debug"})
public final class EpubNavDocument {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<String, EpubNavItem> navItems = new LinkedHashMap();
    @Nullable
    private EpubNavItem ncxNavMap;
    @NotNull
    private final List<EpubNavItem> navElements = new ArrayList();
    @NotNull
    private static final String EPUB_NAV_DOCUMENT_TYPE_TOC = "toc";
    @NotNull
    private static final String NAMESPACE_OPS = "http://www.idpf.org/2007/ops";
    @NotNull
    private static final String NAMESPACE_XHTML = "http://www.w3.org/1999/xhtml";

    @Nullable
    public final EpubNavItem getNcxNavMap() {
        return this.ncxNavMap;
    }

    @Nullable
    public final EpubNavItem getToc() {
        for (EpubNavItem item : this.navElements) {
            String[] stringArray;
            List list;
            if (item.getNavElEpubTypeAttr() == null) continue;
            String string = item.getNavElEpubTypeAttr();
            Intrinsics.checkNotNull((Object)string);
            CharSequence charSequence = string;
            Regex regex = new Regex("\\s+");
            int n = 0;
            List $this$dropLastWhile$iv = regex.split(charSequence, n);
            boolean $i$f$dropLastWhile = false;
            if (!$this$dropLastWhile$iv.isEmpty()) {
                ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                while (iterator$iv.hasPrevious()) {
                    String it = (String)iterator$iv.previous();
                    boolean bl = false;
                    if (((CharSequence)it).length() == 0) continue;
                    list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                    break;
                }
            } else {
                list = CollectionsKt.emptyList();
            }
            Collection $this$toTypedArray$iv = list;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            Intrinsics.checkNotNull((Object)thisCollection$iv.toArray(new String[0]), (String)"null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
            if (!ArraysKt.contains((Object[])Arrays.copyOf(stringArray, stringArray.length), (Object)EPUB_NAV_DOCUMENT_TYPE_TOC)) continue;
            return item;
        }
        return null;
    }

    public final void load(@NotNull XmlPullParser xpp) {
        Intrinsics.checkNotNullParameter((Object)xpp, (String)"xpp");
        xpp.setFeature(XmlPullParserConstants.INSTANCE.getFEATURE_PROCESS_NAMESPACES(), true);
        Ref.IntRef evtType = new Ref.IntRef();
        evtType.element = -1;
        EpubNavItem currentNav = null;
        EpubNavItem currentItem = null;
        int itemDepth = 0;
        String tagName = null;
        while (EpubNavDocument.load$lambda$1(evtType, xpp) != 1) {
            switch (evtType.element) {
                case 2: {
                    String string = xpp.getName();
                    if (string == null) {
                        string = "";
                    }
                    if (Intrinsics.areEqual((Object)(tagName = string), (Object)"nav")) {
                        currentNav = new EpubNavItem(null, null, null, 0);
                        String navTypeAttr = xpp.getAttributeValue(NAMESPACE_OPS, "type");
                        String idAttrVal = xpp.getAttributeValue(null, "id");
                        if (navTypeAttr != null) {
                            currentNav.setNavElEpubTypeAttr(navTypeAttr);
                        }
                        if (idAttrVal != null) {
                            currentNav.setId(idAttrVal);
                            this.navItems.put(idAttrVal, currentNav);
                        }
                        this.navElements.add(currentNav);
                        break;
                    }
                    if (StringsKt.equals((String)tagName, (String)"navMap", (boolean)true)) {
                        this.ncxNavMap = currentNav = new EpubNavItem(null, null, null, 0);
                        break;
                    }
                    if (Intrinsics.areEqual((Object)tagName, (Object)"li")) {
                        EpubNavItem epubNavItem = currentItem;
                        if (epubNavItem == null) {
                            epubNavItem = currentNav;
                        }
                        currentItem = new EpubNavItem(epubNavItem, itemDepth);
                        ++itemDepth;
                        break;
                    }
                    if (Intrinsics.areEqual((Object)tagName, (Object)"a")) {
                        EpubNavItem epubNavItem = currentItem;
                        if (epubNavItem != null) {
                            epubNavItem.setHref(xpp.getAttributeValue(null, "href"));
                        }
                        if (xpp.next() != 4) break;
                        EpubNavItem epubNavItem2 = currentItem;
                        if (epubNavItem2 == null) break;
                        epubNavItem2.setTitle(xpp.getText());
                        break;
                    }
                    if (StringsKt.equals((String)tagName, (String)"navPoint", (boolean)true)) {
                        EpubNavItem epubNavItem = currentItem;
                        if (epubNavItem == null) {
                            epubNavItem = currentNav;
                        }
                        currentItem = new EpubNavItem(epubNavItem, itemDepth);
                        break;
                    }
                    if (Intrinsics.areEqual((Object)tagName, (Object)"text")) {
                        if (xpp.next() != 4) break;
                        EpubNavItem epubNavItem = currentItem;
                        if (epubNavItem == null) break;
                        epubNavItem.setTitle(xpp.getText());
                        break;
                    }
                    if (!Intrinsics.areEqual((Object)tagName, (Object)"content")) break;
                    EpubNavItem epubNavItem = currentItem;
                    if (epubNavItem == null) break;
                    epubNavItem.setHref(xpp.getAttributeValue(null, "src"));
                    break;
                }
                case 3: {
                    if (Intrinsics.areEqual((Object)xpp.getName(), (Object)"nav")) {
                        currentNav = null;
                        break;
                    }
                    if (Intrinsics.areEqual((Object)xpp.getName(), (Object)"li")) {
                        EpubNavItem epubNavItem = currentItem;
                        currentItem = epubNavItem != null ? epubNavItem.getParent() : null;
                        --itemDepth;
                        break;
                    }
                    if (!StringsKt.equals((String)xpp.getName(), (String)"navPoint", (boolean)true)) break;
                    EpubNavItem epubNavItem = currentItem;
                    currentItem = epubNavItem != null ? epubNavItem.getParent() : null;
                    --itemDepth;
                }
            }
        }
    }

    public final void serialize(@NotNull XmlSerializer xs) {
        Intrinsics.checkNotNullParameter((Object)xs, (String)"xs");
        xs.startDocument("UTF-8", Boolean.valueOf(false));
        xs.setPrefix("", NAMESPACE_XHTML);
        xs.setPrefix("epub", NAMESPACE_OPS);
        xs.startTag(NAMESPACE_XHTML, "html").startTag(NAMESPACE_XHTML, "head").startTag(NAMESPACE_XHTML, "meta").attribute(null, "charset", "UTF-8").endTag(NAMESPACE_XHTML, "meta").endTag(NAMESPACE_XHTML, "head").startTag(NAMESPACE_XHTML, "body");
        for (EpubNavItem navItem : this.navElements) {
            xs.startTag(NAMESPACE_XHTML, "nav");
            if (navItem.getId() != null) {
                String string = navItem.getId();
                Intrinsics.checkNotNull((Object)string);
                xs.attribute(null, "id", string);
            }
            if (navItem.getNavElEpubTypeAttr() != null) {
                String string = navItem.getNavElEpubTypeAttr();
                Intrinsics.checkNotNull((Object)string);
                xs.attribute(NAMESPACE_OPS, "type", string);
            }
            xs.startTag(NAMESPACE_XHTML, "ol");
            List<EpubNavItem> list = navItem.getChildren();
            Intrinsics.checkNotNull(list);
            for (EpubNavItem childItem : list) {
                this.writeNavItem(childItem, xs);
            }
            xs.endTag(NAMESPACE_XHTML, "ol").endTag(NAMESPACE_XHTML, "nav");
        }
        xs.endTag(NAMESPACE_XHTML, "body");
        xs.endTag(NAMESPACE_XHTML, "html");
        xs.endDocument();
    }

    private final void writeNavItem(EpubNavItem item, XmlSerializer xs) {
        XmlSerializer xmlSerializer = xs.startTag(NAMESPACE_XHTML, "li").startTag(NAMESPACE_XHTML, "a");
        String string = item.getHref();
        Intrinsics.checkNotNull((Object)string);
        XmlSerializer xmlSerializer2 = xmlSerializer.attribute(null, "href", string);
        String string2 = item.getTitle();
        Intrinsics.checkNotNull((Object)string2);
        xmlSerializer2.text(string2).endTag(NAMESPACE_XHTML, "a");
        if (item.hasChildren()) {
            xs.startTag(NAMESPACE_XHTML, "ol");
            List<EpubNavItem> list = item.getChildren();
            Intrinsics.checkNotNull(list);
            for (EpubNavItem child : list) {
                this.writeNavItem(child, xs);
            }
            xs.endTag(NAMESPACE_XHTML, "ol");
        }
        xs.endTag(NAMESPACE_XHTML, "li");
    }

    @Nullable
    public final EpubNavItem getNavById(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return this.navItems.containsKey(id) ? this.navItems.get(id) : (EpubNavItem)null;
    }

    @Nullable
    public final EpubNavItem findByHref(@NotNull EpubNavItem $this$findByHref, @NotNull String href) {
        EpubNavItem epubNavItem;
        Intrinsics.checkNotNullParameter((Object)$this$findByHref, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)href, (String)"href");
        if (Intrinsics.areEqual((Object)$this$findByHref.getHref(), (Object)href)) {
            return $this$findByHref;
        }
        Sequence sequence = $this$findByHref.getChildren();
        if (sequence != null && (sequence = CollectionsKt.asSequence((Iterable)((Iterable)sequence))) != null && (sequence = SequencesKt.map((Sequence)sequence, (Function1)((Function1)new Function1<EpubNavItem, EpubNavItem>(this, href){
            final /* synthetic */ EpubNavDocument this$0;
            final /* synthetic */ String $href;
            {
                this.this$0 = $receiver;
                this.$href = $href;
                super(1);
            }

            @Nullable
            public final EpubNavItem invoke(@NotNull EpubNavItem it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return this.this$0.findByHref(it, this.$href);
            }
        }))) != null) {
            Object v1;
            block4: {
                Sequence $this$firstOrNull$iv = sequence;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    EpubNavItem it = (EpubNavItem)element$iv;
                    boolean bl = false;
                    if (!(it != null)) continue;
                    v1 = element$iv;
                    break block4;
                }
                v1 = null;
            }
            epubNavItem = v1;
        } else {
            epubNavItem = null;
        }
        return epubNavItem;
    }

    @Nullable
    public final EpubNavItem getNavByHref(@NotNull String href) {
        EpubNavItem epubNavItem;
        Object v0;
        block2: {
            Intrinsics.checkNotNullParameter((Object)href, (String)"href");
            Sequence $this$firstOrNull$iv = SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)this.navElements), (Function1)((Function1)new Function1<EpubNavItem, EpubNavItem>(this, href){
                final /* synthetic */ EpubNavDocument this$0;
                final /* synthetic */ String $href;
                {
                    this.this$0 = $receiver;
                    this.$href = $href;
                    super(1);
                }

                @Nullable
                public final EpubNavItem invoke(@NotNull EpubNavItem it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return this.this$0.findByHref(it, this.$href);
                }
            }));
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                EpubNavItem it = (EpubNavItem)element$iv;
                boolean bl = false;
                if (!(it != null)) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        if ((epubNavItem = (EpubNavItem)v0) == null) {
            EpubNavItem epubNavItem2 = this.ncxNavMap;
            epubNavItem = epubNavItem2 != null ? this.findByHref(epubNavItem2, href) : null;
        }
        EpubNavItem result2 = epubNavItem;
        return result2;
    }

    private static final int load$lambda$1(Ref.IntRef $evtType, XmlPullParser $xpp) {
        $evtType.element = $xpp.next();
        return $evtType.element;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/ustadmobile/core/contentformats/epub/nav/EpubNavDocument$Companion;", "", "()V", "EPUB_NAV_DOCUMENT_TYPE_TOC", "", "NAMESPACE_OPS", "NAMESPACE_XHTML", "getNAMESPACE_XHTML", "()Ljava/lang/String;", "core_debug"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getNAMESPACE_XHTML() {
            return NAMESPACE_XHTML;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

