/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.core.io;

import java.io.FilterOutputStream;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\fH\u0016J \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0012H\u0016R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\t\u00a8\u0006\u0015"}, d2={"Lcom/ustadmobile/core/io/RangeOutputStream;", "Ljava/io/FilterOutputStream;", "output", "Ljava/io/OutputStream;", "start", "", "end", "(Ljava/io/OutputStream;JJ)V", "getEnd", "()J", "position", "singleByteArray", "", "getStart", "write", "", "buf", "offset", "", "len", "p0", "core_release"})
public final class RangeOutputStream
extends FilterOutputStream {
    private final long start;
    private final long end;
    private long position;
    @NotNull
    private final byte[] singleByteArray;

    public final long getStart() {
        return this.start;
    }

    public final long getEnd() {
        return this.end;
    }

    public RangeOutputStream(@NotNull OutputStream output, long start2, long end) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        super(output);
        this.singleByteArray = new byte[1];
        this.start = start2;
        this.end = end;
        if (end != -1L && start2 > end) {
            throw new IllegalArgumentException("RangeOutputStream: Invalid Range: start=" + start2 + ", end=" + end);
        }
    }

    @Override
    public void write(int p0) {
        this.singleByteArray[0] = (byte)p0;
        this.write(this.singleByteArray, 0, 1);
    }

    @Override
    public void write(@NotNull byte[] buf) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        this.write(buf, 0, buf.length);
    }

    @Override
    public void write(@NotNull byte[] buf, int offset, int len) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        int effectiveOffset = (int)Math.max(0L, this.start - this.position);
        int offsetDelta = effectiveOffset - offset;
        int effectiveLen = len - offsetDelta;
        if (this.end > 0L && this.position + (long)len > this.end) {
            effectiveLen -= (int)(this.position + (long)len - (this.end + 1L));
        }
        if (effectiveLen > 0) {
            this.out.write(buf, effectiveOffset, effectiveLen);
        }
        this.position += (long)len;
    }
}

