/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.core.impl;

import android.annotation.TargetApi;
import android.webkit.WebResourceRequest;
import android.webkit.WebResourceResponse;
import com.ustadmobile.core.contentformats.har.HarContent;
import com.ustadmobile.core.contentformats.har.HarNameValuePair;
import com.ustadmobile.core.contentformats.har.HarRequest;
import com.ustadmobile.core.contentformats.har.HarResponse;
import com.ustadmobile.core.io.RangeInputStream;
import com.ustadmobile.core.io.ext.ContainerEntryFileJvmExtKt;
import com.ustadmobile.core.util.ext.HarContentExtKt;
import com.ustadmobile.lib.db.entities.ContainerEntryFile;
import com.ustadmobile.lib.util.RangeUtilKt;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\f\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u0002\u001a\u0016\u0010\u0003\u001a\u00020\u0004*\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0007\u001a\f\u0010\b\u001a\u00020\t*\u00020\u0002H\u0007\u00a8\u0006\n"}, d2={"getInputStreamFromContent", "Ljava/io/InputStream;", "Lcom/ustadmobile/core/contentformats/har/HarResponse;", "toHarRequest", "Lcom/ustadmobile/core/contentformats/har/HarRequest;", "Landroid/webkit/WebResourceRequest;", "payload", "", "toWebResourceResponse", "Landroid/webkit/WebResourceResponse;", "core_debug"})
public final class HarWebViewClientKt {
    /*
     * WARNING - void declaration
     */
    @TargetApi(value=21)
    @NotNull
    public static final HarRequest toHarRequest(@NotNull WebResourceRequest $this$toHarRequest, @Nullable String payload) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)$this$toHarRequest, (String)"<this>");
        HarRequest request = new HarRequest();
        request.setUrl($this$toHarRequest.getUrl().toString());
        Map map = $this$toHarRequest.getRequestHeaders();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"this.requestHeaders");
        Map map2 = map;
        HarRequest harRequest = request;
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            Map.Entry entry2 = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Object k = it.getKey();
            Intrinsics.checkNotNullExpressionValue(k, (String)"it.key");
            String string = (String)k;
            Object v = it.getValue();
            Intrinsics.checkNotNullExpressionValue(v, (String)"it.value");
            collection.add(new HarNameValuePair(string, (String)v));
        }
        harRequest.setHeaders((List)destination$iv$iv);
        request.setMethod($this$toHarRequest.getMethod());
        request.setBody(payload);
        return request;
    }

    /*
     * WARNING - void declaration
     */
    @TargetApi(value=21)
    @NotNull
    public static final WebResourceResponse toWebResourceResponse(@NotNull HarResponse $this$toWebResourceResponse) {
        Object object;
        String[] stringArray;
        String $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$toWebResourceResponse, (String)"<this>");
        Iterable $this$map$iv = $this$toWebResourceResponse.getHeaders();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Object object2 = $this$mapTo$iv$iv.iterator();
        while (object2.hasNext()) {
            void it;
            Object item$iv$iv = object2.next();
            HarNameValuePair harNameValuePair = (HarNameValuePair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TuplesKt.to((Object)it.getName(), (Object)it.getValue()));
        }
        Map headerMap = MapsKt.toMap((Iterable)((List)destination$iv$iv));
        InputStream inputStreamContent = HarWebViewClientKt.getInputStreamFromContent($this$toWebResourceResponse);
        if ($this$toWebResourceResponse.getStatus() == 206 && inputStreamContent != null) {
            Object object3;
            String[] stringArray2;
            String[] stringArray3;
            String string;
            $this$mapTo$iv$iv = (String)headerMap.get(RangeUtilKt.getRANGE_CONTENT_RANGE_HEADER());
            List rangeString = $this$mapTo$iv$iv != null && (string = StringsKt.substringAfter$default((String)$this$mapTo$iv$iv, (String)"bytes ", null, (int)2, null)) != null && ($i$f$mapTo = StringsKt.substringBefore$default((String)string, (String)"/", null, (int)2, null)) != null && (object2 = StringsKt.split$default((CharSequence)$i$f$mapTo, (String[])(stringArray3 = new String[]{"-"}), (boolean)false, (int)0, (int)6, null)) != null ? object2 : CollectionsKt.emptyList();
            long fromByte = Long.parseLong((String)rangeString.get(0));
            long toByte = Long.parseLong((String)rangeString.get(1));
            Object object4 = $this$toWebResourceResponse.getContent();
            if (object4 == null || (object4 = ((HarContent)object4).getMimeType()) == null || (object4 = StringsKt.split$default((CharSequence)((CharSequence)object4), (String[])(stringArray2 = new String[]{";"}), (boolean)false, (int)0, (int)6, null)) == null || (object4 = (String)object4.get(0)) == null) {
                object4 = "text/html";
            }
            if ((object3 = $this$toWebResourceResponse.getContent()) == null || (object3 = ((HarContent)object3).getEncoding()) == null) {
                object3 = "utf-8";
            }
            int n = $this$toWebResourceResponse.getStatus() < 100 || $this$toWebResourceResponse.getStatus() > 299 || $this$toWebResourceResponse.getStatus() < 400 ? 200 : $this$toWebResourceResponse.getStatus();
            String string2 = $this$toWebResourceResponse.getStatusText();
            if (string2 == null) {
                string2 = "OK";
            }
            return new WebResourceResponse((String)object4, (String)object3, n, string2, headerMap, (InputStream)new RangeInputStream(inputStreamContent, fromByte, toByte));
        }
        Object object5 = $this$toWebResourceResponse.getContent();
        if (object5 == null || (object5 = ((HarContent)object5).getMimeType()) == null || (object5 = StringsKt.split$default((CharSequence)((CharSequence)object5), (String[])(stringArray = new String[]{";"}), (boolean)false, (int)0, (int)6, null)) == null || (object5 = (String)object5.get(0)) == null) {
            object5 = "text/html";
        }
        if ((object = $this$toWebResourceResponse.getContent()) == null || (object = ((HarContent)object).getEncoding()) == null) {
            object = "utf-8";
        }
        int n = $this$toWebResourceResponse.getStatus() < 100 || $this$toWebResourceResponse.getStatus() > 299 || $this$toWebResourceResponse.getStatus() < 400 ? 200 : $this$toWebResourceResponse.getStatus();
        String string = $this$toWebResourceResponse.getStatusText();
        if (string == null) {
            string = "OK";
        }
        return new WebResourceResponse((String)object5, (String)object, n, string, headerMap, inputStreamContent);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Nullable
    public static final InputStream getInputStreamFromContent(@NotNull HarResponse $this$getInputStreamFromContent) {
        InputStream inputStream;
        Intrinsics.checkNotNullParameter((Object)$this$getInputStreamFromContent, (String)"<this>");
        HarContent harContent = $this$getInputStreamFromContent.getContent();
        boolean bl = harContent != null ? HarContentExtKt.isTextContent(harContent) : false;
        if (bl) {
            HarContent harContent2 = $this$getInputStreamFromContent.getContent();
            if ((harContent2 != null ? harContent2.getText() : null) != null) {
                byte[] byArray;
                Object object = $this$getInputStreamFromContent.getContent();
                if (object != null && (object = ((HarContent)object).getText()) != null) {
                    Object object2 = object;
                    Charset charset = StandardCharsets.UTF_8;
                    Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
                    byte[] byArray2 = ((String)object2).getBytes(charset);
                    byArray = byArray2;
                    Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"this as java.lang.String).getBytes(charset)");
                } else {
                    byArray = null;
                }
                inputStream = new ByteArrayInputStream(byArray);
                return inputStream;
            }
        }
        HarContent harContent3 = $this$getInputStreamFromContent.getContent();
        HarContent harContent4 = harContent3;
        if (harContent3 == null) return null;
        ContainerEntryFile containerEntryFile = harContent4.getEntryFile();
        harContent4 = containerEntryFile;
        if (containerEntryFile == null) return null;
        inputStream = ContainerEntryFileJvmExtKt.openInputStream((ContainerEntryFile)harContent4);
        return inputStream;
    }
}

