/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.core.util;

import com.ustadmobile.core.io.ext.InputStreamExtKt;
import io.github.aakira.napier.Napier;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.collections.CollectionsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0003\u001a\u0016\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bJ<\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\b2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0006J\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0013\u001a\u00020\u0006\u00a8\u0006\u0014"}, d2={"Lcom/ustadmobile/core/util/ShrinkUtils;", "", "()V", "getVideoResolutionMetadata", "Lkotlin/Triple;", "", "", "srcFile", "Ljava/io/File;", "ffprobePath", "optimiseVideo", "", "srcVideo", "destFile", "ffmpegPath", "resolution", "Lkotlin/Pair;", "aspectRatio", "validateRatio", "ratioStr", "core"})
public final class ShrinkUtils {
    @NotNull
    public static final ShrinkUtils INSTANCE = new ShrinkUtils();

    private ShrinkUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Triple<Integer, Integer, String> getVideoResolutionMetadata(@NotNull File srcFile, @NotNull File ffprobePath) {
        Intrinsics.checkNotNullParameter((Object)srcFile, (String)"srcFile");
        Intrinsics.checkNotNullParameter((Object)ffprobePath, (String)"ffprobePath");
        String[] stringArray = new String[]{ffprobePath.getAbsolutePath(), "-v", "error", "-select_streams", "v:0", "-show_entries", "stream=width,height,display_aspect_ratio", "-of", "default=nw=1:nk=1", srcFile.getPath()};
        ProcessBuilder builder = new ProcessBuilder(stringArray);
        Process process = null;
        try {
            process = builder.start();
            BufferedReader stream = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String width = stream.readLine();
            String height = stream.readLine();
            String string = stream.readLine();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"stream.readLine()");
            String ratio = this.validateRatio(string);
            stream.close();
            process.waitFor();
            int exitValue = process.exitValue();
            if (exitValue != 0) {
                StringBuilder stringBuilder = new StringBuilder().append("Error Stream for src ").append(srcFile.getPath());
                InputStream inputStream = process.getErrorStream();
                Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"process.errorStream");
                Napier.e$default((Napier)Napier.INSTANCE, (String)stringBuilder.append(InputStreamExtKt.readString(inputStream)).toString(), null, null, (int)6, null);
                Triple triple = new Triple((Object)0, (Object)0, (Object)"");
                return triple;
            }
            process.destroy();
            Intrinsics.checkNotNullExpressionValue((Object)width, (String)"width");
            Integer n = Integer.parseInt(width);
            Intrinsics.checkNotNullExpressionValue((Object)height, (String)"height");
            Triple triple = new Triple((Object)n, (Object)Integer.parseInt(height), (Object)ratio);
            return triple;
        }
        catch (InterruptedException e) {
            Napier.e$default((Napier)Napier.INSTANCE, (String)"ffprobe process interrupted", (Throwable)e, null, (int)4, null);
        }
        finally {
            Process process2 = process;
            if (process2 != null) {
                process2.destroy();
            }
        }
        return new Triple((Object)0, (Object)0, (Object)"");
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final String validateRatio(@NotNull String ratioStr) {
        boolean bl;
        block5: {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)ratioStr, (String)"ratioStr");
            char[] cArray = new char[]{':'};
            List parts = StringsKt.split$default((CharSequence)((Object)StringsKt.trim((CharSequence)ratioStr)).toString(), (char[])cArray, (boolean)false, (int)0, (int)6, null);
            if (parts.size() != 2) {
                return null;
            }
            Iterable $this$map$iv = parts;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(StringsKt.toIntOrNull((String)it));
            }
            List partInts = (List)destination$iv$iv;
            Iterable $this$all$iv = partInts;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    Integer it = (Integer)element$iv;
                    boolean bl3 = false;
                    if (it != null && it > 0) continue;
                    bl = false;
                    break block5;
                }
                bl = true;
            }
        }
        return bl ? ((Object)StringsKt.trim((CharSequence)ratioStr)).toString() : (String)null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void optimiseVideo(@NotNull File srcVideo, @NotNull File destFile, @NotNull File ffmpegPath, @NotNull Pair<Integer, Integer> resolution, @Nullable String aspectRatio) {
        Object[] objectArray;
        Intrinsics.checkNotNullParameter((Object)srcVideo, (String)"srcVideo");
        Intrinsics.checkNotNullParameter((Object)destFile, (String)"destFile");
        Intrinsics.checkNotNullParameter((Object)ffmpegPath, (String)"ffmpegPath");
        Intrinsics.checkNotNullParameter(resolution, (String)"resolution");
        Object object = new String[]{ffmpegPath.getAbsolutePath(), "-i", srcVideo.getPath(), "-vf", "scale=" + ((Number)resolution.getFirst()).intValue() + 'x' + ((Number)resolution.getSecond()).intValue()};
        List ffmpegCommand = CollectionsKt.mutableListOf((Object[])object);
        if (aspectRatio != null) {
            object = ffmpegCommand;
            objectArray = new String[]{"-aspect", aspectRatio};
            CollectionsKt.addAll((Collection)object, (Iterable)CollectionsKt.listOf((Object[])objectArray));
        }
        object = ffmpegCommand;
        objectArray = new String[]{"-framerate", "30", "-c:v", "libx264", "-b:v", "250000", "-c:a", "aac", "-b:a", "64000", "-vbr", "on", "-y", destFile.getPath()};
        CollectionsKt.addAll((Collection)object, (Iterable)CollectionsKt.listOf((Object[])objectArray));
        ProcessBuilder builder = new ProcessBuilder(ffmpegCommand);
        builder.redirectErrorStream(true);
        Process process = null;
        try {
            process = builder.start();
            InputStream inputStream = process.getInputStream();
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"process.inputStream");
            ByteStreamsKt.readBytes((InputStream)inputStream);
            process.waitFor();
            int exitValue = process.exitValue();
            if (exitValue != 0) {
                InputStream inputStream2 = process.getErrorStream();
                Intrinsics.checkNotNullExpressionValue((Object)inputStream2, (String)"process.errorStream");
                String errorStreamStr = InputStreamExtKt.readString(inputStream2);
                String errorMsg = "Non-zero exit value: " + exitValue + " running '" + CollectionsKt.joinToString$default((Iterable)ffmpegCommand, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null) + "'. ErrorStream=" + errorStreamStr;
                Napier.e$default((Napier)Napier.INSTANCE, (String)errorMsg, null, null, (int)6, null);
                throw new IOException(errorMsg);
            }
            process.destroy();
        }
        catch (IOException e) {
            throw e;
        }
        catch (InterruptedException e) {
            Napier.e$default((Napier)Napier.INSTANCE, (String)"ffmpeg process interrupted", (Throwable)e, null, (int)4, null);
        }
        finally {
            Process process2 = process;
            if (process2 != null) {
                process2.destroy();
            }
        }
    }
}

