/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.lib.staging.contentscrapers.gdl;

import com.ustadmobile.core.db.UmAppDatabase;
import com.ustadmobile.core.db.dao.ContainerDao;
import com.ustadmobile.core.db.dao.ScrapeQueueItemDao;
import com.ustadmobile.lib.contentscrapers.ContentScraperUtil;
import com.ustadmobile.lib.contentscrapers.ShrinkerUtil;
import com.ustadmobile.lib.contentscrapers.UMLogUtil;
import com.ustadmobile.lib.db.entities.ContentEntry;
import java.io.File;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\b\u0010&\u001a\u00020'H\u0016J\u0010\u0010(\u001a\u00020'2\u0006\u0010\u0002\u001a\u00020\nH\u0002J\u0010\u0010)\u001a\u00020'2\u0006\u0010\u0002\u001a\u00020\nH\u0002R\u001a\u0010\u0006\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u000f\"\u0004\b\u0017\u0010\u0011R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%\u00a8\u0006*"}, d2={"Lcom/ustadmobile/lib/staging/contentscrapers/gdl/GdlContentScraper;", "Ljava/lang/Runnable;", "scrapeUrl", "Ljava/net/URL;", "destLocation", "Ljava/io/File;", "containerDir", "parentEntry", "Lcom/ustadmobile/lib/db/entities/ContentEntry;", "contentType", "", "sqiUid", "", "(Ljava/net/URL;Ljava/io/File;Ljava/io/File;Lcom/ustadmobile/lib/db/entities/ContentEntry;Ljava/lang/String;I)V", "getContainerDir", "()Ljava/io/File;", "setContainerDir", "(Ljava/io/File;)V", "getContentType", "()Ljava/lang/String;", "setContentType", "(Ljava/lang/String;)V", "getDestLocation", "setDestLocation", "isContentUpdated", "", "getParentEntry", "()Lcom/ustadmobile/lib/db/entities/ContentEntry;", "setParentEntry", "(Lcom/ustadmobile/lib/db/entities/ContentEntry;)V", "getScrapeUrl", "()Ljava/net/URL;", "setScrapeUrl", "(Ljava/net/URL;)V", "getSqiUid", "()I", "setSqiUid", "(I)V", "run", "", "scrapeEpubContent", "scrapePdfContent", "lib-content-scrapers"})
public final class GdlContentScraper
implements Runnable {
    @NotNull
    private URL scrapeUrl;
    @NotNull
    private File destLocation;
    @NotNull
    private File containerDir;
    @NotNull
    private ContentEntry parentEntry;
    @NotNull
    private String contentType;
    private int sqiUid;
    private boolean isContentUpdated;

    public GdlContentScraper(@NotNull URL scrapeUrl2, @NotNull File destLocation, @NotNull File containerDir, @NotNull ContentEntry parentEntry, @NotNull String contentType, int sqiUid) {
        Intrinsics.checkNotNullParameter((Object)scrapeUrl2, (String)"scrapeUrl");
        Intrinsics.checkNotNullParameter((Object)destLocation, (String)"destLocation");
        Intrinsics.checkNotNullParameter((Object)containerDir, (String)"containerDir");
        Intrinsics.checkNotNullParameter((Object)parentEntry, (String)"parentEntry");
        Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
        this.scrapeUrl = scrapeUrl2;
        this.destLocation = destLocation;
        this.containerDir = containerDir;
        this.parentEntry = parentEntry;
        this.contentType = contentType;
        this.sqiUid = sqiUid;
        this.isContentUpdated = true;
    }

    @NotNull
    public final URL getScrapeUrl() {
        return this.scrapeUrl;
    }

    public final void setScrapeUrl(@NotNull URL uRL) {
        Intrinsics.checkNotNullParameter((Object)uRL, (String)"<set-?>");
        this.scrapeUrl = uRL;
    }

    @NotNull
    public final File getDestLocation() {
        return this.destLocation;
    }

    public final void setDestLocation(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"<set-?>");
        this.destLocation = file;
    }

    @NotNull
    public final File getContainerDir() {
        return this.containerDir;
    }

    public final void setContainerDir(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"<set-?>");
        this.containerDir = file;
    }

    @NotNull
    public final ContentEntry getParentEntry() {
        return this.parentEntry;
    }

    public final void setParentEntry(@NotNull ContentEntry contentEntry) {
        Intrinsics.checkNotNullParameter((Object)contentEntry, (String)"<set-?>");
        this.parentEntry = contentEntry;
    }

    @NotNull
    public final String getContentType() {
        return this.contentType;
    }

    public final void setContentType(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.contentType = string;
    }

    public final int getSqiUid() {
        return this.sqiUid;
    }

    public final void setSqiUid(int n) {
        this.sqiUid = n;
    }

    @Override
    public void run() {
        UmAppDatabase db = null;
        Intrinsics.throwUninitializedPropertyAccessException((String)"db");
        UmAppDatabase repository = null;
        ContainerDao containerDao = repository.getContainerDao();
        ScrapeQueueItemDao queueDao = db.getScrapeQueueItemDao();
        long startTime = System.currentTimeMillis();
        UMLogUtil.INSTANCE.logInfo("Started scraper url " + this.scrapeUrl + " at start time: " + startTime + " with squUid " + this.sqiUid);
        queueDao.setTimeStarted(this.sqiUid, startTime);
        boolean successful = false;
        try {
            File content = null;
            if (Intrinsics.areEqual((Object)"application/epub+zip", (Object)this.contentType)) {
                content = new File(this.destLocation, this.destLocation.getName());
                String string = this.scrapeUrl.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"scrapeUrl.toString()");
                this.scrapeEpubContent(string);
                successful = true;
            } else if (Intrinsics.areEqual((Object)"application/pdf", (Object)this.contentType)) {
                content = new File(this.destLocation, this.destLocation.getName());
                content = new File(content, FilenameUtils.getName((String)this.scrapeUrl.getPath()));
                String string = this.scrapeUrl.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"scrapeUrl.toString()");
                this.scrapePdfContent(string);
                successful = true;
            } else {
                UMLogUtil.INSTANCE.logError("unsupported kind = " + this.contentType + " at url = " + this.scrapeUrl);
                throw new IllegalArgumentException("unsupported kind = " + this.contentType + " at url = " + this.scrapeUrl);
            }
            if (this.isContentUpdated) {
                ContentScraperUtil.INSTANCE.insertContainer(containerDao, this.parentEntry, true, this.contentType, content.lastModified(), content, db, repository, this.containerDir);
            }
        }
        catch (Exception e) {
            String string = ExceptionUtils.getStackTrace((Throwable)e);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStackTrace(e)");
            UMLogUtil.INSTANCE.logError(string);
            UMLogUtil.INSTANCE.logError("Unable to scrape content from url " + this.scrapeUrl);
            String string2 = this.destLocation.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"destLocation.name");
            ContentScraperUtil.INSTANCE.deleteETagOrModified(this.destLocation, string2);
        }
        queueDao.updateSetStatusById(this.sqiUid, successful ? 3 : 4, 0);
        queueDao.setTimeFinished(this.sqiUid, System.currentTimeMillis());
        long duration = System.currentTimeMillis() - startTime;
        UMLogUtil.INSTANCE.logInfo("Ended scrape for url " + this.scrapeUrl + " in duration: " + duration + " squUid  " + this.sqiUid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void scrapeEpubContent(String scrapeUrl2) {
        HttpURLConnection conn;
        URL url;
        block6: {
            File folder = new File(this.destLocation, this.destLocation.getName());
            folder.mkdirs();
            url = new URL(scrapeUrl2);
            conn = null;
            URLConnection uRLConnection = url.openConnection();
            Intrinsics.checkNotNull((Object)uRLConnection, (String)"null cannot be cast to non-null type java.net.HttpURLConnection");
            conn = (HttpURLConnection)uRLConnection;
            conn.setRequestMethod("HEAD");
            URLConnection uRLConnection2 = conn;
            String string = this.destLocation.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"destLocation.name");
            this.isContentUpdated = ContentScraperUtil.INSTANCE.isFileModified(uRLConnection2, this.destLocation, string);
            if (this.isContentUpdated) break block6;
            conn.disconnect();
            return;
        }
        try {
            File contentFile = new File(this.destLocation, FilenameUtils.getName((String)url.getPath()));
            FileUtils.copyURLToFile((URL)url, (File)contentFile);
            ShrinkerUtil.INSTANCE.shrinkEpub(contentFile);
            conn.disconnect();
        }
        catch (Exception e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                HttpURLConnection httpURLConnection = conn;
                if (httpURLConnection != null) {
                    httpURLConnection.disconnect();
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void scrapePdfContent(String scrapeUrl2) {
        HttpURLConnection conn;
        URL url;
        File folder;
        block6: {
            folder = new File(this.destLocation, this.destLocation.getName());
            folder.mkdirs();
            url = new URL(scrapeUrl2);
            conn = null;
            URLConnection uRLConnection = url.openConnection();
            Intrinsics.checkNotNull((Object)uRLConnection, (String)"null cannot be cast to non-null type java.net.HttpURLConnection");
            conn = (HttpURLConnection)uRLConnection;
            conn.setRequestMethod("HEAD");
            URLConnection uRLConnection2 = conn;
            String string = this.destLocation.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"destLocation.name");
            this.isContentUpdated = ContentScraperUtil.INSTANCE.isFileModified(uRLConnection2, this.destLocation, string);
            if (this.isContentUpdated) break block6;
            conn.disconnect();
            return;
        }
        try {
            File contentFile = new File(folder, FilenameUtils.getName((String)url.getPath()));
            FileUtils.copyURLToFile((URL)url, (File)contentFile);
            conn.disconnect();
        }
        catch (Exception e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                HttpURLConnection httpURLConnection = conn;
                if (httpURLConnection != null) {
                    httpURLConnection.disconnect();
                }
                throw throwable;
            }
        }
    }
}

