/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.lib.contentscrapers.khanacademy;

import com.ustadmobile.core.db.UmAppDatabase;
import com.ustadmobile.core.db.dao.ContentEntryDao;
import com.ustadmobile.lib.contentscrapers.ContentScraperUtil;
import com.ustadmobile.lib.db.entities.ContentEntry;
import com.ustadmobile.lib.db.entities.Language;
import com.ustadmobile.lib.db.entities.LanguageVariant;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u00004\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\u001a&\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u000e\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n\u001a\u0018\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\nH\u0002\u001a\u0016\u0010\f\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010\u001a\u000e\u0010\u0011\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n\u001a\u0010\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u000e\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0003\u001a\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0005\u001a\u00020\n\u00a8\u0006\u0017"}, d2={"createKangLangEntry", "Lcom/ustadmobile/lib/db/entities/ContentEntry;", "langCode", "", "langName", "url", "db", "Lcom/ustadmobile/core/db/UmAppDatabase;", "getJsonContent", "sourceUrl", "Ljava/net/URL;", "getJsonURL", "getKhanEntry", "englishLang", "Lcom/ustadmobile/lib/db/entities/Language;", "contentEntryDao", "Lcom/ustadmobile/core/db/dao/ContentEntryDao;", "getLangCodeFromURL", "getLangUrl", "getYoutubeUrl", "videoId", "isUrlValid", "", "lib-content-scrapers"})
public final class KhanConstantsKt {
    private static final String getLangUrl(String langCode) {
        return "https://" + langCode + ".khanacademy.org/";
    }

    private static final URL getJsonURL(String langCode, URL sourceUrl) {
        return new URL(sourceUrl, "/api/internal/static/content" + sourceUrl.getPath() + "?lang=" + langCode);
    }

    @NotNull
    public static final String getLangCodeFromURL(@NotNull URL sourceUrl) {
        Intrinsics.checkNotNullParameter((Object)sourceUrl, (String)"sourceUrl");
        String string = sourceUrl.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sourceUrl.toString()");
        String langCode = StringsKt.substringAfter$default((String)StringsKt.substringBefore$default((String)string, (String)".khan", null, (int)2, null), (String)"://", null, (int)2, null);
        if (Intrinsics.areEqual((Object)langCode, (Object)"www")) {
            langCode = "en";
        }
        return langCode;
    }

    @NotNull
    public static final ContentEntry getKhanEntry(@NotNull Language englishLang, @NotNull ContentEntryDao contentEntryDao) {
        Intrinsics.checkNotNullParameter((Object)englishLang, (String)"englishLang");
        Intrinsics.checkNotNullParameter((Object)contentEntryDao, (String)"contentEntryDao");
        return ContentScraperUtil.INSTANCE.createOrUpdateContentEntry("https://www.khanacademy.org/", "Khan Academy", "https://www.khanacademy.org/", "Khan Academy", 4, englishLang.getLangUid(), null, "You can learn anything.\nFor free. For everyone. Forever.", false, "", "https://cdn.kastatic.org/images/khan-logo-dark-background.new.png", "", "", 0, contentEntryDao);
    }

    @NotNull
    public static final String getJsonContent(@NotNull URL sourceUrl) {
        Intrinsics.checkNotNullParameter((Object)sourceUrl, (String)"sourceUrl");
        String langCode = KhanConstantsKt.getLangCodeFromURL(sourceUrl);
        String string = IOUtils.toString((URL)KhanConstantsKt.getJsonURL(langCode, sourceUrl), (String)"UTF-8");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(getJsonURL(langCode, sourceUrl), UTF8)");
        return string;
    }

    @NotNull
    public static final ContentEntry createKangLangEntry(@NotNull String langCode, @NotNull String langName, @NotNull String url, @NotNull UmAppDatabase db) {
        Intrinsics.checkNotNullParameter((Object)langCode, (String)"langCode");
        Intrinsics.checkNotNullParameter((Object)langName, (String)"langName");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)db, (String)"db");
        String[] stringArray = new String[]{"-"};
        List langSplitArray = StringsKt.split$default((CharSequence)langCode, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        Language langEntity = null;
        langEntity = ((String)langSplitArray.get(0)).length() == 2 ? ContentScraperUtil.INSTANCE.insertOrUpdateLanguageByTwoCode(db.getLanguageDao(), (String)langSplitArray.get(0)) : ContentScraperUtil.INSTANCE.insertOrUpdateLanguageByThreeCode(db.getLanguageDao(), (String)langSplitArray.get(0));
        LanguageVariant langVariantEntity = null;
        if (langSplitArray.size() > 1) {
            langVariantEntity = ContentScraperUtil.INSTANCE.insertOrUpdateLanguageVariant(db.getLanguageVariantDao(), (String)langSplitArray.get(1), langEntity);
        }
        LanguageVariant languageVariant = langVariantEntity;
        return ContentScraperUtil.INSTANCE.createOrUpdateContentEntry(url, langName, url, "Khan Academy", 4, langEntity.getLangUid(), languageVariant != null ? languageVariant.getLangVariantUid() : 0L, "", false, "", "", "", "", 0, db.getContentEntryDao());
    }

    public static final boolean isUrlValid(@NotNull URL url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        URLConnection uRLConnection = url.openConnection();
        Intrinsics.checkNotNull((Object)uRLConnection, (String)"null cannot be cast to non-null type java.net.HttpURLConnection");
        HttpURLConnection huc = (HttpURLConnection)uRLConnection;
        huc.setRequestMethod("HEAD");
        int responseCode = huc.getResponseCode();
        return responseCode == 200;
    }

    @NotNull
    public static final String getYoutubeUrl(@NotNull String videoId) {
        Intrinsics.checkNotNullParameter((Object)videoId, (String)"videoId");
        return "https://www.youtube.com/watch?v=" + videoId;
    }

    public static final /* synthetic */ String access$getLangUrl(String langCode) {
        return KhanConstantsKt.getLangUrl(langCode);
    }
}

