/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.lib.contentscrapers.harscraper;

import com.ustadmobile.lib.contentscrapers.ContentScraperUtil;
import com.ustadmobile.lib.contentscrapers.ScraperConstants;
import com.ustadmobile.lib.contentscrapers.UMLogUtil;
import java.io.File;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Base64;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.lightbody.bmp.BrowserMobProxyServer;
import net.lightbody.bmp.core.har.HarEntry;
import net.lightbody.bmp.core.har.HarRequest;
import net.lightbody.bmp.core.har.HarResponse;
import net.lightbody.bmp.proxy.CaptureType;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openqa.selenium.InvalidArgumentException;
import org.openqa.selenium.Proxy;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.support.ui.WebDriverWait;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000J\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a|\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2)\u0010\n\u001a%\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\n\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u000bj\u0004\u0018\u0001`\u000f2)\u0010\u0010\u001a%\u0012\u0013\u0012\u00110\u0011\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u0012\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u000bj\u0004\u0018\u0001`\u0013\u001a\u001e\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000e\u001a\u00020\u0007*@\u0010\u0017\"\u001d\u0012\u0013\u0012\u00110\u0011\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u0012\u0012\u0004\u0012\u00020\u00110\u000b2\u001d\u0012\u0013\u0012\u00110\u0011\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u0012\u0012\u0004\u0012\u00020\u00110\u000b*@\u0010\u0018\"\u001d\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\n\u0012\u0004\u0012\u00020\u00010\u000b2\u001d\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\n\u0012\u0004\u0012\u00020\u00010\u000b\u00a8\u0006\u0019"}, d2={"scrapeUrlwithHar", "", "proxy", "Lnet/lightbody/bmp/BrowserMobProxyServer;", "driver", "Lorg/openqa/selenium/chrome/ChromeDriver;", "url", "", "destination", "Ljava/io/File;", "waitCondition", "Lkotlin/Function1;", "Lorg/openqa/selenium/support/ui/WebDriverWait;", "Lkotlin/ParameterName;", "name", "Lcom/ustadmobile/lib/contentscrapers/harscraper/WaitConditionFn;", "filter", "Lnet/lightbody/bmp/core/har/HarEntry;", "harEntry", "Lcom/ustadmobile/lib/contentscrapers/harscraper/ScrapeFilterFn;", "setupProxyWithSelenium", "seleniumProxy", "Lorg/openqa/selenium/Proxy;", "ScrapeFilterFn", "WaitConditionFn", "lib-content-scrapers"})
public final class HarScraperKt {
    @NotNull
    public static final ChromeDriver setupProxyWithSelenium(@NotNull BrowserMobProxyServer proxy, @NotNull Proxy seleniumProxy, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)proxy, (String)"proxy");
        Intrinsics.checkNotNullParameter((Object)seleniumProxy, (String)"seleniumProxy");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        ContentScraperUtil.INSTANCE.setChromeDriverLocation();
        ChromeDriver driver = ContentScraperUtil.INSTANCE.setupChromeDriverWithSeleniumProxy(seleniumProxy);
        CaptureType[] captureTypeArray = new CaptureType[]{CaptureType.REQUEST_HEADERS, CaptureType.RESPONSE_CONTENT, CaptureType.RESPONSE_HEADERS, CaptureType.RESPONSE_BINARY_CONTENT};
        proxy.enableHarCaptureTypes(captureTypeArray);
        proxy.newHar(name);
        return driver;
    }

    public static final void scrapeUrlwithHar(@NotNull BrowserMobProxyServer proxy, @NotNull ChromeDriver driver, @NotNull String url, @NotNull File destination, @Nullable Function1<? super WebDriverWait, Unit> waitCondition, @Nullable Function1<? super HarEntry, ? extends HarEntry> filter) {
        Object v2;
        HarEntry it;
        List entries;
        block12: {
            Intrinsics.checkNotNullParameter((Object)proxy, (String)"proxy");
            Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
            try {
                driver.get(url);
            }
            catch (InvalidArgumentException e) {
                driver.quit();
                throw new IllegalArgumentException(e);
            }
            WebDriverWait waitDriver = new WebDriverWait((WebDriver)driver, ScraperConstants.INSTANCE.getTIME_OUT_SELENIUM());
            ContentScraperUtil.INSTANCE.waitForJSandJQueryToLoad(waitDriver);
            Function1<? super WebDriverWait, Unit> function1 = waitCondition;
            if (function1 != null) {
                function1.invoke((Object)waitDriver);
            }
            entries = null;
            List list = entries = proxy.getHar().getLog().getEntries();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"entries");
            Iterable iterable = list;
            for (Object t : iterable) {
                it = (HarEntry)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getRequest().getUrl(), (Object)url)) continue;
                v2 = t;
                break block12;
            }
            v2 = null;
        }
        Object var8_19 = v2;
        HarEntry it2 = var8_19;
        boolean bl = false;
        HarEntry harEntry = it2;
        if (!(!(harEntry != null && (harEntry = harEntry.getResponse()) != null ? harEntry.getStatus() == 404 : false))) {
            boolean $i$a$-require-HarScraperKt$scrapeUrlwithHar$2$22 = false;
            driver.quit();
            String $i$a$-require-HarScraperKt$scrapeUrlwithHar$2$22 = "404 Starting Url";
            throw new IllegalArgumentException($i$a$-require-HarScraperKt$scrapeUrlwithHar$2$22.toString());
        }
        List list = entries;
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"entries");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (HarEntry)element$iv;
            boolean bl2 = false;
            try {
                HarRequest request = it.getRequest();
                HarResponse response = it.getResponse();
                String string = request.getUrl();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"request.url");
                if (StringsKt.contains$default((CharSequence)string, (CharSequence)"accounts.google.com", (boolean)false, (int)2, null)) {
                    entries.remove(it);
                    continue;
                }
                String decodedPath = URLDecoder.decode(request.getUrl(), "UTF-8");
                URL decodedUrl = new URL(decodedPath);
                File urlDirectory = ContentScraperUtil.INSTANCE.createDirectoryFromUrl(destination, decodedUrl);
                File file = new File(urlDirectory, request.getMethod() + '_' + ContentScraperUtil.INSTANCE.getFileNameFromUrl(decodedUrl));
                Function1<? super HarEntry, ? extends HarEntry> function1 = filter;
                if (function1 != null) {
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    HarEntry cfr_ignored_0 = (HarEntry)function1.invoke((Object)it);
                }
                if (Intrinsics.areEqual((Object)response.getContent().getEncoding(), (Object)"base64")) {
                    byte[] base = Base64.getDecoder().decode(response.getContent().getText());
                    FileUtils.writeByteArrayToFile((File)file, (byte[])base);
                } else {
                    FileUtils.writeStringToFile((File)file, (String)response.getContent().getText(), (String)"UTF-8");
                }
                it.getResponse().getContent().setText(urlDirectory.getName() + '/' + file.getName());
                it.setRequest(null);
            }
            catch (Exception e) {
                UMLogUtil.INSTANCE.logError("har scrapped url failed for request url " + it.getRequest().getUrl());
                String string = e.getMessage();
                Intrinsics.checkNotNull((Object)string);
                UMLogUtil.INSTANCE.logError(string);
            }
            driver.quit();
        }
    }
}

