/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.lib.contentscrapers.abztract;

import com.ustadmobile.core.account.Endpoint;
import com.ustadmobile.lib.contentscrapers.ContentScraperUtil;
import com.ustadmobile.lib.contentscrapers.ScraperConstants;
import com.ustadmobile.lib.contentscrapers.abztract.Indexer;
import com.ustadmobile.lib.contentscrapers.abztract.ScraperException;
import io.github.bonigarcia.wdm.WebDriverManager;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import net.lightbody.bmp.BrowserMobProxy;
import net.lightbody.bmp.BrowserMobProxyServer;
import net.lightbody.bmp.client.ClientUtil;
import net.lightbody.bmp.core.har.HarEntry;
import net.lightbody.bmp.proxy.CaptureType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kodein.di.DI;
import org.openqa.selenium.InvalidArgumentException;
import org.openqa.selenium.Proxy;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.support.ui.WebDriverWait;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b&\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\b\u0010\u0019\u001a\u00020\u001aH\u0016Jt\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\u0006\u0010\u001e\u001a\u00020\u001f2\u000e\b\u0002\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\u001c2+\b\u0002\u0010\"\u001a%\u0012\u0013\u0012\u00110$\u00a2\u0006\f\b%\u0012\b\b&\u0012\u0004\b\b(\"\u0012\u0004\u0012\u00020\u001a\u0018\u00010#j\u0004\u0018\u0001`'2!\u0010(\u001a\u001d\u0012\u0013\u0012\u00110\u0014\u00a2\u0006\f\b%\u0012\b\b&\u0012\u0004\b\b(\u0013\u0012\u0004\u0012\u00020)0#R\u001a\u0010\r\u001a\u00020\u000eX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018\u00a8\u0006*"}, d2={"Lcom/ustadmobile/lib/contentscrapers/abztract/HarIndexer;", "Lcom/ustadmobile/lib/contentscrapers/abztract/Indexer;", "parentContentEntry", "", "runUid", "", "sqiUid", "contentEntryUid", "endpoint", "Lcom/ustadmobile/core/account/Endpoint;", "di", "Lorg/kodein/di/DI;", "(JIIJLcom/ustadmobile/core/account/Endpoint;Lorg/kodein/di/DI;)V", "chromeDriver", "Lorg/openqa/selenium/chrome/ChromeDriver;", "getChromeDriver", "()Lorg/openqa/selenium/chrome/ChromeDriver;", "setChromeDriver", "(Lorg/openqa/selenium/chrome/ChromeDriver;)V", "proxy", "Lnet/lightbody/bmp/BrowserMobProxyServer;", "getProxy", "()Lnet/lightbody/bmp/BrowserMobProxyServer;", "setProxy", "(Lnet/lightbody/bmp/BrowserMobProxyServer;)V", "close", "", "startHarIndexer", "", "Lnet/lightbody/bmp/core/har/HarEntry;", "sourceUrl", "", "regexes", "Lkotlin/text/Regex;", "waitCondition", "Lkotlin/Function1;", "Lorg/openqa/selenium/support/ui/WebDriverWait;", "Lkotlin/ParameterName;", "name", "Lcom/ustadmobile/lib/contentscrapers/abztract/WaitConditionFn;", "block", "", "lib-content-scrapers"})
public abstract class HarIndexer
extends Indexer {
    @NotNull
    private ChromeDriver chromeDriver;
    @NotNull
    private BrowserMobProxyServer proxy;

    public HarIndexer(long parentContentEntry, int runUid, int sqiUid, long contentEntryUid, @NotNull Endpoint endpoint, @NotNull DI di) {
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        Intrinsics.checkNotNullParameter((Object)di, (String)"di");
        super(parentContentEntry, runUid, sqiUid, contentEntryUid, endpoint, di);
        this.proxy = new BrowserMobProxyServer();
        WebDriverManager.chromedriver().setup();
        this.proxy.start();
        CaptureType[] captureTypeArray = new CaptureType[]{CaptureType.REQUEST_HEADERS, CaptureType.RESPONSE_CONTENT, CaptureType.RESPONSE_HEADERS, CaptureType.RESPONSE_BINARY_CONTENT};
        this.proxy.enableHarCaptureTypes(captureTypeArray);
        Proxy seleniumProxy = ClientUtil.createSeleniumProxy((BrowserMobProxy)((BrowserMobProxy)this.proxy));
        seleniumProxy.setNoProxy("<-loopback>");
        ChromeOptions options = new ChromeOptions();
        options.setCapability("proxy", (Object)seleniumProxy);
        options.setCapability("acceptInsecureCerts", true);
        this.chromeDriver = new ChromeDriver(options);
    }

    @NotNull
    protected final ChromeDriver getChromeDriver() {
        return this.chromeDriver;
    }

    protected final void setChromeDriver(@NotNull ChromeDriver chromeDriver) {
        Intrinsics.checkNotNullParameter((Object)chromeDriver, (String)"<set-?>");
        this.chromeDriver = chromeDriver;
    }

    @NotNull
    public final BrowserMobProxyServer getProxy() {
        return this.proxy;
    }

    public final void setProxy(@NotNull BrowserMobProxyServer browserMobProxyServer) {
        Intrinsics.checkNotNullParameter((Object)browserMobProxyServer, (String)"<set-?>");
        this.proxy = browserMobProxyServer;
    }

    @NotNull
    public final List<HarEntry> startHarIndexer(@NotNull String sourceUrl, @NotNull List<Regex> regexes, @Nullable Function1<? super WebDriverWait, Unit> waitCondition, @NotNull Function1<? super BrowserMobProxyServer, Boolean> block) {
        Intrinsics.checkNotNullParameter((Object)sourceUrl, (String)"sourceUrl");
        Intrinsics.checkNotNullParameter(regexes, (String)"regexes");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        ContentScraperUtil.INSTANCE.clearChromeConsoleLog(this.chromeDriver);
        this.proxy.newHar("Indexer");
        try {
            this.chromeDriver.navigate().to(sourceUrl);
        }
        catch (InvalidArgumentException e) {
            this.setIndexerDone(false, 200);
            this.close();
            throw new IllegalArgumentException(e);
        }
        WebDriverWait waitDriver = new WebDriverWait((WebDriver)this.chromeDriver, ScraperConstants.INSTANCE.getTIME_OUT_SELENIUM());
        ContentScraperUtil.INSTANCE.waitForJSandJQueryToLoad(waitDriver);
        Function1<? super WebDriverWait, Unit> function1 = waitCondition;
        if (function1 != null) {
            function1.invoke((Object)waitDriver);
        }
        List fileList = new ArrayList();
        Iterable $this$forEach$iv = regexes;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object object;
            Regex regex = (Regex)element$iv;
            boolean bl = false;
            HarEntry fileEntry = null;
            for (int counterRequest = 0; fileEntry == null && counterRequest < 120; ++counterRequest) {
                Object v3;
                block9: {
                    List list = this.proxy.getHar().getLog().getEntries();
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"proxy.har.log.entries");
                    object = list;
                    Iterator iterator = object.iterator();
                    while (iterator.hasNext()) {
                        Object t = iterator.next();
                        HarEntry harEntry = (HarEntry)t;
                        boolean bl2 = false;
                        String string = harEntry.getRequest().getUrl();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"harEntry.request.url");
                        if (!regex.containsMatchIn((CharSequence)string)) continue;
                        v3 = t;
                        break block9;
                    }
                    v3 = null;
                }
                fileEntry = v3;
                Thread.sleep(1000L);
            }
            if (fileEntry == null) {
                this.setIndexerDone(false, 203);
                this.close();
                throw new ScraperException(203, "no request found for link");
            }
            for (int counterResponse = 0; ((object = (CharSequence)fileEntry.getResponse().getContent().getText()) == null || object.length() == 0) && counterResponse < 120; ++counterResponse) {
                Thread.sleep(1000L);
            }
            object = fileEntry.getResponse().getContent().getText();
            if (object == null || object.length() == 0) {
                this.setIndexerDone(false, 200);
                this.close();
                throw new ScraperException(200, "file didnt load for " + fileEntry.getRequest().getUrl() + " for source url " + sourceUrl);
            }
            fileList.add(fileEntry);
        }
        block.invoke((Object)this.proxy);
        this.close();
        return fileList;
    }

    public static /* synthetic */ List startHarIndexer$default(HarIndexer harIndexer, String string, List list, Function1 function1, Function1 function12, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: startHarIndexer");
        }
        if ((n & 2) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 4) != 0) {
            function1 = null;
        }
        return harIndexer.startHarIndexer(string, list, (Function1<? super WebDriverWait, Unit>)function1, (Function1<? super BrowserMobProxyServer, Boolean>)function12);
    }

    @Override
    public void close() {
        this.chromeDriver.quit();
        if (!this.proxy.isStopped()) {
            this.proxy.stop();
        }
    }
}

