/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.lib.contentscrapers.abztract;

import com.ustadmobile.core.account.Endpoint;
import com.ustadmobile.lib.contentscrapers.ContentScraperUtil;
import com.ustadmobile.lib.contentscrapers.ScraperConstants;
import com.ustadmobile.lib.contentscrapers.abztract.Indexer;
import io.github.bonigarcia.wdm.WebDriverManager;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.kodein.di.DI;
import org.openqa.selenium.InvalidArgumentException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.support.ui.WebDriverWait;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\b\u0010\u0013\u001a\u00020\u0014H\u0016J;\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182+\b\u0002\u0010\u0019\u001a%\u0012\u0013\u0012\u00110\u001b\u00a2\u0006\f\b\u001c\u0012\b\b\u001d\u0012\u0004\b\b(\u0019\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u001aj\u0004\u0018\u0001`\u001eR\u001a\u0010\r\u001a\u00020\u000eX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001f"}, d2={"Lcom/ustadmobile/lib/contentscrapers/abztract/SeleniumIndexer;", "Lcom/ustadmobile/lib/contentscrapers/abztract/Indexer;", "parentContentEntry", "", "runUid", "", "sqiUid", "contentEntryUid", "endpoint", "Lcom/ustadmobile/core/account/Endpoint;", "di", "Lorg/kodein/di/DI;", "(JIIJLcom/ustadmobile/core/account/Endpoint;Lorg/kodein/di/DI;)V", "chromeDriver", "Lorg/openqa/selenium/chrome/ChromeDriver;", "getChromeDriver", "()Lorg/openqa/selenium/chrome/ChromeDriver;", "setChromeDriver", "(Lorg/openqa/selenium/chrome/ChromeDriver;)V", "close", "", "startSeleniumIndexer", "Lorg/jsoup/nodes/Document;", "url", "", "waitCondition", "Lkotlin/Function1;", "Lorg/openqa/selenium/support/ui/WebDriverWait;", "Lkotlin/ParameterName;", "name", "Lcom/ustadmobile/lib/contentscrapers/abztract/WaitConditionFn;", "lib-content-scrapers"})
public abstract class SeleniumIndexer
extends Indexer {
    @NotNull
    private ChromeDriver chromeDriver;

    public SeleniumIndexer(long parentContentEntry, int runUid, int sqiUid, long contentEntryUid, @NotNull Endpoint endpoint, @NotNull DI di) {
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        Intrinsics.checkNotNullParameter((Object)di, (String)"di");
        super(parentContentEntry, runUid, sqiUid, contentEntryUid, endpoint, di);
        WebDriverManager.chromedriver().setup();
        ChromeOptions options = new ChromeOptions();
        this.chromeDriver = new ChromeDriver(options);
    }

    @NotNull
    protected final ChromeDriver getChromeDriver() {
        return this.chromeDriver;
    }

    protected final void setChromeDriver(@NotNull ChromeDriver chromeDriver) {
        Intrinsics.checkNotNullParameter((Object)chromeDriver, (String)"<set-?>");
        this.chromeDriver = chromeDriver;
    }

    @NotNull
    public final Document startSeleniumIndexer(@NotNull String url, @Nullable Function1<? super WebDriverWait, Unit> waitCondition) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        ContentScraperUtil.INSTANCE.clearChromeConsoleLog(this.chromeDriver);
        try {
            this.chromeDriver.navigate().to(url);
        }
        catch (InvalidArgumentException e) {
            this.setIndexerDone(false, 200);
            this.close();
            throw new IllegalArgumentException(e);
        }
        WebDriverWait waitDriver = new WebDriverWait((WebDriver)this.chromeDriver, ScraperConstants.INSTANCE.getTIME_OUT_SELENIUM());
        ContentScraperUtil.INSTANCE.waitForJSandJQueryToLoad(waitDriver);
        Function1<? super WebDriverWait, Unit> function1 = waitCondition;
        if (function1 != null) {
            function1.invoke((Object)waitDriver);
        }
        Document doc = Jsoup.parse((String)this.chromeDriver.getPageSource());
        this.close();
        Intrinsics.checkNotNullExpressionValue((Object)doc, (String)"doc");
        return doc;
    }

    public static /* synthetic */ Document startSeleniumIndexer$default(SeleniumIndexer seleniumIndexer, String string, Function1 function1, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: startSeleniumIndexer");
        }
        if ((n & 2) != 0) {
            function1 = null;
        }
        return seleniumIndexer.startSeleniumIndexer(string, (Function1<? super WebDriverWait, Unit>)function1);
    }

    @Override
    public void close() {
        this.chromeDriver.close();
    }
}

