/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.lib.staging.contentscrapers.gdl;

import com.ustadmobile.core.contentformats.opds.OpdsEntry;
import com.ustadmobile.core.contentformats.opds.OpdsFeed;
import com.ustadmobile.core.contentformats.opds.OpdsLink;
import com.ustadmobile.core.db.dao.ContentCategoryDao;
import com.ustadmobile.core.db.dao.ContentCategorySchemaDao;
import com.ustadmobile.core.db.dao.ContentEntryContentCategoryJoinDao;
import com.ustadmobile.core.db.dao.ContentEntryDao;
import com.ustadmobile.core.db.dao.ContentEntryParentChildJoinDao;
import com.ustadmobile.core.db.dao.LanguageDao;
import com.ustadmobile.core.db.dao.LanguageVariantDao;
import com.ustadmobile.core.db.dao.ScrapeQueueItemDao;
import com.ustadmobile.core.util.LiveDataWorkQueue;
import com.ustadmobile.lib.contentscrapers.ContentScraperUtil;
import com.ustadmobile.lib.contentscrapers.ScraperConstants;
import com.ustadmobile.lib.contentscrapers.UMLogUtil;
import com.ustadmobile.lib.db.entities.ContentCategory;
import com.ustadmobile.lib.db.entities.ContentCategorySchema;
import com.ustadmobile.lib.db.entities.ContentEntry;
import com.ustadmobile.lib.db.entities.Language;
import com.ustadmobile.lib.db.entities.LanguageVariant;
import com.ustadmobile.lib.db.entities.ScrapeQueueItem;
import com.ustadmobile.lib.staging.contentscrapers.gdl.GdlContentIndexer;
import com.ustadmobile.lib.staging.contentscrapers.gdl.GdlContentScraper;
import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.GlobalScope;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserFactory;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 \"2\u00020\u0001:\u0001\"B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\rJ(\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J(\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J(\u0010\u001f\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010 \u001a\u00020\u001c2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\b\u0010!\u001a\u00020\u001aH\u0016R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\f\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0017\u00a8\u0006#"}, d2={"Lcom/ustadmobile/lib/staging/contentscrapers/gdl/GdlContentIndexer;", "Ljava/lang/Runnable;", "queueUrl", "Ljava/net/URL;", "parentEntry", "Lcom/ustadmobile/lib/db/entities/ContentEntry;", "destLocation", "Ljava/io/File;", "contentType", "", "scrapeQueueItemUid", "", "runId", "(Ljava/net/URL;Lcom/ustadmobile/lib/db/entities/ContentEntry;Ljava/io/File;Ljava/lang/String;II)V", "getContentType", "()Ljava/lang/String;", "getDestLocation", "()Ljava/io/File;", "getParentEntry", "()Lcom/ustadmobile/lib/db/entities/ContentEntry;", "getQueueUrl", "()Ljava/net/URL;", "getRunId", "()I", "getScrapeQueueItemUid", "browseContent", "", "feed", "Lcom/ustadmobile/core/contentformats/opds/OpdsFeed;", "url", "browseLanguages", "browsePages", "getFeed", "run", "Companion", "lib-content-scrapers"})
public final class GdlContentIndexer
implements Runnable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final URL queueUrl;
    @NotNull
    private final ContentEntry parentEntry;
    @NotNull
    private final File destLocation;
    @NotNull
    private final String contentType;
    private final int scrapeQueueItemUid;
    private final int runId;
    @NotNull
    private static final String ROOT_URL = "https://opds.staging.digitallibrary.io/v1/en/root.xml";
    private static ContentEntryDao contentEntryDao;
    private static ContentEntryParentChildJoinDao contentParentChildJoinDao;
    private static Language englishLang;
    private static ScrapeQueueItemDao queueDao;
    private static ContentEntry gdlEntry;
    private static LanguageDao langDao;
    private static LanguageVariantDao langVariantDao;
    private static ContentCategorySchemaDao categorySchemeDao;
    private static ContentCategoryDao categoryDao;
    private static ContentEntryContentCategoryJoinDao contentCategoryJoinDao;
    private static int index;
    private static LiveDataWorkQueue<ScrapeQueueItem> scrapeWorkQueue;
    @NotNull
    private static final Map<String, Integer> ccMap;

    public GdlContentIndexer(@NotNull URL queueUrl, @NotNull ContentEntry parentEntry, @NotNull File destLocation, @NotNull String contentType, int scrapeQueueItemUid, int runId) {
        Intrinsics.checkNotNullParameter((Object)queueUrl, (String)"queueUrl");
        Intrinsics.checkNotNullParameter((Object)parentEntry, (String)"parentEntry");
        Intrinsics.checkNotNullParameter((Object)destLocation, (String)"destLocation");
        Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
        this.queueUrl = queueUrl;
        this.parentEntry = parentEntry;
        this.destLocation = destLocation;
        this.contentType = contentType;
        this.scrapeQueueItemUid = scrapeQueueItemUid;
        this.runId = runId;
    }

    @NotNull
    public final URL getQueueUrl() {
        return this.queueUrl;
    }

    @NotNull
    public final ContentEntry getParentEntry() {
        return this.parentEntry;
    }

    @NotNull
    public final File getDestLocation() {
        return this.destLocation;
    }

    @NotNull
    public final String getContentType() {
        return this.contentType;
    }

    public final int getScrapeQueueItemUid() {
        return this.scrapeQueueItemUid;
    }

    public final int getRunId() {
        return this.runId;
    }

    @Override
    public void run() {
        ScrapeQueueItemDao scrapeQueueItemDao;
        System.gc();
        ScrapeQueueItemDao scrapeQueueItemDao2 = queueDao;
        if (scrapeQueueItemDao2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"queueDao");
            scrapeQueueItemDao2 = null;
        }
        scrapeQueueItemDao2.setTimeStarted(this.scrapeQueueItemUid, System.currentTimeMillis());
        boolean successful = false;
        OpdsFeed feed = null;
        try {
            feed = this.getFeed(this.queueUrl);
        }
        catch (Exception e) {
            ScrapeQueueItemDao scrapeQueueItemDao3 = queueDao;
            if (scrapeQueueItemDao3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"queueDao");
                scrapeQueueItemDao3 = null;
            }
            scrapeQueueItemDao3.updateSetStatusById(this.scrapeQueueItemUid, 4, 0);
            ScrapeQueueItemDao scrapeQueueItemDao4 = queueDao;
            if (scrapeQueueItemDao4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"queueDao");
                scrapeQueueItemDao4 = null;
            }
            scrapeQueueItemDao4.setTimeFinished(this.scrapeQueueItemUid, System.currentTimeMillis());
        }
        String string = this.contentType;
        if (Intrinsics.areEqual((Object)string, (Object)ScraperConstants.GDLContentType.ROOT.getType())) {
            try {
                OpdsFeed opdsFeed = feed;
                Intrinsics.checkNotNull((Object)opdsFeed);
                this.browseLanguages(opdsFeed, this.parentEntry, this.queueUrl, this.destLocation);
                this.browsePages(feed, this.parentEntry, this.queueUrl, this.destLocation);
                this.browseContent(feed, this.parentEntry, this.queueUrl, this.destLocation);
                successful = true;
            }
            catch (Exception e) {
                String string2 = ExceptionUtils.getStackTrace((Throwable)e);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getStackTrace(e)");
                UMLogUtil.INSTANCE.logError(string2);
                UMLogUtil.INSTANCE.logError("Error creating topics for url " + this.queueUrl);
            }
        } else if (Intrinsics.areEqual((Object)string, (Object)ScraperConstants.GDLContentType.LANGPAGE.getType())) {
            try {
                OpdsFeed opdsFeed = feed;
                Intrinsics.checkNotNull((Object)opdsFeed);
                this.browsePages(opdsFeed, this.parentEntry, this.queueUrl, this.destLocation);
                this.browseContent(feed, this.parentEntry, this.queueUrl, this.destLocation);
                successful = true;
            }
            catch (Exception e) {
                String string3 = ExceptionUtils.getStackTrace((Throwable)e);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getStackTrace(e)");
                UMLogUtil.INSTANCE.logError(string3);
                UMLogUtil.INSTANCE.logError("Error creating subjects for url " + this.queueUrl);
            }
        } else if (Intrinsics.areEqual((Object)string, (Object)ScraperConstants.GDLContentType.CONTENT.getType())) {
            try {
                OpdsFeed opdsFeed = feed;
                Intrinsics.checkNotNull((Object)opdsFeed);
                this.browseContent(opdsFeed, this.parentEntry, this.queueUrl, this.destLocation);
                successful = true;
            }
            catch (Exception e) {
                String string4 = ExceptionUtils.getStackTrace((Throwable)e);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getStackTrace(e)");
                UMLogUtil.INSTANCE.logError(string4);
                UMLogUtil.INSTANCE.logError("Error creating subjects for url " + this.queueUrl);
            }
        }
        if ((scrapeQueueItemDao = queueDao) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"queueDao");
            scrapeQueueItemDao = null;
        }
        scrapeQueueItemDao.updateSetStatusById(this.scrapeQueueItemUid, successful ? 3 : 4, 0);
        ScrapeQueueItemDao scrapeQueueItemDao5 = queueDao;
        if (scrapeQueueItemDao5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"queueDao");
            scrapeQueueItemDao5 = null;
        }
        scrapeQueueItemDao5.setTimeFinished(this.scrapeQueueItemUid, System.currentTimeMillis());
    }

    private final void browsePages(OpdsFeed feed, ContentEntry parentEntry, URL queueUrl, File destLocation) {
        OpdsLink lastLink;
        Object v0;
        block6: {
            Iterable iterable = feed.getLinkList();
            for (Object t : iterable) {
                OpdsLink it = (OpdsLink)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getRel(), (Object)"last")) continue;
                v0 = t;
                break block6;
            }
            v0 = null;
        }
        OpdsLink opdsLink = lastLink = (OpdsLink)v0;
        Intrinsics.checkNotNull((Object)opdsLink);
        String hrefLink = opdsLink.getHref();
        int sizeOfPages = Integer.parseInt(StringsKt.substringAfter$default((String)hrefLink, (String)"page=", null, (int)2, null));
        if (sizeOfPages == 1) {
            return;
        }
        int x = 2;
        int n = sizeOfPages;
        if (x <= n) {
            while (true) {
                String pageLink = StringsKt.replaceAfter$default((String)hrefLink, (String)"page=", (String)String.valueOf(x), null, (int)4, null);
                ScrapeQueueItemDao scrapeQueueItemDao = queueDao;
                if (scrapeQueueItemDao == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"queueDao");
                    scrapeQueueItemDao = null;
                }
                URL uRL = new URL(pageLink);
                ContentEntry contentEntry = gdlEntry;
                if (contentEntry == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"gdlEntry");
                    contentEntry = null;
                }
                ContentScraperUtil.INSTANCE.createQueueItem(scrapeQueueItemDao, uRL, contentEntry, destLocation, ScraperConstants.GDLContentType.CONTENT.getType(), this.runId, 1);
                if (x == n) break;
                ++x;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void browseLanguages(OpdsFeed feed, ContentEntry parentEntry, URL queueUrl, File destLocation) {
        void $this$forEach$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Iterable iterable = feed.getLinkList();
        boolean $i$f$filter = false;
        Iterator iterator = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            OpdsLink it = (OpdsLink)element$iv$iv;
            boolean bl = false;
            if (!(Intrinsics.areEqual((Object)it.getFacetGroup(), (Object)"Languages") && Intrinsics.areEqual((Object)it.getActiveFacet(), (Object)false))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            OpdsLink lang = (OpdsLink)element$iv;
            boolean bl = false;
            File parentFolder = destLocation.getParentFile();
            String string = lang.getTitle();
            Intrinsics.checkNotNull((Object)string);
            File langFolder = new File(parentFolder, string);
            langFolder.mkdirs();
            ScrapeQueueItemDao scrapeQueueItemDao = queueDao;
            if (scrapeQueueItemDao == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"queueDao");
                scrapeQueueItemDao = null;
            }
            URL uRL = new URL(lang.getHref());
            ContentEntry contentEntry = gdlEntry;
            if (contentEntry == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"gdlEntry");
                contentEntry = null;
            }
            ContentScraperUtil.INSTANCE.createQueueItem(scrapeQueueItemDao, uRL, contentEntry, langFolder, ScraperConstants.GDLContentType.LANGPAGE.getType(), this.runId, 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final OpdsFeed getFeed(URL queueUrl) {
        InputStream opfIn = null;
        XmlPullParserFactory xppFactory = XmlPullParserFactory.newInstance();
        try {
            opfIn = queueUrl.openStream();
            XmlPullParser parser = xppFactory.newPullParser();
            parser.setInput(opfIn, "UTF-8");
            OpdsFeed feed = new OpdsFeed();
            Intrinsics.checkNotNullExpressionValue((Object)parser, (String)"parser");
            feed.loadFromParser(parser);
            OpdsFeed opdsFeed = feed;
            return opdsFeed;
        }
        catch (Exception e) {
            String string = ExceptionUtils.getStackTrace((Throwable)e);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStackTrace(e)");
            UMLogUtil.INSTANCE.logError(string);
            UMLogUtil.INSTANCE.logError("Error creating subjects for url " + queueUrl);
            throw new IllegalArgumentException("Error creating subjects for url " + queueUrl);
        }
        finally {
            block5: {
                InputStream inputStream = opfIn;
                if (inputStream == null) break block5;
                inputStream.close();
            }
        }
    }

    private final void browseContent(OpdsFeed feed, ContentEntry parentEntry, URL url, File destLocation) {
        Iterable $this$forEach$iv = feed.getEntryList();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            int licenseType;
            Object v3;
            OpdsLink sourceUrl;
            Object object2;
            OpdsEntry it;
            block20: {
                OpdsLink opdsLink;
                Object v0;
                Object type2;
                Iterable iterable;
                block18: {
                    it = (OpdsEntry)element$iv;
                    boolean bl = false;
                    iterable = it.getLinkList();
                    for (Object object2 : iterable) {
                        type2 = (OpdsLink)object2;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual((Object)type2.getType(), (Object)"application/epub+zip")) continue;
                        v0 = object2;
                        break block18;
                    }
                    v0 = null;
                }
                if ((opdsLink = (OpdsLink)v0) == null) {
                    Object object3;
                    block19: {
                        Iterator iterator = it.getLinkList();
                        object2 = iterator.iterator();
                        while (object2.hasNext()) {
                            Object otherType = type2 = object2.next();
                            boolean bl = false;
                            if (!Intrinsics.areEqual((Object)otherType.getType(), (Object)"application/pdf")) continue;
                            object3 = type2;
                            break block19;
                        }
                        object3 = null;
                    }
                    if ((opdsLink = (OpdsLink)object3) == null) continue;
                }
                sourceUrl = opdsLink;
                iterable = it.getLinkList();
                for (Object object2 : iterable) {
                    OpdsLink rel = (OpdsLink)object2;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)rel.getRel(), (Object)"http://opds-spec.org/image/thumbnail")) continue;
                    v3 = object2;
                    break block20;
                }
                v3 = null;
            }
            OpdsLink thumbnail = v3;
            Integer n = ccMap.get(it.getLicense());
            int n2 = licenseType = n != null ? n : -1;
            if (licenseType == -1) {
                UMLogUtil.INSTANCE.logError(it.getLicense() + " for book title " + it.getTitle());
            }
            String string = url.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"url.toString()");
            String language = StringsKt.substringBefore$default((String)StringsKt.substringAfter$default((String)string, (String)".io/v1/", null, (int)2, null), (String)"/root.xml", null, (int)2, null);
            object2 = new String[]{"-"};
            List primary = StringsKt.split$default((CharSequence)language, object2, (boolean)false, (int)0, (int)6, null);
            Language lang = null;
            if (((String)primary.get(0)).length() == 2) {
                LanguageDao languageDao = langDao;
                if (languageDao == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"langDao");
                    languageDao = null;
                }
                lang = ContentScraperUtil.INSTANCE.insertOrUpdateLanguageByTwoCode(languageDao, (String)primary.get(0));
            } else {
                LanguageDao languageDao = langDao;
                if (languageDao == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"langDao");
                    languageDao = null;
                }
                lang = ContentScraperUtil.INSTANCE.insertOrUpdateLanguageByThreeCode(languageDao, (String)primary.get(0));
            }
            LanguageVariant variant = null;
            if (primary.size() > 1) {
                LanguageVariantDao languageVariantDao = langVariantDao;
                if (languageVariantDao == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"langVariantDao");
                    languageVariantDao = null;
                }
                variant = ContentScraperUtil.INSTANCE.insertOrUpdateLanguageVariant(languageVariantDao, (String)primary.get(1), lang);
            }
            String string2 = it.getId();
            String string3 = it.getTitle();
            String string4 = sourceUrl.getHref();
            String string5 = it.getPublisher();
            Intrinsics.checkNotNull((Object)string5);
            long l = lang.getLangUid();
            LanguageVariant languageVariant = variant;
            Long l2 = languageVariant != null ? Long.valueOf(languageVariant.getLangVariantUid()) : null;
            String string6 = it.getSummary();
            String string7 = it.getAuthor();
            OpdsLink opdsLink = thumbnail;
            String string8 = opdsLink != null ? opdsLink.getHref() : null;
            ContentEntryDao contentEntryDao = GdlContentIndexer.contentEntryDao;
            if (contentEntryDao == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"contentEntryDao");
                contentEntryDao = null;
            }
            ContentEntry contentEntry = ContentScraperUtil.INSTANCE.createOrUpdateContentEntry(string2, string3, string4, string5, licenseType, l, l2, string6, true, string7, string8, "", "", 0, contentEntryDao);
            ContentEntryParentChildJoinDao contentEntryParentChildJoinDao = contentParentChildJoinDao;
            if (contentEntryParentChildJoinDao == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"contentParentChildJoinDao");
                contentEntryParentChildJoinDao = null;
            }
            int n3 = index;
            index = n3 + 1;
            ContentScraperUtil.INSTANCE.insertOrUpdateParentChildJoin(contentEntryParentChildJoinDao, parentEntry, contentEntry, n3);
            File contentFolder = new File(destLocation, StringsKt.substringAfter$default((String)it.getId(), (String)"uuid:", null, (int)2, null));
            contentFolder.mkdirs();
            String scrapeType = Intrinsics.areEqual((Object)sourceUrl.getType(), (Object)"application/epub+zip") ? "application/epub+zip" : "application/pdf";
            ContentCategorySchemaDao contentCategorySchemaDao = categorySchemeDao;
            if (contentCategorySchemaDao == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"categorySchemeDao");
                contentCategorySchemaDao = null;
            }
            ContentCategorySchema schema = ContentScraperUtil.INSTANCE.insertOrUpdateSchema(contentCategorySchemaDao, "African Storybooks Reading Level", "africanstorybooks/reading/");
            ContentCategoryDao contentCategoryDao = categoryDao;
            if (contentCategoryDao == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"categoryDao");
                contentCategoryDao = null;
            }
            String string9 = it.getTargetName();
            Intrinsics.checkNotNull((Object)string9);
            ContentCategory category = ContentScraperUtil.INSTANCE.insertOrUpdateCategoryContent(contentCategoryDao, schema, string9);
            ContentEntryContentCategoryJoinDao contentEntryContentCategoryJoinDao = contentCategoryJoinDao;
            if (contentEntryContentCategoryJoinDao == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"contentCategoryJoinDao");
                contentEntryContentCategoryJoinDao = null;
            }
            ContentScraperUtil.INSTANCE.insertOrUpdateChildWithMultipleCategoriesJoin(contentEntryContentCategoryJoinDao, category, contentEntry);
            ScrapeQueueItemDao scrapeQueueItemDao = queueDao;
            if (scrapeQueueItemDao == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"queueDao");
                scrapeQueueItemDao = null;
            }
            ContentScraperUtil.INSTANCE.createQueueItem(scrapeQueueItemDao, new URL(sourceUrl.getHref()), contentEntry, contentFolder, scrapeType, this.runId, 2);
        }
    }

    @JvmStatic
    public static final void main(@NotNull String[] args) {
        Companion.main(args);
    }

    public static final /* synthetic */ LiveDataWorkQueue access$getScrapeWorkQueue$cp() {
        return scrapeWorkQueue;
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"Creative Commons Attribution 4.0 International", (Object)1), TuplesKt.to((Object)"Creative Commons Attribution Non Commercial 4.0 International", (Object)4), TuplesKt.to((Object)"Creative Commons Attribution Non Commercial 3.0 Unported", (Object)4), TuplesKt.to((Object)"Creative Commons Attribution Non Commercial Share Alike 4.0 International", (Object)3), TuplesKt.to((Object)"Creative Commons Attribution No Derivatives 4.0 International", (Object)10), TuplesKt.to((Object)"Creative Commons Attribution Share Alike 4.0 International", (Object)2), TuplesKt.to((Object)"Creative Commons Attribution 3.0 Unported", (Object)1)};
        ccMap = MapsKt.mapOf((Pair[])pairArray);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001b\u0010\"\u001a\u00020#2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00040%H\u0007\u00a2\u0006\u0002\u0010&J\u001e\u0010'\u001a\u00020#2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020)2\u0006\u0010+\u001a\u00020\rJ&\u0010,\u001a\u00020#2\u0006\u0010-\u001a\u00020\u00042\u0006\u0010.\u001a\u00020)2\u0006\u0010/\u001a\u00020)2\u0006\u0010+\u001a\u00020\rR\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lcom/ustadmobile/lib/staging/contentscrapers/gdl/GdlContentIndexer$Companion;", "", "()V", "ROOT_URL", "", "getROOT_URL", "()Ljava/lang/String;", "categoryDao", "Lcom/ustadmobile/core/db/dao/ContentCategoryDao;", "categorySchemeDao", "Lcom/ustadmobile/core/db/dao/ContentCategorySchemaDao;", "ccMap", "", "", "contentCategoryJoinDao", "Lcom/ustadmobile/core/db/dao/ContentEntryContentCategoryJoinDao;", "contentEntryDao", "Lcom/ustadmobile/core/db/dao/ContentEntryDao;", "contentParentChildJoinDao", "Lcom/ustadmobile/core/db/dao/ContentEntryParentChildJoinDao;", "englishLang", "Lcom/ustadmobile/lib/db/entities/Language;", "gdlEntry", "Lcom/ustadmobile/lib/db/entities/ContentEntry;", "index", "langDao", "Lcom/ustadmobile/core/db/dao/LanguageDao;", "langVariantDao", "Lcom/ustadmobile/core/db/dao/LanguageVariantDao;", "queueDao", "Lcom/ustadmobile/core/db/dao/ScrapeQueueItemDao;", "scrapeWorkQueue", "Lcom/ustadmobile/core/util/LiveDataWorkQueue;", "Lcom/ustadmobile/lib/db/entities/ScrapeQueueItem;", "main", "", "args", "", "([Ljava/lang/String;)V", "scrapeFromRoot", "destination", "Ljava/io/File;", "container", "runId", "startScrape", "startUrl", "destinationDir", "containerDir", "lib-content-scrapers"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getROOT_URL() {
            return ROOT_URL;
        }

        @JvmStatic
        public final void main(@NotNull String[] args) {
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            if (args.length < 2) {
                System.err.println("Usage: <file destination><container destination><optional log{trace, debug, info, warn, error, fatal}>");
                System.exit(1);
                throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
            }
            UMLogUtil.INSTANCE.setLevel(args.length == 3 ? args[2] : "");
            UMLogUtil.INSTANCE.logInfo(args[0]);
            UMLogUtil.INSTANCE.logInfo(args[1]);
            ContentScraperUtil.INSTANCE.checkIfPathsToDriversExist();
            try {
                this.scrapeFromRoot(new File(args[0]), new File(args[1]), 0);
            }
            catch (Exception e) {
                String string = ExceptionUtils.getStackTrace((Throwable)e);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStackTrace(e)");
                UMLogUtil.INSTANCE.logFatal(string);
                UMLogUtil.INSTANCE.logError("Main method exception catch khan");
            }
        }

        public final void scrapeFromRoot(@NotNull File destination, @NotNull File container2, int runId) {
            Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
            Intrinsics.checkNotNullParameter((Object)container2, (String)"container");
            this.startScrape(this.getROOT_URL(), destination, container2, runId);
        }

        public final void startScrape(@NotNull String startUrl, @NotNull File destinationDir, @NotNull File containerDir, int runId) {
            ContentEntry contentEntry;
            Intrinsics.checkNotNullParameter((Object)startUrl, (String)"startUrl");
            Intrinsics.checkNotNullParameter((Object)destinationDir, (String)"destinationDir");
            Intrinsics.checkNotNullParameter((Object)containerDir, (String)"containerDir");
            URL url = null;
            try {
                url = new URL(startUrl);
            }
            catch (MalformedURLException e) {
                UMLogUtil.INSTANCE.logFatal("Index Malformed url" + startUrl);
                throw new IllegalArgumentException("Malformed url" + startUrl, e);
            }
            Object db = null;
            Intrinsics.throwUninitializedPropertyAccessException((String)"db");
            Object repository = null;
            destinationDir.mkdirs();
            containerDir.mkdirs();
            GdlContentIndexer.contentEntryDao = repository.getContentEntryDao();
            contentParentChildJoinDao = repository.getContentEntryParentChildJoinDao();
            langDao = repository.getLanguageDao();
            langVariantDao = repository.getLanguageVariantDao();
            categorySchemeDao = repository.getContentCategorySchemaDao();
            contentCategoryJoinDao = repository.getContentEntryContentCategoryJoinDao();
            categoryDao = repository.getContentCategoryDao();
            LanguageDao languageDao = repository.getLanguageDao();
            queueDao = db.getScrapeQueueItemDao();
            englishLang = ContentScraperUtil.INSTANCE.insertOrUpdateLanguageByName(languageDao, "English");
            LanguageDao languageDao2 = langDao;
            if (languageDao2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"langDao");
                languageDao2 = null;
            }
            ContentScraperUtil.INSTANCE.insertOrUpdateLanguageManual(languageDao2, "Bukusu", "bxk");
            LanguageDao languageDao3 = langDao;
            if (languageDao3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"langDao");
                languageDao3 = null;
            }
            ContentScraperUtil.INSTANCE.insertOrUpdateLanguageManual(languageDao3, "Lu", "khb");
            LanguageDao languageDao4 = langDao;
            if (languageDao4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"langDao");
                languageDao4 = null;
            }
            ContentScraperUtil.INSTANCE.insertOrUpdateLanguageManual(languageDao4, "Kalanguya", "kak");
            LanguageDao languageDao5 = langDao;
            if (languageDao5 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"langDao");
                languageDao5 = null;
            }
            ContentScraperUtil.INSTANCE.insertOrUpdateLanguageManual(languageDao5, "Hadiyya", "hdy");
            LanguageDao languageDao6 = langDao;
            if (languageDao6 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"langDao");
                languageDao6 = null;
            }
            ContentScraperUtil.INSTANCE.insertOrUpdateLanguageManual(languageDao6, "Gusii", "guz");
            LanguageDao languageDao7 = langDao;
            if (languageDao7 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"langDao");
                languageDao7 = null;
            }
            ContentScraperUtil.INSTANCE.insertOrUpdateLanguageManual(languageDao7, "Wanga", "lwg");
            Language language = englishLang;
            if (language == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"englishLang");
                language = null;
            }
            long l = language.getLangUid();
            ContentEntryDao contentEntryDao = contentEntryDao;
            if (contentEntryDao == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"contentEntryDao");
                contentEntryDao = null;
            }
            ContentEntry masterRootParent = ContentScraperUtil.INSTANCE.createOrUpdateContentEntry("root", "Ustad Mobile", "root", "Ustad Mobile", 1, l, null, "", false, "", "", "", "", 0, contentEntryDao);
            Language language2 = englishLang;
            if (language2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"englishLang");
                language2 = null;
            }
            long l2 = language2.getLangUid();
            ContentEntryDao contentEntryDao2 = contentEntryDao;
            if (contentEntryDao2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"contentEntryDao");
                contentEntryDao2 = null;
            }
            gdlEntry = ContentScraperUtil.INSTANCE.createOrUpdateContentEntry("https://digitallibrary.io/", "Global Digital Library", "https://opds.staging.digitallibrary.io/v1/en/root.xml/", "Global Digital Library", 4, l2, null, "bringing books to every child in the world by 2030", false, "", "https://www.ustadmobile.com/files/gdl-logo.webp", "", "", 0, contentEntryDao2);
            File englishFolder = new File(destinationDir, "English");
            englishFolder.mkdirs();
            ScrapeQueueItemDao scrapeQueueItemDao = queueDao;
            if (scrapeQueueItemDao == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"queueDao");
                scrapeQueueItemDao = null;
            }
            if ((contentEntry = gdlEntry) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"gdlEntry");
                contentEntry = null;
            }
            ContentScraperUtil.INSTANCE.createQueueItem(scrapeQueueItemDao, url, contentEntry, englishFolder, ScraperConstants.GDLContentType.ROOT.getType(), runId, 1);
            int indexProcessor = 4;
            ScrapeQueueItemDao scrapeQueueItemDao2 = queueDao;
            if (scrapeQueueItemDao2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"queueDao");
                scrapeQueueItemDao2 = null;
            }
            LiveDataWorkQueue indexWorkQueue2 = new LiveDataWorkQueue(scrapeQueueItemDao2.findNextQueueItems(1), (Function2)startScrape.indexWorkQueue.1.INSTANCE, indexProcessor, null, null, null, null, null, (Function2)new Function2<ScrapeQueueItem, Continuation<? super Unit>, Object>(runId, null){
                int label;
                /* synthetic */ Object L$0;
                final /* synthetic */ int $runId;
                {
                    this.$runId = $runId;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object var1_1) {
                    var6_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            it = (ScrapeQueueItem)this.L$0;
                            v0 = GdlContentIndexer.access$getQueueDao$cp();
                            if (v0 == null) {
                                Intrinsics.throwUninitializedPropertyAccessException((String)"queueDao");
                                v0 = null;
                            }
                            v0.updateSetStatusById(it.getSqiUid(), 2, 0);
                            v1 = GdlContentIndexer.access$getContentEntryDao$cp();
                            if (v1 == null) {
                                Intrinsics.throwUninitializedPropertyAccessException((String)"contentEntryDao");
                                v1 = null;
                            }
                            this.L$0 = it;
                            this.label = 1;
                            v2 = v1.findByUidAsync(it.getSqiContentEntryParentUid(), (Continuation)this);
                            if (v2 == var6_2) {
                                return var6_2;
                            }
                            ** GOTO lbl25
                        }
                        case 1: {
                            it = (ScrapeQueueItem)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v2 = $result;
lbl25:
                            // 2 sources

                            parent = (ContentEntry)v2;
                            try {
                                v3 = it.getScrapeUrl();
                                Intrinsics.checkNotNull((Object)v3);
                                queueUrl = new URL(v3);
                                v4 = parent;
                                Intrinsics.checkNotNull((Object)v4);
                                v5 = it.getDestDir();
                                Intrinsics.checkNotNull((Object)v5);
                                v6 = new File(v5);
                                v7 = it.getContentType();
                                Intrinsics.checkNotNull((Object)v7);
                                new GdlContentIndexer(queueUrl, v4, v6, v7, it.getSqiUid(), this.$runId).run();
                            }
                            catch (Exception var5_6) {
                                v8 = new StringBuilder().append("SEVERE: invalid URL to index: should not be in queue:");
                                v9 = it.getScrapeUrl();
                                Intrinsics.checkNotNull((Object)v9);
                                throw new RuntimeException(v8.append(v9).toString());
                            }
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    Function2<ScrapeQueueItem, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                    function2.L$0 = value;
                    return (Continuation)function2;
                }

                @Nullable
                public final Object invoke(@NotNull ScrapeQueueItem p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }, 248, null);
            BuildersKt.launch$default((CoroutineScope)((CoroutineScope)GlobalScope.INSTANCE), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>((LiveDataWorkQueue<ScrapeQueueItem>)indexWorkQueue2, null){
                int label;
                final /* synthetic */ LiveDataWorkQueue<ScrapeQueueItem> $indexWorkQueue;
                {
                    this.$indexWorkQueue = $indexWorkQueue;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            this.label = 1;
                            Object object3 = this.$indexWorkQueue.start((Continuation)this);
                            if (object3 != object2) return Unit.INSTANCE;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
            int scrapePrecessor = 6;
            ScrapeQueueItemDao scrapeQueueItemDao3 = queueDao;
            if (scrapeQueueItemDao3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"queueDao");
                scrapeQueueItemDao3 = null;
            }
            scrapeWorkQueue = new LiveDataWorkQueue(scrapeQueueItemDao3.findNextQueueItems(2), (Function2)startScrape.2.INSTANCE, scrapePrecessor, null, null, null, null, null, (Function2)new Function2<ScrapeQueueItem, Continuation<? super Unit>, Object>(containerDir, null){
                int label;
                /* synthetic */ Object L$0;
                final /* synthetic */ File $containerDir;
                {
                    this.$containerDir = $containerDir;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object var1_1) {
                    var6_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            it = (ScrapeQueueItem)this.L$0;
                            v0 = GdlContentIndexer.access$getQueueDao$cp();
                            if (v0 == null) {
                                Intrinsics.throwUninitializedPropertyAccessException((String)"queueDao");
                                v0 = null;
                            }
                            v0.updateSetStatusById(it.getSqiUid(), 2, 0);
                            v1 = GdlContentIndexer.access$getContentEntryDao$cp();
                            if (v1 == null) {
                                Intrinsics.throwUninitializedPropertyAccessException((String)"contentEntryDao");
                                v1 = null;
                            }
                            this.L$0 = it;
                            this.label = 1;
                            v2 = v1.findByUidAsync(it.getSqiContentEntryParentUid(), (Continuation)this);
                            if (v2 == var6_2) {
                                return var6_2;
                            }
                            ** GOTO lbl25
                        }
                        case 1: {
                            it = (ScrapeQueueItem)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v2 = $result;
lbl25:
                            // 2 sources

                            parent = (ContentEntry)v2;
                            try {
                                v3 = it.getScrapeUrl();
                                Intrinsics.checkNotNull((Object)v3);
                                scrapeUrl = new URL(v3);
                                v4 = it.getDestDir();
                                Intrinsics.checkNotNull((Object)v4);
                                v5 = new File(v4);
                                v6 = parent;
                                Intrinsics.checkNotNull((Object)v6);
                                v7 = it.getContentType();
                                Intrinsics.checkNotNull((Object)v7);
                                new GdlContentScraper(scrapeUrl, v5, this.$containerDir, v6, v7, it.getSqiUid()).run();
                            }
                            catch (Exception var5_6) {
                                v8 = new StringBuilder().append("SEVERE: invalid URL to scrape: should not be in queue:");
                                v9 = it.getScrapeUrl();
                                Intrinsics.checkNotNull((Object)v9);
                                throw new RuntimeException(v8.append(v9).toString());
                            }
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    Function2<ScrapeQueueItem, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                    function2.L$0 = value;
                    return (Continuation)function2;
                }

                @Nullable
                public final Object invoke(@NotNull ScrapeQueueItem p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }, 248, null);
            BuildersKt.launch$default((CoroutineScope)((CoroutineScope)GlobalScope.INSTANCE), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null){
                int label;

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            LiveDataWorkQueue liveDataWorkQueue = GdlContentIndexer.access$getScrapeWorkQueue$cp();
                            if (liveDataWorkQueue == null) {
                                Intrinsics.throwUninitializedPropertyAccessException((String)"scrapeWorkQueue");
                                liveDataWorkQueue = null;
                            }
                            this.label = 1;
                            Object object3 = liveDataWorkQueue.start((Continuation)this);
                            if (object3 != object2) return Unit.INSTANCE;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
            UMLogUtil.INSTANCE.logInfo("Finished Indexer");
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

