/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.lib.contentscrapers.ddl;

import com.ustadmobile.core.account.Endpoint;
import com.ustadmobile.core.db.dao.LanguageDao;
import com.ustadmobile.lib.contentscrapers.abztract.Indexer;
import com.ustadmobile.lib.db.entities.ContentEntry;
import com.ustadmobile.lib.db.entities.Language;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.kodein.di.DI;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\b\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016\u00a8\u0006\u0012"}, d2={"Lcom/ustadmobile/lib/contentscrapers/ddl/DdlPageIndexer;", "Lcom/ustadmobile/lib/contentscrapers/abztract/Indexer;", "parentContentEntryUid", "", "runId", "", "sqiUid", "contentEntryUid", "endpoint", "Lcom/ustadmobile/core/account/Endpoint;", "di", "Lorg/kodein/di/DI;", "(JIIJLcom/ustadmobile/core/account/Endpoint;Lorg/kodein/di/DI;)V", "close", "", "indexUrl", "sourceUrl", "", "lib-content-scrapers"})
public final class DdlPageIndexer
extends Indexer {
    public DdlPageIndexer(long parentContentEntryUid, int runId, int sqiUid, long contentEntryUid, @NotNull Endpoint endpoint, @NotNull DI di) {
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        Intrinsics.checkNotNullParameter((Object)di, (String)"di");
        super(parentContentEntryUid, runId, sqiUid, contentEntryUid, endpoint, di);
    }

    @Override
    public void indexUrl(@NotNull String sourceUrl) {
        Language langEntry;
        Intrinsics.checkNotNullParameter((Object)sourceUrl, (String)"sourceUrl");
        LanguageDao languageDao = this.getDb().getLanguageDao();
        ContentEntry contentEntry = this.getParentContentEntry();
        Long l = contentEntry != null ? Long.valueOf(contentEntry.getPrimaryLanguageUid()) : null;
        Intrinsics.checkNotNull((Object)l);
        Language language = langEntry = languageDao.findByUid(l.longValue());
        String twoCodeLang = language != null ? language.getIso_639_1_standard() : null;
        Document document2 = Jsoup.connect((String)sourceUrl).header("X-Requested-With", "XMLHttpRequest").get();
        Elements pageList = document2.select("a.page-link");
        int maxNumber = 1;
        for (Element page : pageList) {
            String num = page.text();
            try {
                int number = Integer.parseInt(num);
                if (number <= maxNumber) continue;
                maxNumber = number;
            }
            catch (NumberFormatException number) {}
        }
        String subjectId = StringsKt.substringAfterLast$default((String)sourceUrl, (String)"=", null, (int)2, null);
        int i = 1;
        int n = maxNumber;
        if (i <= n) {
            while (true) {
                String url = "https://www.ddl.af/" + twoCodeLang + "/resources/list?subject_area=" + subjectId + "&page=" + i;
                Indexer indexer = this;
                ContentEntry contentEntry2 = this.getParentContentEntry();
                Intrinsics.checkNotNull((Object)contentEntry2);
                Indexer.createQueueItem$default(indexer, url, contentEntry2, "ddlListIndexer", 1, this.getParentContentEntryUid(), 0, 32, null);
                if (i == n) break;
                ++i;
            }
        }
        this.setIndexerDone(true, 0);
    }

    @Override
    public void close() {
    }
}

