package com.ustadmobile.core.db.dao;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.lifecycle.LiveData;
import androidx.paging.DataSource;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.paging.LimitOffsetDataSource;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.lib.db.entities.AssignmentProgressSummary;
import com.ustadmobile.lib.db.entities.ClazzAssignment;
import com.ustadmobile.lib.db.entities.ClazzAssignmentWithCourseBlock;
import com.ustadmobile.lib.db.entities.CourseBlock;
import com.ustadmobile.lib.db.entities.PersonGroupAssignmentSummary;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;

@SuppressWarnings({"unchecked", "deprecation"})
public final class ClazzAssignmentDao_Impl extends ClazzAssignmentDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<ClazzAssignment> __insertionAdapterOfClazzAssignment;

  private final EntityDeletionOrUpdateAdapter<ClazzAssignment> __updateAdapterOfClazzAssignment;

  private final SharedSQLiteStatement __preparedStmtOfReplicateOnNewNode;

  private final SharedSQLiteStatement __preparedStmtOfReplicateOnChange;

  private final SharedSQLiteStatement __preparedStmtOfUpdateActiveByUid;

  public ClazzAssignmentDao_Impl(RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfClazzAssignment = new EntityInsertionAdapter<ClazzAssignment>(__db) {
      @Override
      public String createQuery() {
        return "INSERT OR ABORT INTO `ClazzAssignment` (`caUid`,`caTitle`,`caDescription`,`caGroupUid`,`caActive`,`caClassCommentEnabled`,`caPrivateCommentsEnabled`,`caCompletionCriteria`,`caRequireFileSubmission`,`caFileType`,`caSizeLimit`,`caNumberOfFiles`,`caSubmissionPolicy`,`caMarkingType`,`caRequireTextSubmission`,`caTextLimitType`,`caTextLimit`,`caXObjectUid`,`caClazzUid`,`caLocalChangeSeqNum`,`caMasterChangeSeqNum`,`caLastChangedBy`,`caLct`) VALUES (nullif(?, 0),?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, ClazzAssignment value) {
        stmt.bindLong(1, value.getCaUid());
        if (value.getCaTitle() == null) {
          stmt.bindNull(2);
        } else {
          stmt.bindString(2, value.getCaTitle());
        }
        if (value.getCaDescription() == null) {
          stmt.bindNull(3);
        } else {
          stmt.bindString(3, value.getCaDescription());
        }
        stmt.bindLong(4, value.getCaGroupUid());
        final int _tmp = value.getCaActive() ? 1 : 0;
        stmt.bindLong(5, _tmp);
        final int _tmp_1 = value.getCaClassCommentEnabled() ? 1 : 0;
        stmt.bindLong(6, _tmp_1);
        final int _tmp_2 = value.getCaPrivateCommentsEnabled() ? 1 : 0;
        stmt.bindLong(7, _tmp_2);
        stmt.bindLong(8, value.getCaCompletionCriteria());
        final int _tmp_3 = value.getCaRequireFileSubmission() ? 1 : 0;
        stmt.bindLong(9, _tmp_3);
        stmt.bindLong(10, value.getCaFileType());
        stmt.bindLong(11, value.getCaSizeLimit());
        stmt.bindLong(12, value.getCaNumberOfFiles());
        stmt.bindLong(13, value.getCaSubmissionPolicy());
        stmt.bindLong(14, value.getCaMarkingType());
        final int _tmp_4 = value.getCaRequireTextSubmission() ? 1 : 0;
        stmt.bindLong(15, _tmp_4);
        stmt.bindLong(16, value.getCaTextLimitType());
        stmt.bindLong(17, value.getCaTextLimit());
        stmt.bindLong(18, value.getCaXObjectUid());
        stmt.bindLong(19, value.getCaClazzUid());
        stmt.bindLong(20, value.getCaLocalChangeSeqNum());
        stmt.bindLong(21, value.getCaMasterChangeSeqNum());
        stmt.bindLong(22, value.getCaLastChangedBy());
        stmt.bindLong(23, value.getCaLct());
      }
    };
    this.__updateAdapterOfClazzAssignment = new EntityDeletionOrUpdateAdapter<ClazzAssignment>(__db) {
      @Override
      public String createQuery() {
        return "UPDATE OR ABORT `ClazzAssignment` SET `caUid` = ?,`caTitle` = ?,`caDescription` = ?,`caGroupUid` = ?,`caActive` = ?,`caClassCommentEnabled` = ?,`caPrivateCommentsEnabled` = ?,`caCompletionCriteria` = ?,`caRequireFileSubmission` = ?,`caFileType` = ?,`caSizeLimit` = ?,`caNumberOfFiles` = ?,`caSubmissionPolicy` = ?,`caMarkingType` = ?,`caRequireTextSubmission` = ?,`caTextLimitType` = ?,`caTextLimit` = ?,`caXObjectUid` = ?,`caClazzUid` = ?,`caLocalChangeSeqNum` = ?,`caMasterChangeSeqNum` = ?,`caLastChangedBy` = ?,`caLct` = ? WHERE `caUid` = ?";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, ClazzAssignment value) {
        stmt.bindLong(1, value.getCaUid());
        if (value.getCaTitle() == null) {
          stmt.bindNull(2);
        } else {
          stmt.bindString(2, value.getCaTitle());
        }
        if (value.getCaDescription() == null) {
          stmt.bindNull(3);
        } else {
          stmt.bindString(3, value.getCaDescription());
        }
        stmt.bindLong(4, value.getCaGroupUid());
        final int _tmp = value.getCaActive() ? 1 : 0;
        stmt.bindLong(5, _tmp);
        final int _tmp_1 = value.getCaClassCommentEnabled() ? 1 : 0;
        stmt.bindLong(6, _tmp_1);
        final int _tmp_2 = value.getCaPrivateCommentsEnabled() ? 1 : 0;
        stmt.bindLong(7, _tmp_2);
        stmt.bindLong(8, value.getCaCompletionCriteria());
        final int _tmp_3 = value.getCaRequireFileSubmission() ? 1 : 0;
        stmt.bindLong(9, _tmp_3);
        stmt.bindLong(10, value.getCaFileType());
        stmt.bindLong(11, value.getCaSizeLimit());
        stmt.bindLong(12, value.getCaNumberOfFiles());
        stmt.bindLong(13, value.getCaSubmissionPolicy());
        stmt.bindLong(14, value.getCaMarkingType());
        final int _tmp_4 = value.getCaRequireTextSubmission() ? 1 : 0;
        stmt.bindLong(15, _tmp_4);
        stmt.bindLong(16, value.getCaTextLimitType());
        stmt.bindLong(17, value.getCaTextLimit());
        stmt.bindLong(18, value.getCaXObjectUid());
        stmt.bindLong(19, value.getCaClazzUid());
        stmt.bindLong(20, value.getCaLocalChangeSeqNum());
        stmt.bindLong(21, value.getCaMasterChangeSeqNum());
        stmt.bindLong(22, value.getCaLastChangedBy());
        stmt.bindLong(23, value.getCaLct());
        stmt.bindLong(24, value.getCaUid());
      }
    };
    this.__preparedStmtOfReplicateOnNewNode = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "\n"
                + "     REPLACE INTO ClazzAssignmentReplicate(caPk, caDestination)\n"
                + "      SELECT DISTINCT ClazzAssignment.caUid AS caUid,\n"
                + "             ? AS caDestination\n"
                + "        FROM UserSession\n"
                + "             JOIN PersonGroupMember \n"
                + "                    ON UserSession.usPersonUid = PersonGroupMember.groupMemberPersonUid\n"
                + "             \n"
                + "               JOIN ScopedGrant\n"
                + "                    ON ScopedGrant.sgGroupUid = PersonGroupMember.groupMemberGroupUid\n"
                + "                        AND (ScopedGrant.sgPermissions & \n"
                + "        \n"
                + "                    8388608 \n"
                + "                    \n"
                + "                       ) > 0\n"
                + "               JOIN Clazz \n"
                + "                    ON \n"
                + "            ((ScopedGrant.sgTableId = -2\n"
                + "                                AND ScopedGrant.sgEntityUid = -2)\n"
                + "                            OR (ScopedGrant.sgTableId = 6\n"
                + "                                AND ScopedGrant.sgEntityUid = Clazz.clazzUid)\n"
                + "                            OR (ScopedGrant.sgTableId = 164\n"
                + "                                AND ScopedGrant.sgEntityUid = Clazz.clazzSchoolUid))\n"
                + "        \n"
                + "        \n"
                + "             JOIN ClazzAssignment\n"
                + "                    ON ClazzAssignment.caClazzUid = Clazz.clazzUid\n"
                + "       WHERE UserSession.usClientNodeId = ?\n"
                + "         AND UserSession.usStatus = 1\n"
                + "         AND ClazzAssignment.caLct != COALESCE(\n"
                + "             (SELECT caVersionId\n"
                + "                FROM ClazzAssignmentReplicate\n"
                + "               WHERE caPk = ClazzAssignment.caUid\n"
                + "                 AND caDestination = ?), 0) \n"
                + "      /*psql ON CONFLICT(caPk, caDestination) DO UPDATE\n"
                + "             SET caPending = true\n"
                + "      */       \n"
                + "    ";
        return _query;
      }
    };
    this.__preparedStmtOfReplicateOnChange = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "\n"
                + " REPLACE INTO ClazzAssignmentReplicate(caPk, caDestination)\n"
                + "  SELECT DISTINCT ClazzAssignment.caUid AS caUid,\n"
                + "         UserSession.usClientNodeId AS caDestination\n"
                + "    FROM ChangeLog\n"
                + "         JOIN ClazzAssignment\n"
                + "             ON ChangeLog.chTableId = 520\n"
                + "                AND ChangeLog.chEntityPk = ClazzAssignment.caUid\n"
                + "         JOIN Clazz \n"
                + "              ON Clazz.clazzUid = ClazzAssignment.caClazzUid \n"
                + "         \n"
                + "            JOIN ScopedGrant\n"
                + "                 ON \n"
                + "            ((ScopedGrant.sgTableId = -2\n"
                + "                                AND ScopedGrant.sgEntityUid = -2)\n"
                + "                            OR (ScopedGrant.sgTableId = 6\n"
                + "                                AND ScopedGrant.sgEntityUid = Clazz.clazzUid)\n"
                + "                            OR (ScopedGrant.sgTableId = 164\n"
                + "                                AND ScopedGrant.sgEntityUid = Clazz.clazzSchoolUid))\n"
                + "        \n"
                + "                    AND (ScopedGrant.sgPermissions & \n"
                + "        \n"
                + "              8388608\n"
                + "              \n"
                + "              \n"
                + "                                                       ) > 0\n"
                + "             JOIN PersonGroupMember AS PrsGrpMbr\n"
                + "                   ON ScopedGrant.sgGroupUid = PrsGrpMbr.groupMemberGroupUid\n"
                + "                                               \n"
                + "              JOIN UserSession\n"
                + "                   ON UserSession.usPersonUid = PrsGrpMbr.groupMemberPersonUid\n"
                + "                      AND UserSession.usStatus = 1\n"
                + "          \n"
                + "   WHERE UserSession.usClientNodeId != (\n"
                + "         SELECT nodeClientId \n"
                + "           FROM SyncNode\n"
                + "          LIMIT 1)\n"
                + "     AND ClazzAssignment.caLct != COALESCE(\n"
                + "         (SELECT caVersionId\n"
                + "            FROM ClazzAssignmentReplicate\n"
                + "           WHERE caPk = ClazzAssignment.caUid\n"
                + "             AND caDestination = UserSession.usClientNodeId), 0)\n"
                + " /*psql ON CONFLICT(caPk, caDestination) DO UPDATE\n"
                + "     SET caPending = true\n"
                + "  */               \n"
                + " ";
        return _query;
      }
    };
    this.__preparedStmtOfUpdateActiveByUid = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "\n"
                + "        UPDATE ClazzAssignment \n"
                + "           SET caActive = ?, \n"
                + "               caLct = ?\n"
                + "         WHERE caUid = ?";
        return _query;
      }
    };
  }

  @Override
  public long insert(final ClazzAssignment entity) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      long _result = __insertionAdapterOfClazzAssignment.insertAndReturnId(entity);
      __db.setTransactionSuccessful();
      return _result;
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object insertAsync(final ClazzAssignment entity,
      final Continuation<? super Long> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Long>() {
      @Override
      public Long call() throws Exception {
        __db.beginTransaction();
        try {
          long _result = __insertionAdapterOfClazzAssignment.insertAndReturnId(entity);
          __db.setTransactionSuccessful();
          return _result;
        } finally {
          __db.endTransaction();
        }
      }
    }, continuation);
  }

  @Override
  public void insertList(final List<? extends ClazzAssignment> entityList) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __insertionAdapterOfClazzAssignment.insert(entityList);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object insertListAsync(final List<? extends ClazzAssignment> entityList,
      final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __insertionAdapterOfClazzAssignment.insert(entityList);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, continuation);
  }

  @Override
  public void updateList(final List<? extends ClazzAssignment> entityList) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __updateAdapterOfClazzAssignment.handleMultiple(entityList);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public void update(final ClazzAssignment entity) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __updateAdapterOfClazzAssignment.handle(entity);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object updateListAsync(final List<? extends ClazzAssignment> entityList,
      final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __updateAdapterOfClazzAssignment.handleMultiple(entityList);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, continuation);
  }

  @Override
  public Object updateAsync(final ClazzAssignment clazzAssignment,
      final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __updateAdapterOfClazzAssignment.handle(clazzAssignment);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, continuation);
  }

  @Override
  public Object replicateOnNewNode(final long newNodeId,
      final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfReplicateOnNewNode.acquire();
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, newNodeId);
        _argIndex = 2;
        _stmt.bindLong(_argIndex, newNodeId);
        _argIndex = 3;
        _stmt.bindLong(_argIndex, newNodeId);
        __db.beginTransaction();
        try {
          _stmt.executeInsert();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfReplicateOnNewNode.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public Object replicateOnChange(final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfReplicateOnChange.acquire();
        __db.beginTransaction();
        try {
          _stmt.executeInsert();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfReplicateOnChange.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public Object updateActiveByUid(final long cbUid, final boolean active, final long changeTime,
      final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfUpdateActiveByUid.acquire();
        int _argIndex = 1;
        final int _tmp = active ? 1 : 0;
        _stmt.bindLong(_argIndex, _tmp);
        _argIndex = 2;
        _stmt.bindLong(_argIndex, changeTime);
        _argIndex = 3;
        _stmt.bindLong(_argIndex, cbUid);
        __db.beginTransaction();
        try {
          _stmt.executeUpdateDelete();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfUpdateActiveByUid.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public Object getAllAssignmentsByClazzUidAsync(final long clazzUid,
      final Continuation<? super List<? extends ClazzAssignment>> continuation) {
    final String _sql = "\n"
            + "        SELECT * \n"
            + "          FROM ClazzAssignment\n"
            + "         WHERE ClazzAssignment.caClazzUid = ?\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, clazzUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<ClazzAssignment>>() {
      @Override
      public List<ClazzAssignment> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfCaUid = CursorUtil.getColumnIndexOrThrow(_cursor, "caUid");
          final int _cursorIndexOfCaTitle = CursorUtil.getColumnIndexOrThrow(_cursor, "caTitle");
          final int _cursorIndexOfCaDescription = CursorUtil.getColumnIndexOrThrow(_cursor, "caDescription");
          final int _cursorIndexOfCaGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "caGroupUid");
          final int _cursorIndexOfCaActive = CursorUtil.getColumnIndexOrThrow(_cursor, "caActive");
          final int _cursorIndexOfCaClassCommentEnabled = CursorUtil.getColumnIndexOrThrow(_cursor, "caClassCommentEnabled");
          final int _cursorIndexOfCaPrivateCommentsEnabled = CursorUtil.getColumnIndexOrThrow(_cursor, "caPrivateCommentsEnabled");
          final int _cursorIndexOfCaCompletionCriteria = CursorUtil.getColumnIndexOrThrow(_cursor, "caCompletionCriteria");
          final int _cursorIndexOfCaRequireFileSubmission = CursorUtil.getColumnIndexOrThrow(_cursor, "caRequireFileSubmission");
          final int _cursorIndexOfCaFileType = CursorUtil.getColumnIndexOrThrow(_cursor, "caFileType");
          final int _cursorIndexOfCaSizeLimit = CursorUtil.getColumnIndexOrThrow(_cursor, "caSizeLimit");
          final int _cursorIndexOfCaNumberOfFiles = CursorUtil.getColumnIndexOrThrow(_cursor, "caNumberOfFiles");
          final int _cursorIndexOfCaSubmissionPolicy = CursorUtil.getColumnIndexOrThrow(_cursor, "caSubmissionPolicy");
          final int _cursorIndexOfCaMarkingType = CursorUtil.getColumnIndexOrThrow(_cursor, "caMarkingType");
          final int _cursorIndexOfCaRequireTextSubmission = CursorUtil.getColumnIndexOrThrow(_cursor, "caRequireTextSubmission");
          final int _cursorIndexOfCaTextLimitType = CursorUtil.getColumnIndexOrThrow(_cursor, "caTextLimitType");
          final int _cursorIndexOfCaTextLimit = CursorUtil.getColumnIndexOrThrow(_cursor, "caTextLimit");
          final int _cursorIndexOfCaXObjectUid = CursorUtil.getColumnIndexOrThrow(_cursor, "caXObjectUid");
          final int _cursorIndexOfCaClazzUid = CursorUtil.getColumnIndexOrThrow(_cursor, "caClazzUid");
          final int _cursorIndexOfCaLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "caLocalChangeSeqNum");
          final int _cursorIndexOfCaMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "caMasterChangeSeqNum");
          final int _cursorIndexOfCaLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "caLastChangedBy");
          final int _cursorIndexOfCaLct = CursorUtil.getColumnIndexOrThrow(_cursor, "caLct");
          final List<ClazzAssignment> _result = new ArrayList<ClazzAssignment>(_cursor.getCount());
          while(_cursor.moveToNext()) {
            final ClazzAssignment _item;
            _item = new ClazzAssignment();
            final long _tmpCaUid;
            _tmpCaUid = _cursor.getLong(_cursorIndexOfCaUid);
            _item.setCaUid(_tmpCaUid);
            final String _tmpCaTitle;
            if (_cursor.isNull(_cursorIndexOfCaTitle)) {
              _tmpCaTitle = null;
            } else {
              _tmpCaTitle = _cursor.getString(_cursorIndexOfCaTitle);
            }
            _item.setCaTitle(_tmpCaTitle);
            final String _tmpCaDescription;
            if (_cursor.isNull(_cursorIndexOfCaDescription)) {
              _tmpCaDescription = null;
            } else {
              _tmpCaDescription = _cursor.getString(_cursorIndexOfCaDescription);
            }
            _item.setCaDescription(_tmpCaDescription);
            final long _tmpCaGroupUid;
            _tmpCaGroupUid = _cursor.getLong(_cursorIndexOfCaGroupUid);
            _item.setCaGroupUid(_tmpCaGroupUid);
            final boolean _tmpCaActive;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfCaActive);
            _tmpCaActive = _tmp != 0;
            _item.setCaActive(_tmpCaActive);
            final boolean _tmpCaClassCommentEnabled;
            final int _tmp_1;
            _tmp_1 = _cursor.getInt(_cursorIndexOfCaClassCommentEnabled);
            _tmpCaClassCommentEnabled = _tmp_1 != 0;
            _item.setCaClassCommentEnabled(_tmpCaClassCommentEnabled);
            final boolean _tmpCaPrivateCommentsEnabled;
            final int _tmp_2;
            _tmp_2 = _cursor.getInt(_cursorIndexOfCaPrivateCommentsEnabled);
            _tmpCaPrivateCommentsEnabled = _tmp_2 != 0;
            _item.setCaPrivateCommentsEnabled(_tmpCaPrivateCommentsEnabled);
            final int _tmpCaCompletionCriteria;
            _tmpCaCompletionCriteria = _cursor.getInt(_cursorIndexOfCaCompletionCriteria);
            _item.setCaCompletionCriteria(_tmpCaCompletionCriteria);
            final boolean _tmpCaRequireFileSubmission;
            final int _tmp_3;
            _tmp_3 = _cursor.getInt(_cursorIndexOfCaRequireFileSubmission);
            _tmpCaRequireFileSubmission = _tmp_3 != 0;
            _item.setCaRequireFileSubmission(_tmpCaRequireFileSubmission);
            final int _tmpCaFileType;
            _tmpCaFileType = _cursor.getInt(_cursorIndexOfCaFileType);
            _item.setCaFileType(_tmpCaFileType);
            final int _tmpCaSizeLimit;
            _tmpCaSizeLimit = _cursor.getInt(_cursorIndexOfCaSizeLimit);
            _item.setCaSizeLimit(_tmpCaSizeLimit);
            final int _tmpCaNumberOfFiles;
            _tmpCaNumberOfFiles = _cursor.getInt(_cursorIndexOfCaNumberOfFiles);
            _item.setCaNumberOfFiles(_tmpCaNumberOfFiles);
            final int _tmpCaSubmissionPolicy;
            _tmpCaSubmissionPolicy = _cursor.getInt(_cursorIndexOfCaSubmissionPolicy);
            _item.setCaSubmissionPolicy(_tmpCaSubmissionPolicy);
            final int _tmpCaMarkingType;
            _tmpCaMarkingType = _cursor.getInt(_cursorIndexOfCaMarkingType);
            _item.setCaMarkingType(_tmpCaMarkingType);
            final boolean _tmpCaRequireTextSubmission;
            final int _tmp_4;
            _tmp_4 = _cursor.getInt(_cursorIndexOfCaRequireTextSubmission);
            _tmpCaRequireTextSubmission = _tmp_4 != 0;
            _item.setCaRequireTextSubmission(_tmpCaRequireTextSubmission);
            final int _tmpCaTextLimitType;
            _tmpCaTextLimitType = _cursor.getInt(_cursorIndexOfCaTextLimitType);
            _item.setCaTextLimitType(_tmpCaTextLimitType);
            final int _tmpCaTextLimit;
            _tmpCaTextLimit = _cursor.getInt(_cursorIndexOfCaTextLimit);
            _item.setCaTextLimit(_tmpCaTextLimit);
            final long _tmpCaXObjectUid;
            _tmpCaXObjectUid = _cursor.getLong(_cursorIndexOfCaXObjectUid);
            _item.setCaXObjectUid(_tmpCaXObjectUid);
            final long _tmpCaClazzUid;
            _tmpCaClazzUid = _cursor.getLong(_cursorIndexOfCaClazzUid);
            _item.setCaClazzUid(_tmpCaClazzUid);
            final long _tmpCaLocalChangeSeqNum;
            _tmpCaLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfCaLocalChangeSeqNum);
            _item.setCaLocalChangeSeqNum(_tmpCaLocalChangeSeqNum);
            final long _tmpCaMasterChangeSeqNum;
            _tmpCaMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfCaMasterChangeSeqNum);
            _item.setCaMasterChangeSeqNum(_tmpCaMasterChangeSeqNum);
            final int _tmpCaLastChangedBy;
            _tmpCaLastChangedBy = _cursor.getInt(_cursorIndexOfCaLastChangedBy);
            _item.setCaLastChangedBy(_tmpCaLastChangedBy);
            final long _tmpCaLct;
            _tmpCaLct = _cursor.getLong(_cursorIndexOfCaLct);
            _item.setCaLct(_tmpCaLct);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, continuation);
  }

  @Override
  public LiveData<AssignmentProgressSummary> getProgressSummaryForAssignment(
      final long assignmentUid, final long clazzUid, final String group) {
    final String _sql = "\n"
            + "            \n"
            + "            WITH SubmitterList (submitterId, name)\n"
            + "            AS (SELECT DISTINCT ClazzEnrolment.clazzEnrolmentPersonUid AS submitterId, \n"
            + "                       Person.firstNames || ' ' || Person.lastName AS name\n"
            + "                  FROM ClazzEnrolment\n"
            + "                  \n"
            + "                       JOIN Person \n"
            + "                       ON Person.personUid = ClazzEnrolment.clazzEnrolmentPersonUid\n"
            + "                        \n"
            + "                       JOIN ClazzAssignment\n"
            + "                       ON ClazzAssignment.caUid = ?\n"
            + "\n"
            + "                       JOIN CourseBlock\n"
            + "                       ON CourseBlock.cbEntityUid = ClazzAssignment.caUid\n"
            + "                       AND CourseBlock.cbType = 103\n"
            + "                       \n"
            + "                 WHERE ClazzAssignment.caGroupUid = 0\n"
            + "                   AND clazzEnrolmentClazzUid = ?\n"
            + "                   AND clazzEnrolmentActive\n"
            + "                   AND clazzEnrolmentRole = 1000\n"
            + "                   AND CourseBlock.cbGracePeriodDate <= ClazzEnrolment.clazzEnrolmentDateLeft\n"
            + "                   AND ClazzEnrolment.clazzEnrolmentDateJoined <= CourseBlock.cbGracePeriodDate\n"
            + "              GROUP BY submitterId, name\n"
            + "            UNION                 \n"
            + "             SELECT DISTINCT CourseGroupMember.cgmGroupNumber AS submitterId,\n"
            + "                    ? || ' ' || CourseGroupMember.cgmGroupNumber AS name  \n"
            + "               FROM CourseGroupMember\n"
            + "                    JOIN ClazzAssignment\n"
            + "                    ON ClazzAssignment.caUid = ?\n"
            + "              WHERE CourseGroupMember.cgmSetUid = ClazzAssignment.caGroupUid\n"
            + "                AND ClazzAssignment.caGroupUid != 0\n"
            + "                AND CourseGroupMember.cgmGroupNumber != 0\n"
            + "           GROUP BY submitterId, name\n"
            + "            )\n"
            + "        \n"
            + "            \n"
            + "            SELECT (SELECT COUNT(*) FROM SubmitterList) AS totalStudents,\n"
            + "            \n"
            + "                    0 as notSubmittedStudents,\n"
            + "                    \n"
            + "                    (SELECT COUNT(DISTINCT CourseAssignmentSubmission.casSubmitterUid) \n"
            + "                      FROM CourseAssignmentSubmission\n"
            + "                           LEFT JOIN CourseAssignmentMark\n"
            + "                           ON CourseAssignmentSubmission.casSubmitterUid = CourseAssignmentMark.camSubmitterUid\n"
            + "                           AND CourseAssignmentMark.camAssignmentUid = CourseAssignmentSubmission.casAssignmentUid\n"
            + "                     WHERE CourseAssignmentSubmission.casAssignmentUid = ?\n"
            + "                       AND CourseAssignmentMark.camUid IS NULL\n"
            + "                       AND CourseAssignmentSubmission.casSubmitterUid IN (SELECT submitterId \n"
            + "                                                                            FROM SubmitterList))\n"
            + "                      AS submittedStudents,\n"
            + "                     \n"
            + "                     \n"
            + "                     (SELECT COUNT(DISTINCT CourseAssignmentMark.camSubmitterUid) \n"
            + "                        FROM CourseAssignmentMark\n"
            + "                            \n"
            + "                             JOIN CourseAssignmentSubmission\n"
            + "                             ON CourseAssignmentSubmission.casSubmitterUid = CourseAssignmentMark.camSubmitterUid\n"
            + "                             AND CourseAssignmentSubmission.casAssignmentUid = CourseAssignmentMark.camAssignmentUid\n"
            + "                             \n"
            + "                       WHERE CourseAssignmentMark.camAssignmentUid = ?\n"
            + "                         AND CourseAssignmentMark.camSubmitterUid IN (SELECT submitterId \n"
            + "                                                                            FROM SubmitterList))\n"
            + "                         AS markedStudents, \n"
            + "                         \n"
            + "                         'TRUE' AS hasMetricsPermission\n"
            + "                         \n"
            + "         FROM  ClazzAssignment\n"
            + "        WHERE caActive\n"
            + "          AND caClazzUid = ? \n"
            + "          AND caUid = ?                  \n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 8);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, assignmentUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, clazzUid);
    _argIndex = 3;
    if (group == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, group);
    }
    _argIndex = 4;
    _statement.bindLong(_argIndex, assignmentUid);
    _argIndex = 5;
    _statement.bindLong(_argIndex, assignmentUid);
    _argIndex = 6;
    _statement.bindLong(_argIndex, assignmentUid);
    _argIndex = 7;
    _statement.bindLong(_argIndex, clazzUid);
    _argIndex = 8;
    _statement.bindLong(_argIndex, assignmentUid);
    return __db.getInvalidationTracker().createLiveData(new String[]{"ClazzEnrolment","Person","ClazzAssignment","CourseBlock","CourseGroupMember","CourseAssignmentSubmission","CourseAssignmentMark"}, false, new Callable<AssignmentProgressSummary>() {
      @Override
      public AssignmentProgressSummary call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfTotalStudents = 0;
          final int _cursorIndexOfNotSubmittedStudents = 1;
          final int _cursorIndexOfSubmittedStudents = 2;
          final int _cursorIndexOfMarkedStudents = 3;
          final int _cursorIndexOfHasMetricsPermission = 4;
          final AssignmentProgressSummary _result;
          if(_cursor.moveToFirst()) {
            _result = new AssignmentProgressSummary();
            final int _tmpTotalStudents;
            _tmpTotalStudents = _cursor.getInt(_cursorIndexOfTotalStudents);
            _result.setTotalStudents(_tmpTotalStudents);
            final int _tmpNotSubmittedStudents;
            _tmpNotSubmittedStudents = _cursor.getInt(_cursorIndexOfNotSubmittedStudents);
            _result.setNotSubmittedStudents(_tmpNotSubmittedStudents);
            final int _tmpSubmittedStudents;
            _tmpSubmittedStudents = _cursor.getInt(_cursorIndexOfSubmittedStudents);
            _result.setSubmittedStudents(_tmpSubmittedStudents);
            final int _tmpMarkedStudents;
            _tmpMarkedStudents = _cursor.getInt(_cursorIndexOfMarkedStudents);
            _result.setMarkedStudents(_tmpMarkedStudents);
            final boolean _tmpHasMetricsPermission;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfHasMetricsPermission);
            _tmpHasMetricsPermission = _tmp != 0;
            _result.setHasMetricsPermission(_tmpHasMetricsPermission);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @Override
  public DataSource.Factory<Integer, PersonGroupAssignmentSummary> getSubmitterListForAssignment(
      final long assignmentUid, final long clazzUid, final String group, final String searchText) {
    final String _sql = "\n"
            + "         \n"
            + "            WITH SubmitterList (submitterId, name)\n"
            + "            AS (SELECT DISTINCT ClazzEnrolment.clazzEnrolmentPersonUid AS submitterId, \n"
            + "                       Person.firstNames || ' ' || Person.lastName AS name\n"
            + "                  FROM ClazzEnrolment\n"
            + "                  \n"
            + "                       JOIN Person \n"
            + "                       ON Person.personUid = ClazzEnrolment.clazzEnrolmentPersonUid\n"
            + "                        \n"
            + "                       JOIN ClazzAssignment\n"
            + "                       ON ClazzAssignment.caUid = ?\n"
            + "\n"
            + "                       JOIN CourseBlock\n"
            + "                       ON CourseBlock.cbEntityUid = ClazzAssignment.caUid\n"
            + "                       AND CourseBlock.cbType = 103\n"
            + "                       \n"
            + "                 WHERE ClazzAssignment.caGroupUid = 0\n"
            + "                   AND clazzEnrolmentClazzUid = ?\n"
            + "                   AND clazzEnrolmentActive\n"
            + "                   AND clazzEnrolmentRole = 1000\n"
            + "                   AND CourseBlock.cbGracePeriodDate <= ClazzEnrolment.clazzEnrolmentDateLeft\n"
            + "                   AND ClazzEnrolment.clazzEnrolmentDateJoined <= CourseBlock.cbGracePeriodDate\n"
            + "              GROUP BY submitterId, name\n"
            + "            UNION                 \n"
            + "             SELECT DISTINCT CourseGroupMember.cgmGroupNumber AS submitterId,\n"
            + "                    ? || ' ' || CourseGroupMember.cgmGroupNumber AS name  \n"
            + "               FROM CourseGroupMember\n"
            + "                    JOIN ClazzAssignment\n"
            + "                    ON ClazzAssignment.caUid = ?\n"
            + "              WHERE CourseGroupMember.cgmSetUid = ClazzAssignment.caGroupUid\n"
            + "                AND ClazzAssignment.caGroupUid != 0\n"
            + "                AND CourseGroupMember.cgmGroupNumber != 0\n"
            + "           GROUP BY submitterId, name\n"
            + "            )\n"
            + "        \n"
            + "        \n"
            + "         SELECT submitterId AS submitterUid,\n"
            + "                name, \n"
            + "                \n"
            + "                 COALESCE((CASE WHEN CourseAssignmentMark.camUid IS NOT NULL \n"
            + "                          THEN 2 \n"
            + "                          WHEN CourseAssignmentSubmission.casUid IS NOT NULL \n"
            + "                          THEN 1 \n"
            + "                          ELSE 0 END), \n"
            + "                               0) AS fileSubmissionStatus,\n"
            + "                \n"
            + "                (CASE WHEN ClazzAssignment.caGroupUid = 0 \n"
            + "                 THEN 'TRUE' \n"
            + "                 ELSE 'FALSE' END) AS isGroupAssignment,\n"
            + "                 \n"
            + "                 cm.commentsText AS latestPrivateComment \n"
            + "\n"
            + "           FROM SubmitterList\n"
            + "                JOIN ClazzAssignment\n"
            + "                ON ClazzAssignment.caUid = ?\n"
            + "           \n"
            + "                LEFT JOIN CourseAssignmentMark\n"
            + "                ON CourseAssignmentMark.camUid = (SELECT camUid\n"
            + "                                                    FROM CourseAssignmentMark\n"
            + "                                                   WHERE camAssignmentUid = ?\n"
            + "                                                     AND camSubmitterUid = SubmitterList.submitterId\n"
            + "                                                ORDER BY camLct DESC \n"
            + "                                                   LIMIT 1)\n"
            + "                \n"
            + "                LEFT JOIN CourseAssignmentSubmission\n"
            + "                ON CourseAssignmentSubmission.casUid = (SELECT casUid\n"
            + "                                                          FROM CourseAssignmentSubmission\n"
            + "                                                         WHERE casAssignmentUid = ?\n"
            + "                                                           AND casSubmitterUid = SubmitterList.submitterId\n"
            + "                                                      ORDER BY casTimestamp DESC \n"
            + "                                                         LIMIT 1)\n"
            + "                LEFT JOIN Comments AS cm \n"
            + "                    ON cm.commentsUid = (\n"
            + "                                 SELECT Comments.commentsUid \n"
            + "                                   FROM Comments \n"
            + "                                  WHERE Comments.commentsEntityType = 520\n"
            + "                                    AND commentsEntityUid = ?\n"
            + "                                    AND NOT commentsInActive\n"
            + "                                    AND NOT commentsPublic\n"
            + "                                    AND (CASE WHEN ClazzAssignment.caGroupUid = 0\n"
            + "                                              THEN commentsPersonUid = SubmitterList.submitterId\n"
            + "                                              ELSE commentSubmitterUid = SubmitterList.submitterId END)\n"
            + "                               ORDER BY commentsDateTimeAdded DESC LIMIT 1)                                                      \n"
            + "                                                                      \n"
            + "          WHERE name LIKE ?\n"
            + "       ORDER BY name \n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 9);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, assignmentUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, clazzUid);
    _argIndex = 3;
    if (group == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, group);
    }
    _argIndex = 4;
    _statement.bindLong(_argIndex, assignmentUid);
    _argIndex = 5;
    _statement.bindLong(_argIndex, assignmentUid);
    _argIndex = 6;
    _statement.bindLong(_argIndex, assignmentUid);
    _argIndex = 7;
    _statement.bindLong(_argIndex, assignmentUid);
    _argIndex = 8;
    _statement.bindLong(_argIndex, assignmentUid);
    _argIndex = 9;
    if (searchText == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, searchText);
    }
    return new DataSource.Factory<Integer, PersonGroupAssignmentSummary>() {
      @Override
      public LimitOffsetDataSource<PersonGroupAssignmentSummary> create() {
        return new LimitOffsetDataSource<PersonGroupAssignmentSummary>(__db, _statement, false, true , "ClazzEnrolment", "Person", "ClazzAssignment", "CourseBlock", "CourseGroupMember", "CourseAssignmentMark", "CourseAssignmentSubmission", "Comments") {
          @Override
          protected List<PersonGroupAssignmentSummary> convertRows(Cursor cursor) {
            final int _cursorIndexOfSubmitterUid = 0;
            final int _cursorIndexOfName = 1;
            final int _cursorIndexOfFileSubmissionStatus = 2;
            final int _cursorIndexOfIsGroupAssignment = 3;
            final int _cursorIndexOfLatestPrivateComment = 4;
            final List<PersonGroupAssignmentSummary> _res = new ArrayList<PersonGroupAssignmentSummary>(cursor.getCount());
            while(cursor.moveToNext()) {
              final PersonGroupAssignmentSummary _item;
              _item = new PersonGroupAssignmentSummary();
              final long _tmpSubmitterUid;
              _tmpSubmitterUid = cursor.getLong(_cursorIndexOfSubmitterUid);
              _item.setSubmitterUid(_tmpSubmitterUid);
              final String _tmpName;
              if (cursor.isNull(_cursorIndexOfName)) {
                _tmpName = null;
              } else {
                _tmpName = cursor.getString(_cursorIndexOfName);
              }
              _item.setName(_tmpName);
              final int _tmpFileSubmissionStatus;
              _tmpFileSubmissionStatus = cursor.getInt(_cursorIndexOfFileSubmissionStatus);
              _item.setFileSubmissionStatus(_tmpFileSubmissionStatus);
              final boolean _tmpIsGroupAssignment;
              final int _tmp;
              _tmp = cursor.getInt(_cursorIndexOfIsGroupAssignment);
              _tmpIsGroupAssignment = _tmp != 0;
              _item.setGroupAssignment(_tmpIsGroupAssignment);
              final String _tmpLatestPrivateComment;
              if (cursor.isNull(_cursorIndexOfLatestPrivateComment)) {
                _tmpLatestPrivateComment = null;
              } else {
                _tmpLatestPrivateComment = cursor.getString(_cursorIndexOfLatestPrivateComment);
              }
              _item.setLatestPrivateComment(_tmpLatestPrivateComment);
              _res.add(_item);
            }
            return _res;
          }
        };
      }
    };
  }

  @Override
  public Object getSubmitterUid(final long assignmentUid, final long personUid,
      final Continuation<? super Long> continuation) {
    final String _sql = "\n"
            + "        SELECT (CASE WHEN ClazzAssignment.caGroupUid = 0 \n"
            + "                     THEN ? \n"
            + "                     WHEN CourseGroupMember.cgmUid IS NULL \n"
            + "                     THEN 0 \n"
            + "                     ELSE CourseGroupMember.cgmGroupNumber END) as submitterUid\n"
            + "          FROM ClazzAssignment\n"
            + "               LEFT JOIN CourseGroupMember\n"
            + "               ON cgmSetUid = ClazzAssignment.caGroupUid\n"
            + "               AND cgmPersonUid = ?\n"
            + "         WHERE caUid = ?\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 3);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, personUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, personUid);
    _argIndex = 3;
    _statement.bindLong(_argIndex, assignmentUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<Long>() {
      @Override
      public Long call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final Long _result;
          if(_cursor.moveToFirst()) {
            final long _tmp;
            _tmp = _cursor.getLong(0);
            _result = _tmp;
          } else {
            _result = 0L;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, continuation);
  }

  @Override
  public Object findByUidAsync(final long uid,
      final Continuation<? super ClazzAssignment> continuation) {
    final String _sql = "\n"
            + "        SELECT * \n"
            + "          FROM ClazzAssignment \n"
            + "         WHERE caUid = ?\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, uid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<ClazzAssignment>() {
      @Override
      public ClazzAssignment call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfCaUid = CursorUtil.getColumnIndexOrThrow(_cursor, "caUid");
          final int _cursorIndexOfCaTitle = CursorUtil.getColumnIndexOrThrow(_cursor, "caTitle");
          final int _cursorIndexOfCaDescription = CursorUtil.getColumnIndexOrThrow(_cursor, "caDescription");
          final int _cursorIndexOfCaGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "caGroupUid");
          final int _cursorIndexOfCaActive = CursorUtil.getColumnIndexOrThrow(_cursor, "caActive");
          final int _cursorIndexOfCaClassCommentEnabled = CursorUtil.getColumnIndexOrThrow(_cursor, "caClassCommentEnabled");
          final int _cursorIndexOfCaPrivateCommentsEnabled = CursorUtil.getColumnIndexOrThrow(_cursor, "caPrivateCommentsEnabled");
          final int _cursorIndexOfCaCompletionCriteria = CursorUtil.getColumnIndexOrThrow(_cursor, "caCompletionCriteria");
          final int _cursorIndexOfCaRequireFileSubmission = CursorUtil.getColumnIndexOrThrow(_cursor, "caRequireFileSubmission");
          final int _cursorIndexOfCaFileType = CursorUtil.getColumnIndexOrThrow(_cursor, "caFileType");
          final int _cursorIndexOfCaSizeLimit = CursorUtil.getColumnIndexOrThrow(_cursor, "caSizeLimit");
          final int _cursorIndexOfCaNumberOfFiles = CursorUtil.getColumnIndexOrThrow(_cursor, "caNumberOfFiles");
          final int _cursorIndexOfCaSubmissionPolicy = CursorUtil.getColumnIndexOrThrow(_cursor, "caSubmissionPolicy");
          final int _cursorIndexOfCaMarkingType = CursorUtil.getColumnIndexOrThrow(_cursor, "caMarkingType");
          final int _cursorIndexOfCaRequireTextSubmission = CursorUtil.getColumnIndexOrThrow(_cursor, "caRequireTextSubmission");
          final int _cursorIndexOfCaTextLimitType = CursorUtil.getColumnIndexOrThrow(_cursor, "caTextLimitType");
          final int _cursorIndexOfCaTextLimit = CursorUtil.getColumnIndexOrThrow(_cursor, "caTextLimit");
          final int _cursorIndexOfCaXObjectUid = CursorUtil.getColumnIndexOrThrow(_cursor, "caXObjectUid");
          final int _cursorIndexOfCaClazzUid = CursorUtil.getColumnIndexOrThrow(_cursor, "caClazzUid");
          final int _cursorIndexOfCaLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "caLocalChangeSeqNum");
          final int _cursorIndexOfCaMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "caMasterChangeSeqNum");
          final int _cursorIndexOfCaLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "caLastChangedBy");
          final int _cursorIndexOfCaLct = CursorUtil.getColumnIndexOrThrow(_cursor, "caLct");
          final ClazzAssignment _result;
          if(_cursor.moveToFirst()) {
            _result = new ClazzAssignment();
            final long _tmpCaUid;
            _tmpCaUid = _cursor.getLong(_cursorIndexOfCaUid);
            _result.setCaUid(_tmpCaUid);
            final String _tmpCaTitle;
            if (_cursor.isNull(_cursorIndexOfCaTitle)) {
              _tmpCaTitle = null;
            } else {
              _tmpCaTitle = _cursor.getString(_cursorIndexOfCaTitle);
            }
            _result.setCaTitle(_tmpCaTitle);
            final String _tmpCaDescription;
            if (_cursor.isNull(_cursorIndexOfCaDescription)) {
              _tmpCaDescription = null;
            } else {
              _tmpCaDescription = _cursor.getString(_cursorIndexOfCaDescription);
            }
            _result.setCaDescription(_tmpCaDescription);
            final long _tmpCaGroupUid;
            _tmpCaGroupUid = _cursor.getLong(_cursorIndexOfCaGroupUid);
            _result.setCaGroupUid(_tmpCaGroupUid);
            final boolean _tmpCaActive;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfCaActive);
            _tmpCaActive = _tmp != 0;
            _result.setCaActive(_tmpCaActive);
            final boolean _tmpCaClassCommentEnabled;
            final int _tmp_1;
            _tmp_1 = _cursor.getInt(_cursorIndexOfCaClassCommentEnabled);
            _tmpCaClassCommentEnabled = _tmp_1 != 0;
            _result.setCaClassCommentEnabled(_tmpCaClassCommentEnabled);
            final boolean _tmpCaPrivateCommentsEnabled;
            final int _tmp_2;
            _tmp_2 = _cursor.getInt(_cursorIndexOfCaPrivateCommentsEnabled);
            _tmpCaPrivateCommentsEnabled = _tmp_2 != 0;
            _result.setCaPrivateCommentsEnabled(_tmpCaPrivateCommentsEnabled);
            final int _tmpCaCompletionCriteria;
            _tmpCaCompletionCriteria = _cursor.getInt(_cursorIndexOfCaCompletionCriteria);
            _result.setCaCompletionCriteria(_tmpCaCompletionCriteria);
            final boolean _tmpCaRequireFileSubmission;
            final int _tmp_3;
            _tmp_3 = _cursor.getInt(_cursorIndexOfCaRequireFileSubmission);
            _tmpCaRequireFileSubmission = _tmp_3 != 0;
            _result.setCaRequireFileSubmission(_tmpCaRequireFileSubmission);
            final int _tmpCaFileType;
            _tmpCaFileType = _cursor.getInt(_cursorIndexOfCaFileType);
            _result.setCaFileType(_tmpCaFileType);
            final int _tmpCaSizeLimit;
            _tmpCaSizeLimit = _cursor.getInt(_cursorIndexOfCaSizeLimit);
            _result.setCaSizeLimit(_tmpCaSizeLimit);
            final int _tmpCaNumberOfFiles;
            _tmpCaNumberOfFiles = _cursor.getInt(_cursorIndexOfCaNumberOfFiles);
            _result.setCaNumberOfFiles(_tmpCaNumberOfFiles);
            final int _tmpCaSubmissionPolicy;
            _tmpCaSubmissionPolicy = _cursor.getInt(_cursorIndexOfCaSubmissionPolicy);
            _result.setCaSubmissionPolicy(_tmpCaSubmissionPolicy);
            final int _tmpCaMarkingType;
            _tmpCaMarkingType = _cursor.getInt(_cursorIndexOfCaMarkingType);
            _result.setCaMarkingType(_tmpCaMarkingType);
            final boolean _tmpCaRequireTextSubmission;
            final int _tmp_4;
            _tmp_4 = _cursor.getInt(_cursorIndexOfCaRequireTextSubmission);
            _tmpCaRequireTextSubmission = _tmp_4 != 0;
            _result.setCaRequireTextSubmission(_tmpCaRequireTextSubmission);
            final int _tmpCaTextLimitType;
            _tmpCaTextLimitType = _cursor.getInt(_cursorIndexOfCaTextLimitType);
            _result.setCaTextLimitType(_tmpCaTextLimitType);
            final int _tmpCaTextLimit;
            _tmpCaTextLimit = _cursor.getInt(_cursorIndexOfCaTextLimit);
            _result.setCaTextLimit(_tmpCaTextLimit);
            final long _tmpCaXObjectUid;
            _tmpCaXObjectUid = _cursor.getLong(_cursorIndexOfCaXObjectUid);
            _result.setCaXObjectUid(_tmpCaXObjectUid);
            final long _tmpCaClazzUid;
            _tmpCaClazzUid = _cursor.getLong(_cursorIndexOfCaClazzUid);
            _result.setCaClazzUid(_tmpCaClazzUid);
            final long _tmpCaLocalChangeSeqNum;
            _tmpCaLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfCaLocalChangeSeqNum);
            _result.setCaLocalChangeSeqNum(_tmpCaLocalChangeSeqNum);
            final long _tmpCaMasterChangeSeqNum;
            _tmpCaMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfCaMasterChangeSeqNum);
            _result.setCaMasterChangeSeqNum(_tmpCaMasterChangeSeqNum);
            final int _tmpCaLastChangedBy;
            _tmpCaLastChangedBy = _cursor.getInt(_cursorIndexOfCaLastChangedBy);
            _result.setCaLastChangedBy(_tmpCaLastChangedBy);
            final long _tmpCaLct;
            _tmpCaLct = _cursor.getLong(_cursorIndexOfCaLct);
            _result.setCaLct(_tmpCaLct);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, continuation);
  }

  @Override
  public Object getGroupUidFromAssignment(final long uid,
      final Continuation<? super Long> continuation) {
    final String _sql = "\n"
            + "          SELECT COALESCE((\n"
            + "           SELECT caGroupUid\n"
            + "           FROM ClazzAssignment\n"
            + "          WHERE caUid = ?),-1)\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, uid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<Long>() {
      @Override
      public Long call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final Long _result;
          if(_cursor.moveToFirst()) {
            final long _tmp;
            _tmp = _cursor.getLong(0);
            _result = _tmp;
          } else {
            _result = 0L;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, continuation);
  }

  @Override
  public Object findByUidWithBlockAsync(final long uid,
      final Continuation<? super ClazzAssignmentWithCourseBlock> continuation) {
    final String _sql = "\n"
            + "        SELECT * \n"
            + "          FROM ClazzAssignment\n"
            + "               LEFT JOIN CourseBlock\n"
            + "               ON CourseBlock.cbEntityUid = ClazzAssignment.caUid\n"
            + "               AND CourseBlock.cbType = 103\n"
            + "         WHERE caUid = ?\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, uid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<ClazzAssignmentWithCourseBlock>() {
      @Override
      public ClazzAssignmentWithCourseBlock call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfCaUid = CursorUtil.getColumnIndexOrThrow(_cursor, "caUid");
          final int _cursorIndexOfCaTitle = CursorUtil.getColumnIndexOrThrow(_cursor, "caTitle");
          final int _cursorIndexOfCaDescription = CursorUtil.getColumnIndexOrThrow(_cursor, "caDescription");
          final int _cursorIndexOfCaGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "caGroupUid");
          final int _cursorIndexOfCaActive = CursorUtil.getColumnIndexOrThrow(_cursor, "caActive");
          final int _cursorIndexOfCaClassCommentEnabled = CursorUtil.getColumnIndexOrThrow(_cursor, "caClassCommentEnabled");
          final int _cursorIndexOfCaPrivateCommentsEnabled = CursorUtil.getColumnIndexOrThrow(_cursor, "caPrivateCommentsEnabled");
          final int _cursorIndexOfCaCompletionCriteria = CursorUtil.getColumnIndexOrThrow(_cursor, "caCompletionCriteria");
          final int _cursorIndexOfCaRequireFileSubmission = CursorUtil.getColumnIndexOrThrow(_cursor, "caRequireFileSubmission");
          final int _cursorIndexOfCaFileType = CursorUtil.getColumnIndexOrThrow(_cursor, "caFileType");
          final int _cursorIndexOfCaSizeLimit = CursorUtil.getColumnIndexOrThrow(_cursor, "caSizeLimit");
          final int _cursorIndexOfCaNumberOfFiles = CursorUtil.getColumnIndexOrThrow(_cursor, "caNumberOfFiles");
          final int _cursorIndexOfCaSubmissionPolicy = CursorUtil.getColumnIndexOrThrow(_cursor, "caSubmissionPolicy");
          final int _cursorIndexOfCaMarkingType = CursorUtil.getColumnIndexOrThrow(_cursor, "caMarkingType");
          final int _cursorIndexOfCaRequireTextSubmission = CursorUtil.getColumnIndexOrThrow(_cursor, "caRequireTextSubmission");
          final int _cursorIndexOfCaTextLimitType = CursorUtil.getColumnIndexOrThrow(_cursor, "caTextLimitType");
          final int _cursorIndexOfCaTextLimit = CursorUtil.getColumnIndexOrThrow(_cursor, "caTextLimit");
          final int _cursorIndexOfCaXObjectUid = CursorUtil.getColumnIndexOrThrow(_cursor, "caXObjectUid");
          final int _cursorIndexOfCaClazzUid = CursorUtil.getColumnIndexOrThrow(_cursor, "caClazzUid");
          final int _cursorIndexOfCaLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "caLocalChangeSeqNum");
          final int _cursorIndexOfCaMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "caMasterChangeSeqNum");
          final int _cursorIndexOfCaLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "caLastChangedBy");
          final int _cursorIndexOfCaLct = CursorUtil.getColumnIndexOrThrow(_cursor, "caLct");
          final int _cursorIndexOfCbUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cbUid");
          final int _cursorIndexOfCbType = CursorUtil.getColumnIndexOrThrow(_cursor, "cbType");
          final int _cursorIndexOfCbIndentLevel = CursorUtil.getColumnIndexOrThrow(_cursor, "cbIndentLevel");
          final int _cursorIndexOfCbModuleParentBlockUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cbModuleParentBlockUid");
          final int _cursorIndexOfCbTitle = CursorUtil.getColumnIndexOrThrow(_cursor, "cbTitle");
          final int _cursorIndexOfCbDescription = CursorUtil.getColumnIndexOrThrow(_cursor, "cbDescription");
          final int _cursorIndexOfCbCompletionCriteria = CursorUtil.getColumnIndexOrThrow(_cursor, "cbCompletionCriteria");
          final int _cursorIndexOfCbHideUntilDate = CursorUtil.getColumnIndexOrThrow(_cursor, "cbHideUntilDate");
          final int _cursorIndexOfCbDeadlineDate = CursorUtil.getColumnIndexOrThrow(_cursor, "cbDeadlineDate");
          final int _cursorIndexOfCbLateSubmissionPenalty = CursorUtil.getColumnIndexOrThrow(_cursor, "cbLateSubmissionPenalty");
          final int _cursorIndexOfCbGracePeriodDate = CursorUtil.getColumnIndexOrThrow(_cursor, "cbGracePeriodDate");
          final int _cursorIndexOfCbMaxPoints = CursorUtil.getColumnIndexOrThrow(_cursor, "cbMaxPoints");
          final int _cursorIndexOfCbMinPoints = CursorUtil.getColumnIndexOrThrow(_cursor, "cbMinPoints");
          final int _cursorIndexOfCbIndex = CursorUtil.getColumnIndexOrThrow(_cursor, "cbIndex");
          final int _cursorIndexOfCbClazzUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cbClazzUid");
          final int _cursorIndexOfCbActive = CursorUtil.getColumnIndexOrThrow(_cursor, "cbActive");
          final int _cursorIndexOfCbHidden = CursorUtil.getColumnIndexOrThrow(_cursor, "cbHidden");
          final int _cursorIndexOfCbEntityUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cbEntityUid");
          final int _cursorIndexOfCbLct = CursorUtil.getColumnIndexOrThrow(_cursor, "cbLct");
          final ClazzAssignmentWithCourseBlock _result;
          if(_cursor.moveToFirst()) {
            final CourseBlock _tmpBlock;
            if (! (_cursor.isNull(_cursorIndexOfCbUid) && _cursor.isNull(_cursorIndexOfCbType) && _cursor.isNull(_cursorIndexOfCbIndentLevel) && _cursor.isNull(_cursorIndexOfCbModuleParentBlockUid) && _cursor.isNull(_cursorIndexOfCbTitle) && _cursor.isNull(_cursorIndexOfCbDescription) && _cursor.isNull(_cursorIndexOfCbCompletionCriteria) && _cursor.isNull(_cursorIndexOfCbHideUntilDate) && _cursor.isNull(_cursorIndexOfCbDeadlineDate) && _cursor.isNull(_cursorIndexOfCbLateSubmissionPenalty) && _cursor.isNull(_cursorIndexOfCbGracePeriodDate) && _cursor.isNull(_cursorIndexOfCbMaxPoints) && _cursor.isNull(_cursorIndexOfCbMinPoints) && _cursor.isNull(_cursorIndexOfCbIndex) && _cursor.isNull(_cursorIndexOfCbClazzUid) && _cursor.isNull(_cursorIndexOfCbActive) && _cursor.isNull(_cursorIndexOfCbHidden) && _cursor.isNull(_cursorIndexOfCbEntityUid) && _cursor.isNull(_cursorIndexOfCbLct))) {
              _tmpBlock = new CourseBlock();
              final long _tmpCbUid;
              _tmpCbUid = _cursor.getLong(_cursorIndexOfCbUid);
              _tmpBlock.setCbUid(_tmpCbUid);
              final int _tmpCbType;
              _tmpCbType = _cursor.getInt(_cursorIndexOfCbType);
              _tmpBlock.setCbType(_tmpCbType);
              final int _tmpCbIndentLevel;
              _tmpCbIndentLevel = _cursor.getInt(_cursorIndexOfCbIndentLevel);
              _tmpBlock.setCbIndentLevel(_tmpCbIndentLevel);
              final long _tmpCbModuleParentBlockUid;
              _tmpCbModuleParentBlockUid = _cursor.getLong(_cursorIndexOfCbModuleParentBlockUid);
              _tmpBlock.setCbModuleParentBlockUid(_tmpCbModuleParentBlockUid);
              final String _tmpCbTitle;
              if (_cursor.isNull(_cursorIndexOfCbTitle)) {
                _tmpCbTitle = null;
              } else {
                _tmpCbTitle = _cursor.getString(_cursorIndexOfCbTitle);
              }
              _tmpBlock.setCbTitle(_tmpCbTitle);
              final String _tmpCbDescription;
              if (_cursor.isNull(_cursorIndexOfCbDescription)) {
                _tmpCbDescription = null;
              } else {
                _tmpCbDescription = _cursor.getString(_cursorIndexOfCbDescription);
              }
              _tmpBlock.setCbDescription(_tmpCbDescription);
              final int _tmpCbCompletionCriteria;
              _tmpCbCompletionCriteria = _cursor.getInt(_cursorIndexOfCbCompletionCriteria);
              _tmpBlock.setCbCompletionCriteria(_tmpCbCompletionCriteria);
              final long _tmpCbHideUntilDate;
              _tmpCbHideUntilDate = _cursor.getLong(_cursorIndexOfCbHideUntilDate);
              _tmpBlock.setCbHideUntilDate(_tmpCbHideUntilDate);
              final long _tmpCbDeadlineDate;
              _tmpCbDeadlineDate = _cursor.getLong(_cursorIndexOfCbDeadlineDate);
              _tmpBlock.setCbDeadlineDate(_tmpCbDeadlineDate);
              final int _tmpCbLateSubmissionPenalty;
              _tmpCbLateSubmissionPenalty = _cursor.getInt(_cursorIndexOfCbLateSubmissionPenalty);
              _tmpBlock.setCbLateSubmissionPenalty(_tmpCbLateSubmissionPenalty);
              final long _tmpCbGracePeriodDate;
              _tmpCbGracePeriodDate = _cursor.getLong(_cursorIndexOfCbGracePeriodDate);
              _tmpBlock.setCbGracePeriodDate(_tmpCbGracePeriodDate);
              final int _tmpCbMaxPoints;
              _tmpCbMaxPoints = _cursor.getInt(_cursorIndexOfCbMaxPoints);
              _tmpBlock.setCbMaxPoints(_tmpCbMaxPoints);
              final int _tmpCbMinPoints;
              _tmpCbMinPoints = _cursor.getInt(_cursorIndexOfCbMinPoints);
              _tmpBlock.setCbMinPoints(_tmpCbMinPoints);
              final int _tmpCbIndex;
              _tmpCbIndex = _cursor.getInt(_cursorIndexOfCbIndex);
              _tmpBlock.setCbIndex(_tmpCbIndex);
              final long _tmpCbClazzUid;
              _tmpCbClazzUid = _cursor.getLong(_cursorIndexOfCbClazzUid);
              _tmpBlock.setCbClazzUid(_tmpCbClazzUid);
              final boolean _tmpCbActive;
              final int _tmp;
              _tmp = _cursor.getInt(_cursorIndexOfCbActive);
              _tmpCbActive = _tmp != 0;
              _tmpBlock.setCbActive(_tmpCbActive);
              final boolean _tmpCbHidden;
              final int _tmp_1;
              _tmp_1 = _cursor.getInt(_cursorIndexOfCbHidden);
              _tmpCbHidden = _tmp_1 != 0;
              _tmpBlock.setCbHidden(_tmpCbHidden);
              final long _tmpCbEntityUid;
              _tmpCbEntityUid = _cursor.getLong(_cursorIndexOfCbEntityUid);
              _tmpBlock.setCbEntityUid(_tmpCbEntityUid);
              final long _tmpCbLct;
              _tmpCbLct = _cursor.getLong(_cursorIndexOfCbLct);
              _tmpBlock.setCbLct(_tmpCbLct);
            }  else  {
              _tmpBlock = null;
            }
            _result = new ClazzAssignmentWithCourseBlock();
            final long _tmpCaUid;
            _tmpCaUid = _cursor.getLong(_cursorIndexOfCaUid);
            _result.setCaUid(_tmpCaUid);
            final String _tmpCaTitle;
            if (_cursor.isNull(_cursorIndexOfCaTitle)) {
              _tmpCaTitle = null;
            } else {
              _tmpCaTitle = _cursor.getString(_cursorIndexOfCaTitle);
            }
            _result.setCaTitle(_tmpCaTitle);
            final String _tmpCaDescription;
            if (_cursor.isNull(_cursorIndexOfCaDescription)) {
              _tmpCaDescription = null;
            } else {
              _tmpCaDescription = _cursor.getString(_cursorIndexOfCaDescription);
            }
            _result.setCaDescription(_tmpCaDescription);
            final long _tmpCaGroupUid;
            _tmpCaGroupUid = _cursor.getLong(_cursorIndexOfCaGroupUid);
            _result.setCaGroupUid(_tmpCaGroupUid);
            final boolean _tmpCaActive;
            final int _tmp_2;
            _tmp_2 = _cursor.getInt(_cursorIndexOfCaActive);
            _tmpCaActive = _tmp_2 != 0;
            _result.setCaActive(_tmpCaActive);
            final boolean _tmpCaClassCommentEnabled;
            final int _tmp_3;
            _tmp_3 = _cursor.getInt(_cursorIndexOfCaClassCommentEnabled);
            _tmpCaClassCommentEnabled = _tmp_3 != 0;
            _result.setCaClassCommentEnabled(_tmpCaClassCommentEnabled);
            final boolean _tmpCaPrivateCommentsEnabled;
            final int _tmp_4;
            _tmp_4 = _cursor.getInt(_cursorIndexOfCaPrivateCommentsEnabled);
            _tmpCaPrivateCommentsEnabled = _tmp_4 != 0;
            _result.setCaPrivateCommentsEnabled(_tmpCaPrivateCommentsEnabled);
            final int _tmpCaCompletionCriteria;
            _tmpCaCompletionCriteria = _cursor.getInt(_cursorIndexOfCaCompletionCriteria);
            _result.setCaCompletionCriteria(_tmpCaCompletionCriteria);
            final boolean _tmpCaRequireFileSubmission;
            final int _tmp_5;
            _tmp_5 = _cursor.getInt(_cursorIndexOfCaRequireFileSubmission);
            _tmpCaRequireFileSubmission = _tmp_5 != 0;
            _result.setCaRequireFileSubmission(_tmpCaRequireFileSubmission);
            final int _tmpCaFileType;
            _tmpCaFileType = _cursor.getInt(_cursorIndexOfCaFileType);
            _result.setCaFileType(_tmpCaFileType);
            final int _tmpCaSizeLimit;
            _tmpCaSizeLimit = _cursor.getInt(_cursorIndexOfCaSizeLimit);
            _result.setCaSizeLimit(_tmpCaSizeLimit);
            final int _tmpCaNumberOfFiles;
            _tmpCaNumberOfFiles = _cursor.getInt(_cursorIndexOfCaNumberOfFiles);
            _result.setCaNumberOfFiles(_tmpCaNumberOfFiles);
            final int _tmpCaSubmissionPolicy;
            _tmpCaSubmissionPolicy = _cursor.getInt(_cursorIndexOfCaSubmissionPolicy);
            _result.setCaSubmissionPolicy(_tmpCaSubmissionPolicy);
            final int _tmpCaMarkingType;
            _tmpCaMarkingType = _cursor.getInt(_cursorIndexOfCaMarkingType);
            _result.setCaMarkingType(_tmpCaMarkingType);
            final boolean _tmpCaRequireTextSubmission;
            final int _tmp_6;
            _tmp_6 = _cursor.getInt(_cursorIndexOfCaRequireTextSubmission);
            _tmpCaRequireTextSubmission = _tmp_6 != 0;
            _result.setCaRequireTextSubmission(_tmpCaRequireTextSubmission);
            final int _tmpCaTextLimitType;
            _tmpCaTextLimitType = _cursor.getInt(_cursorIndexOfCaTextLimitType);
            _result.setCaTextLimitType(_tmpCaTextLimitType);
            final int _tmpCaTextLimit;
            _tmpCaTextLimit = _cursor.getInt(_cursorIndexOfCaTextLimit);
            _result.setCaTextLimit(_tmpCaTextLimit);
            final long _tmpCaXObjectUid;
            _tmpCaXObjectUid = _cursor.getLong(_cursorIndexOfCaXObjectUid);
            _result.setCaXObjectUid(_tmpCaXObjectUid);
            final long _tmpCaClazzUid;
            _tmpCaClazzUid = _cursor.getLong(_cursorIndexOfCaClazzUid);
            _result.setCaClazzUid(_tmpCaClazzUid);
            final long _tmpCaLocalChangeSeqNum;
            _tmpCaLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfCaLocalChangeSeqNum);
            _result.setCaLocalChangeSeqNum(_tmpCaLocalChangeSeqNum);
            final long _tmpCaMasterChangeSeqNum;
            _tmpCaMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfCaMasterChangeSeqNum);
            _result.setCaMasterChangeSeqNum(_tmpCaMasterChangeSeqNum);
            final int _tmpCaLastChangedBy;
            _tmpCaLastChangedBy = _cursor.getInt(_cursorIndexOfCaLastChangedBy);
            _result.setCaLastChangedBy(_tmpCaLastChangedBy);
            final long _tmpCaLct;
            _tmpCaLct = _cursor.getLong(_cursorIndexOfCaLct);
            _result.setCaLct(_tmpCaLct);
            _result.setBlock(_tmpBlock);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, continuation);
  }

  @Override
  public ClazzAssignment findClazzAssignment() {
    final String _sql = "\n"
            + "        SELECT * \n"
            + "          FROM ClazzAssignment LIMIT 1\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 0);
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final int _cursorIndexOfCaUid = CursorUtil.getColumnIndexOrThrow(_cursor, "caUid");
      final int _cursorIndexOfCaTitle = CursorUtil.getColumnIndexOrThrow(_cursor, "caTitle");
      final int _cursorIndexOfCaDescription = CursorUtil.getColumnIndexOrThrow(_cursor, "caDescription");
      final int _cursorIndexOfCaGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "caGroupUid");
      final int _cursorIndexOfCaActive = CursorUtil.getColumnIndexOrThrow(_cursor, "caActive");
      final int _cursorIndexOfCaClassCommentEnabled = CursorUtil.getColumnIndexOrThrow(_cursor, "caClassCommentEnabled");
      final int _cursorIndexOfCaPrivateCommentsEnabled = CursorUtil.getColumnIndexOrThrow(_cursor, "caPrivateCommentsEnabled");
      final int _cursorIndexOfCaCompletionCriteria = CursorUtil.getColumnIndexOrThrow(_cursor, "caCompletionCriteria");
      final int _cursorIndexOfCaRequireFileSubmission = CursorUtil.getColumnIndexOrThrow(_cursor, "caRequireFileSubmission");
      final int _cursorIndexOfCaFileType = CursorUtil.getColumnIndexOrThrow(_cursor, "caFileType");
      final int _cursorIndexOfCaSizeLimit = CursorUtil.getColumnIndexOrThrow(_cursor, "caSizeLimit");
      final int _cursorIndexOfCaNumberOfFiles = CursorUtil.getColumnIndexOrThrow(_cursor, "caNumberOfFiles");
      final int _cursorIndexOfCaSubmissionPolicy = CursorUtil.getColumnIndexOrThrow(_cursor, "caSubmissionPolicy");
      final int _cursorIndexOfCaMarkingType = CursorUtil.getColumnIndexOrThrow(_cursor, "caMarkingType");
      final int _cursorIndexOfCaRequireTextSubmission = CursorUtil.getColumnIndexOrThrow(_cursor, "caRequireTextSubmission");
      final int _cursorIndexOfCaTextLimitType = CursorUtil.getColumnIndexOrThrow(_cursor, "caTextLimitType");
      final int _cursorIndexOfCaTextLimit = CursorUtil.getColumnIndexOrThrow(_cursor, "caTextLimit");
      final int _cursorIndexOfCaXObjectUid = CursorUtil.getColumnIndexOrThrow(_cursor, "caXObjectUid");
      final int _cursorIndexOfCaClazzUid = CursorUtil.getColumnIndexOrThrow(_cursor, "caClazzUid");
      final int _cursorIndexOfCaLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "caLocalChangeSeqNum");
      final int _cursorIndexOfCaMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "caMasterChangeSeqNum");
      final int _cursorIndexOfCaLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "caLastChangedBy");
      final int _cursorIndexOfCaLct = CursorUtil.getColumnIndexOrThrow(_cursor, "caLct");
      final ClazzAssignment _result;
      if(_cursor.moveToFirst()) {
        _result = new ClazzAssignment();
        final long _tmpCaUid;
        _tmpCaUid = _cursor.getLong(_cursorIndexOfCaUid);
        _result.setCaUid(_tmpCaUid);
        final String _tmpCaTitle;
        if (_cursor.isNull(_cursorIndexOfCaTitle)) {
          _tmpCaTitle = null;
        } else {
          _tmpCaTitle = _cursor.getString(_cursorIndexOfCaTitle);
        }
        _result.setCaTitle(_tmpCaTitle);
        final String _tmpCaDescription;
        if (_cursor.isNull(_cursorIndexOfCaDescription)) {
          _tmpCaDescription = null;
        } else {
          _tmpCaDescription = _cursor.getString(_cursorIndexOfCaDescription);
        }
        _result.setCaDescription(_tmpCaDescription);
        final long _tmpCaGroupUid;
        _tmpCaGroupUid = _cursor.getLong(_cursorIndexOfCaGroupUid);
        _result.setCaGroupUid(_tmpCaGroupUid);
        final boolean _tmpCaActive;
        final int _tmp;
        _tmp = _cursor.getInt(_cursorIndexOfCaActive);
        _tmpCaActive = _tmp != 0;
        _result.setCaActive(_tmpCaActive);
        final boolean _tmpCaClassCommentEnabled;
        final int _tmp_1;
        _tmp_1 = _cursor.getInt(_cursorIndexOfCaClassCommentEnabled);
        _tmpCaClassCommentEnabled = _tmp_1 != 0;
        _result.setCaClassCommentEnabled(_tmpCaClassCommentEnabled);
        final boolean _tmpCaPrivateCommentsEnabled;
        final int _tmp_2;
        _tmp_2 = _cursor.getInt(_cursorIndexOfCaPrivateCommentsEnabled);
        _tmpCaPrivateCommentsEnabled = _tmp_2 != 0;
        _result.setCaPrivateCommentsEnabled(_tmpCaPrivateCommentsEnabled);
        final int _tmpCaCompletionCriteria;
        _tmpCaCompletionCriteria = _cursor.getInt(_cursorIndexOfCaCompletionCriteria);
        _result.setCaCompletionCriteria(_tmpCaCompletionCriteria);
        final boolean _tmpCaRequireFileSubmission;
        final int _tmp_3;
        _tmp_3 = _cursor.getInt(_cursorIndexOfCaRequireFileSubmission);
        _tmpCaRequireFileSubmission = _tmp_3 != 0;
        _result.setCaRequireFileSubmission(_tmpCaRequireFileSubmission);
        final int _tmpCaFileType;
        _tmpCaFileType = _cursor.getInt(_cursorIndexOfCaFileType);
        _result.setCaFileType(_tmpCaFileType);
        final int _tmpCaSizeLimit;
        _tmpCaSizeLimit = _cursor.getInt(_cursorIndexOfCaSizeLimit);
        _result.setCaSizeLimit(_tmpCaSizeLimit);
        final int _tmpCaNumberOfFiles;
        _tmpCaNumberOfFiles = _cursor.getInt(_cursorIndexOfCaNumberOfFiles);
        _result.setCaNumberOfFiles(_tmpCaNumberOfFiles);
        final int _tmpCaSubmissionPolicy;
        _tmpCaSubmissionPolicy = _cursor.getInt(_cursorIndexOfCaSubmissionPolicy);
        _result.setCaSubmissionPolicy(_tmpCaSubmissionPolicy);
        final int _tmpCaMarkingType;
        _tmpCaMarkingType = _cursor.getInt(_cursorIndexOfCaMarkingType);
        _result.setCaMarkingType(_tmpCaMarkingType);
        final boolean _tmpCaRequireTextSubmission;
        final int _tmp_4;
        _tmp_4 = _cursor.getInt(_cursorIndexOfCaRequireTextSubmission);
        _tmpCaRequireTextSubmission = _tmp_4 != 0;
        _result.setCaRequireTextSubmission(_tmpCaRequireTextSubmission);
        final int _tmpCaTextLimitType;
        _tmpCaTextLimitType = _cursor.getInt(_cursorIndexOfCaTextLimitType);
        _result.setCaTextLimitType(_tmpCaTextLimitType);
        final int _tmpCaTextLimit;
        _tmpCaTextLimit = _cursor.getInt(_cursorIndexOfCaTextLimit);
        _result.setCaTextLimit(_tmpCaTextLimit);
        final long _tmpCaXObjectUid;
        _tmpCaXObjectUid = _cursor.getLong(_cursorIndexOfCaXObjectUid);
        _result.setCaXObjectUid(_tmpCaXObjectUid);
        final long _tmpCaClazzUid;
        _tmpCaClazzUid = _cursor.getLong(_cursorIndexOfCaClazzUid);
        _result.setCaClazzUid(_tmpCaClazzUid);
        final long _tmpCaLocalChangeSeqNum;
        _tmpCaLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfCaLocalChangeSeqNum);
        _result.setCaLocalChangeSeqNum(_tmpCaLocalChangeSeqNum);
        final long _tmpCaMasterChangeSeqNum;
        _tmpCaMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfCaMasterChangeSeqNum);
        _result.setCaMasterChangeSeqNum(_tmpCaMasterChangeSeqNum);
        final int _tmpCaLastChangedBy;
        _tmpCaLastChangedBy = _cursor.getInt(_cursorIndexOfCaLastChangedBy);
        _result.setCaLastChangedBy(_tmpCaLastChangedBy);
        final long _tmpCaLct;
        _tmpCaLct = _cursor.getLong(_cursorIndexOfCaLct);
        _result.setCaLct(_tmpCaLct);
      } else {
        _result = null;
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  @Override
  public LiveData<ClazzAssignment> findByUidLive(final long uid) {
    final String _sql = "SELECT * \n"
            + "                      FROM ClazzAssignment \n"
            + "                     WHERE caUid = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, uid);
    return __db.getInvalidationTracker().createLiveData(new String[]{"ClazzAssignment"}, false, new Callable<ClazzAssignment>() {
      @Override
      public ClazzAssignment call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfCaUid = CursorUtil.getColumnIndexOrThrow(_cursor, "caUid");
          final int _cursorIndexOfCaTitle = CursorUtil.getColumnIndexOrThrow(_cursor, "caTitle");
          final int _cursorIndexOfCaDescription = CursorUtil.getColumnIndexOrThrow(_cursor, "caDescription");
          final int _cursorIndexOfCaGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "caGroupUid");
          final int _cursorIndexOfCaActive = CursorUtil.getColumnIndexOrThrow(_cursor, "caActive");
          final int _cursorIndexOfCaClassCommentEnabled = CursorUtil.getColumnIndexOrThrow(_cursor, "caClassCommentEnabled");
          final int _cursorIndexOfCaPrivateCommentsEnabled = CursorUtil.getColumnIndexOrThrow(_cursor, "caPrivateCommentsEnabled");
          final int _cursorIndexOfCaCompletionCriteria = CursorUtil.getColumnIndexOrThrow(_cursor, "caCompletionCriteria");
          final int _cursorIndexOfCaRequireFileSubmission = CursorUtil.getColumnIndexOrThrow(_cursor, "caRequireFileSubmission");
          final int _cursorIndexOfCaFileType = CursorUtil.getColumnIndexOrThrow(_cursor, "caFileType");
          final int _cursorIndexOfCaSizeLimit = CursorUtil.getColumnIndexOrThrow(_cursor, "caSizeLimit");
          final int _cursorIndexOfCaNumberOfFiles = CursorUtil.getColumnIndexOrThrow(_cursor, "caNumberOfFiles");
          final int _cursorIndexOfCaSubmissionPolicy = CursorUtil.getColumnIndexOrThrow(_cursor, "caSubmissionPolicy");
          final int _cursorIndexOfCaMarkingType = CursorUtil.getColumnIndexOrThrow(_cursor, "caMarkingType");
          final int _cursorIndexOfCaRequireTextSubmission = CursorUtil.getColumnIndexOrThrow(_cursor, "caRequireTextSubmission");
          final int _cursorIndexOfCaTextLimitType = CursorUtil.getColumnIndexOrThrow(_cursor, "caTextLimitType");
          final int _cursorIndexOfCaTextLimit = CursorUtil.getColumnIndexOrThrow(_cursor, "caTextLimit");
          final int _cursorIndexOfCaXObjectUid = CursorUtil.getColumnIndexOrThrow(_cursor, "caXObjectUid");
          final int _cursorIndexOfCaClazzUid = CursorUtil.getColumnIndexOrThrow(_cursor, "caClazzUid");
          final int _cursorIndexOfCaLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "caLocalChangeSeqNum");
          final int _cursorIndexOfCaMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "caMasterChangeSeqNum");
          final int _cursorIndexOfCaLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "caLastChangedBy");
          final int _cursorIndexOfCaLct = CursorUtil.getColumnIndexOrThrow(_cursor, "caLct");
          final ClazzAssignment _result;
          if(_cursor.moveToFirst()) {
            _result = new ClazzAssignment();
            final long _tmpCaUid;
            _tmpCaUid = _cursor.getLong(_cursorIndexOfCaUid);
            _result.setCaUid(_tmpCaUid);
            final String _tmpCaTitle;
            if (_cursor.isNull(_cursorIndexOfCaTitle)) {
              _tmpCaTitle = null;
            } else {
              _tmpCaTitle = _cursor.getString(_cursorIndexOfCaTitle);
            }
            _result.setCaTitle(_tmpCaTitle);
            final String _tmpCaDescription;
            if (_cursor.isNull(_cursorIndexOfCaDescription)) {
              _tmpCaDescription = null;
            } else {
              _tmpCaDescription = _cursor.getString(_cursorIndexOfCaDescription);
            }
            _result.setCaDescription(_tmpCaDescription);
            final long _tmpCaGroupUid;
            _tmpCaGroupUid = _cursor.getLong(_cursorIndexOfCaGroupUid);
            _result.setCaGroupUid(_tmpCaGroupUid);
            final boolean _tmpCaActive;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfCaActive);
            _tmpCaActive = _tmp != 0;
            _result.setCaActive(_tmpCaActive);
            final boolean _tmpCaClassCommentEnabled;
            final int _tmp_1;
            _tmp_1 = _cursor.getInt(_cursorIndexOfCaClassCommentEnabled);
            _tmpCaClassCommentEnabled = _tmp_1 != 0;
            _result.setCaClassCommentEnabled(_tmpCaClassCommentEnabled);
            final boolean _tmpCaPrivateCommentsEnabled;
            final int _tmp_2;
            _tmp_2 = _cursor.getInt(_cursorIndexOfCaPrivateCommentsEnabled);
            _tmpCaPrivateCommentsEnabled = _tmp_2 != 0;
            _result.setCaPrivateCommentsEnabled(_tmpCaPrivateCommentsEnabled);
            final int _tmpCaCompletionCriteria;
            _tmpCaCompletionCriteria = _cursor.getInt(_cursorIndexOfCaCompletionCriteria);
            _result.setCaCompletionCriteria(_tmpCaCompletionCriteria);
            final boolean _tmpCaRequireFileSubmission;
            final int _tmp_3;
            _tmp_3 = _cursor.getInt(_cursorIndexOfCaRequireFileSubmission);
            _tmpCaRequireFileSubmission = _tmp_3 != 0;
            _result.setCaRequireFileSubmission(_tmpCaRequireFileSubmission);
            final int _tmpCaFileType;
            _tmpCaFileType = _cursor.getInt(_cursorIndexOfCaFileType);
            _result.setCaFileType(_tmpCaFileType);
            final int _tmpCaSizeLimit;
            _tmpCaSizeLimit = _cursor.getInt(_cursorIndexOfCaSizeLimit);
            _result.setCaSizeLimit(_tmpCaSizeLimit);
            final int _tmpCaNumberOfFiles;
            _tmpCaNumberOfFiles = _cursor.getInt(_cursorIndexOfCaNumberOfFiles);
            _result.setCaNumberOfFiles(_tmpCaNumberOfFiles);
            final int _tmpCaSubmissionPolicy;
            _tmpCaSubmissionPolicy = _cursor.getInt(_cursorIndexOfCaSubmissionPolicy);
            _result.setCaSubmissionPolicy(_tmpCaSubmissionPolicy);
            final int _tmpCaMarkingType;
            _tmpCaMarkingType = _cursor.getInt(_cursorIndexOfCaMarkingType);
            _result.setCaMarkingType(_tmpCaMarkingType);
            final boolean _tmpCaRequireTextSubmission;
            final int _tmp_4;
            _tmp_4 = _cursor.getInt(_cursorIndexOfCaRequireTextSubmission);
            _tmpCaRequireTextSubmission = _tmp_4 != 0;
            _result.setCaRequireTextSubmission(_tmpCaRequireTextSubmission);
            final int _tmpCaTextLimitType;
            _tmpCaTextLimitType = _cursor.getInt(_cursorIndexOfCaTextLimitType);
            _result.setCaTextLimitType(_tmpCaTextLimitType);
            final int _tmpCaTextLimit;
            _tmpCaTextLimit = _cursor.getInt(_cursorIndexOfCaTextLimit);
            _result.setCaTextLimit(_tmpCaTextLimit);
            final long _tmpCaXObjectUid;
            _tmpCaXObjectUid = _cursor.getLong(_cursorIndexOfCaXObjectUid);
            _result.setCaXObjectUid(_tmpCaXObjectUid);
            final long _tmpCaClazzUid;
            _tmpCaClazzUid = _cursor.getLong(_cursorIndexOfCaClazzUid);
            _result.setCaClazzUid(_tmpCaClazzUid);
            final long _tmpCaLocalChangeSeqNum;
            _tmpCaLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfCaLocalChangeSeqNum);
            _result.setCaLocalChangeSeqNum(_tmpCaLocalChangeSeqNum);
            final long _tmpCaMasterChangeSeqNum;
            _tmpCaMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfCaMasterChangeSeqNum);
            _result.setCaMasterChangeSeqNum(_tmpCaMasterChangeSeqNum);
            final int _tmpCaLastChangedBy;
            _tmpCaLastChangedBy = _cursor.getInt(_cursorIndexOfCaLastChangedBy);
            _result.setCaLastChangedBy(_tmpCaLastChangedBy);
            final long _tmpCaLct;
            _tmpCaLct = _cursor.getLong(_cursorIndexOfCaLct);
            _result.setCaLct(_tmpCaLct);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
