package com.ustadmobile.core.db.dao;

import android.database.Cursor;
import androidx.paging.DataSource;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.paging.LimitOffsetDataSource;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.lib.db.entities.Comments;
import com.ustadmobile.lib.db.entities.CommentsWithPerson;
import com.ustadmobile.lib.db.entities.Person;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;

@SuppressWarnings({"unchecked", "deprecation"})
public final class CommentsDao_Impl extends CommentsDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<Comments> __insertionAdapterOfComments;

  private final EntityDeletionOrUpdateAdapter<Comments> __updateAdapterOfComments;

  private final SharedSQLiteStatement __preparedStmtOfReplicateOnNewNode;

  private final SharedSQLiteStatement __preparedStmtOfReplicateOnChange;

  private final SharedSQLiteStatement __preparedStmtOfUpdateInActiveByCommentUid;

  public CommentsDao_Impl(RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfComments = new EntityInsertionAdapter<Comments>(__db) {
      @Override
      public String createQuery() {
        return "INSERT OR ABORT INTO `Comments` (`commentsUid`,`commentsText`,`commentsEntityType`,`commentsEntityUid`,`commentsPublic`,`commentsStatus`,`commentsPersonUid`,`commentsToPersonUid`,`commentSubmitterUid`,`commentsFlagged`,`commentsInActive`,`commentsDateTimeAdded`,`commentsDateTimeUpdated`,`commentsMCSN`,`commentsLCSN`,`commentsLCB`,`commentsLct`) VALUES (nullif(?, 0),?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, Comments value) {
        stmt.bindLong(1, value.getCommentsUid());
        if (value.getCommentsText() == null) {
          stmt.bindNull(2);
        } else {
          stmt.bindString(2, value.getCommentsText());
        }
        stmt.bindLong(3, value.getCommentsEntityType());
        stmt.bindLong(4, value.getCommentsEntityUid());
        final int _tmp = value.getCommentsPublic() ? 1 : 0;
        stmt.bindLong(5, _tmp);
        stmt.bindLong(6, value.getCommentsStatus());
        stmt.bindLong(7, value.getCommentsPersonUid());
        stmt.bindLong(8, value.getCommentsToPersonUid());
        stmt.bindLong(9, value.getCommentSubmitterUid());
        final int _tmp_1 = value.getCommentsFlagged() ? 1 : 0;
        stmt.bindLong(10, _tmp_1);
        final int _tmp_2 = value.getCommentsInActive() ? 1 : 0;
        stmt.bindLong(11, _tmp_2);
        stmt.bindLong(12, value.getCommentsDateTimeAdded());
        stmt.bindLong(13, value.getCommentsDateTimeUpdated());
        stmt.bindLong(14, value.getCommentsMCSN());
        stmt.bindLong(15, value.getCommentsLCSN());
        stmt.bindLong(16, value.getCommentsLCB());
        stmt.bindLong(17, value.getCommentsLct());
      }
    };
    this.__updateAdapterOfComments = new EntityDeletionOrUpdateAdapter<Comments>(__db) {
      @Override
      public String createQuery() {
        return "UPDATE OR ABORT `Comments` SET `commentsUid` = ?,`commentsText` = ?,`commentsEntityType` = ?,`commentsEntityUid` = ?,`commentsPublic` = ?,`commentsStatus` = ?,`commentsPersonUid` = ?,`commentsToPersonUid` = ?,`commentSubmitterUid` = ?,`commentsFlagged` = ?,`commentsInActive` = ?,`commentsDateTimeAdded` = ?,`commentsDateTimeUpdated` = ?,`commentsMCSN` = ?,`commentsLCSN` = ?,`commentsLCB` = ?,`commentsLct` = ? WHERE `commentsUid` = ?";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, Comments value) {
        stmt.bindLong(1, value.getCommentsUid());
        if (value.getCommentsText() == null) {
          stmt.bindNull(2);
        } else {
          stmt.bindString(2, value.getCommentsText());
        }
        stmt.bindLong(3, value.getCommentsEntityType());
        stmt.bindLong(4, value.getCommentsEntityUid());
        final int _tmp = value.getCommentsPublic() ? 1 : 0;
        stmt.bindLong(5, _tmp);
        stmt.bindLong(6, value.getCommentsStatus());
        stmt.bindLong(7, value.getCommentsPersonUid());
        stmt.bindLong(8, value.getCommentsToPersonUid());
        stmt.bindLong(9, value.getCommentSubmitterUid());
        final int _tmp_1 = value.getCommentsFlagged() ? 1 : 0;
        stmt.bindLong(10, _tmp_1);
        final int _tmp_2 = value.getCommentsInActive() ? 1 : 0;
        stmt.bindLong(11, _tmp_2);
        stmt.bindLong(12, value.getCommentsDateTimeAdded());
        stmt.bindLong(13, value.getCommentsDateTimeUpdated());
        stmt.bindLong(14, value.getCommentsMCSN());
        stmt.bindLong(15, value.getCommentsLCSN());
        stmt.bindLong(16, value.getCommentsLCB());
        stmt.bindLong(17, value.getCommentsLct());
        stmt.bindLong(18, value.getCommentsUid());
      }
    };
    this.__preparedStmtOfReplicateOnNewNode = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "\n"
                + "     REPLACE INTO CommentsReplicate(commentsPk, commentsDestination)\n"
                + "      SELECT DISTINCT Comments.commentsUid AS commentsPk,\n"
                + "             ? AS commentsDestination\n"
                + "        FROM Comments\n"
                + "       WHERE Comments.commentsLct != COALESCE(\n"
                + "             (SELECT commentsVersionId\n"
                + "                FROM CommentsReplicate\n"
                + "               WHERE commentsPk = Comments.commentsUid\n"
                + "                 AND commentsDestination = ?), 0) \n"
                + "      /*psql ON CONFLICT(commentsPk, commentsDestination) DO UPDATE\n"
                + "             SET commentsPending = true\n"
                + "      */       \n"
                + "    ";
        return _query;
      }
    };
    this.__preparedStmtOfReplicateOnChange = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "\n"
                + "     REPLACE INTO CommentsReplicate(commentsPk, commentsDestination)\n"
                + "      SELECT DISTINCT Comments.commentsUid AS commentsPk,\n"
                + "             UserSession.usClientNodeId AS commentsDestination\n"
                + "        FROM ChangeLog\n"
                + "             JOIN Comments\n"
                + "                 ON ChangeLog.chTableId = 208\n"
                + "                    AND ChangeLog.chEntityPk = Comments.commentsUid\n"
                + "             JOIN UserSession \n"
                + "                  ON UserSession.usStatus = 1\n"
                + "       WHERE UserSession.usClientNodeId != (\n"
                + "             SELECT nodeClientId \n"
                + "               FROM SyncNode\n"
                + "              LIMIT 1)\n"
                + "         AND Comments.commentsLct != COALESCE(\n"
                + "             (SELECT commentsVersionId\n"
                + "                FROM CommentsReplicate\n"
                + "               WHERE commentsPk = Comments.commentsUid\n"
                + "                 AND commentsDestination = UserSession.usClientNodeId), 0)\n"
                + "     /*psql ON CONFLICT(commentsPk, commentsDestination) DO UPDATE\n"
                + "         SET commentsPending = true\n"
                + "      */               \n"
                + "    ";
        return _query;
      }
    };
    this.__preparedStmtOfUpdateInActiveByCommentUid = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "\n"
                + "        UPDATE Comments \n"
                + "           SET commentsInActive = ?,\n"
                + "               commentsLct = ?\n"
                + "         WHERE Comments.commentsUid = ?\n"
                + "    ";
        return _query;
      }
    };
  }

  @Override
  public long insert(final Comments entity) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      long _result = __insertionAdapterOfComments.insertAndReturnId(entity);
      __db.setTransactionSuccessful();
      return _result;
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object insertAsync(final Comments entity, final Continuation<? super Long> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Long>() {
      @Override
      public Long call() throws Exception {
        __db.beginTransaction();
        try {
          long _result = __insertionAdapterOfComments.insertAndReturnId(entity);
          __db.setTransactionSuccessful();
          return _result;
        } finally {
          __db.endTransaction();
        }
      }
    }, continuation);
  }

  @Override
  public void insertList(final List<? extends Comments> entityList) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __insertionAdapterOfComments.insert(entityList);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object insertListAsync(final List<? extends Comments> entityList,
      final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __insertionAdapterOfComments.insert(entityList);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, continuation);
  }

  @Override
  public void updateList(final List<? extends Comments> entityList) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __updateAdapterOfComments.handleMultiple(entityList);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public void update(final Comments entity) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __updateAdapterOfComments.handle(entity);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object updateListAsync(final List<? extends Comments> entityList,
      final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __updateAdapterOfComments.handleMultiple(entityList);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, continuation);
  }

  @Override
  public Object replicateOnNewNode(final long newNodeId,
      final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfReplicateOnNewNode.acquire();
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, newNodeId);
        _argIndex = 2;
        _stmt.bindLong(_argIndex, newNodeId);
        __db.beginTransaction();
        try {
          _stmt.executeInsert();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfReplicateOnNewNode.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public Object replicateOnChange(final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfReplicateOnChange.acquire();
        __db.beginTransaction();
        try {
          _stmt.executeInsert();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfReplicateOnChange.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public Object updateInActiveByCommentUid(final long uid, final boolean inActive,
      final long changeTime, final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfUpdateInActiveByCommentUid.acquire();
        int _argIndex = 1;
        final int _tmp = inActive ? 1 : 0;
        _stmt.bindLong(_argIndex, _tmp);
        _argIndex = 2;
        _stmt.bindLong(_argIndex, changeTime);
        _argIndex = 3;
        _stmt.bindLong(_argIndex, uid);
        __db.beginTransaction();
        try {
          _stmt.executeUpdateDelete();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfUpdateInActiveByCommentUid.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public Comments findByUidAsync(final long uid) {
    final String _sql = "SELECT * FROM Comments WHERE commentsUid = ?  AND CAST(commentsInActive AS INTEGER) = 0";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, uid);
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final int _cursorIndexOfCommentsUid = CursorUtil.getColumnIndexOrThrow(_cursor, "commentsUid");
      final int _cursorIndexOfCommentsText = CursorUtil.getColumnIndexOrThrow(_cursor, "commentsText");
      final int _cursorIndexOfCommentsEntityType = CursorUtil.getColumnIndexOrThrow(_cursor, "commentsEntityType");
      final int _cursorIndexOfCommentsEntityUid = CursorUtil.getColumnIndexOrThrow(_cursor, "commentsEntityUid");
      final int _cursorIndexOfCommentsPublic = CursorUtil.getColumnIndexOrThrow(_cursor, "commentsPublic");
      final int _cursorIndexOfCommentsStatus = CursorUtil.getColumnIndexOrThrow(_cursor, "commentsStatus");
      final int _cursorIndexOfCommentsPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "commentsPersonUid");
      final int _cursorIndexOfCommentsToPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "commentsToPersonUid");
      final int _cursorIndexOfCommentSubmitterUid = CursorUtil.getColumnIndexOrThrow(_cursor, "commentSubmitterUid");
      final int _cursorIndexOfCommentsFlagged = CursorUtil.getColumnIndexOrThrow(_cursor, "commentsFlagged");
      final int _cursorIndexOfCommentsInActive = CursorUtil.getColumnIndexOrThrow(_cursor, "commentsInActive");
      final int _cursorIndexOfCommentsDateTimeAdded = CursorUtil.getColumnIndexOrThrow(_cursor, "commentsDateTimeAdded");
      final int _cursorIndexOfCommentsDateTimeUpdated = CursorUtil.getColumnIndexOrThrow(_cursor, "commentsDateTimeUpdated");
      final int _cursorIndexOfCommentsMCSN = CursorUtil.getColumnIndexOrThrow(_cursor, "commentsMCSN");
      final int _cursorIndexOfCommentsLCSN = CursorUtil.getColumnIndexOrThrow(_cursor, "commentsLCSN");
      final int _cursorIndexOfCommentsLCB = CursorUtil.getColumnIndexOrThrow(_cursor, "commentsLCB");
      final int _cursorIndexOfCommentsLct = CursorUtil.getColumnIndexOrThrow(_cursor, "commentsLct");
      final Comments _result;
      if(_cursor.moveToFirst()) {
        _result = new Comments();
        final long _tmpCommentsUid;
        _tmpCommentsUid = _cursor.getLong(_cursorIndexOfCommentsUid);
        _result.setCommentsUid(_tmpCommentsUid);
        final String _tmpCommentsText;
        if (_cursor.isNull(_cursorIndexOfCommentsText)) {
          _tmpCommentsText = null;
        } else {
          _tmpCommentsText = _cursor.getString(_cursorIndexOfCommentsText);
        }
        _result.setCommentsText(_tmpCommentsText);
        final int _tmpCommentsEntityType;
        _tmpCommentsEntityType = _cursor.getInt(_cursorIndexOfCommentsEntityType);
        _result.setCommentsEntityType(_tmpCommentsEntityType);
        final long _tmpCommentsEntityUid;
        _tmpCommentsEntityUid = _cursor.getLong(_cursorIndexOfCommentsEntityUid);
        _result.setCommentsEntityUid(_tmpCommentsEntityUid);
        final boolean _tmpCommentsPublic;
        final int _tmp;
        _tmp = _cursor.getInt(_cursorIndexOfCommentsPublic);
        _tmpCommentsPublic = _tmp != 0;
        _result.setCommentsPublic(_tmpCommentsPublic);
        final int _tmpCommentsStatus;
        _tmpCommentsStatus = _cursor.getInt(_cursorIndexOfCommentsStatus);
        _result.setCommentsStatus(_tmpCommentsStatus);
        final long _tmpCommentsPersonUid;
        _tmpCommentsPersonUid = _cursor.getLong(_cursorIndexOfCommentsPersonUid);
        _result.setCommentsPersonUid(_tmpCommentsPersonUid);
        final long _tmpCommentsToPersonUid;
        _tmpCommentsToPersonUid = _cursor.getLong(_cursorIndexOfCommentsToPersonUid);
        _result.setCommentsToPersonUid(_tmpCommentsToPersonUid);
        final long _tmpCommentSubmitterUid;
        _tmpCommentSubmitterUid = _cursor.getLong(_cursorIndexOfCommentSubmitterUid);
        _result.setCommentSubmitterUid(_tmpCommentSubmitterUid);
        final boolean _tmpCommentsFlagged;
        final int _tmp_1;
        _tmp_1 = _cursor.getInt(_cursorIndexOfCommentsFlagged);
        _tmpCommentsFlagged = _tmp_1 != 0;
        _result.setCommentsFlagged(_tmpCommentsFlagged);
        final boolean _tmpCommentsInActive;
        final int _tmp_2;
        _tmp_2 = _cursor.getInt(_cursorIndexOfCommentsInActive);
        _tmpCommentsInActive = _tmp_2 != 0;
        _result.setCommentsInActive(_tmpCommentsInActive);
        final long _tmpCommentsDateTimeAdded;
        _tmpCommentsDateTimeAdded = _cursor.getLong(_cursorIndexOfCommentsDateTimeAdded);
        _result.setCommentsDateTimeAdded(_tmpCommentsDateTimeAdded);
        final long _tmpCommentsDateTimeUpdated;
        _tmpCommentsDateTimeUpdated = _cursor.getLong(_cursorIndexOfCommentsDateTimeUpdated);
        _result.setCommentsDateTimeUpdated(_tmpCommentsDateTimeUpdated);
        final long _tmpCommentsMCSN;
        _tmpCommentsMCSN = _cursor.getLong(_cursorIndexOfCommentsMCSN);
        _result.setCommentsMCSN(_tmpCommentsMCSN);
        final long _tmpCommentsLCSN;
        _tmpCommentsLCSN = _cursor.getLong(_cursorIndexOfCommentsLCSN);
        _result.setCommentsLCSN(_tmpCommentsLCSN);
        final int _tmpCommentsLCB;
        _tmpCommentsLCB = _cursor.getInt(_cursorIndexOfCommentsLCB);
        _result.setCommentsLCB(_tmpCommentsLCB);
        final long _tmpCommentsLct;
        _tmpCommentsLct = _cursor.getLong(_cursorIndexOfCommentsLct);
        _result.setCommentsLct(_tmpCommentsLct);
      } else {
        _result = null;
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  @Override
  public DataSource.Factory<Integer, CommentsWithPerson> findPublicByEntityTypeAndUidLive(
      final int entityType, final long entityUid) {
    final String _sql = "\n"
            + "        SELECT Comments.*, Person.* \n"
            + "          FROM Comments\n"
            + "                LEFT JOIN Person \n"
            + "                ON Person.personUid = Comments.commentsPersonUid \n"
            + "         WHERE Comments.commentsEntityType = ? \n"
            + "           AND Comments.commentsEntityUid = ?\n"
            + "           AND CAST(Comments.commentsFlagged AS INTEGER) = 0\n"
            + "           AND CAST(Comments.commentsInActive AS INTEGER) = 0\n"
            + "           AND CAST(Comments.commentsPublic AS INTEGER) = 1\n"
            + "      ORDER BY Comments.commentsDateTimeAdded DESC \n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 2);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, entityType);
    _argIndex = 2;
    _statement.bindLong(_argIndex, entityUid);
    return new DataSource.Factory<Integer, CommentsWithPerson>() {
      @Override
      public LimitOffsetDataSource<CommentsWithPerson> create() {
        return new LimitOffsetDataSource<CommentsWithPerson>(__db, _statement, false, true , "Comments", "Person") {
          @Override
          protected List<CommentsWithPerson> convertRows(Cursor cursor) {
            final int _cursorIndexOfCommentsUid = CursorUtil.getColumnIndexOrThrow(cursor, "commentsUid");
            final int _cursorIndexOfCommentsText = CursorUtil.getColumnIndexOrThrow(cursor, "commentsText");
            final int _cursorIndexOfCommentsEntityType = CursorUtil.getColumnIndexOrThrow(cursor, "commentsEntityType");
            final int _cursorIndexOfCommentsEntityUid = CursorUtil.getColumnIndexOrThrow(cursor, "commentsEntityUid");
            final int _cursorIndexOfCommentsPublic = CursorUtil.getColumnIndexOrThrow(cursor, "commentsPublic");
            final int _cursorIndexOfCommentsStatus = CursorUtil.getColumnIndexOrThrow(cursor, "commentsStatus");
            final int _cursorIndexOfCommentsPersonUid = CursorUtil.getColumnIndexOrThrow(cursor, "commentsPersonUid");
            final int _cursorIndexOfCommentsToPersonUid = CursorUtil.getColumnIndexOrThrow(cursor, "commentsToPersonUid");
            final int _cursorIndexOfCommentSubmitterUid = CursorUtil.getColumnIndexOrThrow(cursor, "commentSubmitterUid");
            final int _cursorIndexOfCommentsFlagged = CursorUtil.getColumnIndexOrThrow(cursor, "commentsFlagged");
            final int _cursorIndexOfCommentsInActive = CursorUtil.getColumnIndexOrThrow(cursor, "commentsInActive");
            final int _cursorIndexOfCommentsDateTimeAdded = CursorUtil.getColumnIndexOrThrow(cursor, "commentsDateTimeAdded");
            final int _cursorIndexOfCommentsDateTimeUpdated = CursorUtil.getColumnIndexOrThrow(cursor, "commentsDateTimeUpdated");
            final int _cursorIndexOfCommentsMCSN = CursorUtil.getColumnIndexOrThrow(cursor, "commentsMCSN");
            final int _cursorIndexOfCommentsLCSN = CursorUtil.getColumnIndexOrThrow(cursor, "commentsLCSN");
            final int _cursorIndexOfCommentsLCB = CursorUtil.getColumnIndexOrThrow(cursor, "commentsLCB");
            final int _cursorIndexOfCommentsLct = CursorUtil.getColumnIndexOrThrow(cursor, "commentsLct");
            final int _cursorIndexOfPersonUid = CursorUtil.getColumnIndexOrThrow(cursor, "personUid");
            final int _cursorIndexOfUsername = CursorUtil.getColumnIndexOrThrow(cursor, "username");
            final int _cursorIndexOfFirstNames = CursorUtil.getColumnIndexOrThrow(cursor, "firstNames");
            final int _cursorIndexOfLastName = CursorUtil.getColumnIndexOrThrow(cursor, "lastName");
            final int _cursorIndexOfEmailAddr = CursorUtil.getColumnIndexOrThrow(cursor, "emailAddr");
            final int _cursorIndexOfPhoneNum = CursorUtil.getColumnIndexOrThrow(cursor, "phoneNum");
            final int _cursorIndexOfGender = CursorUtil.getColumnIndexOrThrow(cursor, "gender");
            final int _cursorIndexOfActive = CursorUtil.getColumnIndexOrThrow(cursor, "active");
            final int _cursorIndexOfAdmin = CursorUtil.getColumnIndexOrThrow(cursor, "admin");
            final int _cursorIndexOfPersonNotes = CursorUtil.getColumnIndexOrThrow(cursor, "personNotes");
            final int _cursorIndexOfFatherName = CursorUtil.getColumnIndexOrThrow(cursor, "fatherName");
            final int _cursorIndexOfFatherNumber = CursorUtil.getColumnIndexOrThrow(cursor, "fatherNumber");
            final int _cursorIndexOfMotherName = CursorUtil.getColumnIndexOrThrow(cursor, "motherName");
            final int _cursorIndexOfMotherNum = CursorUtil.getColumnIndexOrThrow(cursor, "motherNum");
            final int _cursorIndexOfDateOfBirth = CursorUtil.getColumnIndexOrThrow(cursor, "dateOfBirth");
            final int _cursorIndexOfPersonAddress = CursorUtil.getColumnIndexOrThrow(cursor, "personAddress");
            final int _cursorIndexOfPersonOrgId = CursorUtil.getColumnIndexOrThrow(cursor, "personOrgId");
            final int _cursorIndexOfPersonGroupUid = CursorUtil.getColumnIndexOrThrow(cursor, "personGroupUid");
            final int _cursorIndexOfPersonMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(cursor, "personMasterChangeSeqNum");
            final int _cursorIndexOfPersonLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(cursor, "personLocalChangeSeqNum");
            final int _cursorIndexOfPersonLastChangedBy = CursorUtil.getColumnIndexOrThrow(cursor, "personLastChangedBy");
            final int _cursorIndexOfPersonLct = CursorUtil.getColumnIndexOrThrow(cursor, "personLct");
            final int _cursorIndexOfPersonCountry = CursorUtil.getColumnIndexOrThrow(cursor, "personCountry");
            final int _cursorIndexOfPersonType = CursorUtil.getColumnIndexOrThrow(cursor, "personType");
            final List<CommentsWithPerson> _res = new ArrayList<CommentsWithPerson>(cursor.getCount());
            while(cursor.moveToNext()) {
              final CommentsWithPerson _item;
              final Person _tmpCommentsPerson;
              if (! (cursor.isNull(_cursorIndexOfPersonUid) && cursor.isNull(_cursorIndexOfUsername) && cursor.isNull(_cursorIndexOfFirstNames) && cursor.isNull(_cursorIndexOfLastName) && cursor.isNull(_cursorIndexOfEmailAddr) && cursor.isNull(_cursorIndexOfPhoneNum) && cursor.isNull(_cursorIndexOfGender) && cursor.isNull(_cursorIndexOfActive) && cursor.isNull(_cursorIndexOfAdmin) && cursor.isNull(_cursorIndexOfPersonNotes) && cursor.isNull(_cursorIndexOfFatherName) && cursor.isNull(_cursorIndexOfFatherNumber) && cursor.isNull(_cursorIndexOfMotherName) && cursor.isNull(_cursorIndexOfMotherNum) && cursor.isNull(_cursorIndexOfDateOfBirth) && cursor.isNull(_cursorIndexOfPersonAddress) && cursor.isNull(_cursorIndexOfPersonOrgId) && cursor.isNull(_cursorIndexOfPersonGroupUid) && cursor.isNull(_cursorIndexOfPersonMasterChangeSeqNum) && cursor.isNull(_cursorIndexOfPersonLocalChangeSeqNum) && cursor.isNull(_cursorIndexOfPersonLastChangedBy) && cursor.isNull(_cursorIndexOfPersonLct) && cursor.isNull(_cursorIndexOfPersonCountry) && cursor.isNull(_cursorIndexOfPersonType))) {
                _tmpCommentsPerson = new Person();
                final long _tmpPersonUid;
                _tmpPersonUid = cursor.getLong(_cursorIndexOfPersonUid);
                _tmpCommentsPerson.setPersonUid(_tmpPersonUid);
                final String _tmpUsername;
                if (cursor.isNull(_cursorIndexOfUsername)) {
                  _tmpUsername = null;
                } else {
                  _tmpUsername = cursor.getString(_cursorIndexOfUsername);
                }
                _tmpCommentsPerson.setUsername(_tmpUsername);
                final String _tmpFirstNames;
                if (cursor.isNull(_cursorIndexOfFirstNames)) {
                  _tmpFirstNames = null;
                } else {
                  _tmpFirstNames = cursor.getString(_cursorIndexOfFirstNames);
                }
                _tmpCommentsPerson.setFirstNames(_tmpFirstNames);
                final String _tmpLastName;
                if (cursor.isNull(_cursorIndexOfLastName)) {
                  _tmpLastName = null;
                } else {
                  _tmpLastName = cursor.getString(_cursorIndexOfLastName);
                }
                _tmpCommentsPerson.setLastName(_tmpLastName);
                final String _tmpEmailAddr;
                if (cursor.isNull(_cursorIndexOfEmailAddr)) {
                  _tmpEmailAddr = null;
                } else {
                  _tmpEmailAddr = cursor.getString(_cursorIndexOfEmailAddr);
                }
                _tmpCommentsPerson.setEmailAddr(_tmpEmailAddr);
                final String _tmpPhoneNum;
                if (cursor.isNull(_cursorIndexOfPhoneNum)) {
                  _tmpPhoneNum = null;
                } else {
                  _tmpPhoneNum = cursor.getString(_cursorIndexOfPhoneNum);
                }
                _tmpCommentsPerson.setPhoneNum(_tmpPhoneNum);
                final int _tmpGender;
                _tmpGender = cursor.getInt(_cursorIndexOfGender);
                _tmpCommentsPerson.setGender(_tmpGender);
                final boolean _tmpActive;
                final int _tmp;
                _tmp = cursor.getInt(_cursorIndexOfActive);
                _tmpActive = _tmp != 0;
                _tmpCommentsPerson.setActive(_tmpActive);
                final boolean _tmpAdmin;
                final int _tmp_1;
                _tmp_1 = cursor.getInt(_cursorIndexOfAdmin);
                _tmpAdmin = _tmp_1 != 0;
                _tmpCommentsPerson.setAdmin(_tmpAdmin);
                final String _tmpPersonNotes;
                if (cursor.isNull(_cursorIndexOfPersonNotes)) {
                  _tmpPersonNotes = null;
                } else {
                  _tmpPersonNotes = cursor.getString(_cursorIndexOfPersonNotes);
                }
                _tmpCommentsPerson.setPersonNotes(_tmpPersonNotes);
                final String _tmpFatherName;
                if (cursor.isNull(_cursorIndexOfFatherName)) {
                  _tmpFatherName = null;
                } else {
                  _tmpFatherName = cursor.getString(_cursorIndexOfFatherName);
                }
                _tmpCommentsPerson.setFatherName(_tmpFatherName);
                final String _tmpFatherNumber;
                if (cursor.isNull(_cursorIndexOfFatherNumber)) {
                  _tmpFatherNumber = null;
                } else {
                  _tmpFatherNumber = cursor.getString(_cursorIndexOfFatherNumber);
                }
                _tmpCommentsPerson.setFatherNumber(_tmpFatherNumber);
                final String _tmpMotherName;
                if (cursor.isNull(_cursorIndexOfMotherName)) {
                  _tmpMotherName = null;
                } else {
                  _tmpMotherName = cursor.getString(_cursorIndexOfMotherName);
                }
                _tmpCommentsPerson.setMotherName(_tmpMotherName);
                final String _tmpMotherNum;
                if (cursor.isNull(_cursorIndexOfMotherNum)) {
                  _tmpMotherNum = null;
                } else {
                  _tmpMotherNum = cursor.getString(_cursorIndexOfMotherNum);
                }
                _tmpCommentsPerson.setMotherNum(_tmpMotherNum);
                final long _tmpDateOfBirth;
                _tmpDateOfBirth = cursor.getLong(_cursorIndexOfDateOfBirth);
                _tmpCommentsPerson.setDateOfBirth(_tmpDateOfBirth);
                final String _tmpPersonAddress;
                if (cursor.isNull(_cursorIndexOfPersonAddress)) {
                  _tmpPersonAddress = null;
                } else {
                  _tmpPersonAddress = cursor.getString(_cursorIndexOfPersonAddress);
                }
                _tmpCommentsPerson.setPersonAddress(_tmpPersonAddress);
                final String _tmpPersonOrgId;
                if (cursor.isNull(_cursorIndexOfPersonOrgId)) {
                  _tmpPersonOrgId = null;
                } else {
                  _tmpPersonOrgId = cursor.getString(_cursorIndexOfPersonOrgId);
                }
                _tmpCommentsPerson.setPersonOrgId(_tmpPersonOrgId);
                final long _tmpPersonGroupUid;
                _tmpPersonGroupUid = cursor.getLong(_cursorIndexOfPersonGroupUid);
                _tmpCommentsPerson.setPersonGroupUid(_tmpPersonGroupUid);
                final long _tmpPersonMasterChangeSeqNum;
                _tmpPersonMasterChangeSeqNum = cursor.getLong(_cursorIndexOfPersonMasterChangeSeqNum);
                _tmpCommentsPerson.setPersonMasterChangeSeqNum(_tmpPersonMasterChangeSeqNum);
                final long _tmpPersonLocalChangeSeqNum;
                _tmpPersonLocalChangeSeqNum = cursor.getLong(_cursorIndexOfPersonLocalChangeSeqNum);
                _tmpCommentsPerson.setPersonLocalChangeSeqNum(_tmpPersonLocalChangeSeqNum);
                final int _tmpPersonLastChangedBy;
                _tmpPersonLastChangedBy = cursor.getInt(_cursorIndexOfPersonLastChangedBy);
                _tmpCommentsPerson.setPersonLastChangedBy(_tmpPersonLastChangedBy);
                final long _tmpPersonLct;
                _tmpPersonLct = cursor.getLong(_cursorIndexOfPersonLct);
                _tmpCommentsPerson.setPersonLct(_tmpPersonLct);
                final String _tmpPersonCountry;
                if (cursor.isNull(_cursorIndexOfPersonCountry)) {
                  _tmpPersonCountry = null;
                } else {
                  _tmpPersonCountry = cursor.getString(_cursorIndexOfPersonCountry);
                }
                _tmpCommentsPerson.setPersonCountry(_tmpPersonCountry);
                final int _tmpPersonType;
                _tmpPersonType = cursor.getInt(_cursorIndexOfPersonType);
                _tmpCommentsPerson.setPersonType(_tmpPersonType);
              }  else  {
                _tmpCommentsPerson = null;
              }
              _item = new CommentsWithPerson();
              final long _tmpCommentsUid;
              _tmpCommentsUid = cursor.getLong(_cursorIndexOfCommentsUid);
              _item.setCommentsUid(_tmpCommentsUid);
              final String _tmpCommentsText;
              if (cursor.isNull(_cursorIndexOfCommentsText)) {
                _tmpCommentsText = null;
              } else {
                _tmpCommentsText = cursor.getString(_cursorIndexOfCommentsText);
              }
              _item.setCommentsText(_tmpCommentsText);
              final int _tmpCommentsEntityType;
              _tmpCommentsEntityType = cursor.getInt(_cursorIndexOfCommentsEntityType);
              _item.setCommentsEntityType(_tmpCommentsEntityType);
              final long _tmpCommentsEntityUid;
              _tmpCommentsEntityUid = cursor.getLong(_cursorIndexOfCommentsEntityUid);
              _item.setCommentsEntityUid(_tmpCommentsEntityUid);
              final boolean _tmpCommentsPublic;
              final int _tmp_2;
              _tmp_2 = cursor.getInt(_cursorIndexOfCommentsPublic);
              _tmpCommentsPublic = _tmp_2 != 0;
              _item.setCommentsPublic(_tmpCommentsPublic);
              final int _tmpCommentsStatus;
              _tmpCommentsStatus = cursor.getInt(_cursorIndexOfCommentsStatus);
              _item.setCommentsStatus(_tmpCommentsStatus);
              final long _tmpCommentsPersonUid;
              _tmpCommentsPersonUid = cursor.getLong(_cursorIndexOfCommentsPersonUid);
              _item.setCommentsPersonUid(_tmpCommentsPersonUid);
              final long _tmpCommentsToPersonUid;
              _tmpCommentsToPersonUid = cursor.getLong(_cursorIndexOfCommentsToPersonUid);
              _item.setCommentsToPersonUid(_tmpCommentsToPersonUid);
              final long _tmpCommentSubmitterUid;
              _tmpCommentSubmitterUid = cursor.getLong(_cursorIndexOfCommentSubmitterUid);
              _item.setCommentSubmitterUid(_tmpCommentSubmitterUid);
              final boolean _tmpCommentsFlagged;
              final int _tmp_3;
              _tmp_3 = cursor.getInt(_cursorIndexOfCommentsFlagged);
              _tmpCommentsFlagged = _tmp_3 != 0;
              _item.setCommentsFlagged(_tmpCommentsFlagged);
              final boolean _tmpCommentsInActive;
              final int _tmp_4;
              _tmp_4 = cursor.getInt(_cursorIndexOfCommentsInActive);
              _tmpCommentsInActive = _tmp_4 != 0;
              _item.setCommentsInActive(_tmpCommentsInActive);
              final long _tmpCommentsDateTimeAdded;
              _tmpCommentsDateTimeAdded = cursor.getLong(_cursorIndexOfCommentsDateTimeAdded);
              _item.setCommentsDateTimeAdded(_tmpCommentsDateTimeAdded);
              final long _tmpCommentsDateTimeUpdated;
              _tmpCommentsDateTimeUpdated = cursor.getLong(_cursorIndexOfCommentsDateTimeUpdated);
              _item.setCommentsDateTimeUpdated(_tmpCommentsDateTimeUpdated);
              final long _tmpCommentsMCSN;
              _tmpCommentsMCSN = cursor.getLong(_cursorIndexOfCommentsMCSN);
              _item.setCommentsMCSN(_tmpCommentsMCSN);
              final long _tmpCommentsLCSN;
              _tmpCommentsLCSN = cursor.getLong(_cursorIndexOfCommentsLCSN);
              _item.setCommentsLCSN(_tmpCommentsLCSN);
              final int _tmpCommentsLCB;
              _tmpCommentsLCB = cursor.getInt(_cursorIndexOfCommentsLCB);
              _item.setCommentsLCB(_tmpCommentsLCB);
              final long _tmpCommentsLct;
              _tmpCommentsLct = cursor.getLong(_cursorIndexOfCommentsLct);
              _item.setCommentsLct(_tmpCommentsLct);
              _item.setCommentsPerson(_tmpCommentsPerson);
              _res.add(_item);
            }
            return _res;
          }
        };
      }
    };
  }

  @Override
  public DataSource.Factory<Integer, CommentsWithPerson> findPrivateByEntityTypeAndUidAndForPersonLive(
      final int entityType, final long entityUid, final long personUid) {
    final String _sql = "\n"
            + "        SELECT Comments.*, Person.* FROM Comments\n"
            + "        LEFT JOIN Person ON Person.personUid = Comments.commentsPersonUid \n"
            + "        WHERE Comments.commentsEntityType = ? \n"
            + "        AND Comments.commentsEntityUid = ?\n"
            + "        AND Comments.commentsPersonUid = ? OR Comments.commentsToPersonUid = ? \n"
            + "        AND CAST(Comments.commentsFlagged AS INTEGER) = 0\n"
            + "        AND CAST(Comments.commentsInActive AS INTEGER) = 0\n"
            + "        AND CAST(Comments.commentsPublic AS INTEGER) = 0\n"
            + "        AND Person.personUid = ?\n"
            + "        ORDER BY Comments.commentsDateTimeAdded DESC \n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 5);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, entityType);
    _argIndex = 2;
    _statement.bindLong(_argIndex, entityUid);
    _argIndex = 3;
    _statement.bindLong(_argIndex, personUid);
    _argIndex = 4;
    _statement.bindLong(_argIndex, personUid);
    _argIndex = 5;
    _statement.bindLong(_argIndex, personUid);
    return new DataSource.Factory<Integer, CommentsWithPerson>() {
      @Override
      public LimitOffsetDataSource<CommentsWithPerson> create() {
        return new LimitOffsetDataSource<CommentsWithPerson>(__db, _statement, false, true , "Comments", "Person") {
          @Override
          protected List<CommentsWithPerson> convertRows(Cursor cursor) {
            final int _cursorIndexOfCommentsUid = CursorUtil.getColumnIndexOrThrow(cursor, "commentsUid");
            final int _cursorIndexOfCommentsText = CursorUtil.getColumnIndexOrThrow(cursor, "commentsText");
            final int _cursorIndexOfCommentsEntityType = CursorUtil.getColumnIndexOrThrow(cursor, "commentsEntityType");
            final int _cursorIndexOfCommentsEntityUid = CursorUtil.getColumnIndexOrThrow(cursor, "commentsEntityUid");
            final int _cursorIndexOfCommentsPublic = CursorUtil.getColumnIndexOrThrow(cursor, "commentsPublic");
            final int _cursorIndexOfCommentsStatus = CursorUtil.getColumnIndexOrThrow(cursor, "commentsStatus");
            final int _cursorIndexOfCommentsPersonUid = CursorUtil.getColumnIndexOrThrow(cursor, "commentsPersonUid");
            final int _cursorIndexOfCommentsToPersonUid = CursorUtil.getColumnIndexOrThrow(cursor, "commentsToPersonUid");
            final int _cursorIndexOfCommentSubmitterUid = CursorUtil.getColumnIndexOrThrow(cursor, "commentSubmitterUid");
            final int _cursorIndexOfCommentsFlagged = CursorUtil.getColumnIndexOrThrow(cursor, "commentsFlagged");
            final int _cursorIndexOfCommentsInActive = CursorUtil.getColumnIndexOrThrow(cursor, "commentsInActive");
            final int _cursorIndexOfCommentsDateTimeAdded = CursorUtil.getColumnIndexOrThrow(cursor, "commentsDateTimeAdded");
            final int _cursorIndexOfCommentsDateTimeUpdated = CursorUtil.getColumnIndexOrThrow(cursor, "commentsDateTimeUpdated");
            final int _cursorIndexOfCommentsMCSN = CursorUtil.getColumnIndexOrThrow(cursor, "commentsMCSN");
            final int _cursorIndexOfCommentsLCSN = CursorUtil.getColumnIndexOrThrow(cursor, "commentsLCSN");
            final int _cursorIndexOfCommentsLCB = CursorUtil.getColumnIndexOrThrow(cursor, "commentsLCB");
            final int _cursorIndexOfCommentsLct = CursorUtil.getColumnIndexOrThrow(cursor, "commentsLct");
            final int _cursorIndexOfPersonUid = CursorUtil.getColumnIndexOrThrow(cursor, "personUid");
            final int _cursorIndexOfUsername = CursorUtil.getColumnIndexOrThrow(cursor, "username");
            final int _cursorIndexOfFirstNames = CursorUtil.getColumnIndexOrThrow(cursor, "firstNames");
            final int _cursorIndexOfLastName = CursorUtil.getColumnIndexOrThrow(cursor, "lastName");
            final int _cursorIndexOfEmailAddr = CursorUtil.getColumnIndexOrThrow(cursor, "emailAddr");
            final int _cursorIndexOfPhoneNum = CursorUtil.getColumnIndexOrThrow(cursor, "phoneNum");
            final int _cursorIndexOfGender = CursorUtil.getColumnIndexOrThrow(cursor, "gender");
            final int _cursorIndexOfActive = CursorUtil.getColumnIndexOrThrow(cursor, "active");
            final int _cursorIndexOfAdmin = CursorUtil.getColumnIndexOrThrow(cursor, "admin");
            final int _cursorIndexOfPersonNotes = CursorUtil.getColumnIndexOrThrow(cursor, "personNotes");
            final int _cursorIndexOfFatherName = CursorUtil.getColumnIndexOrThrow(cursor, "fatherName");
            final int _cursorIndexOfFatherNumber = CursorUtil.getColumnIndexOrThrow(cursor, "fatherNumber");
            final int _cursorIndexOfMotherName = CursorUtil.getColumnIndexOrThrow(cursor, "motherName");
            final int _cursorIndexOfMotherNum = CursorUtil.getColumnIndexOrThrow(cursor, "motherNum");
            final int _cursorIndexOfDateOfBirth = CursorUtil.getColumnIndexOrThrow(cursor, "dateOfBirth");
            final int _cursorIndexOfPersonAddress = CursorUtil.getColumnIndexOrThrow(cursor, "personAddress");
            final int _cursorIndexOfPersonOrgId = CursorUtil.getColumnIndexOrThrow(cursor, "personOrgId");
            final int _cursorIndexOfPersonGroupUid = CursorUtil.getColumnIndexOrThrow(cursor, "personGroupUid");
            final int _cursorIndexOfPersonMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(cursor, "personMasterChangeSeqNum");
            final int _cursorIndexOfPersonLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(cursor, "personLocalChangeSeqNum");
            final int _cursorIndexOfPersonLastChangedBy = CursorUtil.getColumnIndexOrThrow(cursor, "personLastChangedBy");
            final int _cursorIndexOfPersonLct = CursorUtil.getColumnIndexOrThrow(cursor, "personLct");
            final int _cursorIndexOfPersonCountry = CursorUtil.getColumnIndexOrThrow(cursor, "personCountry");
            final int _cursorIndexOfPersonType = CursorUtil.getColumnIndexOrThrow(cursor, "personType");
            final List<CommentsWithPerson> _res = new ArrayList<CommentsWithPerson>(cursor.getCount());
            while(cursor.moveToNext()) {
              final CommentsWithPerson _item;
              final Person _tmpCommentsPerson;
              if (! (cursor.isNull(_cursorIndexOfPersonUid) && cursor.isNull(_cursorIndexOfUsername) && cursor.isNull(_cursorIndexOfFirstNames) && cursor.isNull(_cursorIndexOfLastName) && cursor.isNull(_cursorIndexOfEmailAddr) && cursor.isNull(_cursorIndexOfPhoneNum) && cursor.isNull(_cursorIndexOfGender) && cursor.isNull(_cursorIndexOfActive) && cursor.isNull(_cursorIndexOfAdmin) && cursor.isNull(_cursorIndexOfPersonNotes) && cursor.isNull(_cursorIndexOfFatherName) && cursor.isNull(_cursorIndexOfFatherNumber) && cursor.isNull(_cursorIndexOfMotherName) && cursor.isNull(_cursorIndexOfMotherNum) && cursor.isNull(_cursorIndexOfDateOfBirth) && cursor.isNull(_cursorIndexOfPersonAddress) && cursor.isNull(_cursorIndexOfPersonOrgId) && cursor.isNull(_cursorIndexOfPersonGroupUid) && cursor.isNull(_cursorIndexOfPersonMasterChangeSeqNum) && cursor.isNull(_cursorIndexOfPersonLocalChangeSeqNum) && cursor.isNull(_cursorIndexOfPersonLastChangedBy) && cursor.isNull(_cursorIndexOfPersonLct) && cursor.isNull(_cursorIndexOfPersonCountry) && cursor.isNull(_cursorIndexOfPersonType))) {
                _tmpCommentsPerson = new Person();
                final long _tmpPersonUid;
                _tmpPersonUid = cursor.getLong(_cursorIndexOfPersonUid);
                _tmpCommentsPerson.setPersonUid(_tmpPersonUid);
                final String _tmpUsername;
                if (cursor.isNull(_cursorIndexOfUsername)) {
                  _tmpUsername = null;
                } else {
                  _tmpUsername = cursor.getString(_cursorIndexOfUsername);
                }
                _tmpCommentsPerson.setUsername(_tmpUsername);
                final String _tmpFirstNames;
                if (cursor.isNull(_cursorIndexOfFirstNames)) {
                  _tmpFirstNames = null;
                } else {
                  _tmpFirstNames = cursor.getString(_cursorIndexOfFirstNames);
                }
                _tmpCommentsPerson.setFirstNames(_tmpFirstNames);
                final String _tmpLastName;
                if (cursor.isNull(_cursorIndexOfLastName)) {
                  _tmpLastName = null;
                } else {
                  _tmpLastName = cursor.getString(_cursorIndexOfLastName);
                }
                _tmpCommentsPerson.setLastName(_tmpLastName);
                final String _tmpEmailAddr;
                if (cursor.isNull(_cursorIndexOfEmailAddr)) {
                  _tmpEmailAddr = null;
                } else {
                  _tmpEmailAddr = cursor.getString(_cursorIndexOfEmailAddr);
                }
                _tmpCommentsPerson.setEmailAddr(_tmpEmailAddr);
                final String _tmpPhoneNum;
                if (cursor.isNull(_cursorIndexOfPhoneNum)) {
                  _tmpPhoneNum = null;
                } else {
                  _tmpPhoneNum = cursor.getString(_cursorIndexOfPhoneNum);
                }
                _tmpCommentsPerson.setPhoneNum(_tmpPhoneNum);
                final int _tmpGender;
                _tmpGender = cursor.getInt(_cursorIndexOfGender);
                _tmpCommentsPerson.setGender(_tmpGender);
                final boolean _tmpActive;
                final int _tmp;
                _tmp = cursor.getInt(_cursorIndexOfActive);
                _tmpActive = _tmp != 0;
                _tmpCommentsPerson.setActive(_tmpActive);
                final boolean _tmpAdmin;
                final int _tmp_1;
                _tmp_1 = cursor.getInt(_cursorIndexOfAdmin);
                _tmpAdmin = _tmp_1 != 0;
                _tmpCommentsPerson.setAdmin(_tmpAdmin);
                final String _tmpPersonNotes;
                if (cursor.isNull(_cursorIndexOfPersonNotes)) {
                  _tmpPersonNotes = null;
                } else {
                  _tmpPersonNotes = cursor.getString(_cursorIndexOfPersonNotes);
                }
                _tmpCommentsPerson.setPersonNotes(_tmpPersonNotes);
                final String _tmpFatherName;
                if (cursor.isNull(_cursorIndexOfFatherName)) {
                  _tmpFatherName = null;
                } else {
                  _tmpFatherName = cursor.getString(_cursorIndexOfFatherName);
                }
                _tmpCommentsPerson.setFatherName(_tmpFatherName);
                final String _tmpFatherNumber;
                if (cursor.isNull(_cursorIndexOfFatherNumber)) {
                  _tmpFatherNumber = null;
                } else {
                  _tmpFatherNumber = cursor.getString(_cursorIndexOfFatherNumber);
                }
                _tmpCommentsPerson.setFatherNumber(_tmpFatherNumber);
                final String _tmpMotherName;
                if (cursor.isNull(_cursorIndexOfMotherName)) {
                  _tmpMotherName = null;
                } else {
                  _tmpMotherName = cursor.getString(_cursorIndexOfMotherName);
                }
                _tmpCommentsPerson.setMotherName(_tmpMotherName);
                final String _tmpMotherNum;
                if (cursor.isNull(_cursorIndexOfMotherNum)) {
                  _tmpMotherNum = null;
                } else {
                  _tmpMotherNum = cursor.getString(_cursorIndexOfMotherNum);
                }
                _tmpCommentsPerson.setMotherNum(_tmpMotherNum);
                final long _tmpDateOfBirth;
                _tmpDateOfBirth = cursor.getLong(_cursorIndexOfDateOfBirth);
                _tmpCommentsPerson.setDateOfBirth(_tmpDateOfBirth);
                final String _tmpPersonAddress;
                if (cursor.isNull(_cursorIndexOfPersonAddress)) {
                  _tmpPersonAddress = null;
                } else {
                  _tmpPersonAddress = cursor.getString(_cursorIndexOfPersonAddress);
                }
                _tmpCommentsPerson.setPersonAddress(_tmpPersonAddress);
                final String _tmpPersonOrgId;
                if (cursor.isNull(_cursorIndexOfPersonOrgId)) {
                  _tmpPersonOrgId = null;
                } else {
                  _tmpPersonOrgId = cursor.getString(_cursorIndexOfPersonOrgId);
                }
                _tmpCommentsPerson.setPersonOrgId(_tmpPersonOrgId);
                final long _tmpPersonGroupUid;
                _tmpPersonGroupUid = cursor.getLong(_cursorIndexOfPersonGroupUid);
                _tmpCommentsPerson.setPersonGroupUid(_tmpPersonGroupUid);
                final long _tmpPersonMasterChangeSeqNum;
                _tmpPersonMasterChangeSeqNum = cursor.getLong(_cursorIndexOfPersonMasterChangeSeqNum);
                _tmpCommentsPerson.setPersonMasterChangeSeqNum(_tmpPersonMasterChangeSeqNum);
                final long _tmpPersonLocalChangeSeqNum;
                _tmpPersonLocalChangeSeqNum = cursor.getLong(_cursorIndexOfPersonLocalChangeSeqNum);
                _tmpCommentsPerson.setPersonLocalChangeSeqNum(_tmpPersonLocalChangeSeqNum);
                final int _tmpPersonLastChangedBy;
                _tmpPersonLastChangedBy = cursor.getInt(_cursorIndexOfPersonLastChangedBy);
                _tmpCommentsPerson.setPersonLastChangedBy(_tmpPersonLastChangedBy);
                final long _tmpPersonLct;
                _tmpPersonLct = cursor.getLong(_cursorIndexOfPersonLct);
                _tmpCommentsPerson.setPersonLct(_tmpPersonLct);
                final String _tmpPersonCountry;
                if (cursor.isNull(_cursorIndexOfPersonCountry)) {
                  _tmpPersonCountry = null;
                } else {
                  _tmpPersonCountry = cursor.getString(_cursorIndexOfPersonCountry);
                }
                _tmpCommentsPerson.setPersonCountry(_tmpPersonCountry);
                final int _tmpPersonType;
                _tmpPersonType = cursor.getInt(_cursorIndexOfPersonType);
                _tmpCommentsPerson.setPersonType(_tmpPersonType);
              }  else  {
                _tmpCommentsPerson = null;
              }
              _item = new CommentsWithPerson();
              final long _tmpCommentsUid;
              _tmpCommentsUid = cursor.getLong(_cursorIndexOfCommentsUid);
              _item.setCommentsUid(_tmpCommentsUid);
              final String _tmpCommentsText;
              if (cursor.isNull(_cursorIndexOfCommentsText)) {
                _tmpCommentsText = null;
              } else {
                _tmpCommentsText = cursor.getString(_cursorIndexOfCommentsText);
              }
              _item.setCommentsText(_tmpCommentsText);
              final int _tmpCommentsEntityType;
              _tmpCommentsEntityType = cursor.getInt(_cursorIndexOfCommentsEntityType);
              _item.setCommentsEntityType(_tmpCommentsEntityType);
              final long _tmpCommentsEntityUid;
              _tmpCommentsEntityUid = cursor.getLong(_cursorIndexOfCommentsEntityUid);
              _item.setCommentsEntityUid(_tmpCommentsEntityUid);
              final boolean _tmpCommentsPublic;
              final int _tmp_2;
              _tmp_2 = cursor.getInt(_cursorIndexOfCommentsPublic);
              _tmpCommentsPublic = _tmp_2 != 0;
              _item.setCommentsPublic(_tmpCommentsPublic);
              final int _tmpCommentsStatus;
              _tmpCommentsStatus = cursor.getInt(_cursorIndexOfCommentsStatus);
              _item.setCommentsStatus(_tmpCommentsStatus);
              final long _tmpCommentsPersonUid;
              _tmpCommentsPersonUid = cursor.getLong(_cursorIndexOfCommentsPersonUid);
              _item.setCommentsPersonUid(_tmpCommentsPersonUid);
              final long _tmpCommentsToPersonUid;
              _tmpCommentsToPersonUid = cursor.getLong(_cursorIndexOfCommentsToPersonUid);
              _item.setCommentsToPersonUid(_tmpCommentsToPersonUid);
              final long _tmpCommentSubmitterUid;
              _tmpCommentSubmitterUid = cursor.getLong(_cursorIndexOfCommentSubmitterUid);
              _item.setCommentSubmitterUid(_tmpCommentSubmitterUid);
              final boolean _tmpCommentsFlagged;
              final int _tmp_3;
              _tmp_3 = cursor.getInt(_cursorIndexOfCommentsFlagged);
              _tmpCommentsFlagged = _tmp_3 != 0;
              _item.setCommentsFlagged(_tmpCommentsFlagged);
              final boolean _tmpCommentsInActive;
              final int _tmp_4;
              _tmp_4 = cursor.getInt(_cursorIndexOfCommentsInActive);
              _tmpCommentsInActive = _tmp_4 != 0;
              _item.setCommentsInActive(_tmpCommentsInActive);
              final long _tmpCommentsDateTimeAdded;
              _tmpCommentsDateTimeAdded = cursor.getLong(_cursorIndexOfCommentsDateTimeAdded);
              _item.setCommentsDateTimeAdded(_tmpCommentsDateTimeAdded);
              final long _tmpCommentsDateTimeUpdated;
              _tmpCommentsDateTimeUpdated = cursor.getLong(_cursorIndexOfCommentsDateTimeUpdated);
              _item.setCommentsDateTimeUpdated(_tmpCommentsDateTimeUpdated);
              final long _tmpCommentsMCSN;
              _tmpCommentsMCSN = cursor.getLong(_cursorIndexOfCommentsMCSN);
              _item.setCommentsMCSN(_tmpCommentsMCSN);
              final long _tmpCommentsLCSN;
              _tmpCommentsLCSN = cursor.getLong(_cursorIndexOfCommentsLCSN);
              _item.setCommentsLCSN(_tmpCommentsLCSN);
              final int _tmpCommentsLCB;
              _tmpCommentsLCB = cursor.getInt(_cursorIndexOfCommentsLCB);
              _item.setCommentsLCB(_tmpCommentsLCB);
              final long _tmpCommentsLct;
              _tmpCommentsLct = cursor.getLong(_cursorIndexOfCommentsLct);
              _item.setCommentsLct(_tmpCommentsLct);
              _item.setCommentsPerson(_tmpCommentsPerson);
              _res.add(_item);
            }
            return _res;
          }
        };
      }
    };
  }

  @Override
  public DataSource.Factory<Integer, CommentsWithPerson> findPrivateByEntityTypeAndUidAndForPersonLive2(
      final int entityType, final long entityUid, final long submitterUid) {
    final String _sql = "\n"
            + "            SELECT Comments.*, \n"
            + "                   Person.* \n"
            + "              FROM Comments\n"
            + "                   LEFT JOIN Person \n"
            + "                   ON Person.personUid = Comments.commentsPersonUid\n"
            + "             WHERE Comments.commentsEntityType = ? \n"
            + "               AND Comments.commentsEntityUid = ?\n"
            + "               AND Comments.commentSubmitterUid = ?  \n"
            + "               AND CAST(Comments.commentsFlagged AS INTEGER) = 0\n"
            + "               AND CAST(Comments.commentsInActive AS INTEGER) = 0\n"
            + "               AND CAST(Comments.commentsPublic AS INTEGER) = 0\n"
            + "          ORDER BY Comments.commentsDateTimeAdded DESC \n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 3);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, entityType);
    _argIndex = 2;
    _statement.bindLong(_argIndex, entityUid);
    _argIndex = 3;
    _statement.bindLong(_argIndex, submitterUid);
    return new DataSource.Factory<Integer, CommentsWithPerson>() {
      @Override
      public LimitOffsetDataSource<CommentsWithPerson> create() {
        return new LimitOffsetDataSource<CommentsWithPerson>(__db, _statement, false, true , "Comments", "Person") {
          @Override
          protected List<CommentsWithPerson> convertRows(Cursor cursor) {
            final int _cursorIndexOfCommentsUid = CursorUtil.getColumnIndexOrThrow(cursor, "commentsUid");
            final int _cursorIndexOfCommentsText = CursorUtil.getColumnIndexOrThrow(cursor, "commentsText");
            final int _cursorIndexOfCommentsEntityType = CursorUtil.getColumnIndexOrThrow(cursor, "commentsEntityType");
            final int _cursorIndexOfCommentsEntityUid = CursorUtil.getColumnIndexOrThrow(cursor, "commentsEntityUid");
            final int _cursorIndexOfCommentsPublic = CursorUtil.getColumnIndexOrThrow(cursor, "commentsPublic");
            final int _cursorIndexOfCommentsStatus = CursorUtil.getColumnIndexOrThrow(cursor, "commentsStatus");
            final int _cursorIndexOfCommentsPersonUid = CursorUtil.getColumnIndexOrThrow(cursor, "commentsPersonUid");
            final int _cursorIndexOfCommentsToPersonUid = CursorUtil.getColumnIndexOrThrow(cursor, "commentsToPersonUid");
            final int _cursorIndexOfCommentSubmitterUid = CursorUtil.getColumnIndexOrThrow(cursor, "commentSubmitterUid");
            final int _cursorIndexOfCommentsFlagged = CursorUtil.getColumnIndexOrThrow(cursor, "commentsFlagged");
            final int _cursorIndexOfCommentsInActive = CursorUtil.getColumnIndexOrThrow(cursor, "commentsInActive");
            final int _cursorIndexOfCommentsDateTimeAdded = CursorUtil.getColumnIndexOrThrow(cursor, "commentsDateTimeAdded");
            final int _cursorIndexOfCommentsDateTimeUpdated = CursorUtil.getColumnIndexOrThrow(cursor, "commentsDateTimeUpdated");
            final int _cursorIndexOfCommentsMCSN = CursorUtil.getColumnIndexOrThrow(cursor, "commentsMCSN");
            final int _cursorIndexOfCommentsLCSN = CursorUtil.getColumnIndexOrThrow(cursor, "commentsLCSN");
            final int _cursorIndexOfCommentsLCB = CursorUtil.getColumnIndexOrThrow(cursor, "commentsLCB");
            final int _cursorIndexOfCommentsLct = CursorUtil.getColumnIndexOrThrow(cursor, "commentsLct");
            final int _cursorIndexOfPersonUid = CursorUtil.getColumnIndexOrThrow(cursor, "personUid");
            final int _cursorIndexOfUsername = CursorUtil.getColumnIndexOrThrow(cursor, "username");
            final int _cursorIndexOfFirstNames = CursorUtil.getColumnIndexOrThrow(cursor, "firstNames");
            final int _cursorIndexOfLastName = CursorUtil.getColumnIndexOrThrow(cursor, "lastName");
            final int _cursorIndexOfEmailAddr = CursorUtil.getColumnIndexOrThrow(cursor, "emailAddr");
            final int _cursorIndexOfPhoneNum = CursorUtil.getColumnIndexOrThrow(cursor, "phoneNum");
            final int _cursorIndexOfGender = CursorUtil.getColumnIndexOrThrow(cursor, "gender");
            final int _cursorIndexOfActive = CursorUtil.getColumnIndexOrThrow(cursor, "active");
            final int _cursorIndexOfAdmin = CursorUtil.getColumnIndexOrThrow(cursor, "admin");
            final int _cursorIndexOfPersonNotes = CursorUtil.getColumnIndexOrThrow(cursor, "personNotes");
            final int _cursorIndexOfFatherName = CursorUtil.getColumnIndexOrThrow(cursor, "fatherName");
            final int _cursorIndexOfFatherNumber = CursorUtil.getColumnIndexOrThrow(cursor, "fatherNumber");
            final int _cursorIndexOfMotherName = CursorUtil.getColumnIndexOrThrow(cursor, "motherName");
            final int _cursorIndexOfMotherNum = CursorUtil.getColumnIndexOrThrow(cursor, "motherNum");
            final int _cursorIndexOfDateOfBirth = CursorUtil.getColumnIndexOrThrow(cursor, "dateOfBirth");
            final int _cursorIndexOfPersonAddress = CursorUtil.getColumnIndexOrThrow(cursor, "personAddress");
            final int _cursorIndexOfPersonOrgId = CursorUtil.getColumnIndexOrThrow(cursor, "personOrgId");
            final int _cursorIndexOfPersonGroupUid = CursorUtil.getColumnIndexOrThrow(cursor, "personGroupUid");
            final int _cursorIndexOfPersonMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(cursor, "personMasterChangeSeqNum");
            final int _cursorIndexOfPersonLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(cursor, "personLocalChangeSeqNum");
            final int _cursorIndexOfPersonLastChangedBy = CursorUtil.getColumnIndexOrThrow(cursor, "personLastChangedBy");
            final int _cursorIndexOfPersonLct = CursorUtil.getColumnIndexOrThrow(cursor, "personLct");
            final int _cursorIndexOfPersonCountry = CursorUtil.getColumnIndexOrThrow(cursor, "personCountry");
            final int _cursorIndexOfPersonType = CursorUtil.getColumnIndexOrThrow(cursor, "personType");
            final List<CommentsWithPerson> _res = new ArrayList<CommentsWithPerson>(cursor.getCount());
            while(cursor.moveToNext()) {
              final CommentsWithPerson _item;
              final Person _tmpCommentsPerson;
              if (! (cursor.isNull(_cursorIndexOfPersonUid) && cursor.isNull(_cursorIndexOfUsername) && cursor.isNull(_cursorIndexOfFirstNames) && cursor.isNull(_cursorIndexOfLastName) && cursor.isNull(_cursorIndexOfEmailAddr) && cursor.isNull(_cursorIndexOfPhoneNum) && cursor.isNull(_cursorIndexOfGender) && cursor.isNull(_cursorIndexOfActive) && cursor.isNull(_cursorIndexOfAdmin) && cursor.isNull(_cursorIndexOfPersonNotes) && cursor.isNull(_cursorIndexOfFatherName) && cursor.isNull(_cursorIndexOfFatherNumber) && cursor.isNull(_cursorIndexOfMotherName) && cursor.isNull(_cursorIndexOfMotherNum) && cursor.isNull(_cursorIndexOfDateOfBirth) && cursor.isNull(_cursorIndexOfPersonAddress) && cursor.isNull(_cursorIndexOfPersonOrgId) && cursor.isNull(_cursorIndexOfPersonGroupUid) && cursor.isNull(_cursorIndexOfPersonMasterChangeSeqNum) && cursor.isNull(_cursorIndexOfPersonLocalChangeSeqNum) && cursor.isNull(_cursorIndexOfPersonLastChangedBy) && cursor.isNull(_cursorIndexOfPersonLct) && cursor.isNull(_cursorIndexOfPersonCountry) && cursor.isNull(_cursorIndexOfPersonType))) {
                _tmpCommentsPerson = new Person();
                final long _tmpPersonUid;
                _tmpPersonUid = cursor.getLong(_cursorIndexOfPersonUid);
                _tmpCommentsPerson.setPersonUid(_tmpPersonUid);
                final String _tmpUsername;
                if (cursor.isNull(_cursorIndexOfUsername)) {
                  _tmpUsername = null;
                } else {
                  _tmpUsername = cursor.getString(_cursorIndexOfUsername);
                }
                _tmpCommentsPerson.setUsername(_tmpUsername);
                final String _tmpFirstNames;
                if (cursor.isNull(_cursorIndexOfFirstNames)) {
                  _tmpFirstNames = null;
                } else {
                  _tmpFirstNames = cursor.getString(_cursorIndexOfFirstNames);
                }
                _tmpCommentsPerson.setFirstNames(_tmpFirstNames);
                final String _tmpLastName;
                if (cursor.isNull(_cursorIndexOfLastName)) {
                  _tmpLastName = null;
                } else {
                  _tmpLastName = cursor.getString(_cursorIndexOfLastName);
                }
                _tmpCommentsPerson.setLastName(_tmpLastName);
                final String _tmpEmailAddr;
                if (cursor.isNull(_cursorIndexOfEmailAddr)) {
                  _tmpEmailAddr = null;
                } else {
                  _tmpEmailAddr = cursor.getString(_cursorIndexOfEmailAddr);
                }
                _tmpCommentsPerson.setEmailAddr(_tmpEmailAddr);
                final String _tmpPhoneNum;
                if (cursor.isNull(_cursorIndexOfPhoneNum)) {
                  _tmpPhoneNum = null;
                } else {
                  _tmpPhoneNum = cursor.getString(_cursorIndexOfPhoneNum);
                }
                _tmpCommentsPerson.setPhoneNum(_tmpPhoneNum);
                final int _tmpGender;
                _tmpGender = cursor.getInt(_cursorIndexOfGender);
                _tmpCommentsPerson.setGender(_tmpGender);
                final boolean _tmpActive;
                final int _tmp;
                _tmp = cursor.getInt(_cursorIndexOfActive);
                _tmpActive = _tmp != 0;
                _tmpCommentsPerson.setActive(_tmpActive);
                final boolean _tmpAdmin;
                final int _tmp_1;
                _tmp_1 = cursor.getInt(_cursorIndexOfAdmin);
                _tmpAdmin = _tmp_1 != 0;
                _tmpCommentsPerson.setAdmin(_tmpAdmin);
                final String _tmpPersonNotes;
                if (cursor.isNull(_cursorIndexOfPersonNotes)) {
                  _tmpPersonNotes = null;
                } else {
                  _tmpPersonNotes = cursor.getString(_cursorIndexOfPersonNotes);
                }
                _tmpCommentsPerson.setPersonNotes(_tmpPersonNotes);
                final String _tmpFatherName;
                if (cursor.isNull(_cursorIndexOfFatherName)) {
                  _tmpFatherName = null;
                } else {
                  _tmpFatherName = cursor.getString(_cursorIndexOfFatherName);
                }
                _tmpCommentsPerson.setFatherName(_tmpFatherName);
                final String _tmpFatherNumber;
                if (cursor.isNull(_cursorIndexOfFatherNumber)) {
                  _tmpFatherNumber = null;
                } else {
                  _tmpFatherNumber = cursor.getString(_cursorIndexOfFatherNumber);
                }
                _tmpCommentsPerson.setFatherNumber(_tmpFatherNumber);
                final String _tmpMotherName;
                if (cursor.isNull(_cursorIndexOfMotherName)) {
                  _tmpMotherName = null;
                } else {
                  _tmpMotherName = cursor.getString(_cursorIndexOfMotherName);
                }
                _tmpCommentsPerson.setMotherName(_tmpMotherName);
                final String _tmpMotherNum;
                if (cursor.isNull(_cursorIndexOfMotherNum)) {
                  _tmpMotherNum = null;
                } else {
                  _tmpMotherNum = cursor.getString(_cursorIndexOfMotherNum);
                }
                _tmpCommentsPerson.setMotherNum(_tmpMotherNum);
                final long _tmpDateOfBirth;
                _tmpDateOfBirth = cursor.getLong(_cursorIndexOfDateOfBirth);
                _tmpCommentsPerson.setDateOfBirth(_tmpDateOfBirth);
                final String _tmpPersonAddress;
                if (cursor.isNull(_cursorIndexOfPersonAddress)) {
                  _tmpPersonAddress = null;
                } else {
                  _tmpPersonAddress = cursor.getString(_cursorIndexOfPersonAddress);
                }
                _tmpCommentsPerson.setPersonAddress(_tmpPersonAddress);
                final String _tmpPersonOrgId;
                if (cursor.isNull(_cursorIndexOfPersonOrgId)) {
                  _tmpPersonOrgId = null;
                } else {
                  _tmpPersonOrgId = cursor.getString(_cursorIndexOfPersonOrgId);
                }
                _tmpCommentsPerson.setPersonOrgId(_tmpPersonOrgId);
                final long _tmpPersonGroupUid;
                _tmpPersonGroupUid = cursor.getLong(_cursorIndexOfPersonGroupUid);
                _tmpCommentsPerson.setPersonGroupUid(_tmpPersonGroupUid);
                final long _tmpPersonMasterChangeSeqNum;
                _tmpPersonMasterChangeSeqNum = cursor.getLong(_cursorIndexOfPersonMasterChangeSeqNum);
                _tmpCommentsPerson.setPersonMasterChangeSeqNum(_tmpPersonMasterChangeSeqNum);
                final long _tmpPersonLocalChangeSeqNum;
                _tmpPersonLocalChangeSeqNum = cursor.getLong(_cursorIndexOfPersonLocalChangeSeqNum);
                _tmpCommentsPerson.setPersonLocalChangeSeqNum(_tmpPersonLocalChangeSeqNum);
                final int _tmpPersonLastChangedBy;
                _tmpPersonLastChangedBy = cursor.getInt(_cursorIndexOfPersonLastChangedBy);
                _tmpCommentsPerson.setPersonLastChangedBy(_tmpPersonLastChangedBy);
                final long _tmpPersonLct;
                _tmpPersonLct = cursor.getLong(_cursorIndexOfPersonLct);
                _tmpCommentsPerson.setPersonLct(_tmpPersonLct);
                final String _tmpPersonCountry;
                if (cursor.isNull(_cursorIndexOfPersonCountry)) {
                  _tmpPersonCountry = null;
                } else {
                  _tmpPersonCountry = cursor.getString(_cursorIndexOfPersonCountry);
                }
                _tmpCommentsPerson.setPersonCountry(_tmpPersonCountry);
                final int _tmpPersonType;
                _tmpPersonType = cursor.getInt(_cursorIndexOfPersonType);
                _tmpCommentsPerson.setPersonType(_tmpPersonType);
              }  else  {
                _tmpCommentsPerson = null;
              }
              _item = new CommentsWithPerson();
              final long _tmpCommentsUid;
              _tmpCommentsUid = cursor.getLong(_cursorIndexOfCommentsUid);
              _item.setCommentsUid(_tmpCommentsUid);
              final String _tmpCommentsText;
              if (cursor.isNull(_cursorIndexOfCommentsText)) {
                _tmpCommentsText = null;
              } else {
                _tmpCommentsText = cursor.getString(_cursorIndexOfCommentsText);
              }
              _item.setCommentsText(_tmpCommentsText);
              final int _tmpCommentsEntityType;
              _tmpCommentsEntityType = cursor.getInt(_cursorIndexOfCommentsEntityType);
              _item.setCommentsEntityType(_tmpCommentsEntityType);
              final long _tmpCommentsEntityUid;
              _tmpCommentsEntityUid = cursor.getLong(_cursorIndexOfCommentsEntityUid);
              _item.setCommentsEntityUid(_tmpCommentsEntityUid);
              final boolean _tmpCommentsPublic;
              final int _tmp_2;
              _tmp_2 = cursor.getInt(_cursorIndexOfCommentsPublic);
              _tmpCommentsPublic = _tmp_2 != 0;
              _item.setCommentsPublic(_tmpCommentsPublic);
              final int _tmpCommentsStatus;
              _tmpCommentsStatus = cursor.getInt(_cursorIndexOfCommentsStatus);
              _item.setCommentsStatus(_tmpCommentsStatus);
              final long _tmpCommentsPersonUid;
              _tmpCommentsPersonUid = cursor.getLong(_cursorIndexOfCommentsPersonUid);
              _item.setCommentsPersonUid(_tmpCommentsPersonUid);
              final long _tmpCommentsToPersonUid;
              _tmpCommentsToPersonUid = cursor.getLong(_cursorIndexOfCommentsToPersonUid);
              _item.setCommentsToPersonUid(_tmpCommentsToPersonUid);
              final long _tmpCommentSubmitterUid;
              _tmpCommentSubmitterUid = cursor.getLong(_cursorIndexOfCommentSubmitterUid);
              _item.setCommentSubmitterUid(_tmpCommentSubmitterUid);
              final boolean _tmpCommentsFlagged;
              final int _tmp_3;
              _tmp_3 = cursor.getInt(_cursorIndexOfCommentsFlagged);
              _tmpCommentsFlagged = _tmp_3 != 0;
              _item.setCommentsFlagged(_tmpCommentsFlagged);
              final boolean _tmpCommentsInActive;
              final int _tmp_4;
              _tmp_4 = cursor.getInt(_cursorIndexOfCommentsInActive);
              _tmpCommentsInActive = _tmp_4 != 0;
              _item.setCommentsInActive(_tmpCommentsInActive);
              final long _tmpCommentsDateTimeAdded;
              _tmpCommentsDateTimeAdded = cursor.getLong(_cursorIndexOfCommentsDateTimeAdded);
              _item.setCommentsDateTimeAdded(_tmpCommentsDateTimeAdded);
              final long _tmpCommentsDateTimeUpdated;
              _tmpCommentsDateTimeUpdated = cursor.getLong(_cursorIndexOfCommentsDateTimeUpdated);
              _item.setCommentsDateTimeUpdated(_tmpCommentsDateTimeUpdated);
              final long _tmpCommentsMCSN;
              _tmpCommentsMCSN = cursor.getLong(_cursorIndexOfCommentsMCSN);
              _item.setCommentsMCSN(_tmpCommentsMCSN);
              final long _tmpCommentsLCSN;
              _tmpCommentsLCSN = cursor.getLong(_cursorIndexOfCommentsLCSN);
              _item.setCommentsLCSN(_tmpCommentsLCSN);
              final int _tmpCommentsLCB;
              _tmpCommentsLCB = cursor.getInt(_cursorIndexOfCommentsLCB);
              _item.setCommentsLCB(_tmpCommentsLCB);
              final long _tmpCommentsLct;
              _tmpCommentsLct = cursor.getLong(_cursorIndexOfCommentsLct);
              _item.setCommentsLct(_tmpCommentsLct);
              _item.setCommentsPerson(_tmpCommentsPerson);
              _res.add(_item);
            }
            return _res;
          }
        };
      }
    };
  }

  @Override
  public DataSource.Factory<Integer, CommentsWithPerson> findPrivateByEntityTypeAndUidAndPersonLive(
      final int entityType, final long entityUid, final long personUid) {
    final String _sql = "\n"
            + "        SELECT Comments.*, Person.* FROM Comments\n"
            + "        LEFT JOIN Person ON Person.personUid = Comments.commentsPersonUid \n"
            + "        WHERE Comments.commentsEntityType = ? \n"
            + "        AND Comments.commentsEntityUid = ?\n"
            + "        AND CAST(Comments.commentsFlagged AS INTEGER) = 0\n"
            + "        AND CAST(Comments.commentsInActive AS INTEGER) = 0\n"
            + "        AND CAST(Comments.commentsPublic AS INTEGER) = 0\n"
            + "        AND Person.personUid = ?\n"
            + "        ORDER BY Comments.commentsDateTimeAdded DESC \n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 3);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, entityType);
    _argIndex = 2;
    _statement.bindLong(_argIndex, entityUid);
    _argIndex = 3;
    _statement.bindLong(_argIndex, personUid);
    return new DataSource.Factory<Integer, CommentsWithPerson>() {
      @Override
      public LimitOffsetDataSource<CommentsWithPerson> create() {
        return new LimitOffsetDataSource<CommentsWithPerson>(__db, _statement, false, true , "Comments", "Person") {
          @Override
          protected List<CommentsWithPerson> convertRows(Cursor cursor) {
            final int _cursorIndexOfCommentsUid = CursorUtil.getColumnIndexOrThrow(cursor, "commentsUid");
            final int _cursorIndexOfCommentsText = CursorUtil.getColumnIndexOrThrow(cursor, "commentsText");
            final int _cursorIndexOfCommentsEntityType = CursorUtil.getColumnIndexOrThrow(cursor, "commentsEntityType");
            final int _cursorIndexOfCommentsEntityUid = CursorUtil.getColumnIndexOrThrow(cursor, "commentsEntityUid");
            final int _cursorIndexOfCommentsPublic = CursorUtil.getColumnIndexOrThrow(cursor, "commentsPublic");
            final int _cursorIndexOfCommentsStatus = CursorUtil.getColumnIndexOrThrow(cursor, "commentsStatus");
            final int _cursorIndexOfCommentsPersonUid = CursorUtil.getColumnIndexOrThrow(cursor, "commentsPersonUid");
            final int _cursorIndexOfCommentsToPersonUid = CursorUtil.getColumnIndexOrThrow(cursor, "commentsToPersonUid");
            final int _cursorIndexOfCommentSubmitterUid = CursorUtil.getColumnIndexOrThrow(cursor, "commentSubmitterUid");
            final int _cursorIndexOfCommentsFlagged = CursorUtil.getColumnIndexOrThrow(cursor, "commentsFlagged");
            final int _cursorIndexOfCommentsInActive = CursorUtil.getColumnIndexOrThrow(cursor, "commentsInActive");
            final int _cursorIndexOfCommentsDateTimeAdded = CursorUtil.getColumnIndexOrThrow(cursor, "commentsDateTimeAdded");
            final int _cursorIndexOfCommentsDateTimeUpdated = CursorUtil.getColumnIndexOrThrow(cursor, "commentsDateTimeUpdated");
            final int _cursorIndexOfCommentsMCSN = CursorUtil.getColumnIndexOrThrow(cursor, "commentsMCSN");
            final int _cursorIndexOfCommentsLCSN = CursorUtil.getColumnIndexOrThrow(cursor, "commentsLCSN");
            final int _cursorIndexOfCommentsLCB = CursorUtil.getColumnIndexOrThrow(cursor, "commentsLCB");
            final int _cursorIndexOfCommentsLct = CursorUtil.getColumnIndexOrThrow(cursor, "commentsLct");
            final int _cursorIndexOfPersonUid = CursorUtil.getColumnIndexOrThrow(cursor, "personUid");
            final int _cursorIndexOfUsername = CursorUtil.getColumnIndexOrThrow(cursor, "username");
            final int _cursorIndexOfFirstNames = CursorUtil.getColumnIndexOrThrow(cursor, "firstNames");
            final int _cursorIndexOfLastName = CursorUtil.getColumnIndexOrThrow(cursor, "lastName");
            final int _cursorIndexOfEmailAddr = CursorUtil.getColumnIndexOrThrow(cursor, "emailAddr");
            final int _cursorIndexOfPhoneNum = CursorUtil.getColumnIndexOrThrow(cursor, "phoneNum");
            final int _cursorIndexOfGender = CursorUtil.getColumnIndexOrThrow(cursor, "gender");
            final int _cursorIndexOfActive = CursorUtil.getColumnIndexOrThrow(cursor, "active");
            final int _cursorIndexOfAdmin = CursorUtil.getColumnIndexOrThrow(cursor, "admin");
            final int _cursorIndexOfPersonNotes = CursorUtil.getColumnIndexOrThrow(cursor, "personNotes");
            final int _cursorIndexOfFatherName = CursorUtil.getColumnIndexOrThrow(cursor, "fatherName");
            final int _cursorIndexOfFatherNumber = CursorUtil.getColumnIndexOrThrow(cursor, "fatherNumber");
            final int _cursorIndexOfMotherName = CursorUtil.getColumnIndexOrThrow(cursor, "motherName");
            final int _cursorIndexOfMotherNum = CursorUtil.getColumnIndexOrThrow(cursor, "motherNum");
            final int _cursorIndexOfDateOfBirth = CursorUtil.getColumnIndexOrThrow(cursor, "dateOfBirth");
            final int _cursorIndexOfPersonAddress = CursorUtil.getColumnIndexOrThrow(cursor, "personAddress");
            final int _cursorIndexOfPersonOrgId = CursorUtil.getColumnIndexOrThrow(cursor, "personOrgId");
            final int _cursorIndexOfPersonGroupUid = CursorUtil.getColumnIndexOrThrow(cursor, "personGroupUid");
            final int _cursorIndexOfPersonMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(cursor, "personMasterChangeSeqNum");
            final int _cursorIndexOfPersonLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(cursor, "personLocalChangeSeqNum");
            final int _cursorIndexOfPersonLastChangedBy = CursorUtil.getColumnIndexOrThrow(cursor, "personLastChangedBy");
            final int _cursorIndexOfPersonLct = CursorUtil.getColumnIndexOrThrow(cursor, "personLct");
            final int _cursorIndexOfPersonCountry = CursorUtil.getColumnIndexOrThrow(cursor, "personCountry");
            final int _cursorIndexOfPersonType = CursorUtil.getColumnIndexOrThrow(cursor, "personType");
            final List<CommentsWithPerson> _res = new ArrayList<CommentsWithPerson>(cursor.getCount());
            while(cursor.moveToNext()) {
              final CommentsWithPerson _item;
              final Person _tmpCommentsPerson;
              if (! (cursor.isNull(_cursorIndexOfPersonUid) && cursor.isNull(_cursorIndexOfUsername) && cursor.isNull(_cursorIndexOfFirstNames) && cursor.isNull(_cursorIndexOfLastName) && cursor.isNull(_cursorIndexOfEmailAddr) && cursor.isNull(_cursorIndexOfPhoneNum) && cursor.isNull(_cursorIndexOfGender) && cursor.isNull(_cursorIndexOfActive) && cursor.isNull(_cursorIndexOfAdmin) && cursor.isNull(_cursorIndexOfPersonNotes) && cursor.isNull(_cursorIndexOfFatherName) && cursor.isNull(_cursorIndexOfFatherNumber) && cursor.isNull(_cursorIndexOfMotherName) && cursor.isNull(_cursorIndexOfMotherNum) && cursor.isNull(_cursorIndexOfDateOfBirth) && cursor.isNull(_cursorIndexOfPersonAddress) && cursor.isNull(_cursorIndexOfPersonOrgId) && cursor.isNull(_cursorIndexOfPersonGroupUid) && cursor.isNull(_cursorIndexOfPersonMasterChangeSeqNum) && cursor.isNull(_cursorIndexOfPersonLocalChangeSeqNum) && cursor.isNull(_cursorIndexOfPersonLastChangedBy) && cursor.isNull(_cursorIndexOfPersonLct) && cursor.isNull(_cursorIndexOfPersonCountry) && cursor.isNull(_cursorIndexOfPersonType))) {
                _tmpCommentsPerson = new Person();
                final long _tmpPersonUid;
                _tmpPersonUid = cursor.getLong(_cursorIndexOfPersonUid);
                _tmpCommentsPerson.setPersonUid(_tmpPersonUid);
                final String _tmpUsername;
                if (cursor.isNull(_cursorIndexOfUsername)) {
                  _tmpUsername = null;
                } else {
                  _tmpUsername = cursor.getString(_cursorIndexOfUsername);
                }
                _tmpCommentsPerson.setUsername(_tmpUsername);
                final String _tmpFirstNames;
                if (cursor.isNull(_cursorIndexOfFirstNames)) {
                  _tmpFirstNames = null;
                } else {
                  _tmpFirstNames = cursor.getString(_cursorIndexOfFirstNames);
                }
                _tmpCommentsPerson.setFirstNames(_tmpFirstNames);
                final String _tmpLastName;
                if (cursor.isNull(_cursorIndexOfLastName)) {
                  _tmpLastName = null;
                } else {
                  _tmpLastName = cursor.getString(_cursorIndexOfLastName);
                }
                _tmpCommentsPerson.setLastName(_tmpLastName);
                final String _tmpEmailAddr;
                if (cursor.isNull(_cursorIndexOfEmailAddr)) {
                  _tmpEmailAddr = null;
                } else {
                  _tmpEmailAddr = cursor.getString(_cursorIndexOfEmailAddr);
                }
                _tmpCommentsPerson.setEmailAddr(_tmpEmailAddr);
                final String _tmpPhoneNum;
                if (cursor.isNull(_cursorIndexOfPhoneNum)) {
                  _tmpPhoneNum = null;
                } else {
                  _tmpPhoneNum = cursor.getString(_cursorIndexOfPhoneNum);
                }
                _tmpCommentsPerson.setPhoneNum(_tmpPhoneNum);
                final int _tmpGender;
                _tmpGender = cursor.getInt(_cursorIndexOfGender);
                _tmpCommentsPerson.setGender(_tmpGender);
                final boolean _tmpActive;
                final int _tmp;
                _tmp = cursor.getInt(_cursorIndexOfActive);
                _tmpActive = _tmp != 0;
                _tmpCommentsPerson.setActive(_tmpActive);
                final boolean _tmpAdmin;
                final int _tmp_1;
                _tmp_1 = cursor.getInt(_cursorIndexOfAdmin);
                _tmpAdmin = _tmp_1 != 0;
                _tmpCommentsPerson.setAdmin(_tmpAdmin);
                final String _tmpPersonNotes;
                if (cursor.isNull(_cursorIndexOfPersonNotes)) {
                  _tmpPersonNotes = null;
                } else {
                  _tmpPersonNotes = cursor.getString(_cursorIndexOfPersonNotes);
                }
                _tmpCommentsPerson.setPersonNotes(_tmpPersonNotes);
                final String _tmpFatherName;
                if (cursor.isNull(_cursorIndexOfFatherName)) {
                  _tmpFatherName = null;
                } else {
                  _tmpFatherName = cursor.getString(_cursorIndexOfFatherName);
                }
                _tmpCommentsPerson.setFatherName(_tmpFatherName);
                final String _tmpFatherNumber;
                if (cursor.isNull(_cursorIndexOfFatherNumber)) {
                  _tmpFatherNumber = null;
                } else {
                  _tmpFatherNumber = cursor.getString(_cursorIndexOfFatherNumber);
                }
                _tmpCommentsPerson.setFatherNumber(_tmpFatherNumber);
                final String _tmpMotherName;
                if (cursor.isNull(_cursorIndexOfMotherName)) {
                  _tmpMotherName = null;
                } else {
                  _tmpMotherName = cursor.getString(_cursorIndexOfMotherName);
                }
                _tmpCommentsPerson.setMotherName(_tmpMotherName);
                final String _tmpMotherNum;
                if (cursor.isNull(_cursorIndexOfMotherNum)) {
                  _tmpMotherNum = null;
                } else {
                  _tmpMotherNum = cursor.getString(_cursorIndexOfMotherNum);
                }
                _tmpCommentsPerson.setMotherNum(_tmpMotherNum);
                final long _tmpDateOfBirth;
                _tmpDateOfBirth = cursor.getLong(_cursorIndexOfDateOfBirth);
                _tmpCommentsPerson.setDateOfBirth(_tmpDateOfBirth);
                final String _tmpPersonAddress;
                if (cursor.isNull(_cursorIndexOfPersonAddress)) {
                  _tmpPersonAddress = null;
                } else {
                  _tmpPersonAddress = cursor.getString(_cursorIndexOfPersonAddress);
                }
                _tmpCommentsPerson.setPersonAddress(_tmpPersonAddress);
                final String _tmpPersonOrgId;
                if (cursor.isNull(_cursorIndexOfPersonOrgId)) {
                  _tmpPersonOrgId = null;
                } else {
                  _tmpPersonOrgId = cursor.getString(_cursorIndexOfPersonOrgId);
                }
                _tmpCommentsPerson.setPersonOrgId(_tmpPersonOrgId);
                final long _tmpPersonGroupUid;
                _tmpPersonGroupUid = cursor.getLong(_cursorIndexOfPersonGroupUid);
                _tmpCommentsPerson.setPersonGroupUid(_tmpPersonGroupUid);
                final long _tmpPersonMasterChangeSeqNum;
                _tmpPersonMasterChangeSeqNum = cursor.getLong(_cursorIndexOfPersonMasterChangeSeqNum);
                _tmpCommentsPerson.setPersonMasterChangeSeqNum(_tmpPersonMasterChangeSeqNum);
                final long _tmpPersonLocalChangeSeqNum;
                _tmpPersonLocalChangeSeqNum = cursor.getLong(_cursorIndexOfPersonLocalChangeSeqNum);
                _tmpCommentsPerson.setPersonLocalChangeSeqNum(_tmpPersonLocalChangeSeqNum);
                final int _tmpPersonLastChangedBy;
                _tmpPersonLastChangedBy = cursor.getInt(_cursorIndexOfPersonLastChangedBy);
                _tmpCommentsPerson.setPersonLastChangedBy(_tmpPersonLastChangedBy);
                final long _tmpPersonLct;
                _tmpPersonLct = cursor.getLong(_cursorIndexOfPersonLct);
                _tmpCommentsPerson.setPersonLct(_tmpPersonLct);
                final String _tmpPersonCountry;
                if (cursor.isNull(_cursorIndexOfPersonCountry)) {
                  _tmpPersonCountry = null;
                } else {
                  _tmpPersonCountry = cursor.getString(_cursorIndexOfPersonCountry);
                }
                _tmpCommentsPerson.setPersonCountry(_tmpPersonCountry);
                final int _tmpPersonType;
                _tmpPersonType = cursor.getInt(_cursorIndexOfPersonType);
                _tmpCommentsPerson.setPersonType(_tmpPersonType);
              }  else  {
                _tmpCommentsPerson = null;
              }
              _item = new CommentsWithPerson();
              final long _tmpCommentsUid;
              _tmpCommentsUid = cursor.getLong(_cursorIndexOfCommentsUid);
              _item.setCommentsUid(_tmpCommentsUid);
              final String _tmpCommentsText;
              if (cursor.isNull(_cursorIndexOfCommentsText)) {
                _tmpCommentsText = null;
              } else {
                _tmpCommentsText = cursor.getString(_cursorIndexOfCommentsText);
              }
              _item.setCommentsText(_tmpCommentsText);
              final int _tmpCommentsEntityType;
              _tmpCommentsEntityType = cursor.getInt(_cursorIndexOfCommentsEntityType);
              _item.setCommentsEntityType(_tmpCommentsEntityType);
              final long _tmpCommentsEntityUid;
              _tmpCommentsEntityUid = cursor.getLong(_cursorIndexOfCommentsEntityUid);
              _item.setCommentsEntityUid(_tmpCommentsEntityUid);
              final boolean _tmpCommentsPublic;
              final int _tmp_2;
              _tmp_2 = cursor.getInt(_cursorIndexOfCommentsPublic);
              _tmpCommentsPublic = _tmp_2 != 0;
              _item.setCommentsPublic(_tmpCommentsPublic);
              final int _tmpCommentsStatus;
              _tmpCommentsStatus = cursor.getInt(_cursorIndexOfCommentsStatus);
              _item.setCommentsStatus(_tmpCommentsStatus);
              final long _tmpCommentsPersonUid;
              _tmpCommentsPersonUid = cursor.getLong(_cursorIndexOfCommentsPersonUid);
              _item.setCommentsPersonUid(_tmpCommentsPersonUid);
              final long _tmpCommentsToPersonUid;
              _tmpCommentsToPersonUid = cursor.getLong(_cursorIndexOfCommentsToPersonUid);
              _item.setCommentsToPersonUid(_tmpCommentsToPersonUid);
              final long _tmpCommentSubmitterUid;
              _tmpCommentSubmitterUid = cursor.getLong(_cursorIndexOfCommentSubmitterUid);
              _item.setCommentSubmitterUid(_tmpCommentSubmitterUid);
              final boolean _tmpCommentsFlagged;
              final int _tmp_3;
              _tmp_3 = cursor.getInt(_cursorIndexOfCommentsFlagged);
              _tmpCommentsFlagged = _tmp_3 != 0;
              _item.setCommentsFlagged(_tmpCommentsFlagged);
              final boolean _tmpCommentsInActive;
              final int _tmp_4;
              _tmp_4 = cursor.getInt(_cursorIndexOfCommentsInActive);
              _tmpCommentsInActive = _tmp_4 != 0;
              _item.setCommentsInActive(_tmpCommentsInActive);
              final long _tmpCommentsDateTimeAdded;
              _tmpCommentsDateTimeAdded = cursor.getLong(_cursorIndexOfCommentsDateTimeAdded);
              _item.setCommentsDateTimeAdded(_tmpCommentsDateTimeAdded);
              final long _tmpCommentsDateTimeUpdated;
              _tmpCommentsDateTimeUpdated = cursor.getLong(_cursorIndexOfCommentsDateTimeUpdated);
              _item.setCommentsDateTimeUpdated(_tmpCommentsDateTimeUpdated);
              final long _tmpCommentsMCSN;
              _tmpCommentsMCSN = cursor.getLong(_cursorIndexOfCommentsMCSN);
              _item.setCommentsMCSN(_tmpCommentsMCSN);
              final long _tmpCommentsLCSN;
              _tmpCommentsLCSN = cursor.getLong(_cursorIndexOfCommentsLCSN);
              _item.setCommentsLCSN(_tmpCommentsLCSN);
              final int _tmpCommentsLCB;
              _tmpCommentsLCB = cursor.getInt(_cursorIndexOfCommentsLCB);
              _item.setCommentsLCB(_tmpCommentsLCB);
              final long _tmpCommentsLct;
              _tmpCommentsLct = cursor.getLong(_cursorIndexOfCommentsLct);
              _item.setCommentsLct(_tmpCommentsLct);
              _item.setCommentsPerson(_tmpCommentsPerson);
              _res.add(_item);
            }
            return _res;
          }
        };
      }
    };
  }

  @Override
  public DataSource.Factory<Integer, CommentsWithPerson> findPrivateCommentsByEntityTypeAndUidAndPersonAndPersonToLive(
      final int entityType, final long entityUid, final long personFrom) {
    final String _sql = "\n"
            + "        SELECT Comments.*, Person.* FROM Comments\n"
            + "        LEFT JOIN Person ON Person.personUid = Comments.commentsPersonUid \n"
            + "        WHERE Comments.commentsEntityType = ? \n"
            + "        AND Comments.commentsEntityUid = ?\n"
            + "        AND CAST(Comments.commentsFlagged AS INTEGER) = 0\n"
            + "        AND CAST(Comments.commentsInActive AS INTEGER) = 0\n"
            + "        AND CAST(Comments.commentsPublic AS INTEGER) = 0\n"
            + "        AND (Comments.commentsToPersonUid = ? \n"
            + "         OR Comments.commentsPersonUid = ?)\n"
            + "        ORDER BY Comments.commentsDateTimeAdded DESC \n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 4);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, entityType);
    _argIndex = 2;
    _statement.bindLong(_argIndex, entityUid);
    _argIndex = 3;
    _statement.bindLong(_argIndex, personFrom);
    _argIndex = 4;
    _statement.bindLong(_argIndex, personFrom);
    return new DataSource.Factory<Integer, CommentsWithPerson>() {
      @Override
      public LimitOffsetDataSource<CommentsWithPerson> create() {
        return new LimitOffsetDataSource<CommentsWithPerson>(__db, _statement, false, true , "Comments", "Person") {
          @Override
          protected List<CommentsWithPerson> convertRows(Cursor cursor) {
            final int _cursorIndexOfCommentsUid = CursorUtil.getColumnIndexOrThrow(cursor, "commentsUid");
            final int _cursorIndexOfCommentsText = CursorUtil.getColumnIndexOrThrow(cursor, "commentsText");
            final int _cursorIndexOfCommentsEntityType = CursorUtil.getColumnIndexOrThrow(cursor, "commentsEntityType");
            final int _cursorIndexOfCommentsEntityUid = CursorUtil.getColumnIndexOrThrow(cursor, "commentsEntityUid");
            final int _cursorIndexOfCommentsPublic = CursorUtil.getColumnIndexOrThrow(cursor, "commentsPublic");
            final int _cursorIndexOfCommentsStatus = CursorUtil.getColumnIndexOrThrow(cursor, "commentsStatus");
            final int _cursorIndexOfCommentsPersonUid = CursorUtil.getColumnIndexOrThrow(cursor, "commentsPersonUid");
            final int _cursorIndexOfCommentsToPersonUid = CursorUtil.getColumnIndexOrThrow(cursor, "commentsToPersonUid");
            final int _cursorIndexOfCommentSubmitterUid = CursorUtil.getColumnIndexOrThrow(cursor, "commentSubmitterUid");
            final int _cursorIndexOfCommentsFlagged = CursorUtil.getColumnIndexOrThrow(cursor, "commentsFlagged");
            final int _cursorIndexOfCommentsInActive = CursorUtil.getColumnIndexOrThrow(cursor, "commentsInActive");
            final int _cursorIndexOfCommentsDateTimeAdded = CursorUtil.getColumnIndexOrThrow(cursor, "commentsDateTimeAdded");
            final int _cursorIndexOfCommentsDateTimeUpdated = CursorUtil.getColumnIndexOrThrow(cursor, "commentsDateTimeUpdated");
            final int _cursorIndexOfCommentsMCSN = CursorUtil.getColumnIndexOrThrow(cursor, "commentsMCSN");
            final int _cursorIndexOfCommentsLCSN = CursorUtil.getColumnIndexOrThrow(cursor, "commentsLCSN");
            final int _cursorIndexOfCommentsLCB = CursorUtil.getColumnIndexOrThrow(cursor, "commentsLCB");
            final int _cursorIndexOfCommentsLct = CursorUtil.getColumnIndexOrThrow(cursor, "commentsLct");
            final int _cursorIndexOfPersonUid = CursorUtil.getColumnIndexOrThrow(cursor, "personUid");
            final int _cursorIndexOfUsername = CursorUtil.getColumnIndexOrThrow(cursor, "username");
            final int _cursorIndexOfFirstNames = CursorUtil.getColumnIndexOrThrow(cursor, "firstNames");
            final int _cursorIndexOfLastName = CursorUtil.getColumnIndexOrThrow(cursor, "lastName");
            final int _cursorIndexOfEmailAddr = CursorUtil.getColumnIndexOrThrow(cursor, "emailAddr");
            final int _cursorIndexOfPhoneNum = CursorUtil.getColumnIndexOrThrow(cursor, "phoneNum");
            final int _cursorIndexOfGender = CursorUtil.getColumnIndexOrThrow(cursor, "gender");
            final int _cursorIndexOfActive = CursorUtil.getColumnIndexOrThrow(cursor, "active");
            final int _cursorIndexOfAdmin = CursorUtil.getColumnIndexOrThrow(cursor, "admin");
            final int _cursorIndexOfPersonNotes = CursorUtil.getColumnIndexOrThrow(cursor, "personNotes");
            final int _cursorIndexOfFatherName = CursorUtil.getColumnIndexOrThrow(cursor, "fatherName");
            final int _cursorIndexOfFatherNumber = CursorUtil.getColumnIndexOrThrow(cursor, "fatherNumber");
            final int _cursorIndexOfMotherName = CursorUtil.getColumnIndexOrThrow(cursor, "motherName");
            final int _cursorIndexOfMotherNum = CursorUtil.getColumnIndexOrThrow(cursor, "motherNum");
            final int _cursorIndexOfDateOfBirth = CursorUtil.getColumnIndexOrThrow(cursor, "dateOfBirth");
            final int _cursorIndexOfPersonAddress = CursorUtil.getColumnIndexOrThrow(cursor, "personAddress");
            final int _cursorIndexOfPersonOrgId = CursorUtil.getColumnIndexOrThrow(cursor, "personOrgId");
            final int _cursorIndexOfPersonGroupUid = CursorUtil.getColumnIndexOrThrow(cursor, "personGroupUid");
            final int _cursorIndexOfPersonMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(cursor, "personMasterChangeSeqNum");
            final int _cursorIndexOfPersonLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(cursor, "personLocalChangeSeqNum");
            final int _cursorIndexOfPersonLastChangedBy = CursorUtil.getColumnIndexOrThrow(cursor, "personLastChangedBy");
            final int _cursorIndexOfPersonLct = CursorUtil.getColumnIndexOrThrow(cursor, "personLct");
            final int _cursorIndexOfPersonCountry = CursorUtil.getColumnIndexOrThrow(cursor, "personCountry");
            final int _cursorIndexOfPersonType = CursorUtil.getColumnIndexOrThrow(cursor, "personType");
            final List<CommentsWithPerson> _res = new ArrayList<CommentsWithPerson>(cursor.getCount());
            while(cursor.moveToNext()) {
              final CommentsWithPerson _item;
              final Person _tmpCommentsPerson;
              if (! (cursor.isNull(_cursorIndexOfPersonUid) && cursor.isNull(_cursorIndexOfUsername) && cursor.isNull(_cursorIndexOfFirstNames) && cursor.isNull(_cursorIndexOfLastName) && cursor.isNull(_cursorIndexOfEmailAddr) && cursor.isNull(_cursorIndexOfPhoneNum) && cursor.isNull(_cursorIndexOfGender) && cursor.isNull(_cursorIndexOfActive) && cursor.isNull(_cursorIndexOfAdmin) && cursor.isNull(_cursorIndexOfPersonNotes) && cursor.isNull(_cursorIndexOfFatherName) && cursor.isNull(_cursorIndexOfFatherNumber) && cursor.isNull(_cursorIndexOfMotherName) && cursor.isNull(_cursorIndexOfMotherNum) && cursor.isNull(_cursorIndexOfDateOfBirth) && cursor.isNull(_cursorIndexOfPersonAddress) && cursor.isNull(_cursorIndexOfPersonOrgId) && cursor.isNull(_cursorIndexOfPersonGroupUid) && cursor.isNull(_cursorIndexOfPersonMasterChangeSeqNum) && cursor.isNull(_cursorIndexOfPersonLocalChangeSeqNum) && cursor.isNull(_cursorIndexOfPersonLastChangedBy) && cursor.isNull(_cursorIndexOfPersonLct) && cursor.isNull(_cursorIndexOfPersonCountry) && cursor.isNull(_cursorIndexOfPersonType))) {
                _tmpCommentsPerson = new Person();
                final long _tmpPersonUid;
                _tmpPersonUid = cursor.getLong(_cursorIndexOfPersonUid);
                _tmpCommentsPerson.setPersonUid(_tmpPersonUid);
                final String _tmpUsername;
                if (cursor.isNull(_cursorIndexOfUsername)) {
                  _tmpUsername = null;
                } else {
                  _tmpUsername = cursor.getString(_cursorIndexOfUsername);
                }
                _tmpCommentsPerson.setUsername(_tmpUsername);
                final String _tmpFirstNames;
                if (cursor.isNull(_cursorIndexOfFirstNames)) {
                  _tmpFirstNames = null;
                } else {
                  _tmpFirstNames = cursor.getString(_cursorIndexOfFirstNames);
                }
                _tmpCommentsPerson.setFirstNames(_tmpFirstNames);
                final String _tmpLastName;
                if (cursor.isNull(_cursorIndexOfLastName)) {
                  _tmpLastName = null;
                } else {
                  _tmpLastName = cursor.getString(_cursorIndexOfLastName);
                }
                _tmpCommentsPerson.setLastName(_tmpLastName);
                final String _tmpEmailAddr;
                if (cursor.isNull(_cursorIndexOfEmailAddr)) {
                  _tmpEmailAddr = null;
                } else {
                  _tmpEmailAddr = cursor.getString(_cursorIndexOfEmailAddr);
                }
                _tmpCommentsPerson.setEmailAddr(_tmpEmailAddr);
                final String _tmpPhoneNum;
                if (cursor.isNull(_cursorIndexOfPhoneNum)) {
                  _tmpPhoneNum = null;
                } else {
                  _tmpPhoneNum = cursor.getString(_cursorIndexOfPhoneNum);
                }
                _tmpCommentsPerson.setPhoneNum(_tmpPhoneNum);
                final int _tmpGender;
                _tmpGender = cursor.getInt(_cursorIndexOfGender);
                _tmpCommentsPerson.setGender(_tmpGender);
                final boolean _tmpActive;
                final int _tmp;
                _tmp = cursor.getInt(_cursorIndexOfActive);
                _tmpActive = _tmp != 0;
                _tmpCommentsPerson.setActive(_tmpActive);
                final boolean _tmpAdmin;
                final int _tmp_1;
                _tmp_1 = cursor.getInt(_cursorIndexOfAdmin);
                _tmpAdmin = _tmp_1 != 0;
                _tmpCommentsPerson.setAdmin(_tmpAdmin);
                final String _tmpPersonNotes;
                if (cursor.isNull(_cursorIndexOfPersonNotes)) {
                  _tmpPersonNotes = null;
                } else {
                  _tmpPersonNotes = cursor.getString(_cursorIndexOfPersonNotes);
                }
                _tmpCommentsPerson.setPersonNotes(_tmpPersonNotes);
                final String _tmpFatherName;
                if (cursor.isNull(_cursorIndexOfFatherName)) {
                  _tmpFatherName = null;
                } else {
                  _tmpFatherName = cursor.getString(_cursorIndexOfFatherName);
                }
                _tmpCommentsPerson.setFatherName(_tmpFatherName);
                final String _tmpFatherNumber;
                if (cursor.isNull(_cursorIndexOfFatherNumber)) {
                  _tmpFatherNumber = null;
                } else {
                  _tmpFatherNumber = cursor.getString(_cursorIndexOfFatherNumber);
                }
                _tmpCommentsPerson.setFatherNumber(_tmpFatherNumber);
                final String _tmpMotherName;
                if (cursor.isNull(_cursorIndexOfMotherName)) {
                  _tmpMotherName = null;
                } else {
                  _tmpMotherName = cursor.getString(_cursorIndexOfMotherName);
                }
                _tmpCommentsPerson.setMotherName(_tmpMotherName);
                final String _tmpMotherNum;
                if (cursor.isNull(_cursorIndexOfMotherNum)) {
                  _tmpMotherNum = null;
                } else {
                  _tmpMotherNum = cursor.getString(_cursorIndexOfMotherNum);
                }
                _tmpCommentsPerson.setMotherNum(_tmpMotherNum);
                final long _tmpDateOfBirth;
                _tmpDateOfBirth = cursor.getLong(_cursorIndexOfDateOfBirth);
                _tmpCommentsPerson.setDateOfBirth(_tmpDateOfBirth);
                final String _tmpPersonAddress;
                if (cursor.isNull(_cursorIndexOfPersonAddress)) {
                  _tmpPersonAddress = null;
                } else {
                  _tmpPersonAddress = cursor.getString(_cursorIndexOfPersonAddress);
                }
                _tmpCommentsPerson.setPersonAddress(_tmpPersonAddress);
                final String _tmpPersonOrgId;
                if (cursor.isNull(_cursorIndexOfPersonOrgId)) {
                  _tmpPersonOrgId = null;
                } else {
                  _tmpPersonOrgId = cursor.getString(_cursorIndexOfPersonOrgId);
                }
                _tmpCommentsPerson.setPersonOrgId(_tmpPersonOrgId);
                final long _tmpPersonGroupUid;
                _tmpPersonGroupUid = cursor.getLong(_cursorIndexOfPersonGroupUid);
                _tmpCommentsPerson.setPersonGroupUid(_tmpPersonGroupUid);
                final long _tmpPersonMasterChangeSeqNum;
                _tmpPersonMasterChangeSeqNum = cursor.getLong(_cursorIndexOfPersonMasterChangeSeqNum);
                _tmpCommentsPerson.setPersonMasterChangeSeqNum(_tmpPersonMasterChangeSeqNum);
                final long _tmpPersonLocalChangeSeqNum;
                _tmpPersonLocalChangeSeqNum = cursor.getLong(_cursorIndexOfPersonLocalChangeSeqNum);
                _tmpCommentsPerson.setPersonLocalChangeSeqNum(_tmpPersonLocalChangeSeqNum);
                final int _tmpPersonLastChangedBy;
                _tmpPersonLastChangedBy = cursor.getInt(_cursorIndexOfPersonLastChangedBy);
                _tmpCommentsPerson.setPersonLastChangedBy(_tmpPersonLastChangedBy);
                final long _tmpPersonLct;
                _tmpPersonLct = cursor.getLong(_cursorIndexOfPersonLct);
                _tmpCommentsPerson.setPersonLct(_tmpPersonLct);
                final String _tmpPersonCountry;
                if (cursor.isNull(_cursorIndexOfPersonCountry)) {
                  _tmpPersonCountry = null;
                } else {
                  _tmpPersonCountry = cursor.getString(_cursorIndexOfPersonCountry);
                }
                _tmpCommentsPerson.setPersonCountry(_tmpPersonCountry);
                final int _tmpPersonType;
                _tmpPersonType = cursor.getInt(_cursorIndexOfPersonType);
                _tmpCommentsPerson.setPersonType(_tmpPersonType);
              }  else  {
                _tmpCommentsPerson = null;
              }
              _item = new CommentsWithPerson();
              final long _tmpCommentsUid;
              _tmpCommentsUid = cursor.getLong(_cursorIndexOfCommentsUid);
              _item.setCommentsUid(_tmpCommentsUid);
              final String _tmpCommentsText;
              if (cursor.isNull(_cursorIndexOfCommentsText)) {
                _tmpCommentsText = null;
              } else {
                _tmpCommentsText = cursor.getString(_cursorIndexOfCommentsText);
              }
              _item.setCommentsText(_tmpCommentsText);
              final int _tmpCommentsEntityType;
              _tmpCommentsEntityType = cursor.getInt(_cursorIndexOfCommentsEntityType);
              _item.setCommentsEntityType(_tmpCommentsEntityType);
              final long _tmpCommentsEntityUid;
              _tmpCommentsEntityUid = cursor.getLong(_cursorIndexOfCommentsEntityUid);
              _item.setCommentsEntityUid(_tmpCommentsEntityUid);
              final boolean _tmpCommentsPublic;
              final int _tmp_2;
              _tmp_2 = cursor.getInt(_cursorIndexOfCommentsPublic);
              _tmpCommentsPublic = _tmp_2 != 0;
              _item.setCommentsPublic(_tmpCommentsPublic);
              final int _tmpCommentsStatus;
              _tmpCommentsStatus = cursor.getInt(_cursorIndexOfCommentsStatus);
              _item.setCommentsStatus(_tmpCommentsStatus);
              final long _tmpCommentsPersonUid;
              _tmpCommentsPersonUid = cursor.getLong(_cursorIndexOfCommentsPersonUid);
              _item.setCommentsPersonUid(_tmpCommentsPersonUid);
              final long _tmpCommentsToPersonUid;
              _tmpCommentsToPersonUid = cursor.getLong(_cursorIndexOfCommentsToPersonUid);
              _item.setCommentsToPersonUid(_tmpCommentsToPersonUid);
              final long _tmpCommentSubmitterUid;
              _tmpCommentSubmitterUid = cursor.getLong(_cursorIndexOfCommentSubmitterUid);
              _item.setCommentSubmitterUid(_tmpCommentSubmitterUid);
              final boolean _tmpCommentsFlagged;
              final int _tmp_3;
              _tmp_3 = cursor.getInt(_cursorIndexOfCommentsFlagged);
              _tmpCommentsFlagged = _tmp_3 != 0;
              _item.setCommentsFlagged(_tmpCommentsFlagged);
              final boolean _tmpCommentsInActive;
              final int _tmp_4;
              _tmp_4 = cursor.getInt(_cursorIndexOfCommentsInActive);
              _tmpCommentsInActive = _tmp_4 != 0;
              _item.setCommentsInActive(_tmpCommentsInActive);
              final long _tmpCommentsDateTimeAdded;
              _tmpCommentsDateTimeAdded = cursor.getLong(_cursorIndexOfCommentsDateTimeAdded);
              _item.setCommentsDateTimeAdded(_tmpCommentsDateTimeAdded);
              final long _tmpCommentsDateTimeUpdated;
              _tmpCommentsDateTimeUpdated = cursor.getLong(_cursorIndexOfCommentsDateTimeUpdated);
              _item.setCommentsDateTimeUpdated(_tmpCommentsDateTimeUpdated);
              final long _tmpCommentsMCSN;
              _tmpCommentsMCSN = cursor.getLong(_cursorIndexOfCommentsMCSN);
              _item.setCommentsMCSN(_tmpCommentsMCSN);
              final long _tmpCommentsLCSN;
              _tmpCommentsLCSN = cursor.getLong(_cursorIndexOfCommentsLCSN);
              _item.setCommentsLCSN(_tmpCommentsLCSN);
              final int _tmpCommentsLCB;
              _tmpCommentsLCB = cursor.getInt(_cursorIndexOfCommentsLCB);
              _item.setCommentsLCB(_tmpCommentsLCB);
              final long _tmpCommentsLct;
              _tmpCommentsLct = cursor.getLong(_cursorIndexOfCommentsLct);
              _item.setCommentsLct(_tmpCommentsLct);
              _item.setCommentsPerson(_tmpCommentsPerson);
              _res.add(_item);
            }
            return _res;
          }
        };
      }
    };
  }

  @Override
  public List<CommentsWithPerson> findPrivateCommentsByEntityTypeAndUidAndPersonAndPersonToTest(
      final int entityType, final long entityUid, final long personFrom, final long personTo) {
    final String _sql = "\n"
            + "        SELECT Comments.*, Person.* FROM Comments\n"
            + "        LEFT JOIN Person ON Person.personUid = Comments.commentsPersonUid \n"
            + "        WHERE Comments.commentsEntityType = ? \n"
            + "        AND Comments.commentsEntityUid = ?\n"
            + "        AND CAST(Comments.commentsFlagged AS INTEGER) = 0\n"
            + "        AND CAST(Comments.commentsInActive AS INTEGER) = 0\n"
            + "        AND CAST(Comments.commentsPublic AS INTEGER) = 0\n"
            + "        AND Comments.commentsPersonUid = ? \n"
            + "        OR (? = 0 OR Comments.commentsToPersonUid = ?)\n"
            + "        ORDER BY Comments.commentsDateTimeAdded DESC \n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 5);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, entityType);
    _argIndex = 2;
    _statement.bindLong(_argIndex, entityUid);
    _argIndex = 3;
    _statement.bindLong(_argIndex, personFrom);
    _argIndex = 4;
    _statement.bindLong(_argIndex, personTo);
    _argIndex = 5;
    _statement.bindLong(_argIndex, personFrom);
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final int _cursorIndexOfCommentsUid = CursorUtil.getColumnIndexOrThrow(_cursor, "commentsUid");
      final int _cursorIndexOfCommentsText = CursorUtil.getColumnIndexOrThrow(_cursor, "commentsText");
      final int _cursorIndexOfCommentsEntityType = CursorUtil.getColumnIndexOrThrow(_cursor, "commentsEntityType");
      final int _cursorIndexOfCommentsEntityUid = CursorUtil.getColumnIndexOrThrow(_cursor, "commentsEntityUid");
      final int _cursorIndexOfCommentsPublic = CursorUtil.getColumnIndexOrThrow(_cursor, "commentsPublic");
      final int _cursorIndexOfCommentsStatus = CursorUtil.getColumnIndexOrThrow(_cursor, "commentsStatus");
      final int _cursorIndexOfCommentsPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "commentsPersonUid");
      final int _cursorIndexOfCommentsToPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "commentsToPersonUid");
      final int _cursorIndexOfCommentSubmitterUid = CursorUtil.getColumnIndexOrThrow(_cursor, "commentSubmitterUid");
      final int _cursorIndexOfCommentsFlagged = CursorUtil.getColumnIndexOrThrow(_cursor, "commentsFlagged");
      final int _cursorIndexOfCommentsInActive = CursorUtil.getColumnIndexOrThrow(_cursor, "commentsInActive");
      final int _cursorIndexOfCommentsDateTimeAdded = CursorUtil.getColumnIndexOrThrow(_cursor, "commentsDateTimeAdded");
      final int _cursorIndexOfCommentsDateTimeUpdated = CursorUtil.getColumnIndexOrThrow(_cursor, "commentsDateTimeUpdated");
      final int _cursorIndexOfCommentsMCSN = CursorUtil.getColumnIndexOrThrow(_cursor, "commentsMCSN");
      final int _cursorIndexOfCommentsLCSN = CursorUtil.getColumnIndexOrThrow(_cursor, "commentsLCSN");
      final int _cursorIndexOfCommentsLCB = CursorUtil.getColumnIndexOrThrow(_cursor, "commentsLCB");
      final int _cursorIndexOfCommentsLct = CursorUtil.getColumnIndexOrThrow(_cursor, "commentsLct");
      final int _cursorIndexOfPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "personUid");
      final int _cursorIndexOfUsername = CursorUtil.getColumnIndexOrThrow(_cursor, "username");
      final int _cursorIndexOfFirstNames = CursorUtil.getColumnIndexOrThrow(_cursor, "firstNames");
      final int _cursorIndexOfLastName = CursorUtil.getColumnIndexOrThrow(_cursor, "lastName");
      final int _cursorIndexOfEmailAddr = CursorUtil.getColumnIndexOrThrow(_cursor, "emailAddr");
      final int _cursorIndexOfPhoneNum = CursorUtil.getColumnIndexOrThrow(_cursor, "phoneNum");
      final int _cursorIndexOfGender = CursorUtil.getColumnIndexOrThrow(_cursor, "gender");
      final int _cursorIndexOfActive = CursorUtil.getColumnIndexOrThrow(_cursor, "active");
      final int _cursorIndexOfAdmin = CursorUtil.getColumnIndexOrThrow(_cursor, "admin");
      final int _cursorIndexOfPersonNotes = CursorUtil.getColumnIndexOrThrow(_cursor, "personNotes");
      final int _cursorIndexOfFatherName = CursorUtil.getColumnIndexOrThrow(_cursor, "fatherName");
      final int _cursorIndexOfFatherNumber = CursorUtil.getColumnIndexOrThrow(_cursor, "fatherNumber");
      final int _cursorIndexOfMotherName = CursorUtil.getColumnIndexOrThrow(_cursor, "motherName");
      final int _cursorIndexOfMotherNum = CursorUtil.getColumnIndexOrThrow(_cursor, "motherNum");
      final int _cursorIndexOfDateOfBirth = CursorUtil.getColumnIndexOrThrow(_cursor, "dateOfBirth");
      final int _cursorIndexOfPersonAddress = CursorUtil.getColumnIndexOrThrow(_cursor, "personAddress");
      final int _cursorIndexOfPersonOrgId = CursorUtil.getColumnIndexOrThrow(_cursor, "personOrgId");
      final int _cursorIndexOfPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "personGroupUid");
      final int _cursorIndexOfPersonMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "personMasterChangeSeqNum");
      final int _cursorIndexOfPersonLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "personLocalChangeSeqNum");
      final int _cursorIndexOfPersonLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "personLastChangedBy");
      final int _cursorIndexOfPersonLct = CursorUtil.getColumnIndexOrThrow(_cursor, "personLct");
      final int _cursorIndexOfPersonCountry = CursorUtil.getColumnIndexOrThrow(_cursor, "personCountry");
      final int _cursorIndexOfPersonType = CursorUtil.getColumnIndexOrThrow(_cursor, "personType");
      final List<CommentsWithPerson> _result = new ArrayList<CommentsWithPerson>(_cursor.getCount());
      while(_cursor.moveToNext()) {
        final CommentsWithPerson _item;
        final Person _tmpCommentsPerson;
        if (! (_cursor.isNull(_cursorIndexOfPersonUid) && _cursor.isNull(_cursorIndexOfUsername) && _cursor.isNull(_cursorIndexOfFirstNames) && _cursor.isNull(_cursorIndexOfLastName) && _cursor.isNull(_cursorIndexOfEmailAddr) && _cursor.isNull(_cursorIndexOfPhoneNum) && _cursor.isNull(_cursorIndexOfGender) && _cursor.isNull(_cursorIndexOfActive) && _cursor.isNull(_cursorIndexOfAdmin) && _cursor.isNull(_cursorIndexOfPersonNotes) && _cursor.isNull(_cursorIndexOfFatherName) && _cursor.isNull(_cursorIndexOfFatherNumber) && _cursor.isNull(_cursorIndexOfMotherName) && _cursor.isNull(_cursorIndexOfMotherNum) && _cursor.isNull(_cursorIndexOfDateOfBirth) && _cursor.isNull(_cursorIndexOfPersonAddress) && _cursor.isNull(_cursorIndexOfPersonOrgId) && _cursor.isNull(_cursorIndexOfPersonGroupUid) && _cursor.isNull(_cursorIndexOfPersonMasterChangeSeqNum) && _cursor.isNull(_cursorIndexOfPersonLocalChangeSeqNum) && _cursor.isNull(_cursorIndexOfPersonLastChangedBy) && _cursor.isNull(_cursorIndexOfPersonLct) && _cursor.isNull(_cursorIndexOfPersonCountry) && _cursor.isNull(_cursorIndexOfPersonType))) {
          _tmpCommentsPerson = new Person();
          final long _tmpPersonUid;
          _tmpPersonUid = _cursor.getLong(_cursorIndexOfPersonUid);
          _tmpCommentsPerson.setPersonUid(_tmpPersonUid);
          final String _tmpUsername;
          if (_cursor.isNull(_cursorIndexOfUsername)) {
            _tmpUsername = null;
          } else {
            _tmpUsername = _cursor.getString(_cursorIndexOfUsername);
          }
          _tmpCommentsPerson.setUsername(_tmpUsername);
          final String _tmpFirstNames;
          if (_cursor.isNull(_cursorIndexOfFirstNames)) {
            _tmpFirstNames = null;
          } else {
            _tmpFirstNames = _cursor.getString(_cursorIndexOfFirstNames);
          }
          _tmpCommentsPerson.setFirstNames(_tmpFirstNames);
          final String _tmpLastName;
          if (_cursor.isNull(_cursorIndexOfLastName)) {
            _tmpLastName = null;
          } else {
            _tmpLastName = _cursor.getString(_cursorIndexOfLastName);
          }
          _tmpCommentsPerson.setLastName(_tmpLastName);
          final String _tmpEmailAddr;
          if (_cursor.isNull(_cursorIndexOfEmailAddr)) {
            _tmpEmailAddr = null;
          } else {
            _tmpEmailAddr = _cursor.getString(_cursorIndexOfEmailAddr);
          }
          _tmpCommentsPerson.setEmailAddr(_tmpEmailAddr);
          final String _tmpPhoneNum;
          if (_cursor.isNull(_cursorIndexOfPhoneNum)) {
            _tmpPhoneNum = null;
          } else {
            _tmpPhoneNum = _cursor.getString(_cursorIndexOfPhoneNum);
          }
          _tmpCommentsPerson.setPhoneNum(_tmpPhoneNum);
          final int _tmpGender;
          _tmpGender = _cursor.getInt(_cursorIndexOfGender);
          _tmpCommentsPerson.setGender(_tmpGender);
          final boolean _tmpActive;
          final int _tmp;
          _tmp = _cursor.getInt(_cursorIndexOfActive);
          _tmpActive = _tmp != 0;
          _tmpCommentsPerson.setActive(_tmpActive);
          final boolean _tmpAdmin;
          final int _tmp_1;
          _tmp_1 = _cursor.getInt(_cursorIndexOfAdmin);
          _tmpAdmin = _tmp_1 != 0;
          _tmpCommentsPerson.setAdmin(_tmpAdmin);
          final String _tmpPersonNotes;
          if (_cursor.isNull(_cursorIndexOfPersonNotes)) {
            _tmpPersonNotes = null;
          } else {
            _tmpPersonNotes = _cursor.getString(_cursorIndexOfPersonNotes);
          }
          _tmpCommentsPerson.setPersonNotes(_tmpPersonNotes);
          final String _tmpFatherName;
          if (_cursor.isNull(_cursorIndexOfFatherName)) {
            _tmpFatherName = null;
          } else {
            _tmpFatherName = _cursor.getString(_cursorIndexOfFatherName);
          }
          _tmpCommentsPerson.setFatherName(_tmpFatherName);
          final String _tmpFatherNumber;
          if (_cursor.isNull(_cursorIndexOfFatherNumber)) {
            _tmpFatherNumber = null;
          } else {
            _tmpFatherNumber = _cursor.getString(_cursorIndexOfFatherNumber);
          }
          _tmpCommentsPerson.setFatherNumber(_tmpFatherNumber);
          final String _tmpMotherName;
          if (_cursor.isNull(_cursorIndexOfMotherName)) {
            _tmpMotherName = null;
          } else {
            _tmpMotherName = _cursor.getString(_cursorIndexOfMotherName);
          }
          _tmpCommentsPerson.setMotherName(_tmpMotherName);
          final String _tmpMotherNum;
          if (_cursor.isNull(_cursorIndexOfMotherNum)) {
            _tmpMotherNum = null;
          } else {
            _tmpMotherNum = _cursor.getString(_cursorIndexOfMotherNum);
          }
          _tmpCommentsPerson.setMotherNum(_tmpMotherNum);
          final long _tmpDateOfBirth;
          _tmpDateOfBirth = _cursor.getLong(_cursorIndexOfDateOfBirth);
          _tmpCommentsPerson.setDateOfBirth(_tmpDateOfBirth);
          final String _tmpPersonAddress;
          if (_cursor.isNull(_cursorIndexOfPersonAddress)) {
            _tmpPersonAddress = null;
          } else {
            _tmpPersonAddress = _cursor.getString(_cursorIndexOfPersonAddress);
          }
          _tmpCommentsPerson.setPersonAddress(_tmpPersonAddress);
          final String _tmpPersonOrgId;
          if (_cursor.isNull(_cursorIndexOfPersonOrgId)) {
            _tmpPersonOrgId = null;
          } else {
            _tmpPersonOrgId = _cursor.getString(_cursorIndexOfPersonOrgId);
          }
          _tmpCommentsPerson.setPersonOrgId(_tmpPersonOrgId);
          final long _tmpPersonGroupUid;
          _tmpPersonGroupUid = _cursor.getLong(_cursorIndexOfPersonGroupUid);
          _tmpCommentsPerson.setPersonGroupUid(_tmpPersonGroupUid);
          final long _tmpPersonMasterChangeSeqNum;
          _tmpPersonMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonMasterChangeSeqNum);
          _tmpCommentsPerson.setPersonMasterChangeSeqNum(_tmpPersonMasterChangeSeqNum);
          final long _tmpPersonLocalChangeSeqNum;
          _tmpPersonLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonLocalChangeSeqNum);
          _tmpCommentsPerson.setPersonLocalChangeSeqNum(_tmpPersonLocalChangeSeqNum);
          final int _tmpPersonLastChangedBy;
          _tmpPersonLastChangedBy = _cursor.getInt(_cursorIndexOfPersonLastChangedBy);
          _tmpCommentsPerson.setPersonLastChangedBy(_tmpPersonLastChangedBy);
          final long _tmpPersonLct;
          _tmpPersonLct = _cursor.getLong(_cursorIndexOfPersonLct);
          _tmpCommentsPerson.setPersonLct(_tmpPersonLct);
          final String _tmpPersonCountry;
          if (_cursor.isNull(_cursorIndexOfPersonCountry)) {
            _tmpPersonCountry = null;
          } else {
            _tmpPersonCountry = _cursor.getString(_cursorIndexOfPersonCountry);
          }
          _tmpCommentsPerson.setPersonCountry(_tmpPersonCountry);
          final int _tmpPersonType;
          _tmpPersonType = _cursor.getInt(_cursorIndexOfPersonType);
          _tmpCommentsPerson.setPersonType(_tmpPersonType);
        }  else  {
          _tmpCommentsPerson = null;
        }
        _item = new CommentsWithPerson();
        final long _tmpCommentsUid;
        _tmpCommentsUid = _cursor.getLong(_cursorIndexOfCommentsUid);
        _item.setCommentsUid(_tmpCommentsUid);
        final String _tmpCommentsText;
        if (_cursor.isNull(_cursorIndexOfCommentsText)) {
          _tmpCommentsText = null;
        } else {
          _tmpCommentsText = _cursor.getString(_cursorIndexOfCommentsText);
        }
        _item.setCommentsText(_tmpCommentsText);
        final int _tmpCommentsEntityType;
        _tmpCommentsEntityType = _cursor.getInt(_cursorIndexOfCommentsEntityType);
        _item.setCommentsEntityType(_tmpCommentsEntityType);
        final long _tmpCommentsEntityUid;
        _tmpCommentsEntityUid = _cursor.getLong(_cursorIndexOfCommentsEntityUid);
        _item.setCommentsEntityUid(_tmpCommentsEntityUid);
        final boolean _tmpCommentsPublic;
        final int _tmp_2;
        _tmp_2 = _cursor.getInt(_cursorIndexOfCommentsPublic);
        _tmpCommentsPublic = _tmp_2 != 0;
        _item.setCommentsPublic(_tmpCommentsPublic);
        final int _tmpCommentsStatus;
        _tmpCommentsStatus = _cursor.getInt(_cursorIndexOfCommentsStatus);
        _item.setCommentsStatus(_tmpCommentsStatus);
        final long _tmpCommentsPersonUid;
        _tmpCommentsPersonUid = _cursor.getLong(_cursorIndexOfCommentsPersonUid);
        _item.setCommentsPersonUid(_tmpCommentsPersonUid);
        final long _tmpCommentsToPersonUid;
        _tmpCommentsToPersonUid = _cursor.getLong(_cursorIndexOfCommentsToPersonUid);
        _item.setCommentsToPersonUid(_tmpCommentsToPersonUid);
        final long _tmpCommentSubmitterUid;
        _tmpCommentSubmitterUid = _cursor.getLong(_cursorIndexOfCommentSubmitterUid);
        _item.setCommentSubmitterUid(_tmpCommentSubmitterUid);
        final boolean _tmpCommentsFlagged;
        final int _tmp_3;
        _tmp_3 = _cursor.getInt(_cursorIndexOfCommentsFlagged);
        _tmpCommentsFlagged = _tmp_3 != 0;
        _item.setCommentsFlagged(_tmpCommentsFlagged);
        final boolean _tmpCommentsInActive;
        final int _tmp_4;
        _tmp_4 = _cursor.getInt(_cursorIndexOfCommentsInActive);
        _tmpCommentsInActive = _tmp_4 != 0;
        _item.setCommentsInActive(_tmpCommentsInActive);
        final long _tmpCommentsDateTimeAdded;
        _tmpCommentsDateTimeAdded = _cursor.getLong(_cursorIndexOfCommentsDateTimeAdded);
        _item.setCommentsDateTimeAdded(_tmpCommentsDateTimeAdded);
        final long _tmpCommentsDateTimeUpdated;
        _tmpCommentsDateTimeUpdated = _cursor.getLong(_cursorIndexOfCommentsDateTimeUpdated);
        _item.setCommentsDateTimeUpdated(_tmpCommentsDateTimeUpdated);
        final long _tmpCommentsMCSN;
        _tmpCommentsMCSN = _cursor.getLong(_cursorIndexOfCommentsMCSN);
        _item.setCommentsMCSN(_tmpCommentsMCSN);
        final long _tmpCommentsLCSN;
        _tmpCommentsLCSN = _cursor.getLong(_cursorIndexOfCommentsLCSN);
        _item.setCommentsLCSN(_tmpCommentsLCSN);
        final int _tmpCommentsLCB;
        _tmpCommentsLCB = _cursor.getInt(_cursorIndexOfCommentsLCB);
        _item.setCommentsLCB(_tmpCommentsLCB);
        final long _tmpCommentsLct;
        _tmpCommentsLct = _cursor.getLong(_cursorIndexOfCommentsLct);
        _item.setCommentsLct(_tmpCommentsLct);
        _item.setCommentsPerson(_tmpCommentsPerson);
        _result.add(_item);
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
