package com.ustadmobile.core.db.dao;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.lifecycle.LiveData;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.lib.db.entities.ContainerImportJob;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;

@SuppressWarnings({"unchecked", "deprecation"})
public final class ContainerImportJobDao_Impl extends ContainerImportJobDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<ContainerImportJob> __insertionAdapterOfContainerImportJob;

  private final EntityDeletionOrUpdateAdapter<ContainerImportJob> __updateAdapterOfContainerImportJob;

  private final SharedSQLiteStatement __preparedStmtOfSetStatusToQueueAsync;

  private final SharedSQLiteStatement __preparedStmtOfUpdateProgress;

  private final SharedSQLiteStatement __preparedStmtOfUpdateStatus;

  private final SharedSQLiteStatement __preparedStmtOfUpdateImportComplete;

  private final SharedSQLiteStatement __preparedStmtOfUpdateSessionId;

  public ContainerImportJobDao_Impl(RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfContainerImportJob = new EntityInsertionAdapter<ContainerImportJob>(__db) {
      @Override
      public String createQuery() {
        return "INSERT OR ABORT INTO `ContainerImportJob` (`cijUid`,`cijContainerUid`,`cijUri`,`cijImportMode`,`cijContainerBaseDir`,`cijContentEntryUid`,`cijMimeType`,`cijSessionId`,`cijJobStatus`,`cijBytesSoFar`,`cijImportCompleted`,`cijContentLength`,`cijContainerEntryFileUids`,`cijConversionParams`) VALUES (nullif(?, 0),?,?,?,?,?,?,?,?,?,?,?,?,?)";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, ContainerImportJob value) {
        stmt.bindLong(1, value.getCijUid());
        stmt.bindLong(2, value.getCijContainerUid());
        if (value.getCijUri() == null) {
          stmt.bindNull(3);
        } else {
          stmt.bindString(3, value.getCijUri());
        }
        stmt.bindLong(4, value.getCijImportMode());
        if (value.getCijContainerBaseDir() == null) {
          stmt.bindNull(5);
        } else {
          stmt.bindString(5, value.getCijContainerBaseDir());
        }
        stmt.bindLong(6, value.getCijContentEntryUid());
        if (value.getCijMimeType() == null) {
          stmt.bindNull(7);
        } else {
          stmt.bindString(7, value.getCijMimeType());
        }
        if (value.getCijSessionId() == null) {
          stmt.bindNull(8);
        } else {
          stmt.bindString(8, value.getCijSessionId());
        }
        stmt.bindLong(9, value.getCijJobStatus());
        stmt.bindLong(10, value.getCijBytesSoFar());
        final int _tmp = value.getCijImportCompleted() ? 1 : 0;
        stmt.bindLong(11, _tmp);
        stmt.bindLong(12, value.getCijContentLength());
        if (value.getCijContainerEntryFileUids() == null) {
          stmt.bindNull(13);
        } else {
          stmt.bindString(13, value.getCijContainerEntryFileUids());
        }
        if (value.getCijConversionParams() == null) {
          stmt.bindNull(14);
        } else {
          stmt.bindString(14, value.getCijConversionParams());
        }
      }
    };
    this.__updateAdapterOfContainerImportJob = new EntityDeletionOrUpdateAdapter<ContainerImportJob>(__db) {
      @Override
      public String createQuery() {
        return "UPDATE OR ABORT `ContainerImportJob` SET `cijUid` = ?,`cijContainerUid` = ?,`cijUri` = ?,`cijImportMode` = ?,`cijContainerBaseDir` = ?,`cijContentEntryUid` = ?,`cijMimeType` = ?,`cijSessionId` = ?,`cijJobStatus` = ?,`cijBytesSoFar` = ?,`cijImportCompleted` = ?,`cijContentLength` = ?,`cijContainerEntryFileUids` = ?,`cijConversionParams` = ? WHERE `cijUid` = ?";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, ContainerImportJob value) {
        stmt.bindLong(1, value.getCijUid());
        stmt.bindLong(2, value.getCijContainerUid());
        if (value.getCijUri() == null) {
          stmt.bindNull(3);
        } else {
          stmt.bindString(3, value.getCijUri());
        }
        stmt.bindLong(4, value.getCijImportMode());
        if (value.getCijContainerBaseDir() == null) {
          stmt.bindNull(5);
        } else {
          stmt.bindString(5, value.getCijContainerBaseDir());
        }
        stmt.bindLong(6, value.getCijContentEntryUid());
        if (value.getCijMimeType() == null) {
          stmt.bindNull(7);
        } else {
          stmt.bindString(7, value.getCijMimeType());
        }
        if (value.getCijSessionId() == null) {
          stmt.bindNull(8);
        } else {
          stmt.bindString(8, value.getCijSessionId());
        }
        stmt.bindLong(9, value.getCijJobStatus());
        stmt.bindLong(10, value.getCijBytesSoFar());
        final int _tmp = value.getCijImportCompleted() ? 1 : 0;
        stmt.bindLong(11, _tmp);
        stmt.bindLong(12, value.getCijContentLength());
        if (value.getCijContainerEntryFileUids() == null) {
          stmt.bindNull(13);
        } else {
          stmt.bindString(13, value.getCijContainerEntryFileUids());
        }
        if (value.getCijConversionParams() == null) {
          stmt.bindNull(14);
        } else {
          stmt.bindString(14, value.getCijConversionParams());
        }
        stmt.bindLong(15, value.getCijUid());
      }
    };
    this.__preparedStmtOfSetStatusToQueueAsync = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "UPDATE ContainerImportJob SET cijJobStatus = 4 WHERE cijUid = ? AND cijJobStatus = 0";
        return _query;
      }
    };
    this.__preparedStmtOfUpdateProgress = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "UPDATE ContainerImportJob SET cijBytesSoFar = ?, cijContentLength = ? WHERE cijUid = ?";
        return _query;
      }
    };
    this.__preparedStmtOfUpdateStatus = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "UPDATE ContainerImportJob SET cijJobStatus = ? WHERE cijUid = ?";
        return _query;
      }
    };
    this.__preparedStmtOfUpdateImportComplete = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "UPDATE ContainerImportJob \n"
                + "                       SET cijImportCompleted = ?,\n"
                + "                           cijContainerUid = ?\n"
                + "                     WHERE cijUid = ?";
        return _query;
      }
    };
    this.__preparedStmtOfUpdateSessionId = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "UPDATE ContainerImportJob SET cijSessionId = ? WHERE cijUid = ?";
        return _query;
      }
    };
  }

  @Override
  public long insert(final ContainerImportJob entity) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      long _result = __insertionAdapterOfContainerImportJob.insertAndReturnId(entity);
      __db.setTransactionSuccessful();
      return _result;
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object insertAsync(final ContainerImportJob entity,
      final Continuation<? super Long> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Long>() {
      @Override
      public Long call() throws Exception {
        __db.beginTransaction();
        try {
          long _result = __insertionAdapterOfContainerImportJob.insertAndReturnId(entity);
          __db.setTransactionSuccessful();
          return _result;
        } finally {
          __db.endTransaction();
        }
      }
    }, continuation);
  }

  @Override
  public void insertList(final List<? extends ContainerImportJob> entityList) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __insertionAdapterOfContainerImportJob.insert(entityList);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public void updateList(final List<? extends ContainerImportJob> entityList) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __updateAdapterOfContainerImportJob.handleMultiple(entityList);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public void update(final ContainerImportJob entity) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __updateAdapterOfContainerImportJob.handle(entity);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object setStatusToQueueAsync(final long uploadJobId,
      final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfSetStatusToQueueAsync.acquire();
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, uploadJobId);
        __db.beginTransaction();
        try {
          _stmt.executeUpdateDelete();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfSetStatusToQueueAsync.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public void updateProgress(final long progress, final long contentLength,
      final long uploadJobId) {
    __db.assertNotSuspendingTransaction();
    final SupportSQLiteStatement _stmt = __preparedStmtOfUpdateProgress.acquire();
    int _argIndex = 1;
    _stmt.bindLong(_argIndex, progress);
    _argIndex = 2;
    _stmt.bindLong(_argIndex, contentLength);
    _argIndex = 3;
    _stmt.bindLong(_argIndex, uploadJobId);
    __db.beginTransaction();
    try {
      _stmt.executeUpdateDelete();
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
      __preparedStmtOfUpdateProgress.release(_stmt);
    }
  }

  @Override
  public void updateStatus(final int status, final long uploadJobId) {
    __db.assertNotSuspendingTransaction();
    final SupportSQLiteStatement _stmt = __preparedStmtOfUpdateStatus.acquire();
    int _argIndex = 1;
    _stmt.bindLong(_argIndex, status);
    _argIndex = 2;
    _stmt.bindLong(_argIndex, uploadJobId);
    __db.beginTransaction();
    try {
      _stmt.executeUpdateDelete();
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
      __preparedStmtOfUpdateStatus.release(_stmt);
    }
  }

  @Override
  public void updateImportComplete(final boolean importCompleted, final long containerUid,
      final long importJobUid) {
    __db.assertNotSuspendingTransaction();
    final SupportSQLiteStatement _stmt = __preparedStmtOfUpdateImportComplete.acquire();
    int _argIndex = 1;
    final int _tmp = importCompleted ? 1 : 0;
    _stmt.bindLong(_argIndex, _tmp);
    _argIndex = 2;
    _stmt.bindLong(_argIndex, containerUid);
    _argIndex = 3;
    _stmt.bindLong(_argIndex, importJobUid);
    __db.beginTransaction();
    try {
      _stmt.executeUpdateDelete();
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
      __preparedStmtOfUpdateImportComplete.release(_stmt);
    }
  }

  @Override
  public Object updateSessionId(final long importJobUid, final String sessionId,
      final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfUpdateSessionId.acquire();
        int _argIndex = 1;
        if (sessionId == null) {
          _stmt.bindNull(_argIndex);
        } else {
          _stmt.bindString(_argIndex, sessionId);
        }
        _argIndex = 2;
        _stmt.bindLong(_argIndex, importJobUid);
        __db.beginTransaction();
        try {
          _stmt.executeUpdateDelete();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfUpdateSessionId.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public ContainerImportJob findBySessionId(final String sessionId) {
    final String _sql = "SELECT * FROM ContainerImportJob WHERE cijSessionId = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    if (sessionId == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, sessionId);
    }
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final int _cursorIndexOfCijUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cijUid");
      final int _cursorIndexOfCijContainerUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cijContainerUid");
      final int _cursorIndexOfCijUri = CursorUtil.getColumnIndexOrThrow(_cursor, "cijUri");
      final int _cursorIndexOfCijImportMode = CursorUtil.getColumnIndexOrThrow(_cursor, "cijImportMode");
      final int _cursorIndexOfCijContainerBaseDir = CursorUtil.getColumnIndexOrThrow(_cursor, "cijContainerBaseDir");
      final int _cursorIndexOfCijContentEntryUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cijContentEntryUid");
      final int _cursorIndexOfCijMimeType = CursorUtil.getColumnIndexOrThrow(_cursor, "cijMimeType");
      final int _cursorIndexOfCijSessionId = CursorUtil.getColumnIndexOrThrow(_cursor, "cijSessionId");
      final int _cursorIndexOfCijJobStatus = CursorUtil.getColumnIndexOrThrow(_cursor, "cijJobStatus");
      final int _cursorIndexOfCijBytesSoFar = CursorUtil.getColumnIndexOrThrow(_cursor, "cijBytesSoFar");
      final int _cursorIndexOfCijImportCompleted = CursorUtil.getColumnIndexOrThrow(_cursor, "cijImportCompleted");
      final int _cursorIndexOfCijContentLength = CursorUtil.getColumnIndexOrThrow(_cursor, "cijContentLength");
      final int _cursorIndexOfCijContainerEntryFileUids = CursorUtil.getColumnIndexOrThrow(_cursor, "cijContainerEntryFileUids");
      final int _cursorIndexOfCijConversionParams = CursorUtil.getColumnIndexOrThrow(_cursor, "cijConversionParams");
      final ContainerImportJob _result;
      if(_cursor.moveToFirst()) {
        _result = new ContainerImportJob();
        final long _tmpCijUid;
        _tmpCijUid = _cursor.getLong(_cursorIndexOfCijUid);
        _result.setCijUid(_tmpCijUid);
        final long _tmpCijContainerUid;
        _tmpCijContainerUid = _cursor.getLong(_cursorIndexOfCijContainerUid);
        _result.setCijContainerUid(_tmpCijContainerUid);
        final String _tmpCijUri;
        if (_cursor.isNull(_cursorIndexOfCijUri)) {
          _tmpCijUri = null;
        } else {
          _tmpCijUri = _cursor.getString(_cursorIndexOfCijUri);
        }
        _result.setCijUri(_tmpCijUri);
        final int _tmpCijImportMode;
        _tmpCijImportMode = _cursor.getInt(_cursorIndexOfCijImportMode);
        _result.setCijImportMode(_tmpCijImportMode);
        final String _tmpCijContainerBaseDir;
        if (_cursor.isNull(_cursorIndexOfCijContainerBaseDir)) {
          _tmpCijContainerBaseDir = null;
        } else {
          _tmpCijContainerBaseDir = _cursor.getString(_cursorIndexOfCijContainerBaseDir);
        }
        _result.setCijContainerBaseDir(_tmpCijContainerBaseDir);
        final long _tmpCijContentEntryUid;
        _tmpCijContentEntryUid = _cursor.getLong(_cursorIndexOfCijContentEntryUid);
        _result.setCijContentEntryUid(_tmpCijContentEntryUid);
        final String _tmpCijMimeType;
        if (_cursor.isNull(_cursorIndexOfCijMimeType)) {
          _tmpCijMimeType = null;
        } else {
          _tmpCijMimeType = _cursor.getString(_cursorIndexOfCijMimeType);
        }
        _result.setCijMimeType(_tmpCijMimeType);
        final String _tmpCijSessionId;
        if (_cursor.isNull(_cursorIndexOfCijSessionId)) {
          _tmpCijSessionId = null;
        } else {
          _tmpCijSessionId = _cursor.getString(_cursorIndexOfCijSessionId);
        }
        _result.setCijSessionId(_tmpCijSessionId);
        final int _tmpCijJobStatus;
        _tmpCijJobStatus = _cursor.getInt(_cursorIndexOfCijJobStatus);
        _result.setCijJobStatus(_tmpCijJobStatus);
        final long _tmpCijBytesSoFar;
        _tmpCijBytesSoFar = _cursor.getLong(_cursorIndexOfCijBytesSoFar);
        _result.setCijBytesSoFar(_tmpCijBytesSoFar);
        final boolean _tmpCijImportCompleted;
        final int _tmp;
        _tmp = _cursor.getInt(_cursorIndexOfCijImportCompleted);
        _tmpCijImportCompleted = _tmp != 0;
        _result.setCijImportCompleted(_tmpCijImportCompleted);
        final long _tmpCijContentLength;
        _tmpCijContentLength = _cursor.getLong(_cursorIndexOfCijContentLength);
        _result.setCijContentLength(_tmpCijContentLength);
        final String _tmpCijContainerEntryFileUids;
        if (_cursor.isNull(_cursorIndexOfCijContainerEntryFileUids)) {
          _tmpCijContainerEntryFileUids = null;
        } else {
          _tmpCijContainerEntryFileUids = _cursor.getString(_cursorIndexOfCijContainerEntryFileUids);
        }
        _result.setCijContainerEntryFileUids(_tmpCijContainerEntryFileUids);
        final String _tmpCijConversionParams;
        if (_cursor.isNull(_cursorIndexOfCijConversionParams)) {
          _tmpCijConversionParams = null;
        } else {
          _tmpCijConversionParams = _cursor.getString(_cursorIndexOfCijConversionParams);
        }
        _result.setCijConversionParams(_tmpCijConversionParams);
      } else {
        _result = null;
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  @Override
  public ContainerImportJob findByUid(final long uploadId) {
    final String _sql = "SELECT * FROM ContainerImportJob where cijUid = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, uploadId);
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final int _cursorIndexOfCijUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cijUid");
      final int _cursorIndexOfCijContainerUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cijContainerUid");
      final int _cursorIndexOfCijUri = CursorUtil.getColumnIndexOrThrow(_cursor, "cijUri");
      final int _cursorIndexOfCijImportMode = CursorUtil.getColumnIndexOrThrow(_cursor, "cijImportMode");
      final int _cursorIndexOfCijContainerBaseDir = CursorUtil.getColumnIndexOrThrow(_cursor, "cijContainerBaseDir");
      final int _cursorIndexOfCijContentEntryUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cijContentEntryUid");
      final int _cursorIndexOfCijMimeType = CursorUtil.getColumnIndexOrThrow(_cursor, "cijMimeType");
      final int _cursorIndexOfCijSessionId = CursorUtil.getColumnIndexOrThrow(_cursor, "cijSessionId");
      final int _cursorIndexOfCijJobStatus = CursorUtil.getColumnIndexOrThrow(_cursor, "cijJobStatus");
      final int _cursorIndexOfCijBytesSoFar = CursorUtil.getColumnIndexOrThrow(_cursor, "cijBytesSoFar");
      final int _cursorIndexOfCijImportCompleted = CursorUtil.getColumnIndexOrThrow(_cursor, "cijImportCompleted");
      final int _cursorIndexOfCijContentLength = CursorUtil.getColumnIndexOrThrow(_cursor, "cijContentLength");
      final int _cursorIndexOfCijContainerEntryFileUids = CursorUtil.getColumnIndexOrThrow(_cursor, "cijContainerEntryFileUids");
      final int _cursorIndexOfCijConversionParams = CursorUtil.getColumnIndexOrThrow(_cursor, "cijConversionParams");
      final ContainerImportJob _result;
      if(_cursor.moveToFirst()) {
        _result = new ContainerImportJob();
        final long _tmpCijUid;
        _tmpCijUid = _cursor.getLong(_cursorIndexOfCijUid);
        _result.setCijUid(_tmpCijUid);
        final long _tmpCijContainerUid;
        _tmpCijContainerUid = _cursor.getLong(_cursorIndexOfCijContainerUid);
        _result.setCijContainerUid(_tmpCijContainerUid);
        final String _tmpCijUri;
        if (_cursor.isNull(_cursorIndexOfCijUri)) {
          _tmpCijUri = null;
        } else {
          _tmpCijUri = _cursor.getString(_cursorIndexOfCijUri);
        }
        _result.setCijUri(_tmpCijUri);
        final int _tmpCijImportMode;
        _tmpCijImportMode = _cursor.getInt(_cursorIndexOfCijImportMode);
        _result.setCijImportMode(_tmpCijImportMode);
        final String _tmpCijContainerBaseDir;
        if (_cursor.isNull(_cursorIndexOfCijContainerBaseDir)) {
          _tmpCijContainerBaseDir = null;
        } else {
          _tmpCijContainerBaseDir = _cursor.getString(_cursorIndexOfCijContainerBaseDir);
        }
        _result.setCijContainerBaseDir(_tmpCijContainerBaseDir);
        final long _tmpCijContentEntryUid;
        _tmpCijContentEntryUid = _cursor.getLong(_cursorIndexOfCijContentEntryUid);
        _result.setCijContentEntryUid(_tmpCijContentEntryUid);
        final String _tmpCijMimeType;
        if (_cursor.isNull(_cursorIndexOfCijMimeType)) {
          _tmpCijMimeType = null;
        } else {
          _tmpCijMimeType = _cursor.getString(_cursorIndexOfCijMimeType);
        }
        _result.setCijMimeType(_tmpCijMimeType);
        final String _tmpCijSessionId;
        if (_cursor.isNull(_cursorIndexOfCijSessionId)) {
          _tmpCijSessionId = null;
        } else {
          _tmpCijSessionId = _cursor.getString(_cursorIndexOfCijSessionId);
        }
        _result.setCijSessionId(_tmpCijSessionId);
        final int _tmpCijJobStatus;
        _tmpCijJobStatus = _cursor.getInt(_cursorIndexOfCijJobStatus);
        _result.setCijJobStatus(_tmpCijJobStatus);
        final long _tmpCijBytesSoFar;
        _tmpCijBytesSoFar = _cursor.getLong(_cursorIndexOfCijBytesSoFar);
        _result.setCijBytesSoFar(_tmpCijBytesSoFar);
        final boolean _tmpCijImportCompleted;
        final int _tmp;
        _tmp = _cursor.getInt(_cursorIndexOfCijImportCompleted);
        _tmpCijImportCompleted = _tmp != 0;
        _result.setCijImportCompleted(_tmpCijImportCompleted);
        final long _tmpCijContentLength;
        _tmpCijContentLength = _cursor.getLong(_cursorIndexOfCijContentLength);
        _result.setCijContentLength(_tmpCijContentLength);
        final String _tmpCijContainerEntryFileUids;
        if (_cursor.isNull(_cursorIndexOfCijContainerEntryFileUids)) {
          _tmpCijContainerEntryFileUids = null;
        } else {
          _tmpCijContainerEntryFileUids = _cursor.getString(_cursorIndexOfCijContainerEntryFileUids);
        }
        _result.setCijContainerEntryFileUids(_tmpCijContainerEntryFileUids);
        final String _tmpCijConversionParams;
        if (_cursor.isNull(_cursorIndexOfCijConversionParams)) {
          _tmpCijConversionParams = null;
        } else {
          _tmpCijConversionParams = _cursor.getString(_cursorIndexOfCijConversionParams);
        }
        _result.setCijConversionParams(_tmpCijConversionParams);
      } else {
        _result = null;
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  @Override
  public LiveData<List<ContainerImportJob>> findJobs() {
    final String _sql = "\n"
            + "            SELECT * \n"
            + "              FROM ContainerImportJob \n"
            + "             WHERE cijJobStatus = 4\n"
            + "                   AND (NOT cijImportCompleted OR \n"
            + "                   (SELECT connectivityState \n"
            + "                      FROM ConnectivityStatus)\n"
            + "                   IN (3, 4))\n"
            + "             LIMIT 10";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 0);
    return __db.getInvalidationTracker().createLiveData(new String[]{"ContainerImportJob","ConnectivityStatus"}, false, new Callable<List<ContainerImportJob>>() {
      @Override
      public List<ContainerImportJob> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfCijUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cijUid");
          final int _cursorIndexOfCijContainerUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cijContainerUid");
          final int _cursorIndexOfCijUri = CursorUtil.getColumnIndexOrThrow(_cursor, "cijUri");
          final int _cursorIndexOfCijImportMode = CursorUtil.getColumnIndexOrThrow(_cursor, "cijImportMode");
          final int _cursorIndexOfCijContainerBaseDir = CursorUtil.getColumnIndexOrThrow(_cursor, "cijContainerBaseDir");
          final int _cursorIndexOfCijContentEntryUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cijContentEntryUid");
          final int _cursorIndexOfCijMimeType = CursorUtil.getColumnIndexOrThrow(_cursor, "cijMimeType");
          final int _cursorIndexOfCijSessionId = CursorUtil.getColumnIndexOrThrow(_cursor, "cijSessionId");
          final int _cursorIndexOfCijJobStatus = CursorUtil.getColumnIndexOrThrow(_cursor, "cijJobStatus");
          final int _cursorIndexOfCijBytesSoFar = CursorUtil.getColumnIndexOrThrow(_cursor, "cijBytesSoFar");
          final int _cursorIndexOfCijImportCompleted = CursorUtil.getColumnIndexOrThrow(_cursor, "cijImportCompleted");
          final int _cursorIndexOfCijContentLength = CursorUtil.getColumnIndexOrThrow(_cursor, "cijContentLength");
          final int _cursorIndexOfCijContainerEntryFileUids = CursorUtil.getColumnIndexOrThrow(_cursor, "cijContainerEntryFileUids");
          final int _cursorIndexOfCijConversionParams = CursorUtil.getColumnIndexOrThrow(_cursor, "cijConversionParams");
          final List<ContainerImportJob> _result = new ArrayList<ContainerImportJob>(_cursor.getCount());
          while(_cursor.moveToNext()) {
            final ContainerImportJob _item;
            _item = new ContainerImportJob();
            final long _tmpCijUid;
            _tmpCijUid = _cursor.getLong(_cursorIndexOfCijUid);
            _item.setCijUid(_tmpCijUid);
            final long _tmpCijContainerUid;
            _tmpCijContainerUid = _cursor.getLong(_cursorIndexOfCijContainerUid);
            _item.setCijContainerUid(_tmpCijContainerUid);
            final String _tmpCijUri;
            if (_cursor.isNull(_cursorIndexOfCijUri)) {
              _tmpCijUri = null;
            } else {
              _tmpCijUri = _cursor.getString(_cursorIndexOfCijUri);
            }
            _item.setCijUri(_tmpCijUri);
            final int _tmpCijImportMode;
            _tmpCijImportMode = _cursor.getInt(_cursorIndexOfCijImportMode);
            _item.setCijImportMode(_tmpCijImportMode);
            final String _tmpCijContainerBaseDir;
            if (_cursor.isNull(_cursorIndexOfCijContainerBaseDir)) {
              _tmpCijContainerBaseDir = null;
            } else {
              _tmpCijContainerBaseDir = _cursor.getString(_cursorIndexOfCijContainerBaseDir);
            }
            _item.setCijContainerBaseDir(_tmpCijContainerBaseDir);
            final long _tmpCijContentEntryUid;
            _tmpCijContentEntryUid = _cursor.getLong(_cursorIndexOfCijContentEntryUid);
            _item.setCijContentEntryUid(_tmpCijContentEntryUid);
            final String _tmpCijMimeType;
            if (_cursor.isNull(_cursorIndexOfCijMimeType)) {
              _tmpCijMimeType = null;
            } else {
              _tmpCijMimeType = _cursor.getString(_cursorIndexOfCijMimeType);
            }
            _item.setCijMimeType(_tmpCijMimeType);
            final String _tmpCijSessionId;
            if (_cursor.isNull(_cursorIndexOfCijSessionId)) {
              _tmpCijSessionId = null;
            } else {
              _tmpCijSessionId = _cursor.getString(_cursorIndexOfCijSessionId);
            }
            _item.setCijSessionId(_tmpCijSessionId);
            final int _tmpCijJobStatus;
            _tmpCijJobStatus = _cursor.getInt(_cursorIndexOfCijJobStatus);
            _item.setCijJobStatus(_tmpCijJobStatus);
            final long _tmpCijBytesSoFar;
            _tmpCijBytesSoFar = _cursor.getLong(_cursorIndexOfCijBytesSoFar);
            _item.setCijBytesSoFar(_tmpCijBytesSoFar);
            final boolean _tmpCijImportCompleted;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfCijImportCompleted);
            _tmpCijImportCompleted = _tmp != 0;
            _item.setCijImportCompleted(_tmpCijImportCompleted);
            final long _tmpCijContentLength;
            _tmpCijContentLength = _cursor.getLong(_cursorIndexOfCijContentLength);
            _item.setCijContentLength(_tmpCijContentLength);
            final String _tmpCijContainerEntryFileUids;
            if (_cursor.isNull(_cursorIndexOfCijContainerEntryFileUids)) {
              _tmpCijContainerEntryFileUids = null;
            } else {
              _tmpCijContainerEntryFileUids = _cursor.getString(_cursorIndexOfCijContainerEntryFileUids);
            }
            _item.setCijContainerEntryFileUids(_tmpCijContainerEntryFileUids);
            final String _tmpCijConversionParams;
            if (_cursor.isNull(_cursorIndexOfCijConversionParams)) {
              _tmpCijConversionParams = null;
            } else {
              _tmpCijConversionParams = _cursor.getString(_cursorIndexOfCijConversionParams);
            }
            _item.setCijConversionParams(_tmpCijConversionParams);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @Override
  public Object getTitleOfEntry(final long importJobUid,
      final Continuation<? super String> continuation) {
    final String _sql = "SELECT ContentEntry.title FROM ContainerImportJob LEFT JOIN ContentEntry ON ContainerImportJob.cijContentEntryUid = ContentEntry.contentEntryUid WHERE ContainerImportJob.cijUid = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, importJobUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<String>() {
      @Override
      public String call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final String _result;
          if(_cursor.moveToFirst()) {
            if (_cursor.isNull(0)) {
              _result = null;
            } else {
              _result = _cursor.getString(0);
            }
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, continuation);
  }

  @Override
  public LiveData<ContainerImportJob> getImportJobLiveData(final long importJobUid) {
    final String _sql = "SELECT * From  ContainerImportJob WHERE ContainerImportJob.cijUid = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, importJobUid);
    return __db.getInvalidationTracker().createLiveData(new String[]{"ContainerImportJob"}, false, new Callable<ContainerImportJob>() {
      @Override
      public ContainerImportJob call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfCijUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cijUid");
          final int _cursorIndexOfCijContainerUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cijContainerUid");
          final int _cursorIndexOfCijUri = CursorUtil.getColumnIndexOrThrow(_cursor, "cijUri");
          final int _cursorIndexOfCijImportMode = CursorUtil.getColumnIndexOrThrow(_cursor, "cijImportMode");
          final int _cursorIndexOfCijContainerBaseDir = CursorUtil.getColumnIndexOrThrow(_cursor, "cijContainerBaseDir");
          final int _cursorIndexOfCijContentEntryUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cijContentEntryUid");
          final int _cursorIndexOfCijMimeType = CursorUtil.getColumnIndexOrThrow(_cursor, "cijMimeType");
          final int _cursorIndexOfCijSessionId = CursorUtil.getColumnIndexOrThrow(_cursor, "cijSessionId");
          final int _cursorIndexOfCijJobStatus = CursorUtil.getColumnIndexOrThrow(_cursor, "cijJobStatus");
          final int _cursorIndexOfCijBytesSoFar = CursorUtil.getColumnIndexOrThrow(_cursor, "cijBytesSoFar");
          final int _cursorIndexOfCijImportCompleted = CursorUtil.getColumnIndexOrThrow(_cursor, "cijImportCompleted");
          final int _cursorIndexOfCijContentLength = CursorUtil.getColumnIndexOrThrow(_cursor, "cijContentLength");
          final int _cursorIndexOfCijContainerEntryFileUids = CursorUtil.getColumnIndexOrThrow(_cursor, "cijContainerEntryFileUids");
          final int _cursorIndexOfCijConversionParams = CursorUtil.getColumnIndexOrThrow(_cursor, "cijConversionParams");
          final ContainerImportJob _result;
          if(_cursor.moveToFirst()) {
            _result = new ContainerImportJob();
            final long _tmpCijUid;
            _tmpCijUid = _cursor.getLong(_cursorIndexOfCijUid);
            _result.setCijUid(_tmpCijUid);
            final long _tmpCijContainerUid;
            _tmpCijContainerUid = _cursor.getLong(_cursorIndexOfCijContainerUid);
            _result.setCijContainerUid(_tmpCijContainerUid);
            final String _tmpCijUri;
            if (_cursor.isNull(_cursorIndexOfCijUri)) {
              _tmpCijUri = null;
            } else {
              _tmpCijUri = _cursor.getString(_cursorIndexOfCijUri);
            }
            _result.setCijUri(_tmpCijUri);
            final int _tmpCijImportMode;
            _tmpCijImportMode = _cursor.getInt(_cursorIndexOfCijImportMode);
            _result.setCijImportMode(_tmpCijImportMode);
            final String _tmpCijContainerBaseDir;
            if (_cursor.isNull(_cursorIndexOfCijContainerBaseDir)) {
              _tmpCijContainerBaseDir = null;
            } else {
              _tmpCijContainerBaseDir = _cursor.getString(_cursorIndexOfCijContainerBaseDir);
            }
            _result.setCijContainerBaseDir(_tmpCijContainerBaseDir);
            final long _tmpCijContentEntryUid;
            _tmpCijContentEntryUid = _cursor.getLong(_cursorIndexOfCijContentEntryUid);
            _result.setCijContentEntryUid(_tmpCijContentEntryUid);
            final String _tmpCijMimeType;
            if (_cursor.isNull(_cursorIndexOfCijMimeType)) {
              _tmpCijMimeType = null;
            } else {
              _tmpCijMimeType = _cursor.getString(_cursorIndexOfCijMimeType);
            }
            _result.setCijMimeType(_tmpCijMimeType);
            final String _tmpCijSessionId;
            if (_cursor.isNull(_cursorIndexOfCijSessionId)) {
              _tmpCijSessionId = null;
            } else {
              _tmpCijSessionId = _cursor.getString(_cursorIndexOfCijSessionId);
            }
            _result.setCijSessionId(_tmpCijSessionId);
            final int _tmpCijJobStatus;
            _tmpCijJobStatus = _cursor.getInt(_cursorIndexOfCijJobStatus);
            _result.setCijJobStatus(_tmpCijJobStatus);
            final long _tmpCijBytesSoFar;
            _tmpCijBytesSoFar = _cursor.getLong(_cursorIndexOfCijBytesSoFar);
            _result.setCijBytesSoFar(_tmpCijBytesSoFar);
            final boolean _tmpCijImportCompleted;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfCijImportCompleted);
            _tmpCijImportCompleted = _tmp != 0;
            _result.setCijImportCompleted(_tmpCijImportCompleted);
            final long _tmpCijContentLength;
            _tmpCijContentLength = _cursor.getLong(_cursorIndexOfCijContentLength);
            _result.setCijContentLength(_tmpCijContentLength);
            final String _tmpCijContainerEntryFileUids;
            if (_cursor.isNull(_cursorIndexOfCijContainerEntryFileUids)) {
              _tmpCijContainerEntryFileUids = null;
            } else {
              _tmpCijContainerEntryFileUids = _cursor.getString(_cursorIndexOfCijContainerEntryFileUids);
            }
            _result.setCijContainerEntryFileUids(_tmpCijContainerEntryFileUids);
            final String _tmpCijConversionParams;
            if (_cursor.isNull(_cursorIndexOfCijConversionParams)) {
              _tmpCijConversionParams = null;
            } else {
              _tmpCijConversionParams = _cursor.getString(_cursorIndexOfCijConversionParams);
            }
            _result.setCijConversionParams(_tmpCijConversionParams);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
