package com.ustadmobile.core.db.dao;

import android.database.Cursor;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.lib.db.entities.ContentCategory;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;

@SuppressWarnings({"unchecked", "deprecation"})
public final class ContentCategoryDao_Impl extends ContentCategoryDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<ContentCategory> __insertionAdapterOfContentCategory;

  private final EntityDeletionOrUpdateAdapter<ContentCategory> __updateAdapterOfContentCategory;

  private final SharedSQLiteStatement __preparedStmtOfReplicateOnNewNode;

  private final SharedSQLiteStatement __preparedStmtOfReplicateOnChange;

  public ContentCategoryDao_Impl(RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfContentCategory = new EntityInsertionAdapter<ContentCategory>(__db) {
      @Override
      public String createQuery() {
        return "INSERT OR ABORT INTO `ContentCategory` (`contentCategoryUid`,`ctnCatContentCategorySchemaUid`,`name`,`contentCategoryLocalChangeSeqNum`,`contentCategoryMasterChangeSeqNum`,`contentCategoryLastChangedBy`,`contentCategoryLct`) VALUES (nullif(?, 0),?,?,?,?,?,?)";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, ContentCategory value) {
        stmt.bindLong(1, value.getContentCategoryUid());
        stmt.bindLong(2, value.getCtnCatContentCategorySchemaUid());
        if (value.getName() == null) {
          stmt.bindNull(3);
        } else {
          stmt.bindString(3, value.getName());
        }
        stmt.bindLong(4, value.getContentCategoryLocalChangeSeqNum());
        stmt.bindLong(5, value.getContentCategoryMasterChangeSeqNum());
        stmt.bindLong(6, value.getContentCategoryLastChangedBy());
        stmt.bindLong(7, value.getContentCategoryLct());
      }
    };
    this.__updateAdapterOfContentCategory = new EntityDeletionOrUpdateAdapter<ContentCategory>(__db) {
      @Override
      public String createQuery() {
        return "UPDATE OR ABORT `ContentCategory` SET `contentCategoryUid` = ?,`ctnCatContentCategorySchemaUid` = ?,`name` = ?,`contentCategoryLocalChangeSeqNum` = ?,`contentCategoryMasterChangeSeqNum` = ?,`contentCategoryLastChangedBy` = ?,`contentCategoryLct` = ? WHERE `contentCategoryUid` = ?";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, ContentCategory value) {
        stmt.bindLong(1, value.getContentCategoryUid());
        stmt.bindLong(2, value.getCtnCatContentCategorySchemaUid());
        if (value.getName() == null) {
          stmt.bindNull(3);
        } else {
          stmt.bindString(3, value.getName());
        }
        stmt.bindLong(4, value.getContentCategoryLocalChangeSeqNum());
        stmt.bindLong(5, value.getContentCategoryMasterChangeSeqNum());
        stmt.bindLong(6, value.getContentCategoryLastChangedBy());
        stmt.bindLong(7, value.getContentCategoryLct());
        stmt.bindLong(8, value.getContentCategoryUid());
      }
    };
    this.__preparedStmtOfReplicateOnNewNode = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "\n"
                + "     REPLACE INTO ContentCategoryReplicate(ccPk, ccDestination)\n"
                + "      SELECT DISTINCT ContentCategory.contentCategoryUid AS ccPk,\n"
                + "             ? AS ccDestination\n"
                + "        FROM ContentCategory\n"
                + "       WHERE ContentCategory.contentCategoryLct != COALESCE(\n"
                + "             (SELECT ccVersionId\n"
                + "                FROM ContentCategoryReplicate\n"
                + "               WHERE ccPk = ContentCategory.contentCategoryUid\n"
                + "                 AND ccDestination = ?), 0) \n"
                + "      /*psql ON CONFLICT(ccPk, ccDestination) DO UPDATE\n"
                + "             SET ccPending = true\n"
                + "      */       \n"
                + "    ";
        return _query;
      }
    };
    this.__preparedStmtOfReplicateOnChange = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "\n"
                + " REPLACE INTO ContentCategoryReplicate(ccPk, ccDestination)\n"
                + "  SELECT DISTINCT ContentCategory.contentCategoryUid AS ccUid,\n"
                + "         UserSession.usClientNodeId AS ccDestination\n"
                + "    FROM ChangeLog\n"
                + "         JOIN ContentCategory\n"
                + "             ON ChangeLog.chTableId = 1\n"
                + "                AND ChangeLog.chEntityPk = ContentCategory.contentCategoryUid\n"
                + "         JOIN UserSession \n"
                + "              ON UserSession.usStatus = 1\n"
                + "   WHERE UserSession.usClientNodeId != (\n"
                + "         SELECT nodeClientId \n"
                + "           FROM SyncNode\n"
                + "          LIMIT 1)\n"
                + "     AND ContentCategory.contentCategoryLct != COALESCE(\n"
                + "         (SELECT ccVersionId\n"
                + "            FROM ContentCategoryReplicate\n"
                + "           WHERE ccPk = ContentCategory.contentCategoryUid\n"
                + "             AND ccDestination = UserSession.usClientNodeId), 0)\n"
                + " /*psql ON CONFLICT(ccPk, ccDestination) DO UPDATE\n"
                + "     SET ccPending = true\n"
                + "  */               \n"
                + "    ";
        return _query;
      }
    };
  }

  @Override
  public long insert(final ContentCategory entity) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      long _result = __insertionAdapterOfContentCategory.insertAndReturnId(entity);
      __db.setTransactionSuccessful();
      return _result;
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object insertAsync(final ContentCategory entity,
      final Continuation<? super Long> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Long>() {
      @Override
      public Long call() throws Exception {
        __db.beginTransaction();
        try {
          long _result = __insertionAdapterOfContentCategory.insertAndReturnId(entity);
          __db.setTransactionSuccessful();
          return _result;
        } finally {
          __db.endTransaction();
        }
      }
    }, continuation);
  }

  @Override
  public void insertList(final List<? extends ContentCategory> entityList) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __insertionAdapterOfContentCategory.insert(entityList);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public void updateList(final List<? extends ContentCategory> entityList) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __updateAdapterOfContentCategory.handleMultiple(entityList);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public void update(final ContentCategory entity) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __updateAdapterOfContentCategory.handle(entity);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object replicateOnNewNode(final long newNodeId,
      final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfReplicateOnNewNode.acquire();
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, newNodeId);
        _argIndex = 2;
        _stmt.bindLong(_argIndex, newNodeId);
        __db.beginTransaction();
        try {
          _stmt.executeInsert();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfReplicateOnNewNode.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public Object replicateOnChange(final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfReplicateOnChange.acquire();
        __db.beginTransaction();
        try {
          _stmt.executeInsert();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfReplicateOnChange.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public List<ContentCategory> publicContentCategories() {
    final String _sql = "SELECT ContentCategory.* FROM ContentCategory";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 0);
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final int _cursorIndexOfContentCategoryUid = CursorUtil.getColumnIndexOrThrow(_cursor, "contentCategoryUid");
      final int _cursorIndexOfCtnCatContentCategorySchemaUid = CursorUtil.getColumnIndexOrThrow(_cursor, "ctnCatContentCategorySchemaUid");
      final int _cursorIndexOfName = CursorUtil.getColumnIndexOrThrow(_cursor, "name");
      final int _cursorIndexOfContentCategoryLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "contentCategoryLocalChangeSeqNum");
      final int _cursorIndexOfContentCategoryMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "contentCategoryMasterChangeSeqNum");
      final int _cursorIndexOfContentCategoryLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "contentCategoryLastChangedBy");
      final int _cursorIndexOfContentCategoryLct = CursorUtil.getColumnIndexOrThrow(_cursor, "contentCategoryLct");
      final List<ContentCategory> _result = new ArrayList<ContentCategory>(_cursor.getCount());
      while(_cursor.moveToNext()) {
        final ContentCategory _item;
        _item = new ContentCategory();
        final long _tmpContentCategoryUid;
        _tmpContentCategoryUid = _cursor.getLong(_cursorIndexOfContentCategoryUid);
        _item.setContentCategoryUid(_tmpContentCategoryUid);
        final long _tmpCtnCatContentCategorySchemaUid;
        _tmpCtnCatContentCategorySchemaUid = _cursor.getLong(_cursorIndexOfCtnCatContentCategorySchemaUid);
        _item.setCtnCatContentCategorySchemaUid(_tmpCtnCatContentCategorySchemaUid);
        final String _tmpName;
        if (_cursor.isNull(_cursorIndexOfName)) {
          _tmpName = null;
        } else {
          _tmpName = _cursor.getString(_cursorIndexOfName);
        }
        _item.setName(_tmpName);
        final long _tmpContentCategoryLocalChangeSeqNum;
        _tmpContentCategoryLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfContentCategoryLocalChangeSeqNum);
        _item.setContentCategoryLocalChangeSeqNum(_tmpContentCategoryLocalChangeSeqNum);
        final long _tmpContentCategoryMasterChangeSeqNum;
        _tmpContentCategoryMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfContentCategoryMasterChangeSeqNum);
        _item.setContentCategoryMasterChangeSeqNum(_tmpContentCategoryMasterChangeSeqNum);
        final int _tmpContentCategoryLastChangedBy;
        _tmpContentCategoryLastChangedBy = _cursor.getInt(_cursorIndexOfContentCategoryLastChangedBy);
        _item.setContentCategoryLastChangedBy(_tmpContentCategoryLastChangedBy);
        final long _tmpContentCategoryLct;
        _tmpContentCategoryLct = _cursor.getLong(_cursorIndexOfContentCategoryLct);
        _item.setContentCategoryLct(_tmpContentCategoryLct);
        _result.add(_item);
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  @Override
  public ContentCategory findCategoryBySchemaIdAndName(final long schemaId, final String name) {
    final String _sql = "SELECT * FROM ContentCategory WHERE ctnCatContentCategorySchemaUid = ? AND name = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 2);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, schemaId);
    _argIndex = 2;
    if (name == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, name);
    }
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final int _cursorIndexOfContentCategoryUid = CursorUtil.getColumnIndexOrThrow(_cursor, "contentCategoryUid");
      final int _cursorIndexOfCtnCatContentCategorySchemaUid = CursorUtil.getColumnIndexOrThrow(_cursor, "ctnCatContentCategorySchemaUid");
      final int _cursorIndexOfName = CursorUtil.getColumnIndexOrThrow(_cursor, "name");
      final int _cursorIndexOfContentCategoryLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "contentCategoryLocalChangeSeqNum");
      final int _cursorIndexOfContentCategoryMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "contentCategoryMasterChangeSeqNum");
      final int _cursorIndexOfContentCategoryLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "contentCategoryLastChangedBy");
      final int _cursorIndexOfContentCategoryLct = CursorUtil.getColumnIndexOrThrow(_cursor, "contentCategoryLct");
      final ContentCategory _result;
      if(_cursor.moveToFirst()) {
        _result = new ContentCategory();
        final long _tmpContentCategoryUid;
        _tmpContentCategoryUid = _cursor.getLong(_cursorIndexOfContentCategoryUid);
        _result.setContentCategoryUid(_tmpContentCategoryUid);
        final long _tmpCtnCatContentCategorySchemaUid;
        _tmpCtnCatContentCategorySchemaUid = _cursor.getLong(_cursorIndexOfCtnCatContentCategorySchemaUid);
        _result.setCtnCatContentCategorySchemaUid(_tmpCtnCatContentCategorySchemaUid);
        final String _tmpName;
        if (_cursor.isNull(_cursorIndexOfName)) {
          _tmpName = null;
        } else {
          _tmpName = _cursor.getString(_cursorIndexOfName);
        }
        _result.setName(_tmpName);
        final long _tmpContentCategoryLocalChangeSeqNum;
        _tmpContentCategoryLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfContentCategoryLocalChangeSeqNum);
        _result.setContentCategoryLocalChangeSeqNum(_tmpContentCategoryLocalChangeSeqNum);
        final long _tmpContentCategoryMasterChangeSeqNum;
        _tmpContentCategoryMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfContentCategoryMasterChangeSeqNum);
        _result.setContentCategoryMasterChangeSeqNum(_tmpContentCategoryMasterChangeSeqNum);
        final int _tmpContentCategoryLastChangedBy;
        _tmpContentCategoryLastChangedBy = _cursor.getInt(_cursorIndexOfContentCategoryLastChangedBy);
        _result.setContentCategoryLastChangedBy(_tmpContentCategoryLastChangedBy);
        final long _tmpContentCategoryLct;
        _tmpContentCategoryLct = _cursor.getLong(_cursorIndexOfContentCategoryLct);
        _result.setContentCategoryLct(_tmpContentCategoryLct);
      } else {
        _result = null;
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
